/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SinglePowerFailedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kSinglePowerFailedMsg = "SinglePowerFailedFlexEvent";
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private static final ObjectId kSinglePowerRestoredOid = MultipleEvent.SinglePowerRestored.getObjectId();
    private static final Logger logger = LogManager.getLogger(SinglePowerFailedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOnBattery();
        if (AggregatorState.find_matches(blArray, true) == 1 && (this.theState.getLastReportedSinglePowerState() == 1 || this.theState.getLastReportedSinglePowerState() == 0)) {
            logger.info("firing SinglePowerFailed event ");
            if (this.theState.getLastReportedSinglePowerState() == 1) {
                this.theManager.dispatchEvent(new Event(kSinglePowerRestoredOid, false));
            }
            String string = PSAggregatorUtils.getAddress(this.theState, this.theManager);
            this.theManager.dispatchEvent(new DetailedEvent(kSinglePowerFailedOid, true, new SinglePowerFormatter(kSinglePowerFailedMsg, string), false, MultipleEvent.SinglePowerFailed.getEventId()));
            this.theState.setLastReportedSinglePowerState(2);
            this.setSinglePowerFailedState();
        }
    }

    private void setSinglePowerFailedState() {
        try {
            Boolean bl = true;
            this.theManager.dataBusSet(Output.SinglePowerFailedState.getObjectId(), bl);
        }
        catch (Exception exception) {
            logger.error("Error setSinglePowerFailed :", (Throwable)exception);
        }
    }
}

