/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SinglePowerRestoredFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private static final String kSinglePowerRestoredMsg = "SinglePowerRestoredFlexEvent";
    private static final ObjectId kSinglePowerRestoredOid = MultipleEvent.SinglePowerRestored.getObjectId();
    private static final Logger logger = LogManager.getLogger(SinglePowerRestoredFiringLogicRule.class);

    @Override
    public void calculate() {
        if (this.isEventOccur()) {
            logger.info("Cancel SinglePowerFailed event ");
            this.theManager.dispatchEvent(new Event(kSinglePowerFailedOid, false));
            if (!this.isOnBatteryState()) {
                logger.info("Send SinglePowerRestored event ");
                this.theManager.dispatchEvent(new DetailedEvent(kSinglePowerRestoredOid, true, new EventMessageFormatter(kSinglePowerRestoredMsg), true, MultipleEvent.SinglePowerRestored.getEventId()));
            }
            this.theState.setLastReportedSinglePowerState(1);
            this.resetSinglePowerFailedState();
        }
    }

    private boolean isEventOccur() {
        boolean bl = false;
        boolean[] blArray = this.theState.getOnBattery();
        if (this.theState.getLastReportedSinglePowerState() == 2) {
            if (AggregatorState.find_matches(blArray, true) == 0) {
                bl = true;
                logger.info("On line state");
            }
            if (this.isOnBatteryState()) {
                bl = true;
                logger.info("On battery state");
            }
        }
        return bl;
    }

    private boolean isOnBatteryState() {
        boolean bl = false;
        boolean[] blArray = this.theState.getOnBattery();
        if (AggregatorState.find_matches(blArray, true) > 1) {
            bl = true;
        }
        return bl;
    }

    private void resetSinglePowerFailedState() {
        try {
            Boolean bl = false;
            this.theManager.dataBusSet(Output.SinglePowerFailedState.getObjectId(), bl);
        }
        catch (Exception exception) {
            logger.error("Error resetSinglePowerFailed :", (Throwable)exception);
        }
    }
}

