/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurnOffInitiatedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kPowerSourceTurnOffInitiatedMsg = "PowerSourceTurnOffInitiatedFlexEvent";
    private static final String kPowerSourceTurnOffMsg = "PowerSourceTurnOffFlexEvent";
    private static final ObjectId kTurnOffInitiatedOid = ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId();
    private static final Logger logger = LogManager.getLogger(TurnOffInitiatedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getUpsTurnOffInitiated();
        boolean[] blArray2 = this.theState.getPowerOff();
        if (AggregatorState.find_matches(blArray, true) > 1 && this.theState.getLastReportedUpsTurnOffState() == 0) {
            logger.info("firing TurnOffInitiated event ");
            this.theManager.dispatchEvent(new Event(kTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kPowerSourceTurnOffInitiatedMsg)));
            this.theState.setLastReportedUpsTurnOffState(1);
        }
        if (AggregatorState.find_matches(blArray, true) < 1 && this.theState.getLastReportedUpsTurnOffState() == 1) {
            logger.info("Clear TurnOffInitiated state");
            this.theState.setLastReportedUpsTurnOffState(0);
        }
        if (AggregatorState.find_matches(blArray2, true) > 1 && this.theState.getLastReportedPowerOffState() == 0) {
            logger.info("firing TurnOff event ");
            this.theManager.dispatchEvent(new Event(kTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kPowerSourceTurnOffMsg)));
            this.theState.setLastReportedPowerOffState(2);
        }
        if (AggregatorState.find_matches(blArray2, true) < 1 && this.theState.getLastReportedPowerOffState() == 2) {
            logger.info("Clear PowerOffInitiated state");
            this.theState.setLastReportedPowerOffState(0);
        }
    }
}

