/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.runtimeverifier;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.runtimeverifier.RunTimeVerifierThread;
import com.apcc.m11.components.runtimeverifier.Verifier;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeExceededFormatter;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.services.RuntimeVerificationGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunTimeVerifier
implements IComponent,
IM11Component,
IDataSource,
IDataConsumer,
IEventConsumer {
    private static final Logger logger = LogManager.getLogger(RunTimeVerifier.class);
    private static final String KEY_RUNTIME_REMAINING_THRESHOLD = "Shutdown.runtimeRemainingThreshold";
    private static final String KEY_RUNTIME_REMAINING_CMDFILE_THRESHOLD = "Shutdown.runtimeRemainingCmdFileThreshold";
    private ServiceManager services;
    private EventListener<ConfigurationEvent> configEventListener;
    private final String kVerificationFrequencyIdentifier = "Verification Frequency";
    private final int kDefaultVerificationFrequency = 30;
    private final int kDefaultRuntimeRemainingThreshold = 0;
    private final String kComponentName = "Run Time Verifier";
    private final String kComponentID = "runtimeverifier";
    private final String kFormatterDirectory = "i18n";
    private static final String kSeparator = ".";
    private final String kComponentVersion = "1.0.0";
    private Verifier theRunTimeVerifier;
    private RunTimeVerifierThread theRunTimeVerifierThread;
    private IPermanentStorage thePermanentStorage;
    private IEventProducer theEventProducer;
    private boolean theComponentIsEnabled = false;
    private Vector<ObjectId> theSupportedOids;
    private RunTimeExceededFormatter theRunTimeExceededFormatter;

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        RunTimeVerifier runTimeVerifier = null;
        if (!objectId.equals((Object)M11Component.kOid)) {
            logger.info("Invalid Instance " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        runTimeVerifier = this;
        return runTimeVerifier;
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        this.services = ServiceManager.getInstance();
        this.thePermanentStorage = iPermanentStorage;
        SSHActionConfigurator sSHActionConfigurator = new SSHActionConfigurator(this.services.getConfigurationManager(), this.services.getAuthHelper(), this.services.getAdvancedSetupHelper());
        this.theRunTimeVerifier = new Verifier(sSHActionConfigurator, this.services);
        this.theSupportedOids = new Vector();
        this.theSupportedOids.addElement(RuntimeVerificationGroup.VerificationFrequency.getObjectId());
        this.theSupportedOids.addElement(RuntimeVerificationGroup.RuntimeRemainingThreshold.getObjectId());
        this.theSupportedOids.addElement(RuntimeVerificationGroup.RuntimeRemainingCmdFileThreshold.getObjectId());
        this.theSupportedOids.addElement(RuntimeVerificationGroup.TotalShutdownDurations.getObjectId());
        this.theRunTimeVerifierThread = new RunTimeVerifierThread(this.theRunTimeVerifier, sSHActionConfigurator, this.services);
        int n = 30;
        int n2 = 0;
        int n3 = 0;
        try {
            n = (Integer)this.thePermanentStorage.readData(this.getComponentID(), "Verification Frequency");
        }
        catch (Exception exception) {
            logger.debug("init: could not get verification freq. from permanent storage, using default:" + n);
        }
        n2 = this.services.getConfigurationManager().getInt("Shutdown", "runtimeRemainingThreshold", 0);
        n3 = this.services.getConfigurationManager().getInt("Shutdown", "runtimeRemainingCmdFileThreshold", 0);
        this.theRunTimeVerifierThread.setFrequency(n);
        this.theRunTimeVerifierThread.setRuntimeThreshold(n2);
        this.theRunTimeVerifierThread.setRuntimeCmdFileThreshold(n3);
    }

    public void start() throws ComponentFailureException {
        if (this.configEventListener == null) {
            this.configEventListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        if (!configurationEvent.isBeforeUpdate()) {
                            if (StringUtils.equals((CharSequence)configurationEvent.getPropertyName(), (CharSequence)RunTimeVerifier.KEY_RUNTIME_REMAINING_THRESHOLD)) {
                                try {
                                    RunTimeVerifier.this.theRunTimeVerifierThread.setRuntimeThreshold(Integer.parseInt(configurationEvent.getPropertyValue().toString()));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    logger.error((Object)numberFormatException);
                                }
                            } else if (StringUtils.equals((CharSequence)configurationEvent.getPropertyName(), (CharSequence)RunTimeVerifier.KEY_RUNTIME_REMAINING_CMDFILE_THRESHOLD)) {
                                try {
                                    RunTimeVerifier.this.theRunTimeVerifierThread.setRuntimeCmdFileThreshold(Integer.parseInt(configurationEvent.getPropertyValue().toString()));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    logger.error((Object)numberFormatException);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        this.services.getConfigurationManager().addEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.theRunTimeVerifierThread.setFormatterDirectory(RunTimeVerifier.class.getPackage().getName() + ".i18n");
        this.theComponentIsEnabled = true;
    }

    public void start(ITemporaryStorage iTemporaryStorage) throws ComponentFailureException {
        this.start();
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        if (objectId.equals((Object)EventProducer.kOid)) {
            object = this.theRunTimeVerifierThread;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this;
        } else if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            object = this;
        } else {
            throw new InvalidObjectIdException();
        }
        return object;
    }

    public void stop() {
        this.services.getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.theRunTimeVerifierThread.stop_verifier();
        this.theRunTimeVerifierThread.interrupt();
        this.theComponentIsEnabled = false;
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
        this.stop();
    }

    public void suspend() {
        this.theComponentIsEnabled = false;
        this.theRunTimeVerifierThread.suspendVerifier();
    }

    public String getComponentName() {
        return "Run Time Verifier";
    }

    public void resume() {
        this.theComponentIsEnabled = true;
        this.theRunTimeVerifierThread.resumeVerifier();
    }

    public ComponentID getComponentID() {
        return new ComponentID("runtimeverifier");
    }

    public String getComponentVersion() {
        return "1.0.0";
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (this.theComponentIsEnabled) {
            switch (n) {
                case 0: {
                    getResult = this.get(objectId);
                    break;
                }
                case 1: {
                    getResult.setValue((Object)Availability.AVAILABLE);
                    break;
                }
                case 2: {
                    getResult = new GetResult();
                    getResult.setError();
                    break;
                }
                case 3: {
                    getResult.setValue((Object)this.theRunTimeExceededFormatter);
                    break;
                }
                default: {
                    logger.warn("Invalid get type: " + n);
                    throw new InvalidObjectIdException();
                }
            }
        }
        return getResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (!this.theComponentIsEnabled) {
            getResult.setError();
            return getResult;
        }
        if (objectId.equals((Object)RuntimeVerificationGroup.VerificationFrequency.getObjectId())) {
            getResult.setValue((Object)this.theRunTimeVerifierThread.getFrequency());
            return getResult;
        }
        if (objectId.equals((Object)RuntimeVerificationGroup.RuntimeRemainingThreshold.getObjectId())) {
            getResult.setValue((Object)this.theRunTimeVerifierThread.getRuntimeThreshold());
            return getResult;
        }
        if (objectId.equals((Object)RuntimeVerificationGroup.RuntimeRemainingCmdFileThreshold.getObjectId())) {
            getResult.setValue((Object)this.theRunTimeVerifierThread.getRuntimeCmdFileThreshold());
            return getResult;
        }
        if (objectId.equals((Object)RuntimeVerificationGroup.TotalShutdownDurations.getObjectId())) {
            getResult.setValue((Object)this.theRunTimeVerifierThread.getTotalShutdownDuration());
            return getResult;
        }
        logger.info("Bad ID " + objectId.toString());
        throw new InvalidObjectIdException();
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, InvalidValueException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        SetResult setResult = new SetResult();
        if (this.theComponentIsEnabled) {
            if (objectId.equals((Object)RuntimeVerificationGroup.VerificationFrequency.getObjectId())) {
                if (!(object instanceof Integer)) {
                    throw new InvalidValueException("Value must be an Integer.");
                }
                Integer n = (Integer)object;
                this.theRunTimeVerifierThread.setFrequency(n);
                try {
                    this.thePermanentStorage.writeData(this.getComponentID(), "Verification Frequency", (Object)n);
                }
                catch (Exception exception) {
                    logger.error("set: could not write verification frequency to permanent storage ", (Throwable)exception);
                }
                setResult.setSuccessful(true);
                return setResult;
            }
            if (objectId.equals((Object)RuntimeVerificationGroup.RuntimeRemainingThreshold.getObjectId()) || objectId.equals((Object)RuntimeVerificationGroup.RuntimeRemainingCmdFileThreshold.getObjectId())) {
                if (object instanceof String) {
                    try {
                        object = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidValueException("Value must be an Integer.");
                    }
                }
                if (object == null) {
                    object = 0;
                }
                if (!(object instanceof Integer)) {
                    throw new InvalidValueException("Value must be an Integer.");
                }
                if (Integer.valueOf(object.toString()) < 0) {
                    throw new InvalidValueException("Value must be greater than zero.");
                }
                Integer n = (Integer)object;
                if (objectId.equals((Object)RuntimeVerificationGroup.RuntimeRemainingThreshold.getObjectId())) {
                    this.theRunTimeVerifierThread.setRuntimeThreshold(n);
                    this.services.getConfigurationManager().setProperty("Shutdown", "runtimeRemainingThreshold", n.toString());
                } else {
                    this.theRunTimeVerifierThread.setRuntimeCmdFileThreshold(n);
                    this.services.getConfigurationManager().setProperty("Shutdown", "runtimeRemainingCmdFileThreshold", n.toString());
                }
                setResult.setSuccessful(true);
                return setResult;
            }
            logger.info("Bad ID: " + objectId.toString());
            throw new InvalidObjectIdException();
        }
        logger.info("get: Component not initialized");
        setResult.setSuccessful(false);
        return setResult;
    }

    public Enumeration<ObjectId> getSupportedOids() {
        return this.theSupportedOids.elements();
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theRunTimeVerifier.setDataSource(iDataSource);
        this.theRunTimeVerifierThread.setDataSource(iDataSource);
    }

    public void update(Event event) {
        if (event != null) {
            ObjectId objectId = event.getObjectId();
            if (objectId != null && objectId.equals((Object)Communication.CommunicationEstablished.getObjectId())) {
                this.theRunTimeVerifierThread.start();
            } else if (objectId != null && objectId.equals((Object)UtilityLineStatus.PowerFailed.getObjectId())) {
                if (event instanceof AdvancedGroupEvent) {
                    this.theRunTimeVerifierThread.setOnBattery(event.isActive(), ((AdvancedGroupEvent)event).getGroup());
                } else {
                    this.theRunTimeVerifierThread.setOnBattery(event.isActive());
                }
            }
        }
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer = iEventProducer;
        this.theEventProducer.registerEventConsumer((IEventConsumer)this);
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer.unRegisterEventConsumer((IEventConsumer)this);
    }

    public Enumeration<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(Communication.CommunicationEstablished.getObjectId());
        vector.addElement(UtilityLineStatus.PowerFailed.getObjectId());
        return vector.elements();
    }
}

