/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.runtimeverifier;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.runtimeverifier.RuntimeVerifierUtils;
import com.apcc.m11.components.runtimeverifier.Verifier;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeExceededFormatter;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeThresholdClearedFormatter;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeThresholdCmdFileClearedFormatter;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeThresholdCmdFileFormatter;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeThresholdFormatter;
import com.apcc.m11.components.runtimeverifier.formatters.RunTimeWithinRangeFormatter;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.util.TimeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunTimeVerifierThread
extends Thread
implements IEventProducer {
    private static final Logger logger = LogManager.getLogger(RunTimeVerifierThread.class);
    private static final int kDefaultFrequency = 30;
    private boolean theRuntimeThresholdEventSent = false;
    private boolean theRuntimeCmdFileThresholdEventSent = false;
    private boolean theRunTimeWasEnough = true;
    private Map<Integer, Boolean> theRunTimeWasEnoughMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> theRuntimeThresholdEventMap = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> theRuntimeCmdFileThresholdEventMap = new HashMap<Integer, Boolean>();
    private boolean theDelayVerifierIsEnabled = true;
    private boolean threadSuspended = false;
    private int theDelayTime = 30;
    private int theRuntimeThreshold = 0;
    private int theRuntimeCmdFileThreshold = 0;
    private boolean onBattery = false;
    private Map<Integer, Boolean> onBatteryMap = new HashMap<Integer, Boolean>();
    public IEventConsumer theEventConsumer;
    public static Verifier theRunTimeVerifier;
    private RunTimeExceededFormatter theRunTimeExceededFormatter;
    private RunTimeWithinRangeFormatter theRunTimeWithinRangeFormatter;
    private RunTimeThresholdFormatter theRunTimeThresholdFormatter;
    private RunTimeThresholdClearedFormatter theRunTimeThresholdClearedFormatter;
    private RunTimeThresholdCmdFileFormatter theRunTimeThresholdCmdFileFormatter;
    private RunTimeThresholdCmdFileClearedFormatter theRunTimeThresholdCmdFileClearedFormatter;
    private SSHActionConfigurator sshActionHelper;
    private IDataSource theDataSource;
    private ServiceManager services;
    private Integer[] totalShutdownDuration = null;

    public RunTimeVerifierThread(Verifier verifier, SSHActionConfigurator sSHActionConfigurator, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        theRunTimeVerifier = verifier;
        this.sshActionHelper = sSHActionConfigurator;
        this.services = serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isDelayVerifierEnabled()) {
            logger.debug("Checking Runtime");
            try {
                this.totalShutdownDuration = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() ? this.verifyRuntimeForAdvancedGroups() : this.verifyRuntime();
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error((Object)invalidObjectIdException);
            }
            catch (CommunicationException communicationException) {
                logger.debug("Communication with NMC not established - Runtime Verification will run again as scheduled: {}", (Object)communicationException.getLocalizedMessage());
            }
            catch (Exception exception) {
                logger.error("Issue checking Runtime. Runtime Verification will run again as scheduled: {}", (Throwable)exception);
                logger.debug("Unexpected exception Exception Details {}", (Throwable)exception);
            }
            try {
                RunTimeVerifierThread.sleep(TimeUnit.MILLISECONDS.convert(this.theDelayTime, TimeUnit.SECONDS));
                RunTimeVerifierThread runTimeVerifierThread = this;
                synchronized (runTimeVerifierThread) {
                    while (this.isVerifierSuspended()) {
                        this.wait(1000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private Integer[] verifyRuntime() throws InvalidObjectIdException, CommunicationException {
        if (theRunTimeVerifier.runtime_exceeded()) {
            if (this.theRunTimeWasEnough) {
                Event event = new Event(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), false, (IFormatter)this.theRunTimeWithinRangeFormatter);
                this.theEventConsumer.update(event);
                DetailedEvent detailedEvent = new DetailedEvent(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), this.theRunTimeExceededFormatter, false, RuntimeVerifierEvents.RunTimeExceeded.getEventId());
                this.theEventConsumer.update((Event)detailedEvent);
                this.theRunTimeWasEnough = false;
            }
        } else if (!this.theRunTimeWasEnough) {
            Event event = new Event(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), false, (IFormatter)this.theRunTimeExceededFormatter);
            this.theEventConsumer.update(event);
            DetailedEvent detailedEvent = new DetailedEvent(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), this.theRunTimeWithinRangeFormatter, true, RuntimeVerifierEvents.RunTimeWithinRange.getEventId());
            this.theEventConsumer.update((Event)detailedEvent);
            this.theRunTimeWasEnough = true;
        }
        this.verifyRuntimeRemainingBelowThreshold();
        return new Integer[]{theRunTimeVerifier.getTotalShutdownDuration()};
    }

    private void verifyRuntimeRemainingBelowThreshold() throws CommunicationException, InvalidObjectIdException {
        GetResult getResult = null;
        try {
            logger.debug("Try Redundant Method");
            getResult = this.theDataSource.get(Battery.RuntimeRemainingforThreshold.getObjectId());
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug("Using Normal Runtime Remaining");
            getResult = this.theDataSource.get(Battery.RuntimeRemaining.getObjectId());
        }
        boolean bl = false;
        boolean bl2 = false;
        if (getResult.getValue() instanceof Vector) {
            var4_5 = 0;
            int n = 0;
            for (Integer n2 : (Vector)getResult.getValue()) {
                if ((n2 = Integer.valueOf((int)TimeUnit.SECONDS.convert(n2.intValue(), TimeUnit.MINUTES))) < this.theRuntimeThreshold) {
                    ++var4_5;
                }
                if (n2 >= this.theRuntimeCmdFileThreshold) continue;
                ++n;
            }
            bl = var4_5 > 1;
            bl2 = n > 1;
            logger.debug("number of UPS with runtime below threshold = {}", (Object)var4_5);
            logger.debug("number of UPS with runtime below command file threshold = {}", (Object)n);
        } else {
            var4_5 = (Integer)getResult.getValue();
            bl = (var4_5 = (int)TimeUnit.SECONDS.convert(var4_5, TimeUnit.MINUTES)) < this.theRuntimeThreshold;
            bl2 = var4_5 < this.theRuntimeCmdFileThreshold;
            logger.debug("Battery.RuntimeRemaining = {} seconds", (Object)var4_5);
        }
        if (bl && this.onBattery) {
            if (!this.theRuntimeThresholdEventSent) {
                logger.debug("firing runtime remaining below threshold");
                Event event = new Event(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId(), false);
                this.theEventConsumer.update(event);
                DetailedEvent detailedEvent = new DetailedEvent(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), true, this.theRunTimeThresholdFormatter, false, RuntimeVerifierEvents.RunTimeRemaining.getEventId());
                this.theEventConsumer.update((Event)detailedEvent);
                this.theRuntimeThresholdEventSent = true;
            }
        } else if (this.theRuntimeThresholdEventSent) {
            logger.debug("firing runtime remaining back above threshold");
            Event event = new Event(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), false);
            this.theEventConsumer.update(event);
            this.theRuntimeThresholdEventSent = false;
            DetailedEvent detailedEvent = new DetailedEvent(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId(), true, this.theRunTimeThresholdClearedFormatter, true, RuntimeVerifierEvents.RunTimeRemainingCleared.getEventId());
            this.theEventConsumer.update((Event)detailedEvent);
        }
        if (bl2 && this.onBattery) {
            if (!this.theRuntimeCmdFileThresholdEventSent) {
                logger.debug("firing runtime remaining below command file threshold");
                Event event = new Event(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId(), false);
                this.theEventConsumer.update(event);
                Event event2 = new Event(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId(), true, (IFormatter)this.theRunTimeThresholdCmdFileFormatter);
                this.theEventConsumer.update(event2);
                this.theRuntimeCmdFileThresholdEventSent = true;
            }
        } else if (this.theRuntimeCmdFileThresholdEventSent) {
            logger.debug("firing runtime remaining back above command file threshold");
            Event event = new Event(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId(), false);
            this.theEventConsumer.update(event);
            this.theRuntimeCmdFileThresholdEventSent = false;
            Event event3 = new Event(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId(), true, (IFormatter)this.theRunTimeThresholdCmdFileClearedFormatter);
            this.theEventConsumer.update(event3);
        }
    }

    private boolean isPhysical(UPSSetup uPSSetup) {
        return uPSSetup.getHosts().isEmpty() && uPSSetup.isVirtualHostsShutdownEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] verifyRuntimeForAdvancedGroups() throws InvalidObjectIdException, CommunicationException {
        void var12_21;
        void var12_16;
        Object object2;
        logger.debug("verifyRuntimeForAdvancedGroups() - start");
        List<UPSSetup> list = this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig();
        Integer[] integerArray = new Integer[list.size()];
        GetResult getResult = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        try {
            getResult = this.theDataSource.get(Battery.RuntimeRemaining.getObjectId());
            if (getResult != null) {
                vector = (Vector)getResult.getValue();
            }
            if ((getResult = this.theDataSource.get(Battery.RuntimeRemainingforThreshold.getObjectId())) != null) {
                vector2 = (Vector)getResult.getValue();
            }
            if ((getResult = this.theDataSource.get(Configuration.LowBatteryRuntime.getObjectId())) != null) {
                vector3 = (Vector)getResult.getValue();
            }
            if ((getResult = this.theDataSource.get(OperatingStatus.PowerSourceShutdownDelay.getObjectId())) != null) {
                vector4 = (Vector)getResult.getValue();
            }
        }
        catch (ClassCastException classCastException) {
            logger.error("verifyRuntimeForAdvancedGroups() - invalid class when verifying runtime {}", (Throwable)classCastException);
            return null;
        }
        int n = theRunTimeVerifier.get_shutdown_delay();
        if (vector != null && vector.size() != list.size() || vector3 != null && vector3.size() != list.size()) {
            logger.warn("verifyRuntimeForAdvancedGroups() - values for all groups not returned, probably initializing");
            logger.debug("verifyRuntimeForAdvancedGroups() - runtimeRemaining: {}", (Object)vector);
            logger.debug("verifyRuntimeForAdvancedGroups() - lowBatteryRuntime: {}", (Object)vector3);
            logger.debug("verifyRuntimeForAdvancedGroups() - powerSourceShutdownDelays: {}", (Object)vector4);
            return null;
        }
        Vector<Object> vector5 = new Vector<Object>();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            UPSSetup uPSSetup = object3.next();
            if (!this.isPhysical(uPSSetup) && !uPSSetup.isVirtualHostsShutdownEnabled()) continue;
            object3.remove();
            vector5.add(uPSSetup);
        }
        list.addAll(vector5);
        object3 = new HashMap();
        for (UPSSetup object22 : list) {
            if (!object22.getCmdFileEnabled()) continue;
            int n2 = object22.getCmdFileDuration();
            if (object22.isExecuteCommandFileAfterHostShutdown()) {
                boolean bl = true;
                if (this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && object22.getHosts().isEmpty() && !object22.isVirtualHostsShutdownEnabled()) {
                    bl = false;
                }
                if (bl) {
                    n2 += object22.getCmdFileDelay();
                }
            }
            if ((object2 = (Integer)((HashMap)object3).get(object22.getCmdFilePath())) != null && (Integer)object2 >= n2) continue;
            ((HashMap)object3).put(object22.getCmdFilePath(), n2);
            logger.debug("verifyRuntimeForAdvancedGroups() - adding cmdfile duration for: {} = {}", (Object)object22.getCmdFilePath(), (Object)n2);
        }
        int n3 = 0;
        String string = "";
        for (Object object2 : ((HashMap)object3).values()) {
            n3 += ((Integer)object2).intValue();
            if (!var12_16.isEmpty()) {
                String string2 = (String)var12_16 + " + " + ((Integer)object2).toString();
                continue;
            }
            String string3 = (String)var12_16 + ((Integer)object2).toString();
        }
        if (n3 > 0) {
            logger.debug("verifyRuntimeForAdvancedGroups() - totalCmdFileDuration: {} = {}", (Object)n3, (Object)var12_16);
        } else {
            logger.debug("verifyRuntimeForAdvancedGroups() - totalCmdFileDuration: {}", (Object)n3);
        }
        HashMap hashMap = new HashMap();
        object2 = this.sshActionHelper.readAll(false);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            SSHSettings sSHSettings = (SSHSettings)iterator.next();
            if (sSHSettings.getTrigger() == SSHActionTrigger.ON_STARTUP) continue;
            boolean bl = sSHSettings.isEnabled();
            for (UPSSetup uPSSetup : list) {
                boolean bl2 = uPSSetup.getSSHSetting(sSHSettings.getSection());
                if (!bl || !bl2) continue;
                hashMap.put(sSHSettings.getSection(), sSHSettings.getRuntime() + 10);
            }
        }
        int n4 = 0;
        String string4 = "";
        for (Integer n5 : hashMap.values()) {
            n4 += n5.intValue();
            if (!var12_21.isEmpty()) {
                String string5 = (String)var12_21 + " + " + n5.toString();
                continue;
            }
            String string6 = (String)var12_21 + n5.toString();
        }
        if (n4 > 0) {
            logger.debug("verifyRuntimeForAdvancedGroups() - totalSSHDuration: {} = {}", (Object)n4, (Object)var12_21);
        } else {
            logger.debug("verifyRuntimeForAdvancedGroups() - totalSSHDuration: {}", (Object)n4);
        }
        int n6 = 0;
        int n7 = 0;
        if (this.services.getVirtualConfigurationManager().isHyperV() && !this.services.getVirtualConfigurationManager().isManagedHost()) {
            logger.debug("verifyRuntimeForAdvancedGroups() - HyperV Standalone Host uses HostConfigSettings");
            VMSettings vMSettings = this.services.getWebServerUtils().readHypervVMSettingsFromConfig();
            if (vMSettings.isGuestVMMigrationEnabled()) {
                logger.debug("guestVMMigrationDuration={}", (Object)vMSettings.getGuestVMMigrationDuration());
                n7 += vMSettings.getGuestVMMigrationDuration();
            }
            if (vMSettings.isGuestVMVAppShutdownEnabled()) {
                logger.debug("guestVMShutdownDuration={}", (Object)vMSettings.getGuestVMVappShutdownDuration());
                n7 += vMSettings.getGuestVMVappShutdownDuration();
            }
            if (vMSettings.isGuestVMVappStartupEnabled()) {
                logger.debug("guestVMStartupDuration={}", (Object)vMSettings.getGuestVMVappStartupDuration());
                n7 += vMSettings.getGuestVMVappStartupDuration();
            }
            logger.debug("verifyRuntimeForAdvancedGroups() - HyperV Standalone Host VM Shutdown delay: {}", (Object)(n7 += RuntimeVerifierUtils.getHyperVStopClusterDurations(vMSettings)));
        }
        int n8 = 0;
        int n9 = 0;
        if (this.services.getVirtualConfigurationManager().isManagedESXi()) {
            n8 = new RuntimeVerifierUtils(this.services).getVsanSyncDurationForAllSetups(list);
            n9 = RuntimeVerifierUtils.getDelayMaintenanceModeTimeoutForAllSetups(list);
            VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig();
            if (vMSettings.isDisableHAMode()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + Disable HA Delay: {}", (Object)(n7 += vMSettings.getDisableHADelay()), (Object)vMSettings.getDisableHADelay());
            }
            if (vMSettings.isVCLSvMsPresent()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + Disabling vCLS Delay: {}", (Object)(n7 += vMSettings.getDisableVClsDelay()), (Object)vMSettings.getDisableVClsDelay());
            }
        }
        for (UPSSetup uPSSetup : list) {
            long l;
            ConfigurationManager configurationManager;
            int n10;
            int n11 = n7;
            logger.info("verifyRuntimeForAdvancedGroups() - calculating for group: {} isPhysical: {}", (Object)uPSSetup.getGroup(), (Object)(this.isPhysical(uPSSetup) || uPSSetup.isVirtualHostsShutdownEnabled() ? 1 : 0));
            logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired (initial): {}", (Object)n11);
            if (uPSSetup.getVMSettings().isGuestVMVappStartupEnabled()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + VM Startup: {}", (Object)(n11 += uPSSetup.getVMSettings().getGuestVMVappStartupDuration()), (Object)uPSSetup.getVMSettings().getGuestVMVappStartupDuration());
            }
            if (uPSSetup.getVMSettings().isGuestVMMigrationEnabled()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + VM Migration: {}", (Object)(n11 += uPSSetup.getVMSettings().getGuestVMMigrationDuration()), (Object)uPSSetup.getVMSettings().getGuestVMMigrationDuration());
            }
            if (this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().isNutanixESXi()) {
                n10 = this.getNutanixClusterShutdownTimes(uPSSetup.getVMSettings());
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + Nutanix Cluster Shutdown: {}", (Object)(n11 += n10), (Object)n10);
            }
            if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + uVM  Shutdown(nutanix): {}", (Object)(n11 += uPSSetup.getVMSettings().getGuestVMVappShutdownDuration()), (Object)uPSSetup.getVMSettings().getGuestVMVappShutdownDuration());
            } else if (!StringUtils.isBlank((CharSequence)this.services.getVirtualConfigurationManager().getVirtualInstallValue()) && uPSSetup.getVMSettings().isGuestVMVAppShutdownEnabled()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + VM & VApp Shutdown: {}", (Object)(n11 += uPSSetup.getVMSettings().getGuestVMVappShutdownDuration()), (Object)uPSSetup.getVMSettings().getGuestVMVappShutdownDuration());
            }
            if (this.services.getHostSystemUtils().isVCenterManagedAdvancedMode() && !this.services.getHostSystemUtils().isVCSAVMInPrioritizationGroup() && (configurationManager = this.services.getConfigurationManager()).containsKey("HostConfigSettings", "VCSA_shutdown_duration")) {
                int n12 = configurationManager.getInt("HostConfigSettings", "VCSA_shutdown_duration", 10);
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + VCSA Shutdown: {}", (Object)(n11 += n12), (Object)n12);
            }
            if (uPSSetup.getVMSettings().getHostMaintenanceEnabled()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + Host Maintenance Duration: {}", (Object)(n11 += uPSSetup.getVMSettings().getHostMaintenanceDuration()), (Object)uPSSetup.getVMSettings().getHostMaintenanceDuration());
            }
            if (uPSSetup.getVMSettings().getHostShutdownEnabled()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + Host Shutdown Duration: {}", (Object)(n11 += uPSSetup.getVMSettings().getHostShutdownDuration()), (Object)uPSSetup.getVMSettings().getHostShutdownDuration());
            }
            if (this.services.getVsanUtils().isVsanCluster()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + vSan Prepare Duration: {}", (Object)(n11 += uPSSetup.getVMSettings().getVsanPrepareDuration()), (Object)uPSSetup.getVMSettings().getVsanPrepareDuration());
            }
            if (this.services.getVirtualConfigurationManager().isManagedESXi()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + vSanSyncDurationForAllSetups: {}", (Object)(n11 += n8), (Object)n8);
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + delayMaintenanceModeTimeoutForAllSetups: {}", (Object)(n11 += n9), (Object)n9);
            }
            logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + cmdFile duration: {}", (Object)(n11 += n3), (Object)n3);
            logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + SSH Actions: {}", (Object)(n11 += n4), (Object)n4);
            if (uPSSetup.getLocalMachineShutdownEnabled()) {
                n10 = theRunTimeVerifier.getTotalOSShutdownTime();
                logger.debug("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired: {} + OS Shutdown: {}", (Object)(n11 += n10), (Object)n10);
            }
            n6 = Math.max(n11, n6);
            logger.debug("verifyRuntimeForAdvancedGroups() - max group ShutdownTimeRequired: {}", (Object)n6);
            if (this.isPhysical(uPSSetup) || uPSSetup.isVirtualHostsShutdownEnabled()) {
                n11 = n6;
                logger.debug("verifyRuntimeForAdvancedGroups() - Physical group using maxShutdownTime: {}", (Object)n11);
            }
            logger.info("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired for group: {} = {}", (Object)uPSSetup.getGroup(), (Object)n11);
            n10 = 0;
            if (logger.isDebugEnabled()) {
                long l2 = TimeUnit.SECONDS.convert(((Integer)vector.get(uPSSetup.getGroup())).intValue(), TimeUnit.MINUTES) - 120L;
                l = (long)n11 + (long)n;
                logger.debug("verifyRuntimeForAdvancedGroups() - Runtime Check: Runtime Available (-2 minutes): {}, Runtime Needed: {}", (Object)l2, (Object)l);
            }
            if (vector != null && TimeUnit.SECONDS.convert(((Integer)vector.get(uPSSetup.getGroup())).intValue(), TimeUnit.MINUTES) - 120L < (long)(n11 + n)) {
                n10 = 1;
                logger.debug("verifyRuntimeForAdvancedGroups() - Runtime Remaining insufficient");
            }
            if (logger.isDebugEnabled()) {
                long l3 = TimeUnit.SECONDS.convert((long)((Integer)vector3.get(uPSSetup.getGroup())).intValue() - 2L, TimeUnit.MINUTES);
                l = n11;
                logger.debug("verifyRuntimeForAdvancedGroups() - Low Battery Check: Runtime Available: {}, Runtime Needed: {}", (Object)l3, (Object)l);
            }
            if (vector3 != null && TimeUnit.SECONDS.convert((long)((Integer)vector3.get(uPSSetup.getGroup())).intValue() - 2L, TimeUnit.MINUTES) < (long)n11) {
                n10 = 1;
                logger.debug("verifyRuntimeForAdvancedGroups() - Low Battery Runtime insufficient");
            }
            TimeUtils timeUtils = new TimeUtils();
            int n13 = (int)timeUtils.roundUp(n11, TimeUnit.SECONDS, TimeUnit.MINUTES);
            logger.info("verifyRuntimeForAdvancedGroups() - shutdownTimeRequired rounded to nearest minute for group {} is {}", (Object)uPSSetup.getGroup(), (Object)n13);
            integerArray[uPSSetup.getGroup()] = n13;
            if (vector4 != null && vector4.size() == list.size() && vector4.get(uPSSetup.getGroup()) != null && n11 > (Integer)vector4.get(uPSSetup.getGroup())) {
                logger.debug("verifyRuntimeForAdvancedGroups() - Powersource Shutdown Delay insufficient: {}", vector4.get(uPSSetup.getGroup()));
                vector4.set(uPSSetup.getGroup(), n13);
            } else if (vector4 != null && uPSSetup.getGroup() < vector4.size()) {
                vector4.set(uPSSetup.getGroup(), null);
            }
            Boolean bl = this.theRunTimeWasEnoughMap.get(uPSSetup.getGroup());
            if (bl == null) {
                bl = true;
            }
            logger.debug("verifyRuntimeForAdvancedGroups() - Runtime Exceeded: {}, Was Enough: {}", (Object)(n10 != 0), (Object)bl);
            if (n10 != 0) {
                if (bl.booleanValue()) {
                    logger.debug("verifyRuntimeForAdvancedGroups() - cancel runtime within range event for group: {}, name: {}", (Object)uPSSetup.getGroup(), (Object)uPSSetup.getName());
                    var27_55 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), false, (IFormatter)this.theRunTimeWithinRangeFormatter, uPSSetup.getGroup(), uPSSetup.getName());
                    this.theEventConsumer.update((Event)var27_55);
                    logger.debug("verifyRuntimeForAdvancedGroups() - create runtime exceeded event for group: {}, name: {}", (Object)uPSSetup.getGroup(), (Object)uPSSetup.getName());
                    var28_56 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), this.theRunTimeExceededFormatter, uPSSetup.getGroup(), uPSSetup.getName(), false, RuntimeVerifierEvents.RunTimeExceeded.getEventId());
                    this.theEventConsumer.update((Event)var28_56);
                    this.theRunTimeWasEnoughMap.put(uPSSetup.getGroup(), false);
                }
            } else if (!bl.booleanValue()) {
                logger.debug("verifyRuntimeForAdvancedGroups() - cancel runtime exceeded event for group: {}, name: {}", (Object)uPSSetup.getGroup(), (Object)uPSSetup.getName());
                var27_55 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), false, (IFormatter)this.theRunTimeExceededFormatter, uPSSetup.getGroup(), uPSSetup.getName());
                this.theEventConsumer.update((Event)var27_55);
                logger.debug("verifyRuntimeForAdvancedGroups() - create runtime within range event for group: {}, name: {}", (Object)uPSSetup.getGroup(), (Object)uPSSetup.getName());
                var28_56 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), this.theRunTimeWithinRangeFormatter, uPSSetup.getGroup(), uPSSetup.getName(), true, RuntimeVerifierEvents.RunTimeWithinRange.getEventId());
                this.theEventConsumer.update((Event)var28_56);
                this.theRunTimeWasEnoughMap.put(uPSSetup.getGroup(), true);
            }
            if (vector2 == null) continue;
            this.verifyRuntimeRemainingThresholdAdvanced(uPSSetup, (Vector)vector2.get(uPSSetup.getGroup()));
        }
        if (vector4 != null && vector4.size() == list.size()) {
            try {
                logger.debug("verifyRuntimeForAdvancedGroups() - setting Powersource Shutdown Delays");
                this.theDataSource.set(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)vector4);
            }
            catch (InvalidValueException invalidValueException) {
                logger.error("verifyRuntimeForAdvancedGroups() - error setting PowerSourceShutdownDelay", (Throwable)invalidValueException);
            }
        }
        logger.debug("verifyRuntimeForAdvancedGroups() - end");
        return integerArray;
    }

    private void verifyRuntimeRemainingThresholdAdvanced(UPSSetup uPSSetup, Vector<Integer> vector) {
        AdvancedGroupEvent advancedGroupEvent;
        Object object2;
        logger.debug("verifyRuntimeRemainingThresholdAdvanced for group: " + uPSSetup.getName());
        Boolean bl = this.onBatteryMap.get(uPSSetup.getGroup());
        if (bl == null) {
            bl = false;
        }
        if (!this.theRuntimeThresholdEventMap.containsKey(uPSSetup.getGroup())) {
            this.theRuntimeThresholdEventMap.put(uPSSetup.getGroup(), false);
        }
        if (!this.theRuntimeCmdFileThresholdEventMap.containsKey(uPSSetup.getGroup())) {
            this.theRuntimeCmdFileThresholdEventMap.put(uPSSetup.getGroup(), false);
        }
        int n = 0;
        int n2 = 0;
        if (vector != null) {
            for (Object object2 : vector) {
                object2 = (int)TimeUnit.SECONDS.convert(object2.intValue(), TimeUnit.MINUTES);
                logger.debug("runtime=" + object2);
                if (object2 < this.theRuntimeThreshold) {
                    ++n;
                }
                if (object2 >= this.theRuntimeCmdFileThreshold) continue;
                ++n2;
            }
        }
        int n3 = uPSSetup.getNumberOfRedundantUPS();
        if (uPSSetup.getRedundancyLostShutdownEnabled()) {
            n3 = Math.max(0, n3 - 1);
        }
        logger.debug("Number of UPS with runtime remaining below threshold = " + n);
        logger.debug("Number of UPS with runtime remaining below command file threshold = " + n2);
        logger.debug("Number of redundant UPS = " + n3);
        if (bl.booleanValue() && n > n3) {
            if (!this.theRuntimeThresholdEventMap.get(uPSSetup.getGroup()).booleanValue()) {
                logger.debug("firing runtime remaining below threshold for group " + uPSSetup.getName());
                object2 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId(), false, uPSSetup.getGroup(), uPSSetup.getName());
                this.theEventConsumer.update((Event)object2);
                advancedGroupEvent = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), true, this.theRunTimeThresholdFormatter, uPSSetup.getGroup(), uPSSetup.getName(), false, RuntimeVerifierEvents.RunTimeRemaining.getEventId());
                this.theEventConsumer.update((Event)advancedGroupEvent);
                this.theRuntimeThresholdEventMap.put(uPSSetup.getGroup(), true);
            }
        } else if (this.theRuntimeThresholdEventMap.get(uPSSetup.getGroup()).booleanValue()) {
            logger.debug("firing runtime remaining back above threshold for group " + uPSSetup.getName());
            object2 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), false, uPSSetup.getGroup(), uPSSetup.getName());
            this.theEventConsumer.update((Event)object2);
            this.theRuntimeThresholdEventMap.put(uPSSetup.getGroup(), false);
            advancedGroupEvent = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId(), true, this.theRunTimeThresholdClearedFormatter, uPSSetup.getGroup(), uPSSetup.getName(), true, RuntimeVerifierEvents.RunTimeRemainingCleared.getEventId());
            this.theEventConsumer.update((Event)advancedGroupEvent);
        }
        if (bl.booleanValue() && n2 > n3) {
            if (!this.theRuntimeCmdFileThresholdEventMap.get(uPSSetup.getGroup()).booleanValue()) {
                logger.debug("firing runtime remaining below command file threshold for group " + uPSSetup.getName());
                object2 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId(), false, uPSSetup.getGroup(), uPSSetup.getName());
                this.theEventConsumer.update((Event)object2);
                advancedGroupEvent = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId(), true, (IFormatter)this.theRunTimeThresholdCmdFileFormatter, uPSSetup.getGroup(), uPSSetup.getName());
                this.theEventConsumer.update((Event)advancedGroupEvent);
                this.theRuntimeCmdFileThresholdEventMap.put(uPSSetup.getGroup(), true);
            }
        } else if (this.theRuntimeCmdFileThresholdEventMap.get(uPSSetup.getGroup()).booleanValue()) {
            logger.debug("firing runtime remaining back above command file threshold for group " + uPSSetup.getName());
            object2 = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId(), false, uPSSetup.getGroup(), uPSSetup.getName());
            this.theEventConsumer.update((Event)object2);
            this.theRuntimeCmdFileThresholdEventMap.put(uPSSetup.getGroup(), false);
            advancedGroupEvent = new AdvancedGroupEvent(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId(), true, (IFormatter)this.theRunTimeThresholdCmdFileClearedFormatter, uPSSetup.getGroup(), uPSSetup.getName());
            this.theEventConsumer.update((Event)advancedGroupEvent);
        }
    }

    public void setFormatterDirectory(String string) {
        this.theRunTimeExceededFormatter = new RunTimeExceededFormatter(string);
        this.theRunTimeWithinRangeFormatter = new RunTimeWithinRangeFormatter(string);
        this.theRunTimeThresholdFormatter = new RunTimeThresholdFormatter(string);
        this.theRunTimeThresholdClearedFormatter = new RunTimeThresholdClearedFormatter(string);
        this.theRunTimeThresholdCmdFileFormatter = new RunTimeThresholdCmdFileFormatter(string);
        this.theRunTimeThresholdCmdFileClearedFormatter = new RunTimeThresholdCmdFileClearedFormatter(string);
    }

    public void setFrequency(int n) {
        this.theDelayTime = n;
    }

    public int getFrequency() {
        return this.theDelayTime;
    }

    public void setRuntimeThreshold(int n) {
        this.theRuntimeThreshold = n;
    }

    public int getRuntimeThreshold() {
        return this.theRuntimeThreshold;
    }

    public int getRuntimeCmdFileThreshold() {
        return this.theRuntimeCmdFileThreshold;
    }

    public void setRuntimeCmdFileThreshold(int n) {
        this.theRuntimeCmdFileThreshold = n;
    }

    public void setOnBattery(boolean bl) {
        this.onBattery = bl;
    }

    public void setOnBattery(boolean bl, int n) {
        this.onBatteryMap.put(n, bl);
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theEventConsumer = iEventConsumer;
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theEventConsumer = null;
    }

    public void stop_verifier() {
        this.disableDelayVerifier();
    }

    private synchronized void disableDelayVerifier() {
        this.theDelayVerifierIsEnabled = false;
    }

    private synchronized boolean isDelayVerifierEnabled() {
        return this.theDelayVerifierIsEnabled;
    }

    public synchronized void suspendVerifier() {
        this.threadSuspended = true;
    }

    public synchronized void resumeVerifier() {
        this.threadSuspended = false;
    }

    private synchronized boolean isVerifierSuspended() {
        return this.threadSuspended;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    private int getNutanixClusterShutdownTimes(VMSettings vMSettings) {
        int n;
        int n2 = 0;
        int n3 = vMSettings.getCvmShutdownDuration();
        logger.debug("NutanixClusterShutdownTimes + cvmShutdownDuration({}) = {}", (Object)n3, (Object)(n2 += n3));
        int n4 = vMSettings.getCvmStartupDuration();
        logger.debug("NutanixClusterShutdownTimes + cvmStartupDuration({}) = {}", (Object)n4, (Object)(n2 += n4));
        int n5 = vMSettings.getClusterShutdownDuration();
        logger.debug("NutanixClusterShutdownTimes + clusterShutdownDuration({}) = {}", (Object)n5, (Object)(n2 += n5));
        if (vMSettings.isAfsShutdownEnable()) {
            n = vMSettings.getAfsShutdownDuration();
            logger.debug("NutanixClusterShutdownTimes + afsShutdownDuration({}) = {}", (Object)n, (Object)(n2 += n));
        }
        if (vMSettings.isOngoingReplicationAbortDelayEnable()) {
            n = vMSettings.getOngoingReplicationAbortDelayDuration();
            logger.debug("NutanixClusterShutdownTimes + ongoingReplicationAbortDelayDuration({}) = {}", (Object)n, (Object)(n2 += n));
        }
        return n2;
    }

    @Generated
    public Integer[] getTotalShutdownDuration() {
        return this.totalShutdownDuration;
    }
}

