/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.runtimeverifier;

import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.pcns.ServiceManager;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeVerifierUtils {
    private static final Logger logger = LogManager.getLogger(RuntimeVerifierUtils.class);
    private ServiceManager services;

    public RuntimeVerifierUtils(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    public int getVsanSyncTimeout(VMSettings vMSettings, Collection<String> collection) {
        if (collection == null || collection.size() <= 0 || vMSettings.getVsanSyncTimeout() <= 0) {
            return 0;
        }
        if (collection.stream().anyMatch(string -> VsanUtils.isHostnameWithVsanTag(string))) {
            logger.debug("getVsanSyncTimeout() - timeout: {}", (Object)vMSettings.getVsanSyncTimeout());
            return vMSettings.getVsanSyncTimeout();
        }
        logger.debug("getVsanSyncTimeout() - no hosts are part of vSAN cluster");
        return 0;
    }

    public static int getDelayMaintenanceModeTimeout(VMSettings vMSettings, Collection<String> collection) {
        if (collection == null || collection.size() <= 0 || !vMSettings.isHostMaintenanceModeDelayed() || vMSettings.getHostMaintenanceModeTimeout() <= 0) {
            return 0;
        }
        int n = vMSettings.getHostMaintenanceModeTimeout() * collection.size();
        logger.debug("getDelayMaintenanceModeTimeout() - timeout: {}, hosts: {} ~ total: {}", (Object)vMSettings.getHostMaintenanceModeTimeout(), (Object)collection.size(), (Object)n);
        return n;
    }

    public static int getDelayMaintenanceModeTimeoutForAllSetups(List<UPSSetup> list) {
        int n = 0;
        for (UPSSetup uPSSetup : list) {
            int n2 = RuntimeVerifierUtils.getDelayMaintenanceModeTimeout(uPSSetup.getVMSettings(), uPSSetup.getHosts());
            logger.debug("getDelayMaintenanceModeTimeoutForAllSetups() - upsSetup: {}, groupTotal: {}", (Object)uPSSetup.getGroup(), (Object)n2);
            n += n2;
        }
        return n;
    }

    public int getVsanSyncDurationForAllSetups(List<UPSSetup> list) {
        int n = 0;
        for (UPSSetup uPSSetup : list) {
            int n2 = this.getVsanSyncTimeout(uPSSetup.getVMSettings(), uPSSetup.getHosts());
            logger.debug("getVsanSyncDurationForAllSetups() - upsSetup: {}, groupTotal: {}", (Object)uPSSetup.getGroup(), (Object)n2);
            n += n2;
        }
        return n;
    }

    public static int getHyperVStopClusterDurations(VMSettings vMSettings) {
        int n = 0;
        if (vMSettings != null && vMSettings.isHVStopClusterEnabled()) {
            logger.debug("getHyperVStopClusterDurations() - stop cluster enabled");
            int n2 = vMSettings.getHVStopClusterDuration();
            logger.debug("getHyperVStopClusterDurations() - hvStopClusterDuration: {}", (Object)n2);
            n += n2;
            int n3 = vMSettings.getHVStartClusterDuration();
            logger.debug("getHyperVStopClusterDurations() - hvStartClusterDuration: {}", (Object)n3);
            n += n3;
        }
        return n;
    }
}

