/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.runtimeverifier;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.runtimeverifier.RuntimeVerifierUtils;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareESXiHostType;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import com.apcc.pcns.util.TimeUtils;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verifier
implements IDataConsumer {
    private static final Logger logger = LogManager.getLogger(Verifier.class);
    private static final int TRAP_PROPAGATION_DELAY = 2;
    private static final int kMinutesToSecondsConversion = 60;
    private IDataSource theDataSource;
    private SSHActionConfigurator sshActionHelper;
    private ServiceManager services;
    private Integer totalShutdownDuration = null;

    public Verifier(@NonNull SSHActionConfigurator sSHActionConfigurator, @NonNull ServiceManager serviceManager) {
        if (sSHActionConfigurator == null) {
            throw new IllegalArgumentException("sshActionHelper is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.sshActionHelper = sSHActionConfigurator;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    public int getTotalOSShutdownTime() {
        int n;
        int n2 = 0;
        logger.debug("getTotalOSShutdownTime() - start");
        if (this.services.getConfigurationManager().isEnabled("Shutdown", "shutdownCommandFileEnabled").booleanValue()) {
            n = this.services.getConfigurationManager().getInt("Shutdown", "shutdownCommandFileDuration", 0);
            logger.debug("getTotalOSShutdownTime() - shutdownCommandFileDuration: {}", (Object)n);
            n2 += n;
            int n3 = this.services.getConfigurationManager().getInt("Shutdown", "shutdownCommandFileDelay", 0);
            logger.debug("getTotalOSShutdownTime() - shutdownCommandFileDelay: {}", (Object)n3);
            n2 += n3;
        }
        n = this.services.getConfigurationManager().getInt("Shutdown", "shutdownDelay", 0);
        logger.debug("getTotalOSShutdownTime() - shutdownDelay: {}", (Object)n);
        n2 += n;
        n = this.services.getConfigurationManager().getInt("Shutdown", "shutdownCommandDuration", 0);
        logger.debug("getTotalOSShutdownTime() - shutdownCommandDuration: {}", (Object)n);
        logger.debug("getTotalOSShutdownTime() - end, result: {}", (Object)(n2 += n));
        return n2;
    }

    private int getSSHActionShutdownTime() {
        logger.debug("getSSHActionShutdownTime() - start");
        List<SSHSettings> list = this.sshActionHelper.readAll(false);
        int n = 0;
        for (SSHSettings sSHSettings : list) {
            if (sSHSettings.getTrigger() == SSHActionTrigger.ON_STARTUP || !sSHSettings.isEnabled()) continue;
            n += sSHSettings.getRuntime() + 10;
        }
        logger.debug("getSSHActionShutdownTime() - end, result: {}", (Object)n);
        return n;
    }

    private int getClusterShutdownTime() {
        int n = 0;
        logger.debug("getClusterShutdownTime() - start");
        if (this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            return this.getNutanixClusterShutdownTime();
        }
        if (this.services.getVirtualConfigurationManager().isHyperflex()) {
            return this.getHyperflexClusterShutdownTime();
        }
        if (this.services.getVirtualConfigurationManager().isSimplivity()) {
            return this.getSimplivityClusterShutdownTime();
        }
        if (this.services.getVirtualConfigurationManager().isVxRail()) {
            return this.getVxRailClusterShutdownTime();
        }
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            logger.debug("getClusterShutdownTime() - Hyper-V");
            n += RuntimeVerifierUtils.getHyperVStopClusterDurations(this.services.getWebServerUtils().readHypervVMSettingsFromConfig());
        }
        if (this.services.getConfigurationManager().containsKey("HostConfigSettings", "vsan_prepare")) {
            logger.debug("getClusterShutdownTime() - Hyper-V");
            n += this.getVsanClusterPrepareDuration();
        }
        logger.debug("getClusterShutdownTime() - end, result: {}", (Object)n);
        return n;
    }

    private int getNutanixClusterShutdownTime() {
        int n;
        logger.debug("getNutanixClusterShutdownTime() - start");
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig(null);
        int n2 = 0;
        int n3 = vMSettings.getCvmShutdownDuration();
        logger.debug("getNutanixClusterShutdownTime() - cvmShutdownDuration: {}", (Object)n3);
        n2 += n3;
        int n4 = vMSettings.getCvmStartupDuration();
        logger.debug("getNutanixClusterShutdownTime() - cvmStartupDuration: {}", (Object)n4);
        n2 += n4;
        int n5 = vMSettings.getClusterShutdownDuration();
        logger.debug("getNutanixClusterShutdownTime() - clusterShutdownDuration: {}", (Object)n5);
        n2 += n5;
        if (vMSettings.isAfsShutdownEnable()) {
            n = vMSettings.getAfsShutdownDuration();
            logger.debug("getNutanixClusterShutdownTime() - afsShutdownDuration: {}", (Object)n);
            n2 += n;
        }
        if (vMSettings.isOngoingReplicationAbortDelayEnable()) {
            n = vMSettings.getOngoingReplicationAbortDelayDuration();
            logger.debug("getNutanixClusterShutdownTime() - ongoingReplicationAbortDelayDuration: {}", (Object)n);
            n2 += n;
        }
        logger.debug("getNutanixClusterShutdownTime() - end, result: {}", (Object)n2);
        return n2;
    }

    private int getSimplivityClusterShutdownTime() {
        logger.debug("getSimplivityClusterShutdownTime() - start");
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig(null);
        int n = 0;
        int n2 = vMSettings.getOvcShutdownDuration();
        logger.debug("getSimplivityClusterShutdownTime() - OvcShutdownDuration: {}", (Object)n2);
        n += n2;
        int n3 = vMSettings.getOvcStartupDuration();
        logger.debug("getSimplivityClusterShutdownTime() - OvcStartupDuration: {}", (Object)n3);
        logger.debug("getSimplivityClusterShutdownTime() - end, result: {}", (Object)(n += n3));
        return n;
    }

    private int getHyperflexClusterShutdownTime() {
        logger.debug("getHyperflexClusterShutdownTime() - start");
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig(null);
        int n = 0;
        int n2 = vMSettings.getCvmShutdownDuration();
        logger.debug("getHyperflexClusterShutdownTime() - cvmShutdownDuration: {}", (Object)n2);
        n += n2;
        int n3 = vMSettings.getCvmStartupDuration();
        logger.debug("getHyperflexClusterShutdownTime() - cvmStartupDuration: {}", (Object)n3);
        n += n3;
        int n4 = vMSettings.getClusterShutdownDuration();
        logger.debug("getHyperflexClusterShutdownTime() - clusterShutdownDuration: {}", (Object)n4);
        logger.debug("getHyperflexClusterShutdownTime() - end, result: {}", (Object)(n += n4));
        return n;
    }

    private int getVxRailClusterShutdownTime() {
        logger.debug("getVxRailClusterShutdownTime() - start");
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig(null);
        int n = 0;
        int n2 = vMSettings.getVxRailShutdownDuration();
        logger.debug("getVxRailClusterShutdownTime() - vxRailShutdownDuration: {}", (Object)n2);
        n += n2;
        int n3 = vMSettings.getVxRailShutdownDelay();
        logger.debug("getVxRailClusterShutdownTime() - vxRailShutdownDelay: {}", (Object)n3);
        logger.debug("getVxRailClusterShutdownTime() - end, result: {}", (Object)(n += n3));
        return n;
    }

    private int getVsanClusterPrepareDuration() {
        logger.debug("getVsanClusterPrepareDuration() - start");
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromConfig(null);
        int n = 0;
        int n2 = vMSettings.getVsanPrepareDuration();
        logger.debug("getVsanClusterPrepareDuration() - vsanPrepareDuration: {}", (Object)n2);
        logger.debug("getVsanClusterPrepareDuration() - end, result: {}", (Object)(n += n2));
        return n;
    }

    private int getTotalVMSettingsShutdownTime() {
        int n = 0;
        logger.debug("getTotalVMSettingsShutdownTime() - start");
        boolean bl = this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV();
        boolean bl2 = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl3 = this.services.getVirtualConfigurationManager().isVxRail();
        if (bl || bl2) {
            VMSettings vMSettings = null;
            vMSettings = bl2 ? this.services.getWebServerUtils().readHypervVMSettingsFromConfig() : this.services.getWebServerUtils().readVMSettingsFromConfig(null);
            if (vMSettings.isGuestVMMigrationEnabled()) {
                logger.debug("getTotalVMSettingsShutdownTime() - guestVMMigrationDuration: {}", (Object)vMSettings.getGuestVMMigrationDuration());
                n += vMSettings.getGuestVMMigrationDuration();
            }
            if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
                logger.debug("getTotalVMSettingsShutdownTime() - guestVMShutdownDuration: {}", (Object)vMSettings.getGuestVMVappShutdownDuration());
                n += vMSettings.getGuestVMVappShutdownDuration();
            }
            if (vMSettings.isGuestVMVAppShutdownEnabled()) {
                logger.debug("getTotalVMSettingsShutdownTime() - guestVMShutdownDuration: {}", (Object)vMSettings.getGuestVMVappShutdownDuration());
                n += vMSettings.getGuestVMVappShutdownDuration();
            }
            if (vMSettings.isGuestVMVappStartupEnabled()) {
                logger.debug("getTotalVMSettingsShutdownTime() - guestVMStartupDuration: {} BeforeVmStartupDelay: {}  betweenVmStartupDelay: {}", (Object)vMSettings.getGuestVMVappStartupDuration(), (Object)vMSettings.getBeforeVmStartupDelay(), (Object)vMSettings.getBetweenVmStartupDelay());
                n += vMSettings.getGuestVMVappStartupDuration() + vMSettings.getBeforeVmStartupDelay() + vMSettings.getBetweenVmStartupDelay();
            }
            if (!(bl2 || !this.services.getConfigurationManager().containsKey("HostDetails", "is_VCSA") || !this.services.getConfigurationManager().getBoolean("HostDetails", "is_VCSA").booleanValue() || bl3 && this.services.getVxRailUtils().isVcsaOnVxRailVsanHost() || this.services.getHostSystemUtils().isVCSAVMInPrioritizationGroup())) {
                logger.debug("getTotalVMSettingsShutdownTime() - VCSAShutdownDuration: {}", (Object)vMSettings.getvCSAShutdownDuration());
                n += vMSettings.getvCSAShutdownDuration();
            }
            if (vMSettings.getHostMaintenanceEnabled()) {
                logger.debug("getTotalVMSettingsShutdownTime() - HostMaintenanceDuration: {}", (Object)vMSettings.getHostMaintenanceDuration());
                n += vMSettings.getHostMaintenanceDuration();
            }
            if (vMSettings.getHostShutdownEnabled()) {
                logger.debug("getTotalVMSettingsShutdownTime() - HostShutdownDuration: {}", (Object)vMSettings.getHostShutdownDuration());
                n += vMSettings.getHostShutdownDuration();
            }
            if (this.services.getVirtualConfigurationManager().isManagedESXi()) {
                int n2;
                List<String> list = this.services.getVirtualConfigurationManager().parseHostListParameterWithVsanTags("HostConfigSettings");
                if (!bl3) {
                    n2 = new RuntimeVerifierUtils(this.services).getVsanSyncTimeout(vMSettings, list);
                    logger.debug("getTotalVMSettingsShutdownTime() - vSanSyncTimeout: {}", (Object)n2);
                    n += n2;
                }
                if (this.services.getVirtualConfigurationManager().isVxRail() && !this.services.getVxRailUtils().isVcsaOnVxRailVsanHost()) {
                    VsanUtils vsanUtils = this.services.getVsanUtils();
                    HostSystemUtils hostSystemUtils = this.services.getHostSystemUtils();
                    list = vsanUtils.removeVsanTagsFromHostlist(list);
                    list = list.stream().filter(string -> !VMWareESXiHostType.VSAN.equals((Object)vsanUtils.checkHostType(hostSystemUtils.getHostSystem((String)string)))).collect(Collectors.toList());
                }
                n2 = RuntimeVerifierUtils.getDelayMaintenanceModeTimeout(vMSettings, list);
                logger.debug("getTotalVMSettingsShutdownTime() - DelayMaintenanceModeTimeout: {}", (Object)n2);
                n += n2;
                if (this.services.getVirtualConfigurationManager().hasVCLSBeenDetectedOnCluster()) {
                    n += this.services.getVirtualConfigurationManager().getDisableVClsDelay();
                }
                if (this.services.getVirtualConfigurationManager().getDisableHAOnShutdown()) {
                    n += this.services.getVirtualConfigurationManager().getDisableHADelay();
                }
            }
        }
        logger.debug("getTotalVMSettingsShutdownTime() - end, result: {}", (Object)n);
        return n;
    }

    public int get_shutdown_delay() throws InvalidObjectIdException, CommunicationException {
        int n = 0;
        logger.debug("get_shutdown_delay() - start");
        GetResult getResult = this.theDataSource.get(ShutdownGroup.ShutdownTriggers.getObjectId());
        Vector vector = (Vector)getResult.getValue();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            VariableBinding variableBinding = (VariableBinding)enumeration.nextElement();
            if (!variableBinding.getObjectId().equals((Object)UtilityLineStatus.PowerFailed.getObjectId())) continue;
            n = (Integer)variableBinding.getValue();
            break;
        }
        logger.debug("get_shutdown_delay() - end, result: {}", (Object)n);
        return n;
    }

    public boolean runtime_exceeded() throws InvalidObjectIdException, CommunicationException {
        boolean bl = false;
        logger.debug("runtime_exceeded() - start");
        GetResult getResult = this.theDataSource.get(Battery.RuntimeRemaining.getObjectId());
        Integer n = (Integer)getResult.getValue();
        long l = TimeUnit.SECONDS.convert(n.longValue(), TimeUnit.MINUTES);
        logger.debug("runtime_exceeded() - Battery.RuntimeRemaining: {} seconds", (Object)l);
        int n2 = this.getTotalOSShutdownTime() + this.getSSHActionShutdownTime() + this.getClusterShutdownTime() + this.getTotalVMSettingsShutdownTime();
        logger.debug("runtime_exceeded() - total shutdown time: {}", (Object)n2);
        int n3 = this.get_shutdown_delay();
        logger.debug("runtime_exceeded() - delay_before_shutdown_begins: {}", (Object)n3);
        logger.debug("runtime_exceeded() - runtime available: {}, runtime required: {}", (Object)(l -= TimeUnit.SECONDS.convert(2L, TimeUnit.MINUTES)), (Object)(n2 + n3));
        if (l < (long)(n2 + n3)) {
            bl = true;
        }
        if (!bl) {
            getResult = this.theDataSource.get(Configuration.LowBatteryRuntime.getObjectId());
            int n4 = (Integer)getResult.getValue() * 60;
            logger.debug("runtime_exceeded() - low battery duration: {}", (Object)n4);
            logger.debug("runtime_exceeded() - low battery duration: {}, total shutdown time: {}", (Object)((long)n4 - TimeUnit.SECONDS.convert(2L, TimeUnit.MINUTES)), (Object)n2);
            if ((long)n4 - TimeUnit.SECONDS.convert(2L, TimeUnit.MINUTES) < (long)n2) {
                bl = true;
            }
        }
        logger.debug("runtime_exceeded() - runtime_is_not_enough: {}", (Object)bl);
        this.increaseShutdownDelay(n2);
        return bl;
    }

    private void increaseShutdownDelay(int n) {
        logger.debug("increaseShutdownDelay() - start, totalShutdownTime: {}", (Object)n);
        try {
            int n2 = 0;
            GetResult getResult = this.theDataSource.get(OperatingStatus.PowerSourceShutdownDelay.getObjectId());
            int n3 = (Integer)getResult.getValue();
            TimeUtils timeUtils = new TimeUtils();
            n2 = (int)timeUtils.roundUp(n, TimeUnit.SECONDS, TimeUnit.MINUTES);
            logger.debug("increaseShutdownDelay() - rounded delay to: {}", (Object)n2);
            this.totalShutdownDuration = n2;
            if (n3 < n2) {
                logger.info("increaseShutdownDelay() - increase delay from: {} to: {}", (Object)n3, (Object)n2);
                SetResult setResult = this.theDataSource.set(OperatingStatus.PowerSourceShutdownDelay.getObjectId(), (Object)n2);
                if (!setResult.wasSuccessful()) {
                    logger.error("increaseShutdownDelay() - cannot increase the power source's shutdown delay");
                }
            }
        }
        catch (InvalidValueException invalidValueException) {
            logger.error("increaseShutdownDelay() - InvalidValueException, cannot compute value", (Throwable)invalidValueException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error("increaseShutdownDelay() - InvalidObjectIdException, cannot compute value", (Throwable)invalidObjectIdException);
        }
        catch (CommunicationException communicationException) {
            logger.debug("increaseShutdownDelay() - CommunicationException, cannot compute value", (Throwable)communicationException);
        }
        catch (Exception exception) {
            logger.error("increaseShutdownDelay() - Exception, cannot compute value", (Throwable)exception);
        }
    }

    @Generated
    public Integer getTotalShutdownDuration() {
        return this.totalShutdownDuration;
    }
}

