/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.pcns.ServiceManager;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedOSShutdowner
extends Thread {
    private IPermanentStorage m11Config;
    private static final Logger logger = LogManager.getLogger(DelayedOSShutdowner.class);
    private ServiceManager services;

    public DelayedOSShutdowner(IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.m11Config = iPermanentStorage;
        this.services = serviceManager;
    }

    @Override
    public void run() {
        try {
            TimeUnit.SECONDS.sleep(this.services.getVirtualConfigurationManager().getShutdownDelay());
            Object[] objectArray = new String[2];
            objectArray[0] = this.getShutdownFileName();
            long l = this.services.getVirtualConfigurationManager().getShutdownDuration();
            objectArray[1] = Long.toString(l);
            logger.info("Shutdowner command: {}", (Object)Arrays.toString(objectArray));
            Runtime runtime = Runtime.getRuntime();
            runtime.exec((String[])objectArray);
            TimeUnit.MINUTES.sleep(l);
        }
        catch (Exception exception) {
            logger.error("Could not execute shutdown script", (Throwable)exception);
        }
    }

    public String getShutdownFileName() {
        String string = "";
        try {
            string = this.services.getConfigurationManager().getString("Shutdown", "shutdownCommand");
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException);
        }
        logger.debug("Reading shutdown command from INI, got: {}", (Object)string);
        if (string == null || string.isEmpty()) {
            String string2 = this.services.getApplicationSettings().getApplicationDirectory();
            String string3 = StringUtils.joinWith((String)File.separator, (Object[])new Object[]{string2, "bin", "shutdown"});
            String string4 = StringUtils.joinWith((String)File.separator, (Object[])new Object[]{string2, "bin", "shutdown.cmd"});
            File file = new File(string4);
            string = file.exists() ? string4 : string3;
            logger.debug("Setting shutdown command to: {}", (Object)string);
            this.services.getConfigurationManager().setProperty("Shutdown", "shutdownCommand", string);
        }
        return string;
    }
}

