/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.sshservice.SSHActionManager;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupClearedTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(GroupClearedTask.class);
    int groupId;
    @NonNull
    private ServiceManager services;
    @NonNull
    private SSHActionManager sshActionManager;

    public GroupClearedTask(int n, @NonNull SSHActionManager sSHActionManager, @NonNull ServiceManager serviceManager) {
        if (sSHActionManager == null) {
            throw new IllegalArgumentException("sshActionManager is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.sshActionManager = sSHActionManager;
        this.groupId = n;
    }

    @Override
    public void run() {
        logger.debug("Running Cleared Group Actions");
        this.sshActionManager.clearActionLocks(SSHActionTrigger.BEFORE_HOST_SHUTDOWN);
        this.sshActionManager.clearActionLocks(SSHActionTrigger.AFTER_HOST_SHUTDOWN);
        this.sshActionManager.clearActionLocks(SSHActionTrigger.BEFORE_VM_SHUTDOWN);
        this.sshActionManager.runSSHActions(this.groupId, SSHActionTrigger.ON_STARTUP);
        logger.debug("Running Cleared Group Actions DONE");
    }
}

