/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.ShutdownSequencer;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.sshservice.SSHActionManager;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MasterSequenceThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(MasterSequenceThread.class);
    private StandardHost host;
    private Event triggerEvent;
    private ShutdownState theState;
    private IPermanentStorage aPermanentStorage;
    private ShutdownSequencer sequencer;
    private IEventConsumer eventConsumer;
    private IDataSource dataSource;
    private String setupName = "";
    private final Object lock = new Object();
    protected static AtomicInteger ThreadCount = new AtomicInteger(0);
    protected static Integer[] Waypoint = null;
    private static LinkedHashSet<String> criticalHostsPerformingVMTasks = new LinkedHashSet();
    private static LinkedHashSet<String> protectedHostsRunningCmdFile = new LinkedHashSet();
    private static LinkedHashSet<String> criticalHostsShuttingDown = new LinkedHashSet();
    private static LinkedHashSet<String> criticalHostsPerformingClusterStopOps = new LinkedHashSet();
    private SSHActionManager sshActionMgr;
    private ServiceManager services;
    private OperatingSystemEventLogger osLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterSequenceThread(StandardHost standardHost, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage, ShutdownSequencer shutdownSequencer, IEventConsumer iEventConsumer, IDataSource iDataSource, SSHActionManager sSHActionManager, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.osLogger = this.services.getOperatingSystemEventLogger();
        this.host = standardHost;
        this.triggerEvent = event;
        this.theState = shutdownState;
        this.aPermanentStorage = iPermanentStorage;
        this.sequencer = shutdownSequencer;
        this.eventConsumer = iEventConsumer;
        this.dataSource = iDataSource;
        this.sshActionMgr = sSHActionManager;
        AtomicInteger atomicInteger = ThreadCount;
        synchronized (atomicInteger) {
            if (Waypoint == null) {
                Waypoint = new Integer[4];
                Arrays.fill((Object[])Waypoint, (Object)0);
            }
        }
    }

    @Override
    public void run() {
        logger.info("Starting Master Shutdown Sequence with {}", (Object)this.host.getClass().getName());
        try {
            this.services.getShutdownLogger().clearShutdownReasons();
            this.StartSequence();
            if (this.triggerEvent != null && this.triggerEvent instanceof AdvancedGroupEvent) {
                this.setupName = ((AdvancedGroupEvent)this.triggerEvent).getGroupName();
                logger.info("UPS Setup: {}", (Object)this.setupName);
            }
            logger.info("STEP: Initialise");
            this.host.initialize(this.eventConsumer, this.dataSource, this.triggerEvent, this.theState, this.aPermanentStorage);
            logger.debug("protected hosts: {}", this.host.getProtectedHostList());
            logger.debug("critical hosts: {}", this.host.getHostSet());
            boolean bl = this.host.isExecuteCommandFileAfterHostShutdown(this.triggerEvent);
            boolean bl2 = "advanced".equals(this.services.getVirtualConfigurationManager().getUPSConfigMode());
            if (bl2) {
                logger.debug("{} blocking critical hosts for VM Operations", (Object)this.setupName);
                this.blockCriticalHosts(criticalHostsPerformingVMTasks);
                logger.debug("{} blocking critical hosts for host shutdown", (Object)this.setupName);
                this.blockCriticalHosts(criticalHostsShuttingDown);
            }
            logger.info("STEP: WayPoint - wait for all threads to lock all critical hosts");
            this.WayPoint(0);
            logger.info("STEP: Initialise UPS Turn Off");
            this.host.turnOffUpsOrOutlet(this.triggerEvent);
            logger.info("STEP: Entering retreat mode & Disabling HA");
            this.host.handleVCLS();
            logger.info("STEP: Pre User VM Shutdown SSH Actions");
            this.runPreUserVMShutdownSSHActions();
            logger.info("STEP: VMTasks");
            this.host.vMTasks();
            logger.info("STEP: VCSA VM Shutdown");
            this.host.VCSAVMShutdown();
            if (bl2) {
                logger.debug("{} releasing critical hosts with VM Operations completed", (Object)this.setupName);
                this.releaseCriticalHosts(criticalHostsPerformingVMTasks);
                logger.debug("{} waiting for critical hosts performing VM Operations", (Object)this.setupName);
                this.waitForAllBlockedHosts(criticalHostsPerformingVMTasks);
                logger.debug("{} waiting for critical hosts performing Cluster Operations", (Object)this.setupName);
                this.waitForBlockedHosts(criticalHostsPerformingClusterStopOps);
                logger.debug("{} blocking critical hosts for Cluster Operations", (Object)this.setupName);
                this.blockCriticalHosts(criticalHostsPerformingClusterStopOps);
            }
            logger.info("STEP: Perform cluster/HCI operations");
            this.host.performClusterStopOps();
            if (bl2) {
                logger.debug("{} releasing critical hosts with Cluster Operations completed", (Object)this.setupName);
                this.releaseCriticalHosts(criticalHostsPerformingClusterStopOps);
                logger.debug("{} waiting for critical hosts performing Cluster Operations", (Object)this.setupName);
                this.waitForAllBlockedHosts(criticalHostsPerformingClusterStopOps);
            }
            logger.info("STEP: Pre Host Shutdown SSH Actions");
            this.runPreHostShutdownSSHActions();
            logger.info("STEP: Pre Host Shutdown Command Files");
            this.runPreHostShutdownCommandFiles(bl, bl2);
            logger.info("STEP: enter MaintenanceMode");
            this.host.enterMaintenanceMode();
            logger.info("STEP: host Shutdown");
            this.host.hostShutdown();
            logger.info("STEP: WayPoint - wait for all threads before PCNS Host Shutdown");
            this.WayPoint(1);
            logger.info("STEP: PCNS Host shutdown");
            this.host.pcnsHostShutdown();
            if (bl2) {
                logger.debug("{} releasing critical hosts with host shutdown completed", (Object)this.setupName);
                this.releaseCriticalHosts(criticalHostsShuttingDown);
                logger.debug("{} waiting for critical hosts performing host shutdown", (Object)this.setupName);
                this.waitForBlockedHosts(criticalHostsShuttingDown);
            }
            logger.info("STEP: Post Host Shutdown SSH Actions");
            this.runPostHostShutdownSSHActions();
            logger.info("STEP: Post Host Shutdown Command Files");
            this.runPostHostShutdownCommandFiles(bl, bl2);
            logger.info("STEP: WayPoint - wait for all threads before PCNS OS Shutdown");
            this.WayPoint(2);
            logger.info("STEP: PCNS OS Shutdown");
            this.host.pcnsOSShutdown();
            if (this.services.getWebServerUtils().isTurnOffUPSOrOutlet(this.triggerEvent)) {
                try {
                    logger.debug("Start UPS/Outlet Off delay of 60 seconds to allow Turn Off receipt from NMC");
                    TimeUnit.SECONDS.sleep(60L);
                    logger.debug("End UPS/Outlet Off delay");
                }
                catch (InterruptedException interruptedException) {
                    logger.error("UPS/Outlet delay.");
                }
            }
        }
        catch (Throwable throwable) {
            logger.error("STEP: MasterSequence Exception", throwable);
            throw throwable;
        }
        finally {
            this.sshActionMgr.clearActionLocks(SSHActionTrigger.BEFORE_VM_SHUTDOWN);
            this.sshActionMgr.clearActionLocks(SSHActionTrigger.BEFORE_HOST_SHUTDOWN);
            this.sshActionMgr.clearActionLocks(SSHActionTrigger.AFTER_HOST_SHUTDOWN);
            logger.info("STEP: MasterSequence End");
            this.EndSequence();
        }
    }

    private Integer getAdvancedSetupGroup(Event event) {
        Integer n = null;
        if (event instanceof AdvancedGroupEvent) {
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
            n = advancedGroupEvent.getGroup();
        }
        return n;
    }

    private void runPreUserVMShutdownSSHActions() {
        logger.debug("runPreUserVMShutdownSSHActions() - start");
        this.sshActionMgr.clearActionLocks(SSHActionTrigger.ON_STARTUP);
        logger.debug("runPreUserVMShutdownSSHActions() - cleared SSH action locks for startup");
        Integer n = this.getAdvancedSetupGroup(this.triggerEvent);
        logger.debug("runPreUserVMShutdownSSHActions() - running runSSHActions() for group {}", (Object)n);
        this.sshActionMgr.runSSHActions(n, SSHActionTrigger.BEFORE_VM_SHUTDOWN);
        logger.debug("runPreUserVMShutdownSSHActions() - end");
    }

    private void runPreHostShutdownSSHActions() {
        Integer n = this.getAdvancedSetupGroup(this.triggerEvent);
        logger.debug("runPreHostShutdownSSHActions() - running runSSHActions() for group {}", (Object)n);
        this.sshActionMgr.runSSHActions(n, SSHActionTrigger.BEFORE_HOST_SHUTDOWN);
        logger.debug("runPreHostShutdownSSHActions() - end");
    }

    private void runPostHostShutdownSSHActions() {
        logger.debug("runPostHostShutdownSSHActions() - start");
        Integer n = this.getAdvancedSetupGroup(this.triggerEvent);
        this.sshActionMgr.runSSHActions(n, SSHActionTrigger.AFTER_HOST_SHUTDOWN);
        logger.debug("runPostHostShutdownSSHActions() - end");
    }

    private void runPostHostShutdownCommandFiles(boolean bl, boolean bl2) {
        logger.debug("runPostHostShutdownCommandFiles() - start");
        if (bl) {
            this.runShutdownCommandFile(bl2, true);
        }
        logger.debug("runPostHostShutdownCommandFiles() - end");
    }

    private void runPreHostShutdownCommandFiles(boolean bl, boolean bl2) {
        logger.debug("runPreHostShutdownCommandFiles() - start");
        if (!bl) {
            this.runShutdownCommandFile(bl2, false);
        }
        if (bl2) {
            if (bl) {
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.debug("{} waiting for blocked hosts executing command file", (Object)this.setupName);
            this.waitForBlockedHosts(protectedHostsRunningCmdFile);
        }
        logger.debug("runPreHostShutdownCommandFiles() - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockHostsForCommandFiles() {
        logger.debug("blockProtectedHosts - start {}", (Object)this.setupName);
        Set<String> set = this.host.getProtectedHostList();
        if (set != null && !set.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = protectedHostsRunningCmdFile;
            synchronized (linkedHashSet) {
                protectedHostsRunningCmdFile.addAll(set);
                logger.debug("blockProtectedHosts - processing Hosts: {}", protectedHostsRunningCmdFile);
            }
        }
        logger.debug("blockProtectedHosts - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseHostsForCommandFiles() {
        logger.debug("releaseProtectedHosts - start {}", (Object)this.setupName);
        Set<String> set = this.host.getProtectedHostList();
        if (set != null && !set.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = protectedHostsRunningCmdFile;
            synchronized (linkedHashSet) {
                protectedHostsRunningCmdFile.removeAll(set);
                logger.debug("releaseProtectedHosts - processing Hosts: {}", protectedHostsRunningCmdFile);
            }
        }
        logger.debug("releaseProtectedHosts - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockCriticalHosts(LinkedHashSet<String> linkedHashSet) {
        logger.debug("blockCriticalHosts - start {}", (Object)this.setupName);
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Set<String> set = this.host.getHostSet();
        if (!set.isEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                linkedHashSet.addAll(set);
                logger.debug("blockCriticalHosts - processing Hosts: {}", linkedHashSet);
            }
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("blockCriticalHosts - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCriticalHosts(LinkedHashSet<String> linkedHashSet) {
        logger.debug("releaseCriticalHosts - start {}", (Object)this.setupName);
        Object object = this.lock;
        synchronized (object) {
            linkedHashSet.removeAll(this.host.getHostSet());
            logger.debug("releaseCriticalHosts - released hosts: {}, remaining hosts Hosts: {}", this.host.getHostSet(), linkedHashSet);
        }
        logger.debug("releaseCriticalHosts - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForBlockedHosts(LinkedHashSet<String> linkedHashSet) {
        logger.debug("waitForBlockedHosts - start {}", (Object)this.setupName);
        Set<String> set = this.host.getProtectedHostList();
        logger.debug("waitForBlockedHosts - checking protected hosts: {} against blocked list: {}", set, linkedHashSet);
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                logger.debug("waitForBlockedHosts - host {} blocked is {}", (Object)string, (Object)linkedHashSet.contains(string));
            }
            for (String string : set) {
                boolean bl = false;
                Object object = this.lock;
                synchronized (object) {
                    bl = linkedHashSet.contains(string);
                }
                while (bl) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = this.lock;
                    synchronized (object) {
                        bl = linkedHashSet.contains(string);
                    }
                }
            }
        }
        logger.debug("waitForBlockedHosts - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAllBlockedHosts(LinkedHashSet<String> linkedHashSet) {
        logger.debug("waitForAllBlockedHosts - start {}", (Object)this.setupName);
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            bl = !linkedHashSet.isEmpty();
        }
        if (!bl) {
            logger.debug("waitForAllBlockedHosts - not waiting, no hosts blocked");
            return;
        }
        logger.debug("waitForAllBlockedHosts - checking blocked list: {}", linkedHashSet);
        for (int i = 10000; bl && i > 0; --i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                logger.error("waitForAllBlockedHosts() - wait interrupted, error: {}", (Object)interruptedException.getMessage());
            }
            Object object2 = this.lock;
            synchronized (object2) {
                bl = !linkedHashSet.isEmpty();
                continue;
            }
        }
        logger.debug("waitForAllBlockedHosts - end {}", (Object)this.setupName);
    }

    public void runShutdownCommandFile(boolean bl, boolean bl2) {
        int n;
        logger.debug("runShutdownCommandFile - start {}", (Object)this.setupName);
        CommandFile commandFile = this.host.getCommandFile(this.triggerEvent);
        UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
        if (commandFile != null && !userFilePathValidator.isValid(commandFile.getPath(), true)) {
            logger.error("runShutdownCommandFile() - Command file path is invalid.  Aborting execution of: {}", (Object)commandFile.getPath());
            this.osLogger.warn("Oslogger.CommandFile.Error", "110", commandFile.getPath());
            return;
        }
        if (bl && commandFile != null && !bl2) {
            logger.debug("{} blocking protected hosts for executing command file", (Object)this.setupName);
            this.blockHostsForCommandFiles();
        }
        if (bl2) {
            n = this.host.getDelayBeforeExecuteCommandFile(this.triggerEvent);
            if (n > 0) {
                try {
                    logger.debug("runShutdownCommandFile - Waiting {} seconds after Host Shutdown before running shutdown command file", (Object)n);
                    TimeUnit.SECONDS.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)interruptedException);
                }
            } else {
                logger.info("runShutdownCommandFile - Delay value after Host Shutdown before shutdown command file is zero");
            }
        }
        if (commandFile != null) {
            n = this.sequencer.startCmdFile(this.triggerEvent, commandFile);
            this.sequencer.waitForCmdFileToComplete(this.triggerEvent, commandFile, n);
            if (bl && !bl2) {
                logger.debug("{} releasing protected hosts for executing command file completed", (Object)this.setupName);
                this.releaseHostsForCommandFiles();
            }
        } else {
            logger.debug("runShutdownCommandFile - no command file configured");
            if (bl && !bl2) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        logger.debug("runShutdownCommandFile - end {}", (Object)this.setupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void StartSequence() {
        AtomicInteger atomicInteger = ThreadCount;
        synchronized (atomicInteger) {
            logger.debug("StartSequence() - start");
            ThreadCount.incrementAndGet();
            ThreadCount.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void EndSequence() {
        AtomicInteger atomicInteger = ThreadCount;
        synchronized (atomicInteger) {
            logger.debug("EndSequence() - start");
            ThreadCount.decrementAndGet();
            int n = 0;
            while (n < Waypoint.length) {
                Integer[] integerArray = Waypoint;
                int n2 = n++;
                Integer n3 = integerArray[n2];
                integerArray[n2] = integerArray[n2] - 1;
            }
            ThreadCount.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void WayPoint(int n) {
        AtomicInteger atomicInteger = ThreadCount;
        synchronized (atomicInteger) {
            logger.debug("WayPoint() - {}={}", (Object)n, (Object)Waypoint[n]);
            Integer[] integerArray = Waypoint;
            int n2 = n;
            Integer n3 = integerArray[n2];
            integerArray[n2] = integerArray[n2] + 1;
            ThreadCount.notifyAll();
            while (Waypoint[n] < ThreadCount.get()) {
                logger.trace("{}:{} {}", (Object)n, (Object)Waypoint[n], (Object)ThreadCount.get());
                try {
                    ThreadCount.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug("WayPoint() - end");
        }
    }
}

