/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.util.CountdownTimer;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.AuthenticationException;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixClusterOps {
    private static final Logger logger = LogManager.getLogger(NutanixClusterOps.class);
    private NutanixConnection connection;
    private final boolean isAdvanced;
    private final int advanced_idx;
    private ServiceManager services;
    private NutanixUtils nutanixUtils = null;

    public NutanixClusterOps(NutanixConnection nutanixConnection, boolean bl, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.connection = nutanixConnection;
        this.isAdvanced = bl;
        this.advanced_idx = n;
        this.services = serviceManager;
        this.nutanixUtils = serviceManager.getNutanixUtils();
    }

    public void logEvent(int n, String string) {
        String string2 = null;
        try {
            logger.debug("logEvent() - eventId: {}", (Object)n);
            string2 = new VirtualizationFeaturesFormatter((Integer)n, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logEvent() - failed to create event log message for Nutanix cluster event: {}", throwable);
        }
        this.services.getConfigurationManager().getApplicationErrorHandler().put(string2);
    }

    public void logEvent(int n) {
        String string = null;
        try {
            logger.debug("logEvent() - eventId: {}", (Object)n);
            string = new VirtualizationFeaturesFormatter(n).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logEvent() - failed to create event log message for Nutanix cluster event: {}", throwable);
        }
        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
    }

    protected int getDuration(String string) {
        return this.services.getNutanixUtils().getDuration(this.isAdvanced, this.advanced_idx, string);
    }

    protected boolean getBoolean(String string) {
        return this.services.getNutanixUtils().getBoolean(this.isAdvanced, this.advanced_idx, string);
    }

    protected void checkAllCvmsDown() {
        logger.debug("checkAllCvmsDown() - start");
        this.services.getNutanixUtils().getCvmIPsFromConfig().forEach(string -> {
            if (this.services.getNutanixUtils().isHostUp((String)string)) {
                logger.error("checkAllCvmsDown() - CVM with IP: {} should be down but still accessible", string);
            }
        });
    }

    public void stopCluster() {
        int n = this.getDuration("cluster_shutdown_duration");
        logger.info("stopCluster() - performing Nutanix cluster stop");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.logEvent(165);
        try {
            this.connection.stopCluster(n);
            if (this.isClusterUp()) {
                logger.debug("stopCluster() - cluster still running after stop command was sent");
                this.nutanixUtils.logClusterStillRunningEvent();
            }
        }
        catch (ConnectException connectException) {
            if (connectException.getCause() instanceof AuthenticationException) {
                logger.debug("stopCluster() - Failed to connect to any CVM. There was an authentication failure with at least one CVM: {}", (Throwable)connectException);
                this.nutanixUtils.logCVMAuthFailEvent();
            } else {
                logger.debug("stopCluster() - Failed to connect to any CVM: {}", (Throwable)connectException);
                this.nutanixUtils.logCVMConnFailEvent();
            }
        }
        catch (IllegalStateException | RemoteException exception) {
            logger.error("stopCluster() - failed to stop Nutanix cluster: {}", (Throwable)exception);
            this.nutanixUtils.logClusterStopFailedEvent();
        }
        logger.debug("stopCluster() - waiting rest of cluster stop duration");
        countdownTimer.sleep();
        logger.debug("stopCluster() - end");
    }

    public boolean isClusterUp() {
        logger.trace("isClusterUp() - start");
        if (!this.connection.isConnected()) {
            logger.warn("isClusterUp() - not connected to CVM, cannot check cluster status");
            return false;
        }
        try {
            return this.connection.isClusterUp();
        }
        catch (RemoteException remoteException) {
            logger.error("isClusterUp() - failed to check cluster status, error: {}", (Throwable)remoteException);
            return false;
        }
    }

    public void stopAfs() {
        if (!this.getBoolean("afs_shutdown_enable")) {
            logger.debug("stopAfs() - skipping stop AFS");
            return;
        }
        int n = this.getDuration("afs_shutdown_duration");
        logger.info("stopAfs() - performing Nutanix AFS stop");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.logEvent(151);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            try {
                NutanixConnection nutanixConnection = this.getClusterConnection();
                nutanixConnection.connect();
                nutanixConnection.stopAfs();
                nutanixConnection.disconnect();
            }
            catch (RemoteException remoteException) {
                logger.error("stopAfs() - failed to stop Nutanix AFS: {}", (Throwable)remoteException);
                throw new CompletionException(remoteException);
            }
            catch (IOException | IllegalArgumentException exception) {
                logger.error("stopAfs() - failure with connection to stop Nutanix AFS: {}", (Throwable)exception);
                throw new CompletionException(exception);
            }
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("stopAfs() - timed out while trying to stop Nutanix AFS: {}", (Throwable)timeoutException);
            this.nutanixUtils.logAFSStopTimeoutEvent();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)executionException);
            if (throwable instanceof AuthenticationException) {
                logger.error("stopAfs() - authentication error when stopping Nutanix AFS: {}", (Throwable)executionException);
                this.nutanixUtils.logClusterAuthFailEvent(null);
            } else if (throwable instanceof RemoteException) {
                logger.error("stopAfs() - command failure when stopping Nutanix AFS: {}", (Throwable)executionException);
                this.nutanixUtils.logAFSCommandFailedEvent();
            } else if (throwable instanceof IOException) {
                logger.error("stopAfs() - connection failure when stopping Nutanix AFS: {}", (Throwable)executionException);
                this.nutanixUtils.logClusterConnectionFailEvent(null);
            } else {
                logger.error("stopAfs() - failed to stop Nutanix AFS: {}", (Throwable)executionException);
                this.nutanixUtils.logAFSForceStopFailedEvent();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("stopAfs() - failed to stop Nutanix AFS: {}", (Throwable)interruptedException);
            this.nutanixUtils.logAFSForceStopFailedEvent();
        }
        logger.debug("stopAfs() - waiting rest of AFS stop duration");
        countdownTimer.sleep();
        logger.debug("stopAfs() - end");
    }

    public boolean isAfsActive() {
        logger.trace("isAfsActive() - start");
        try {
            return this.connection.isAfsActive();
        }
        catch (RemoteException remoteException) {
            logger.error("AfsStatus() - failed to check AFS status, error: {}", (Throwable)remoteException);
            return false;
        }
    }

    public void shutdownCvms() {
        int n = this.getDuration("cvm_shutdown_duration");
        logger.info("shutdownCvms() - performing Nutanix CVM shutdown");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.logEvent(170);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            try {
                this.connection.shutdownAllCvms(n);
            }
            catch (RemoteException remoteException) {
                logger.debug("shutdownCvms() - failed to shut down Nutanix CVMs. No SSH session available is expected as CVM should have closed connection, error: {}", (Throwable)remoteException);
            }
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.debug("shutdownCvms() - timed out, as expected, while trying to shut down Nutanix CVMs");
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("shutdownCvms() - failed to shut down Nutanix CVMs: {}", (Throwable)exception);
        }
        logger.debug("shutdownCvms() - waiting rest of CVM shutdown duration");
        countdownTimer.sleep();
        this.checkAllCvmsDown();
        logger.debug("shutdownCvms() - end");
    }

    public void abortActiveReplications() {
        logger.debug("abortActiveReplications() - start");
        if (!this.getBoolean("ongoing_replication_abort_delay_enable")) {
            logger.debug("abortActiveReplications() - skipping abort of Protection Domain replications");
            return;
        }
        try {
            if (!this.isReplicationOngoing()) {
                logger.debug("abortActiveReplications() - no active replication detected, skipping abort of Protection Domain replications");
                this.logPDReplNoneOngoing();
                return;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("abortActiveReplications() - failed to retrieve Protection Domains replication status: {}", (Throwable)remoteException);
            this.nutanixUtils.logPDReplForceAbortEvent();
            return;
        }
        logger.debug("abortActiveReplications() - waiting for running Protection Domain replications to finish");
        this.logPDReplInProgress();
        try {
            TimeUnit.SECONDS.sleep(this.getDuration("ongoing_replication_abort_delay_duration"));
        }
        catch (InterruptedException interruptedException) {
            logger.error("abortActiveReplications() - wait for Protection Domain replications to finish interrupted: {}", (Throwable)interruptedException);
            this.nutanixUtils.logPDReplForceAbortEvent();
        }
        logger.debug("abortActiveReplications() - aborting ongoing Protection Domain replications");
        this.logEvent(155);
        int n = this.getDuration("ongoing_replication_abort_command_duration");
        try {
            this.connection.abortPDReplications(n);
        }
        catch (RemoteException remoteException) {
            logger.error("abortActiveReplications() - failed to abort ongoing Protection Domains replications: {}", (Throwable)remoteException);
            this.nutanixUtils.logPDReplAbortSomeFailedEvent();
        }
        try {
            logger.debug("abortActiveReplications() - after PD replication abort, any PD replication ongoing: {}", (Object)this.isReplicationOngoing());
        }
        catch (RemoteException remoteException) {
            logger.error("abortActiveReplications() - failed to retrieve PD replication status, error: {}", (Throwable)remoteException);
        }
        logger.debug("abortActiveReplications() - end");
    }

    protected void logPDReplNoneOngoing() {
        this.services.getVirtualLoggingUtils().logNutanixPDReplNoneOngoingEvent();
    }

    protected void logPDReplInProgress() {
        this.services.getVirtualLoggingUtils().logNutanixPDInProgressEvent();
    }

    private boolean isReplicationOngoing() throws RemoteException {
        return this.connection.isReplicationActive();
    }

    public void disableMetroAvailability() {
        if (!this.getBoolean("metro_availability_disable")) {
            logger.debug("disableMetroAvailability() - skipping disabling Metro Availability");
            return;
        }
        logger.info("disableMetroAvailability() - disabling Nutanix Protection Domains Metro Availability");
        this.logEvent(160);
        try {
            this.connection.disablePDMetro();
        }
        catch (RemoteException remoteException) {
            logger.error("disableMetroAvailability() - failed to disable Protection Domains Metro Availability: {}", (Throwable)remoteException);
            this.nutanixUtils.logPDMetroDisableFailedEvent();
        }
        logger.debug("disableMetroAvailability() - end");
    }

    public void enableMetroAvailability() {
        if (!this.getBoolean("metro_availability_re-enable")) {
            logger.debug("enableMetroAvailability() - skipping enabling Metro Availability");
            return;
        }
        logger.debug("enableMetroAvailability() - start");
        try {
            this.logEvent(162);
            List<String> list = this.connection.getMetroPds();
            if (list.isEmpty()) {
                logger.debug("enableMetroAvailability() - no protection domain configuration found to re-enable Metro availability for");
                return;
            }
            logger.info("enableMetroAvailability() - enabling Nutanix Protection Domains Metro Availability for: {}", list);
            this.connection.enablePDMetro(list);
        }
        catch (RemoteException remoteException) {
            logger.error("enableMetroAvailability() - failed to enable Protection Domains Metro Availability: {}", (Throwable)remoteException);
            this.nutanixUtils.logPDMetroEnableFailedEvent();
        }
        logger.debug("enableMetroAvailability() - end");
    }

    public void startCluster() throws IllegalStateException {
        logger.info("startCluster() - performing Nutanix cluster start");
        int n = this.getDuration("cluster_startup_duration");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.logEvent(167);
        try {
            this.connection.startCluster();
        }
        catch (IllegalStateException | RemoteException exception) {
            logger.error("startCluster() - failed to start Nutanix cluster: {}", (Throwable)exception);
            this.nutanixUtils.logClusterStartFailedEvent();
            throw new IllegalStateException("Failed to start cluster", exception);
        }
        logger.debug("startCluster() - waiting rest of cluster start duration");
        countdownTimer.sleep();
        logger.debug("startCluster() - cluster start step completed");
        if (!this.isClusterUp()) {
            logger.error("startCluster() - cluster still not up after successful command and start up duration expired");
            this.nutanixUtils.logClusterStartTimeoutEvent();
            throw new IllegalStateException("Failed to start cluster");
        }
        logger.debug("startCluster() - end");
    }

    public void startAFS() throws IllegalStateException {
        if (!this.getBoolean("afs_startup_enable")) {
            logger.debug("startAFS() - skipping, not enabled in configuration");
            return;
        }
        logger.info("startAFS() - start");
        int n = this.getDuration("afs_startup_duration");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.logEvent(153);
        boolean bl = false;
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            try {
                this.connection.startAfs(n);
            }
            catch (IllegalStateException | RemoteException exception) {
                throw new CompletionException("Nutanix AFS start failed", exception);
            }
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
            logger.debug("startAFS() - AFS start command sent");
            bl = true;
        }
        catch (TimeoutException timeoutException) {
            logger.error("startAFS() - timed out while trying to start AFS");
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("startAFS() - failed to start AFS: {}", (Throwable)exception);
        }
        logger.debug("startAFS() - waiting rest of AFS start duration");
        countdownTimer.sleep();
        logger.debug("startAFS() - AFS start step completed");
        if (!bl) {
            this.logEvent(154);
            throw new IllegalStateException("Failed to start AFS");
        }
        logger.debug("startAFS() - end");
    }

    protected NutanixConnection getClusterConnection() throws IllegalArgumentException, IOException {
        return NutanixService.getInstance().getClusterConnection();
    }

    public void disconnect() {
        try {
            this.connection.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.connection = null;
    }
}

