/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.components.shutdowner.NutanixClusterOps;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixEsxiStartupHandler {
    private static final Logger logger = LogManager.getLogger(NutanixEsxiStartupHandler.class);
    private ShutdownState theState;
    private Set<String> virtualHostsToShutdown;
    private NutanixConnection connection;
    private boolean isAdvancedMode;
    private int ups_setup_idx;
    private String clusterIp;
    private NutanixClusterOps nutanixClusterOps;
    private ServiceManager services;
    private VMWareConnection vmwareConnection;

    public NutanixEsxiStartupHandler(Set<String> set, ShutdownState shutdownState, boolean bl, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.virtualHostsToShutdown = set;
        this.theState = shutdownState;
        this.isAdvancedMode = bl;
        this.ups_setup_idx = n;
        this.clusterIp = serviceManager.getNutanixUtils().getClusterIp();
    }

    public void performNutanixStartup() throws IllegalStateException {
        if (!this.services.getVirtualisationStatusStore().isNutanixClusterStopped() && !this.services.getVirtualisationStatusStore().isHostUnlockedForShutdown(this.clusterIp)) {
            logger.debug("performNutanixStartup() - skipping Nutanix startup, cluster already started");
            return;
        }
        logger.info("performNutanixStartup() - performing Nutanix ESXi startup operations");
        if (this.services.getNutanixUtils().isClusterLocked(this.isAdvancedMode)) {
            logger.debug("performNutanixStartup() - not performing start up, cluster is locked for shutdown");
            throw new IllegalStateException("Cluster is locked for shutdown, cannot perform startup");
        }
        if (this.services.getNutanixUtils().hasClusterActiveCriticalEvent(this.isAdvancedMode, this.theState)) {
            logger.debug("performNutanixStartup() - not performing start up, cluster has active critical event");
            throw new IllegalStateException("Cluster has active critical event, cannot perform startup");
        }
        if (this.services.getNutanixUtils().getBoolean(this.isAdvancedMode, this.ups_setup_idx, "cvm_startup_enable")) {
            try {
                this.powerOnCVMs();
            }
            catch (IllegalStateException illegalStateException) {
                logger.error("performNutanixStartup() - unable to start CVMs for cluster: {}", (Object)this.clusterIp);
                throw illegalStateException;
            }
        } else {
            logger.debug("performNutanixStartup() - CVM startup not enabled");
        }
        int n = this.services.getNutanixUtils().getDuration(this.isAdvancedMode, this.ups_setup_idx, "cvm_startup_duration");
        try {
            this.services.getNutanixUtils().logCvmStartupWaitEvent(this.clusterIp);
            TimeUnit.SECONDS.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            logger.warn("performNutanixStartup() - failed to wait for CVM start up: {}", (Throwable)interruptedException);
        }
        List<String> list = this.services.getNutanixUtils().getCvmIPsFromConfig();
        logger.debug("performNutanixStartup() - checking if following CVMs: {} are up", list);
        if (!this.services.getNutanixUtils().isAllHostsUp(list)) {
            logger.debug("performNutanixStartup() - not all CVMs are back online yet");
            throw new IllegalStateException("Not all CVM back online");
        }
        if (this.services.getNutanixUtils().isClusterLocked(this.isAdvancedMode)) {
            logger.debug("performNutanixStartup() - not performing start up, cluster is locked for shutdown");
            throw new IllegalStateException("Cluster locked for shutdown, cannot start cluster.");
        }
        if (this.services.getNutanixUtils().hasClusterActiveCriticalEvent(this.isAdvancedMode, this.theState)) {
            logger.debug("performNutanixStartup() - not performing start up, cluster has active critical event");
            throw new IllegalStateException("Cluster has active critical event, cannot start cluster.");
        }
        String string = list.get(0);
        logger.debug("performNutanixStartup() - trying to connect to CVM: {}", (Object)string);
        this.setUpCvmConnection(string);
        this.setUpClusterOps();
        if (this.theState.isNutanixClusterStopInProgress()) {
            logger.debug("performNutanixStartup() - cluster stop in progress, cannot start cluster");
            throw new IllegalStateException("Cluster currently stopping, cannot start cluster");
        }
        if (!this.nutanixClusterOps.isClusterUp()) {
            try {
                this.nutanixClusterOps.startCluster();
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException("Failed to start cluster", illegalStateException);
            }
        } else {
            logger.debug("performNutanixStartup() - cluster already started, skipping cluster start up");
        }
        this.services.getNutanixUtils().logClusterAlreadyUpEvent(this.clusterIp);
        this.nutanixClusterOps.enableMetroAvailability();
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            this.startAfsWithoutVCSA();
        } else {
            try {
                this.nutanixClusterOps.startAFS();
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("performNutanixStartup() - Nutanix AFS did not start, continuing start up!");
            }
        }
        logger.debug("performNutanixStartup() - disconnecting from CVM: {}", (Object)string);
        try {
            this.connection.disconnect();
        }
        catch (RemoteException remoteException) {
            logger.debug("performNutanixStartup() - disconnect failed, session might be timed out by now: {}", (Throwable)remoteException);
        }
        this.connection = null;
        this.nutanixClusterOps = null;
        this.services.getVirtualisationStatusStore().clearNutanixClusterStopped();
        logger.debug("performNutanixStartup() - end");
    }

    private void setUpCvmConnection(String string) throws IllegalStateException {
        logger.debug("setUpCvmConnection() - start, CVM: {}", (Object)string);
        try {
            this.connection = NutanixService.getInstance().getCvmNutanixConnection(string);
            this.connection.connect();
            logger.debug("setUpCvmConnection() - successfully connected to CVM: {}: {}", (Object)string, (Object)this.connection.isConnected());
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("setUpCvmConnection() - unable to connect to the Nutanix CVM: {}, error: {}", (Object)string, (Object)exception);
            throw new IllegalStateException("Failed to connect to CVM");
        }
    }

    private void setUpClusterOps() {
        this.nutanixClusterOps = new NutanixClusterOps(this.connection, this.isAdvancedMode, this.ups_setup_idx, this.services);
    }

    private void powerOnCVMs() throws IllegalStateException {
        logger.debug("powerOnCVMs() - start");
        List<String> list = this.services.getNutanixUtils().getNutanixHostIpsFromConfig(this.isAdvancedMode);
        list.forEach(string2 -> {
            block17: {
                ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
                if (serviceInstance == null) {
                    serviceInstance = this.vmwareConnection.getESXiHostInstance((String)string2);
                }
                if (serviceInstance == null) {
                    throw new IllegalStateException("Unable to connect to VCenter");
                }
                String string3 = this.services.getVirtualisationStatusStore().getCvmName((String)string2);
                if (string3 == null) {
                    logger.debug("powerOnCVMs() - no CVM name retrieved for host: {}", string2);
                    return;
                }
                Predicate<String> predicate = string -> this.services.getVirtualisationStatusStore().isHostLockedForShutdown((String)string);
                if (this.virtualHostsToShutdown.stream().anyMatch(predicate)) {
                    logger.debug("powerOnCVMs() - hosts shutting down, not starting CVM: {}", (Object)string3);
                    throw new IllegalStateException("Hosts are shutting down");
                }
                Predicate<String> predicate2 = string -> !this.services.getHostSystemUtils().isHostHealthy((String)string);
                if (this.virtualHostsToShutdown.stream().anyMatch(predicate2)) {
                    logger.debug("powerOnCVMs() - not all hosts are healthy, not starting CVMs");
                    throw new IllegalStateException("Hosts not all healthy");
                }
                logger.debug("powerOnCVMs() - retrieved CVM name: {} for host: {}", (Object)string3, string2);
                VirtualMachine virtualMachine = null;
                try {
                    virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string3);
                }
                catch (InvalidProperty invalidProperty) {
                    logger.error("powerOnCVMs() - InvalidProperty: ", (Throwable)invalidProperty);
                }
                catch (RuntimeFault runtimeFault) {
                    logger.error("powerOnCVMs() - RuntimeFault: ", (Throwable)runtimeFault);
                }
                catch (RemoteException remoteException) {
                    logger.error("powerOnCVMs() - RemoteException: ", (Throwable)remoteException);
                }
                catch (Exception exception) {
                    logger.error("powerOnCVMs() - Exception: ", (Throwable)exception);
                }
                if (virtualMachine == null) {
                    logger.debug("powerOnCVMs() - no virtual machine found for CVM: {}", (Object)string3);
                    return;
                }
                HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, serviceInstance);
                if (hostSystem == null) {
                    logger.error("powerOnCVMs() - hostSystem is null for CVM: {}", (Object)virtualMachine.getName());
                    throw new IllegalStateException("Host system is null");
                }
                if (this.canCvmPowerOn(virtualMachine, (String)string2)) {
                    logger.debug("powerOnCVMs() - CVM to be started on host: {}", (Object)hostSystem.getName());
                    try {
                        this.services.getVirtualLoggingUtils().logNutanixCVMStartupLogEvent(virtualMachine.getName());
                        Task task = virtualMachine.powerOnVM_Task(hostSystem);
                        String string4 = task.waitForTask();
                        if (string4.equals("success")) {
                            logger.info("powerOnCVMs() - CVM: {} successfully powered on", (Object)virtualMachine.getName());
                            this.services.getVirtualisationStatusStore().clearCvm((String)string2);
                            break block17;
                        }
                        logger.error("powerOnCVMs() - CVM: {} failed to power on with taskResult: {}", (Object)virtualMachine.getName(), (Object)string4);
                    }
                    catch (Exception exception) {
                        logger.error("powerOnCVMs() - error starting CVM: {} - {}", (Object)virtualMachine.getName(), (Object)exception);
                    }
                } else {
                    logger.debug("powerOnCVMs() - skipping CVM: {}", (Object)virtualMachine.getName());
                }
            }
        });
        logger.debug("powerOnCVMs() - end");
    }

    private void startAfsWithoutVCSA() {
        if (!this.services.getNutanixUtils().getBoolean(this.isAdvancedMode, this.ups_setup_idx, "afs_startup_enable")) {
            logger.debug("startAfsWithoutVCSA() - skipping start AFS");
            return;
        }
        int n = this.services.getVirtualConfigurationManager().getDurationGlobal("afs_startup_duration");
        logger.info("startAfsWithoutVCSA() - performing Nutanix AFS start");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.services.getVirtualLoggingUtils().logNutanixAfsStartEvent();
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            Map<String, VirtualMachine> map = this.powerOnAfsVMs();
            NutanixConnection nutanixConnection = this.getAfsVmConn(map);
            try {
                nutanixConnection.startAfsCluster(n);
            }
            catch (RemoteException remoteException) {
                logger.error("startAfsWithoutVCSA() - failed to start Nutanix AFS: {}", (Throwable)remoteException);
                throw new CompletionException(remoteException);
            }
            try {
                nutanixConnection.disconnect();
            }
            catch (RemoteException remoteException) {
                logger.error("startAfsWithoutVCSA() - failed to disconnect from Nutanix AFS VM: {}", (Throwable)remoteException);
            }
            nutanixConnection = null;
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("startAfsWithoutVCSA() - timed out while trying to start Nutanix AFS: {}", (Throwable)timeoutException);
            this.services.getVirtualLoggingUtils().logNutanixAfsStartFailedEvent();
        }
        catch (InterruptedException | CompletionException | ExecutionException exception) {
            logger.error("startAfsWithoutVCSA() - failed to start Nutanix AFS: {}", (Throwable)exception);
            this.services.getVirtualLoggingUtils().logNutanixAfsStartFailedEvent();
        }
        logger.debug("startAfsWithoutVCSA() - waiting rest of AFS start duration");
        countdownTimer.sleep();
        logger.debug("startAfsWithoutVCSA() - end");
    }

    private Map<String, VirtualMachine> powerOnAfsVMs() {
        logger.debug("powerOnAfsVMs() - start");
        List<String> list = this.services.getNutanixUtils().getNutanixHostIpsFromConfig(this.isAdvancedMode);
        List<String> list2 = this.services.getNutanixUtils().getAfsVmsFromConfig();
        HashMap<String, VirtualMachine> hashMap = new HashMap<String, VirtualMachine>();
        logger.debug("powerOnAfsVMs() - retrieved AFS VM names: {}", list2);
        list.forEach(string -> {
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance((String)string);
            if (serviceInstance == null) {
                logger.error("powerOnAfsVMs() - Unable to connect to ESXi host {}", string);
                return;
            }
            list2.forEach(string2 -> {
                if (hashMap.keySet().contains(string2)) {
                    return;
                }
                VirtualMachine virtualMachine = null;
                try {
                    logger.debug("powerOnAfsVms() - looking for AFS VM {} on host {}", string2, string);
                    virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, (String)string2);
                }
                catch (InvalidProperty invalidProperty) {
                }
                catch (RuntimeFault runtimeFault) {
                    logger.error("powerOnAfsVMs() - RuntimeFault: ", (Throwable)runtimeFault);
                }
                catch (RemoteException remoteException) {
                    logger.error("powerOnAfsVMs() - RemoteException: ", (Throwable)remoteException);
                }
                catch (Exception exception) {
                    logger.error("powerOnAfsVMs() - Exception: ", (Throwable)exception);
                }
                if (virtualMachine == null) {
                    logger.debug("powerOnAfsVms() - failed to retrieve AFS VM {} for host {}", string2, string);
                    return;
                }
                HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, serviceInstance);
                if (hostSystem == null) {
                    logger.error("powerOnAfsVMs() - hostSystem is null for AFS VM: {}", string2);
                    return;
                }
                try {
                    logger.debug("powerOnAfsVMs() - attempting to power on AFS VM {}", string2);
                    Task task = virtualMachine.powerOnVM_Task(hostSystem);
                    String string3 = task.waitForTask();
                    if (string3.equals("success")) {
                        if (virtualMachine.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn) {
                            logger.info("powerOnAfsVMs() - AFS VM: {} successfully powered on", string2);
                            hashMap.put((String)string2, virtualMachine);
                        } else {
                            logger.error("powerOnAfsVMs() - AFS VM: {} failed to power on still in powered on state", string2);
                        }
                    } else {
                        logger.error("powerOnAfsVMs() - AFS VM: {} failed to power on with taskResult: {}", string2, (Object)string3);
                    }
                }
                catch (Exception exception) {
                    logger.error("powerOnAfsVMs() - error powering on AFS VM: {} - {}", string2, (Object)exception);
                }
            });
        });
        logger.debug("powerOnAfsVMs() - end, powered on AFS VMs: {}", hashMap);
        return hashMap;
    }

    private NutanixConnection getAfsVmConn(Map<String, VirtualMachine> map) {
        NutanixConnection nutanixConnection = null;
        String string = null;
        boolean bl = false;
        int n = 3;
        block4: while (!bl) {
            try {
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                logger.error("getAfsVmConn() - interrupted while waiting for AFS VM Ip to be retrieved");
                throw new CompletionException(interruptedException);
            }
            for (String string2 : map.keySet()) {
                VirtualMachine virtualMachine = map.get(string2);
                if (virtualMachine == null) {
                    logger.debug("getAfsVmConn() - retrieved NULL as AFS VM, trying next AFS VM");
                    continue;
                }
                String string3 = virtualMachine.getGuest().getIpAddress();
                if (StringUtils.isBlank((CharSequence)string3)) continue;
                logger.debug("getAfsVmConn() - retrieved IP address {} for AFS VM {}", (Object)string3, (Object)string2);
                bl = true;
                string = string3;
                continue block4;
            }
        }
        try {
            nutanixConnection = NutanixService.getInstance().getCvmNutanixConnection(string);
            nutanixConnection.connect();
            logger.debug("getAfsVmConn() - succesfully connected to AFS VM with IP {}", string);
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug("getAfsVmConn() - failed to connect to AFS VM with IP {}, error: {}", string, (Object)exception);
        }
        if (nutanixConnection != null && nutanixConnection.isConnected()) {
            return nutanixConnection;
        }
        return null;
    }

    private boolean canCvmPowerOn(VirtualMachine virtualMachine, String string) {
        if (this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) {
            logger.debug("canCvmPowerOn() - CVM: {} is already powered on", (Object)virtualMachine.getName());
            this.services.getVirtualisationStatusStore().clearCvm(string);
            return false;
        }
        if (!this.services.getVirtualMachineUtils().isConnected(virtualMachine)) {
            logger.error("canCvmPowerOn() - CVM: {} is not connected, unable to start", (Object)virtualMachine.getName());
            throw new IllegalStateException("CVM not connected,cannot be powered on");
        }
        return true;
    }
}

