/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.model.VMPriorityVector;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.util.CountdownTimer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixUvmHandler {
    private static final Logger logger = LogManager.getLogger(NutanixUvmHandler.class);
    private ShutdownState theState;
    private NutanixConnection connection;
    String clusterIp;
    private boolean isAdvancedMode;
    private int upsSetupIdx;
    private NutanixUtils nutanixUtils = null;
    private VirtualisationStatusStore virtualisationStatusStore;
    private ServiceManager services;

    public NutanixUvmHandler(ShutdownState shutdownState, NutanixConnection nutanixConnection, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.theState = shutdownState;
        this.connection = nutanixConnection;
        this.nutanixUtils = serviceManager.getNutanixUtils();
        this.isAdvancedMode = serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode();
        this.upsSetupIdx = n;
        this.clusterIp = this.nutanixUtils.getClusterIp();
    }

    public void stopAllUVMs() {
        logger.debug("stopAllUVMs() - start");
        if (this.theState.isNutanixUvmStartInProgress()) {
            try {
                CompletableFuture.runAsync(() -> this.waitIfVMStartupInProgress()).get(this.nutanixUtils.getDuration(this.isAdvancedMode, this.upsSetupIdx, "uvm_startup_duration"), TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                logger.warn("stopAllUVMs() - failed to wait for VM startup to finish");
            }
            catch (TimeoutException timeoutException) {
                logger.debug("stopAllUVMs() - timed out waiting for VM startup to finish, continue with shutdown");
            }
        }
        Map<String, String> map = null;
        map = this.getPoweredOnVms();
        if (map.isEmpty()) {
            logger.debug("stopAllUVMs() - no VMs powered on, no shutdown needed");
            return;
        }
        this.theState.setNutanixUvmStop();
        this.services.getVirtualLoggingUtils().logNutanixAHVVMShutdownEvent();
        boolean bl = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
        if (bl) {
            VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN);
            Vector<VMPriority> vector = new VMPriorityVector(bl).getPriorities();
            this.shutdownVMs(map, vector, vMPrioritizationDurations);
        } else {
            int n = this.getShutdownDuration();
            this.shutdownVMs(map, n);
        }
        if (!this.isVMsOff()) {
            this.nutanixUtils.logUvmShutdownFailEvent();
            logger.error("stopAllUVMs() - user VMs did not shutdown in time, trying to power off");
            this.powerOffRemainingVms();
        }
        if (!this.isVMsOff()) {
            logger.error("stopAllUVMs() - user VMs did not shutdown in time");
            this.services.getVirtualLoggingUtils().logClusterVMShutdownFailedInsufficientTimeEvent(this.clusterIp);
            return;
        }
        this.theState.clearNutanixUvmStop();
        logger.debug("stopAllUVMs() - end");
    }

    private Map<String, String> getPoweredOnVms() {
        logger.debug("getPoweredOnVms() - start");
        Map<Object, Object> map = new HashMap();
        try {
            map = this.connection.getOnUvms();
        }
        catch (RemoteException remoteException) {
            logger.error("getPoweredOnVms() - failed to retrieve list of powered on VMs, error: {}", (Throwable)remoteException);
        }
        if (map.isEmpty()) {
            logger.debug("getPoweredOnVms() - no UVMs powered on");
            return map;
        }
        map = this.nutanixUtils.filterOutAfsVms(map);
        return map;
    }

    private int getShutdownDuration() {
        Optional<VMSettings> optional = this.getVmSettings();
        if (optional.isPresent()) {
            return optional.get().getGuestVMVappShutdownDuration();
        }
        return 0;
    }

    private int getShutdownDuration(VMPriority vMPriority, VMPrioritizationDurations vMPrioritizationDurations) {
        return vMPrioritizationDurations.getDuration(vMPriority);
    }

    private int getPowerOffDuration() {
        Optional<VMSettings> optional = this.getVmSettings();
        if (optional.isPresent()) {
            return optional.get().getUvmPoweroffDuration();
        }
        return 0;
    }

    private int getForceOffDuration() {
        Optional<VMSettings> optional = this.getVmSettings();
        if (optional.isPresent()) {
            return optional.get().getUvmForceoffDuration();
        }
        return 0;
    }

    private Optional<VMSettings> getVmSettings() {
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.upsSetupIdx);
            if (uPSSetup != null) {
                return Optional.ofNullable(uPSSetup.getVMSettings());
            }
            logger.error("getVmSettings() - failed to read advanced shutdown configuration");
        }
        return Optional.ofNullable(this.services.getWebServerUtils().readVMSettingsFromConfigAndCluster());
    }

    private boolean isVMsOff() {
        Map<String, String> map = null;
        try {
            map = this.connection.getOnUvms();
        }
        catch (RemoteException remoteException) {
            logger.error("isVMsOff() - failed to retrieve list of powered on VMs, error: {}", (Throwable)remoteException);
            return true;
        }
        map = this.nutanixUtils.filterOutAfsVms(map);
        return map.isEmpty();
    }

    private void shutdownVMs(Map<String, String> map, List<VMPriority> list, VMPrioritizationDurations vMPrioritizationDurations) {
        for (VMPriority vMPriority : list) {
            logger.info("shutdownVMs() - stopping User VMs, priority: {}", (Object)vMPriority);
            int n = this.getShutdownDuration(vMPriority, vMPrioritizationDurations);
            if (n == 0) {
                logger.error("shutdownVMs() - duration is 0, no VM shutdown for priority: {}", (Object)vMPriority);
                continue;
            }
            Map<String, String> map2 = this.services.getVMPrioritizationUtils().filterVMsByPriority(map, vMPriority);
            this.shutdownVMs(map2, n);
            logger.debug("shutdownVMs() - issued shutdown for all VMs for priority {}", (Object)vMPriority);
        }
    }

    private void shutdownVMs(Map<String, String> map, int n) {
        if (n == 0) {
            logger.error("shutdownVMs() - VM Shutdown Duration is 0, not shutting down");
            return;
        }
        logger.debug("shutdownVMs() - start, shutting down UVMs, duration: {}", (Object)n);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.virtualisationStatusStore.saveVMToPropertyFile(this.clusterIp, map);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            logger.debug("shutdownVMs() - run shutdown command for all Nutanix User VMs");
            CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
            try {
                this.connection.shutdownUvms(map);
            }
            catch (RemoteException remoteException) {
                logger.error("shutdownVMs() - failed to shut down Nutanix UVMs: {}", (Throwable)remoteException);
            }
            logger.debug("shutdownVMs() - waiting: {} seconds for UVMs to shut down", (Object)n);
            countdownTimer.sleep();
            logger.debug("shutdownVMs() - UVM shutdown command completed");
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("shutdownVMs() - failed to shut down Nutanix UVMs: {}", (Throwable)exception);
        }
        logger.debug("shutdownVMs() - waiting rest of UVM shutdown duration");
        countdownTimer.sleep();
        logger.debug("shutdownVMs() - end, UVM shutdown completed");
    }

    private void powerOffRemainingVms() {
        logger.debug("powerOffRemainingVms() - start");
        if (this.isVMsOff()) {
            logger.debug("powerOffRemainingVms() - all VMs already off, no need for power off");
            return;
        }
        int n = this.getPowerOffDuration();
        Map<String, String> map = null;
        map = this.getPoweredOnVms();
        if (map.isEmpty()) {
            logger.debug("powerOffRemainingVms() - no VMs powered on, no need for power off");
            return;
        }
        logger.debug("powerOffRemainingVms() - power off remaining Nutanix User VMs");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        try {
            this.connection.powerOffUvms(map);
        }
        catch (RemoteException remoteException) {
            logger.error("powerOffRemainingVms() - failed to power off Nutanix UVMs: {}", (Throwable)remoteException);
        }
        logger.debug("powerOffRemainingVms() - waiting: {} seconds for UVMs to power down", (Object)n);
        countdownTimer.sleep();
        if (this.isVMsOff()) {
            logger.debug("powerOffRemainingVms() - all VMs succesfully powered off");
            return;
        }
        int n2 = this.getForceOffDuration();
        map = this.getPoweredOnVms();
        if (map.isEmpty()) {
            logger.debug("powerOffRemainingVms() - all VMs already off, no need for force power off");
            return;
        }
        logger.error("powerOffRemainingVms() - force off remaining Nutanix User VMs");
        CountdownTimer countdownTimer2 = new CountdownTimer(n2, TimeUnit.SECONDS);
        try {
            this.connection.forceOffUvms(map);
        }
        catch (RemoteException remoteException) {
            logger.error("stopVMs() - failed to force power off Nutanix UVMs: {}", (Throwable)remoteException);
        }
        countdownTimer2.sleep();
        logger.debug("powerOffRemainingVms() - end, power off remaining VMs step completed");
    }

    private void waitIfVMStartupInProgress() {
        logger.debug("waitIfVMStartupInProgress() - start");
        if (this.theState.isNutanixUvmStartInProgress()) {
            this.services.getVirtualLoggingUtils().logVirtualizationStartupInProgressEvent(this.clusterIp);
            do {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.theState.isNutanixUvmStartInProgress());
        }
        logger.debug("waitIfVMStartupInProgress() - end");
    }

    public void startUpUvms(Set<String> set) {
        logger.info("startUpUvms() - handling UVM start up for host: {}", (Object)this.clusterIp);
        if (!set.contains(this.clusterIp)) {
            logger.debug("startUpUvms() - cluster not in host start up list, skipping VM start up");
            return;
        }
        if (this.virtualisationStatusStore.isHostLockedForShutdown(this.clusterIp)) {
            logger.debug("startUpUvms() - not starting UVMs, cluster: {} is shutting down", (Object)this.clusterIp);
            return;
        }
        boolean bl = false;
        if (this.virtualisationStatusStore.isHostLockedForShutdown(this.clusterIp)) {
            logger.debug("startUpUvms() - not starting UVMs, host: {} is shutting down", (Object)this.clusterIp);
            return;
        }
        if (this.theState.checkIfCriticalEventActive(this.clusterIp)) {
            logger.debug("startUpUvms() - critical event active on host: {}", (Object)this.clusterIp);
            return;
        }
        List<String> list = this.getStartUpList(this.clusterIp, bl);
        if (list.isEmpty()) {
            logger.debug("startUpUvms() - no UVMs found to start up for host: {}", (Object)this.clusterIp);
            return;
        }
        logger.debug("startUpUvms() - UVM start up list: {}", list);
        this.theState.setNutanixUvmStart();
        this.performUvmStartUp(list, this.clusterIp, bl);
        list.clear();
        bl = true;
        list = this.getStartUpList(this.clusterIp, bl);
        if (!list.isEmpty()) {
            try {
                TimeUnit.MINUTES.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                logger.error("startUpUvms() - interrupted while waiting for UVM start up reattempt: {}", (Throwable)interruptedException);
            }
            logger.info("startUpUvms() - reattempting UVM start up for host: {}", (Object)this.clusterIp);
            this.services.getVirtualLoggingUtils().logReattemptVMStartupLogEvent(this.clusterIp);
            this.performUvmStartUp(list, this.clusterIp, bl);
        }
        this.theState.clearNutanixUvmStart();
        logger.debug("startUpUvms() - end");
    }

    private Map<String, String> reduceToOffUvms(List<String> list) {
        Map<String, String> map = new HashMap<String, String>();
        logger.debug("reduceToOffUvms() - start, retrieving powered off UVMs");
        try {
            Map<String, String> map2 = this.connection.getOffUvms();
            logger.debug("reduceToOffUvms() - powered off VMs: {}", map2);
            map = this.nutanixUtils.matchUvmsWithUuids(map2, list);
        }
        catch (RemoteException remoteException) {
            logger.debug("reduceToOffUvms() - unable to read UVMs currently powered off: {}", (Throwable)remoteException);
        }
        logger.debug("reduceToOffUvms() - end, start up VM list: {}", map);
        return map;
    }

    private List<String> getStartUpList(String string, boolean bl) {
        Optional<List<String>> optional;
        if (bl) {
            logger.debug("getStartUpList() - retrieving UVM reattempt start up list for host: {}", (Object)string);
            optional = Optional.ofNullable(this.virtualisationStatusStore.getReattemptVMStartupList(string));
        } else {
            logger.debug("getStartUpList() - retrieving UVM start up list for host: {}", (Object)string);
            optional = Optional.ofNullable(this.virtualisationStatusStore.getStartupVMList(string));
        }
        return optional.orElse(new ArrayList());
    }

    private void performUvmStartUp(List<String> list, String string, boolean bl) {
        logger.debug("performUvmStartUp() - start, filtering startup list to list of UVMs currently powered off");
        Map<String, String> map = this.reduceToOffUvms(list);
        if (map.isEmpty()) {
            if (!list.isEmpty() && this.getPoweredOnVms().keySet().containsAll(list)) {
                logger.debug("performUvmStartUp() - All UVMs from start up list are in power state on, clearing VMs for host {}", (Object)string);
                this.virtualisationStatusStore.clearVMs(string);
                return;
            }
            logger.error("performUvmStartUp() - No UVMs from start up list are in power state off, skipping power on.");
            return;
        }
        Vector<VMPriority> vector = this.services.getVMPrioritizationUtils().getVMStartupPriorities(bl);
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.services.getVirtualLoggingUtils().logNutanixAHVVMStartupLogEvent(this.clusterIp);
        ListIterator<VMPriority> listIterator = vector.listIterator(vector.size());
        while (listIterator.hasPrevious()) {
            Object object;
            VMPriority vMPriority = listIterator.previous();
            logger.debug("performUvmStartUp() - performing UVM start up for priority: {}", (Object)vMPriority);
            int n = 0;
            if (this.isAdvancedMode) {
                object = this.nutanixUtils.getNutanixHostIpsFromConfig(this.isAdvancedMode);
                n = this.services.getVMPrioritizationUtils().getVMVAppStartupDuration(vMPriority, vMPrioritizationDurations, object.get(0));
            } else {
                n = this.services.getVMPrioritizationUtils().getVMVAppStartupDuration(vMPriority, vMPrioritizationDurations, string);
            }
            object = this.services.getVMPrioritizationUtils().filterVMsByPriority(map, vMPriority);
            if (n == 0) {
                this.services.getVMPrioritizationUtils();
                VMPrioritizationUtils.logPriorityDurationZero((Map<String, String>)object, vMPriority);
                logger.debug("performUvmStartUp() - dont attempt to restart skipped  UVMs {}", object.values());
                logger.trace("performUvmStartUp() - startupList {}", list);
                list.removeAll(object.keySet());
                logger.trace("performUvmStartUp() - startupList (after) {}", list);
                continue;
            }
            logger.debug("performUvmStartUp() - starting UVMs: {} for priority: {}", object, (Object)vMPriority);
            this.powerOnUvms((Map<String, String>)object);
            logger.debug("performUvmStartUp() - performed UVM start up for priority: {}, waiting for: {} seconds", (Object)vMPriority, (Object)n);
            try {
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                logger.error("performUvmStartUp() - interrupted while waiting for UVMs for priority: {} to power on: {}", (Object)vMPriority, (Object)interruptedException);
            }
        }
        logger.debug("performUvmStartUp() - startupList at the end {}", list);
        this.reduceToOffUvms(list).forEach(hashMap::putIfAbsent);
        this.updateReattemptUuidsInProperties(bl, hashMap, string);
        logger.debug("performUvmStartUp() - end");
    }

    private void updateReattemptUuidsInProperties(boolean bl, Map<String, String> map, String string) {
        logger.debug("updateReattemptUuidsInProperties() - start");
        if (!this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
            if (!bl) {
                logger.debug("Clearing VMs for host {}", (Object)string);
                this.virtualisationStatusStore.clearVMs(string);
                if (!map.isEmpty()) {
                    logger.debug("Saving list of reattempt VMs {}", map);
                    List<String> list = map.keySet().stream().collect(Collectors.toList());
                    this.virtualisationStatusStore.saveReAttemptVMs(list, string);
                }
            } else {
                logger.debug("Clearing VMs from reattempt list for host {}", (Object)string);
                this.virtualisationStatusStore.clearReattemptVMs(string);
            }
        }
    }

    private void powerOnUvms(Map<String, String> map) {
        logger.debug("powerOnUvms() - start, UVMs: {}", map);
        try {
            this.connection.turnOnUvms(map);
        }
        catch (RemoteException remoteException) {
            logger.debug("powerOnUvms() - failed to power on UVMs from startup list: {}", (Throwable)remoteException);
        }
    }
}

