/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.commandfilerunner.DelayedExecutor;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.EventKey;
import com.apcc.m11.components.shutdowner.ITriggerConsumer;
import com.apcc.m11.components.shutdowner.MasterSequenceThread;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.formatters.CriticalGroupFormatter;
import com.apcc.m11.components.shutdowner.formatters.ShutdownInProgressFormatter;
import com.apcc.m11.components.shutdowner.formatters.TurnOffOnBatteryFormatter;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.shutdowner.hosts.ESXUnmanagedStandaloneHost;
import com.apcc.m11.components.shutdowner.hosts.HyperVManagedHost;
import com.apcc.m11.components.shutdowner.hosts.HyperVUnmanagedClusterHost;
import com.apcc.m11.components.shutdowner.hosts.HyperVUnmanagedStandaloneHost;
import com.apcc.m11.components.shutdowner.hosts.HyperflexHost;
import com.apcc.m11.components.shutdowner.hosts.NutanixAHVHost;
import com.apcc.m11.components.shutdowner.hosts.NutanixESXHost;
import com.apcc.m11.components.shutdowner.hosts.SimplivityHost;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.shutdowner.hosts.VxRailHost;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.internalEvents.shutdown.ShutdownInProgress;
import com.apcc.m11.ds.powersource.OIdEventMapping;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.sshservice.SSHActionManager;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownSequencer
implements IDataConsumer,
IEventProducer,
ITriggerConsumer {
    private static final Logger logger = LogManager.getLogger(ShutdownSequencer.class);
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private String theResourceBundle;
    private ShutdownState theState = null;
    private IEventConsumer theEventConsumer = null;
    private String theOSName;
    private IDataSource theDataSource = null;
    private IPermanentStorage aPermanentStorage;
    private ServiceManager services;
    private ILicensingManager licensingManager;
    private ApplicationErrorHandler errorHandler;
    @NonNull
    private SSHActionManager sshActionManager;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private OperatingSystemEventLogger osLogger;
    private Map<EventKey, ShutdownTimer> aNonCriticalShutdownTimerMap = new TreeMap<EventKey, ShutdownTimer>();
    private Map<String, Boolean> runningFiles = new HashMap<String, Boolean>();

    public ShutdownSequencer(@NonNull ShutdownState shutdownState, String string, @NonNull ServiceManager serviceManager) {
        if (shutdownState == null) {
            throw new IllegalArgumentException("aState is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("serviceManager is marked non-null but is null");
        }
        this.services = serviceManager;
        this.osLogger = serviceManager.getOperatingSystemEventLogger();
        this.theState = shutdownState;
        this.theState.setCriticalShutdownTimers(new TreeMap<EventKey, ShutdownTimer>());
        this.theOSName = string;
        this.licensingManager = this.services.getLicensingManager();
        this.licensingManager.init();
        this.errorHandler = this.services.getApplicationErrorHandler();
    }

    public ShutdownState getShutdownState() {
        return this.theState;
    }

    public void setResourceBundleLocation(String string) {
        this.theResourceBundle = string;
    }

    public void setPermanentStorage(IPermanentStorage iPermanentStorage) {
        this.aPermanentStorage = iPermanentStorage;
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theEventConsumer = iEventConsumer;
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        this.theEventConsumer = null;
    }

    @Override
    public synchronized void triggerOccurred(Event event, int n) {
        try {
            ObjectId objectId = event.getObjectId();
            logger.info("ShutdownSequencer triggeroccurred: event_oid = " + String.valueOf(objectId));
            this.startShutdown(event, n);
        }
        catch (Exception exception) {
            logger.error("triggerOccurred", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void triggerCanceled(Event event) {
        logger.debug("triggerCanceled(): start");
        logger.info("triggerCanceled(): Cancel shutdown: " + event.toString() + OIdEventMapping.getEventName(event));
        logger.debug("triggerCanceled(): Cancel event: " + String.valueOf(event.getObjectId()));
        logger.debug("triggerCanceled() - seek Lock");
        Object object = this.theState.getCriticalShutdownTimersLock();
        synchronized (object) {
            logger.debug("triggerCanceled(): got lock");
            EventKey eventKey = new EventKey(event);
            ShutdownTimer shutdownTimer = this.theState.getCriticalShutdownTimer(eventKey);
            if (shutdownTimer != null && !shutdownTimer.isEventCleared()) {
                logger.debug("triggerCanceled() - sendEventLogNotices");
                this.sendEventLogNotices(event);
            }
            logger.debug("triggerCanceled(): checking timers");
            this.cancelNonCriticalTimers(event, eventKey);
            if (shutdownTimer != null && !shutdownTimer.isEventCleared()) {
                logger.debug("triggerCanceled(): Shutdown cancelling event generated after event has gone critical  Event:" + String.valueOf(event.getObjectId()));
                shutdownTimer.cancel_shutdown();
                if (shutdownTimer.isAlive()) {
                    logger.info("triggerCanceled(): Shutdown timer is currently active, setting event cleared flag");
                    shutdownTimer.setEventCleared();
                } else {
                    logger.debug("triggerCanceled(): shutdown completed.  Clear event");
                    if (!this.theState.removeCriticalShutdownTimer(eventKey)) {
                        logger.debug("triggerCanceled(): no timer found");
                    }
                    HashSet<String> hashSet = new HashSet<String>(this.services.getVirtualConfigurationManager().getProtectedVirtualHosts(shutdownTimer.getTriggerEvent()));
                    this.services.getVirtualConfigurationManager().clearCriticalHosts(this.theState, hashSet);
                }
                logger.debug("triggerCanceled(): Remove cmdfiles from map");
                this.removeCmdFileFromRunningMap(shutdownTimer.getRanFile());
                logger.debug("triggerCanceled() - sendEventClearedTrap");
                this.sendEventClearedTrap();
            } else {
                logger.trace("triggerCanceled(): not a critical timer ");
            }
        }
        logger.debug("triggerCanceled() - free Lock");
        logger.debug("triggerCanceled() - end");
    }

    private void sendEventLogNotices(Event event) {
        boolean bl = false;
        try {
            boolean bl2 = this.services.getVirtualConfigurationManager().isESXi() || this.services.getVirtualConfigurationManager().isHyperV();
            this.logCriticalGroupResolvedEvent(event);
            if (event instanceof AdvancedGroupEvent) {
                logger.debug("sendEventLogNotices(): AdvancedGroup handling");
                bl = this.isPhysicalGroup(event);
            }
            if (!event.getObjectId().equals((Object)kSinglePowerFailedOid) && !bl && bl2) {
                this.notifyEventToEventLog(event);
            }
        }
        catch (Exception exception) {
            logger.error("Error sending Event Notices", (Throwable)exception);
        }
    }

    private void logCriticalGroupResolvedEvent(Event event) {
        AdvancedGroupFormatter advancedGroupFormatter = new AdvancedGroupFormatter(new CriticalGroupFormatter("CriticalGroupResolvedWithEvent.Log"));
        try {
            this.services.getConfigurationManager().getApplicationErrorHandler().put(advancedGroupFormatter.format(event));
        }
        catch (Exception exception) {
            logger.warn("logCriticalGroupResolvedEvent(): Error logging event cleared. ", (Throwable)exception);
        }
    }

    private boolean isPhysicalGroup(Event event) {
        boolean bl = false;
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(((AdvancedGroupEvent)event).getGroup());
        if (uPSSetup != null && uPSSetup.getHosts().isEmpty() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
            bl = true;
            logger.debug("isPhysicalGroup(): it is a physical group");
        }
        return bl;
    }

    private void cancelNonCriticalTimers(Event event, EventKey eventKey) {
        logger.debug("cancelNonCriticalTimers(): non-criticalTimers:" + this.aNonCriticalShutdownTimerMap.size());
        logger.debug("cancelNonCriticalTimers(): criticalTimers:" + this.theState.getCriticalShutdownTimersCount());
        if (this.aNonCriticalShutdownTimerMap.containsKey(eventKey)) {
            ShutdownTimer shutdownTimer = this.aNonCriticalShutdownTimerMap.get(eventKey);
            shutdownTimer.cancel_shutdown();
            shutdownTimer.interrupt();
            logger.info("cancelNonCriticalTimers(): Cancelling non-critical timer for:" + String.valueOf(shutdownTimer.getTriggerEvent()) + " Event:" + String.valueOf(event.getObjectId()));
            if (this.aNonCriticalShutdownTimerMap.remove(eventKey) == null) {
                logger.debug("cancelNonCriticalTimers(): not removed from map ");
            }
        } else {
            logger.debug("cancelNonCriticalTimers(): no non-critical timer for " + event.toString() + " Event:" + String.valueOf(event.getObjectId()));
        }
    }

    private void notifyEventToEventLog(Event event) {
        logger.debug("notifyEventToEventLog(): Log it resolved");
        Set<String> set = this.services.getVirtualConfigurationManager().getProtectedVirtualHosts(event);
        if (set != null) {
            this.logCriticalEventResolved(set, event);
        }
    }

    private void sendEventClearedTrap() {
        try {
            logger.debug("sendEventClearedTrap()");
            Collection<ShutdownTimer> collection = this.theState.getCriticalShutdownTimersList();
            boolean bl = false;
            for (ShutdownTimer object : collection) {
                if (object.isEventCleared()) continue;
                logger.debug("sendEventClearedTrap(): Active Timer found, no clearing Trap");
                bl = true;
                break;
            }
            if (!bl) {
                ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                String string = Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventClear");
                PcnsTrapGenerator.getInstance(this.aPermanentStorage, this.services).clearTrap(PcnsTrapGenerator.pcnsCriticalEventActive, string);
            } else {
                logger.debug("sendEventClearedTrap(): No clearing trap required at this point");
            }
        }
        catch (Exception exception) {
            logger.error("Error sending event Trap", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startShutdown(Event event, int n) {
        logger.info("ShutdownSequencer start_shutdown: anEvent=" + String.valueOf(event) + " aDelayTime=" + n);
        EventKey eventKey = new EventKey(event);
        if (this.aNonCriticalShutdownTimerMap.containsKey(eventKey) || this.theState.getCriticalShutdownTimer(eventKey) != null) {
            logger.debug("startShutdown(): Event already in progress for:" + String.valueOf(event.getObjectId()));
            return;
        }
        ShutdownInProgressFormatter shutdownInProgressFormatter = new ShutdownInProgressFormatter(this.theResourceBundle, this.theOSName, n);
        Event event2 = new Event(ShutdownInProgress.kOid, (IFormatter)shutdownInProgressFormatter);
        this.theEventConsumer.update(event2);
        logger.info("startShutdown(): Shutdown starting event generated " + n);
        ShutdownTimer shutdownTimer = new ShutdownTimer(event, this, n, this.services);
        logger.debug("startShutdown() - seek Lock");
        Object object = this.theState.getCriticalShutdownTimersLock();
        synchronized (object) {
            logger.debug("startShutdown() - got Lock");
            if (this.aNonCriticalShutdownTimerMap.containsKey(eventKey) || this.theState.getCriticalShutdownTimer(eventKey) != null) {
                logger.debug("startShutdown(): Event already in progress for:" + String.valueOf(event.getObjectId()));
                return;
            }
            logger.info("newTimer:" + String.valueOf(eventKey.getKey()));
            ShutdownTimer shutdownTimer2 = this.aNonCriticalShutdownTimerMap.put(eventKey, shutdownTimer);
            if (shutdownTimer2 != null) {
                logger.warn("startShutdown(): Replacing existing shutdown timer for Event:" + String.valueOf(event.getObjectId()));
            }
            logger.debug("startShutdown(): non-criticalTimers:" + this.aNonCriticalShutdownTimerMap.size());
            logger.debug("startShutdown(): criticalTimers:" + this.theState.getCriticalShutdownTimersCount());
        }
        logger.debug("startShutdown() - free Lock");
        shutdownTimer.start();
    }

    public Map<EventKey, ShutdownTimer> getShutdownTimerMap() {
        return this.aNonCriticalShutdownTimerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Event event) {
        Object object;
        logger.info("shutdownNow(" + String.valueOf(event.getObjectId()) + ") enabled:" + this.theState.isShutdownerEnabled());
        if (!this.isShutdownerReady()) {
            logger.error("shutdownNow(): Shutdowner is not started correctly");
            return;
        }
        if (this.licensingManager.isLicenseRequired()) {
            logger.warn("shutdownNow(): PCNS is not licensed, can't run shutdown");
            this.logShutdownAbortedNoLicense();
            return;
        }
        StandardHost standardHost = this.getAffectedHost(event, this.theEventConsumer);
        logger.debug("shutdownNow(): AffectedHost: " + (standardHost != null ? standardHost.getClass().getName() : "none"));
        boolean bl = true;
        if (this.services.getVirtualConfigurationManager().isHyperV() && !this.services.getVirtualConfigurationManager().isManagedHost()) {
            object = this.theState;
            synchronized (object) {
                if (!this.theState.hasHostShutdownInitiated("localhost")) {
                    Map<EventKey, ShutdownTimer> map = this.theState.getCriticalShutdownTimersMap();
                    for (Map.Entry<EventKey, ShutdownTimer> entry : map.entrySet()) {
                        if (!entry.getKey().getKey().equals(event)) continue;
                        this.theState.addHostToShutdown("localhost", entry.getValue());
                    }
                } else {
                    bl = false;
                    logger.debug("shutdownNow(): localhost already shutting down");
                }
            }
        }
        if (standardHost != null) {
            standardHost.setPerformHyperVUnmanagedVirtShutdown(bl);
            object = new MasterSequenceThread(standardHost, event, this.theState, this.aPermanentStorage, this, this.theEventConsumer, this.theDataSource, this.sshActionManager, this.services);
            ((Thread)object).start();
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            logger.error("shutdownNow(): No Affected Host detected");
        }
    }

    public StandardHost getAffectedHost(Event event, IEventConsumer iEventConsumer) {
        logger.debug("getAffectedHost() - start");
        StandardHost standardHost = null;
        logger.debug("Managed or AVH: {} Advanced:{}", (Object)this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV(), (Object)this.services.getAdvancedSetupHelper().isAdvancedShutdownMode());
        if (this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            if (!(event instanceof AdvancedGroupEvent)) {
                logger.error("getAffectedHost(): Wrong type of event!!!");
                return standardHost;
            }
            logger.debug("getAffectedHost() - Managed Advanced");
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(advancedGroupEvent.getGroup());
            if (uPSSetup != null && uPSSetup.getHosts().isEmpty() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
                standardHost = new StandardHost(this.services);
            }
        }
        if (standardHost == null) {
            standardHost = this.getHostType();
        }
        return standardHost;
    }

    public StandardHost getHostType() {
        StandardHost standardHost = null;
        boolean bl = false;
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            standardHost = this.services.getVirtualConfigurationManager().isManagedHost() ? (this.services.getVirtualConfigurationManager().isNutanixSupported() ? new NutanixESXHost(this.services) : (this.services.getVirtualConfigurationManager().isSimplivity() ? new SimplivityHost(this.services) : (this.services.getVirtualConfigurationManager().isHyperflex() ? new HyperflexHost(this.services) : (this.services.getVirtualConfigurationManager().isVxRail() ? new VxRailHost(this.services) : new ESXManagedHost(this.services))))) : new ESXUnmanagedStandaloneHost(this.services);
        } else if (this.services.getVirtualConfigurationManager().isHyperV()) {
            standardHost = this.services.getVirtualConfigurationManager().isManagedHost() ? new HyperVManagedHost(this.services) : (HyperVUnmanagedClusterHost.isClusterServiceInstalled() ? new HyperVUnmanagedClusterHost(this.services) : new HyperVUnmanagedStandaloneHost(this.services));
        } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            standardHost = new NutanixAHVHost(this.services);
        } else {
            bl = true;
            standardHost = new StandardHost(this.services);
        }
        if (logger.isTraceEnabled()) {
            if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
                logger.trace("getHostType() - advanced");
                if (bl) {
                    logger.trace("getHostType() - Standard-advanced");
                }
            } else {
                logger.trace("getHostType() - standard");
                if (bl) {
                    logger.trace("getHostType() - Standard-single");
                }
            }
        }
        standardHost.setSshActionManager(this.sshActionManager);
        return standardHost;
    }

    private boolean isShutdownerReady() {
        int n = 0;
        while (!this.theState.isShutdownerEnabled()) {
            logger.info("isShutdownerReady() shutdowner not ready, waiting...");
            try {
                Thread.sleep(1000L);
                if (++n <= 300) continue;
                return false;
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        return true;
    }

    public void turnOffOnBatteryNow() {
        logger.info("turnOffOnBatteryNow()");
        TurnOffOnBatteryFormatter turnOffOnBatteryFormatter = new TurnOffOnBatteryFormatter(this.theResourceBundle);
        Event event = new Event(ShutdownEvents.ShutdownOnBattery.getObjectId(), (IFormatter)turnOffOnBatteryFormatter);
        this.theEventConsumer.update(event);
        this.triggerCanceled(new Event(kSinglePowerFailedOid));
    }

    public void cancelAllShutdowns() {
        for (ShutdownTimer shutdownTimer : this.theState.getCriticalShutdownTimersList()) {
            shutdownTimer.cancel_shutdown();
        }
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startCmdFile(Event event, CommandFile commandFile) {
        logger.info("startCmdFile(): Run Cmd File ");
        int n = 0;
        Event event2 = this.runningFiles;
        synchronized (event2) {
            logger.debug("startCmdFile(): checking for:" + commandFile.getPath() + " in " + this.runningFiles.toString());
            if (this.runningFiles.get(commandFile.getPath()) == null) {
                this.runningFiles.put(commandFile.getPath(), true);
                logger.debug("startCmdFile(): Added file lock:" + this.runningFiles.toString());
            } else if (this.runningFiles.get(commandFile.getPath()).booleanValue()) {
                logger.debug("startCmdFile(): Found in runningFiles true");
                n = 1;
            } else {
                logger.debug("startCmdFile(): Found in runningFiles false");
                n = 2;
            }
        }
        event2 = Utils.formatRunCommandFile(event, this.theResourceBundle, ShutdownEvents.ShutdownCmdFileStarting.getObjectId(), n);
        this.theEventConsumer.update(event2);
        return n;
    }

    public void waitForCmdFileToComplete(Event event, CommandFile commandFile, int n) {
        EventKey eventKey = new EventKey(event);
        ShutdownTimer shutdownTimer = this.theState.getCriticalShutdownTimer(eventKey);
        if (shutdownTimer != null) {
            shutdownTimer.setRanFile(commandFile.getPath());
        }
        if (n == 0) {
            Vector<CommandFile> vector = new Vector<CommandFile>();
            CommandFile commandFile2 = new CommandFile(commandFile.getPath(), event.getObjectId(), 0, 0);
            vector.add(commandFile2);
            DelayedExecutor delayedExecutor = new DelayedExecutor(this.osLogger, vector, event, 0, 0);
            delayedExecutor.setDataSource(this.theDataSource);
            delayedExecutor.start();
            new CountdownTimer(commandFile.getPeriodicInterval(), TimeUnit.SECONDS).sleep();
            Event event2 = Utils.formatRunCommandFile(event, this.theResourceBundle, ShutdownEvents.CmdFileDone.getObjectId(), 4);
            this.theEventConsumer.update(event2);
            shutdownTimer = this.theState.getCriticalShutdownTimer(eventKey);
            if (shutdownTimer != null && shutdownTimer.isShutdownEnabled()) {
                this.runningFiles.put(commandFile.getPath(), false);
                logger.debug("waitForCmdFileToComplete(): Updating runningFiles to false");
            } else {
                this.runningFiles.remove(commandFile.getPath());
                logger.debug("waitForCmdFileToComplete(): Updating runningFiles to remove:" + commandFile.getPath());
                if (shutdownTimer == null) {
                    logger.debug("waitForCmdFileToComplete(): shutdown_timer is null");
                } else {
                    logger.debug("waitForCmdFileToComplete(): shutdown_timer enabled:" + shutdownTimer.isShutdownEnabled());
                }
            }
        } else if (n == 1) {
            new CountdownTimer(commandFile.getPeriodicInterval(), TimeUnit.SECONDS).sleep();
        } else {
            logger.info("waitForCmdFileToComplete(): File has already been run, no need to wait");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCmdFileFromRunningMap(String string) {
        Map<String, Boolean> map = this.runningFiles;
        synchronized (map) {
            logger.debug("removeCmdFileFromRunningMap(): Checking running files for:" + string + " in " + this.runningFiles.toString());
            Boolean bl = this.runningFiles.get(string);
            if (bl != null && !bl.booleanValue()) {
                this.runningFiles.remove(string);
                logger.debug("removeCmdFileFromRunningMap(): Removing from runningFiles:" + string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logCriticalEventResolved(Set<String> set, Event event) {
        if (set != null) {
            Vector<String> vector = new Vector<String>();
            String string = OIdEventMapping.getEventName(event);
            logger.debug("logCriticalEventResolved: " + String.valueOf(event.getObjectId()) + "-" + string + " on " + set.size() + " hosts");
            for (String object2 : set) {
                vector.add(object2);
            }
            Object object3 = null;
            if (string == null) {
                if (set.size() == 0) {
                    VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter(50);
                } else if (set.size() == 1) {
                    VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)41, vector);
                } else {
                    VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)42, vector);
                }
            } else if (set.size() == 0 || set.contains(null)) {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)51, string);
            } else if (set.size() == 1) {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)32, string, vector);
            } else {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)33, string, vector);
            }
            if (event instanceof AdvancedGroupEvent) {
                void var6_13;
                AdvancedGroupFormatter advancedGroupFormatter = new AdvancedGroupFormatter((IFormatter)var6_13);
            }
            try {
                void var6_15;
                object3 = var6_15.format((Object)event);
                logger.debug("logCriticalEventResolved(): logging: " + (String)object3);
                this.services.getConfigurationManager().getApplicationErrorHandler().put((String)object3);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("logCriticalEventResolved(): unable to log message");
            }
            logger.debug("logCriticalEventResolved: end");
        }
    }

    public void logShutdownAbortedNoLicense() {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        String string = Utils.getResourceString(resourceBundleWrapper, "Licensing.CantShutDown");
        this.errorHandler.put(string);
    }

    public void runAllStartupSSHActions() {
        this.sshActionManager.runSSHActions(null, SSHActionTrigger.ON_STARTUP);
    }

    @Generated
    public void setSshActionManager(@NonNull SSHActionManager sSHActionManager) {
        if (sSHActionManager == null) {
            throw new IllegalArgumentException("sshActionManager is marked non-null but is null");
        }
        this.sshActionManager = sSHActionManager;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setOsLogger(@NonNull OperatingSystemEventLogger operatingSystemEventLogger) {
        if (operatingSystemEventLogger == null) {
            throw new IllegalArgumentException("osLogger is marked non-null but is null");
        }
        this.osLogger = operatingSystemEventLogger;
    }
}

