/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.shutdowner.EventKey;
import com.apcc.m11.components.shutdowner.GroupClearedTask;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.sshservice.SSHActionManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownState {
    private static final Logger logger = LogManager.getLogger(ShutdownState.class);
    private boolean theShutdownerIsEnabled = false;
    private boolean OSShutdownInProgress = false;
    private boolean theHypervVirtualizationStartupInProgress = false;
    private boolean theResumeHostCompleted = false;
    private boolean isVCSAStartupReattempt = true;
    private boolean isVCSARequiredForAppStartup = false;
    private boolean nutanixClusterStopInProgress = false;
    private boolean nutanixUvmStopInProgress = false;
    private boolean nutanixUvmStartInProgress = false;
    private boolean nutanixCvmStartInProgress = false;
    private boolean hyperflexClusterStopInProgress = false;
    private boolean disablingHAInProgress = false;
    private boolean disablingVCLSInProgress = false;
    private boolean hasHABeenDisabled = false;
    private boolean hasVCLSBeenDisabled = false;
    private boolean shutdownVclsVms = false;
    private boolean enablingHAInProgress = false;
    private boolean enablingVCLSInProgress = false;
    private boolean clusterHandlingInProgress = false;
    private CountdownTimer disableVclsTimer;
    private boolean vSanPreparationInProgress = false;
    private boolean hasVsanPreparationRun = false;
    private boolean vSanRecoveryInProgress = false;
    private HashSet<String> theVMwareVMStartupInProgress = new LinkedHashSet<String>();
    private HashSet<String> theVMwareVAppStartupInProgress = new LinkedHashSet<String>();
    private HashSet<Integer> thevAppShutdownThreadRunInitiated = new HashSet();
    private HashSet<Integer> theVMMigrationLoggingInitiated = new HashSet();
    private String vCenterVMUUID = null;
    private Set<String> theVAppsShutdownSet = new HashSet<String>();
    private String aPCNSHostIPorName;
    private HostSystem aPCNSHostSystem;
    private Map<EventKey, ShutdownTimer> theCriticalShutdownTimers = null;
    private Map<String, ShutdownTimer> theHostsToShutdown = new HashMap<String, ShutdownTimer>();
    private Map<String, String> ESXiHostIPMap = new HashMap<String, String>();
    private HostSystem vcsaHostSystem = null;
    private String vcsaHostName = null;
    private String vcsaHostIp = null;
    private VirtualMachine vcsaVirtualMachine = null;
    private List<String> vAppsRunningPCNS = new ArrayList<String>();
    private ReentrantLock maintenanceModeLock = new ReentrantLock();
    private boolean isVcsaHostShutdown = false;
    private ServiceManager services;
    @NonNull
    private SSHActionManager sshActionManager;

    public ShutdownState(SSHActionManager sSHActionManager, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.sshActionManager = sSHActionManager;
    }

    public void setVcsaHostName(String string) {
        logger.debug("setVcsaHostName() - start, hostname: {}", (Object)string);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.vcsaHostName = string;
        }
        logger.debug("setVcsaHostName() - start, VCSA Host name set to: {}", (Object)this.vcsaHostName);
    }

    public String getVcsaHostName() {
        logger.debug("getVcsaHostName() - VCSA Host name: {}", (Object)this.vcsaHostName);
        return this.vcsaHostName;
    }

    public String getVcsaHostIp() {
        logger.debug("getVcsaHostIp() - VCSA Host IP: {}", (Object)this.vcsaHostIp);
        return this.vcsaHostIp;
    }

    public void setVcsaHostIp(String string) {
        logger.debug("setVcsaHostIp() - start, VCSA Host IP: {}", (Object)string);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.vcsaHostIp = string;
        }
        logger.debug("setVcsaHostIp() - end, VCSA Host IP set to: {}", (Object)this.vcsaHostIp);
    }

    public synchronized boolean isShutdownerEnabled() {
        return this.theShutdownerIsEnabled;
    }

    public synchronized void enable() {
        this.theShutdownerIsEnabled = true;
    }

    public synchronized void disable() {
        this.theShutdownerIsEnabled = false;
    }

    public synchronized boolean checkAndSetOSShutdownInProgress(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (!this.OSShutdownInProgress) {
                this.OSShutdownInProgress = true;
            } else {
                bl2 = true;
            }
        } else if (this.OSShutdownInProgress) {
            this.OSShutdownInProgress = false;
        } else {
            bl2 = true;
        }
        return bl2;
    }

    public synchronized boolean setvAppShutdownThreadRunInitiated(int n) {
        if (!this.thevAppShutdownThreadRunInitiated.contains(n)) {
            this.thevAppShutdownThreadRunInitiated.add(n);
            return true;
        }
        return false;
    }

    public synchronized void clearvAppShutdownThreadRunInitiated(int n) {
        if (this.thevAppShutdownThreadRunInitiated.contains(n)) {
            this.thevAppShutdownThreadRunInitiated.remove(n);
        }
    }

    public synchronized boolean isvAppShutdownThreadRunInitiated(int n) {
        boolean bl = false;
        if (this.thevAppShutdownThreadRunInitiated.contains(n)) {
            bl = true;
        }
        return bl;
    }

    public synchronized void setVMMigrationLoggingInitiated(int n) {
        if (!this.theVMMigrationLoggingInitiated.contains(n)) {
            this.theVMMigrationLoggingInitiated.add(n);
        }
    }

    public synchronized void clearVMMigrationLoggingInitiated(int n) {
        if (this.theVMMigrationLoggingInitiated.contains(n)) {
            this.theVMMigrationLoggingInitiated.remove(n);
        }
    }

    public synchronized boolean isVMMigrationLoggingInitiated(int n) {
        boolean bl = false;
        if (this.theVMMigrationLoggingInitiated.contains(n)) {
            bl = true;
        }
        return bl;
    }

    public synchronized void setVMWareVMStartup(String string) {
        this.theVMwareVMStartupInProgress.add(string);
    }

    public synchronized void clearVMWareVMStartup(String string) {
        if (this.theVMwareVMStartupInProgress.contains(string)) {
            this.theVMwareVMStartupInProgress.remove(string);
        }
    }

    public synchronized boolean isVMWareVMStartupInProgress(String string) {
        boolean bl = false;
        if (this.theVMwareVMStartupInProgress.contains(string)) {
            bl = true;
        }
        return bl;
    }

    public synchronized void setVMWareVAppStartup(String string) {
        logger.debug("setVMWareVAppStartup({})", (Object)string);
        this.theVMwareVAppStartupInProgress.add(string);
    }

    public synchronized void clearVMWareVAppStartup(String string) {
        logger.debug("clearVMWareVAppStartup({})", (Object)string);
        if (this.theVMwareVAppStartupInProgress.contains(string)) {
            this.theVMwareVAppStartupInProgress.remove(string);
            logger.debug("clearVMWareVAppStartup({}) - removed", (Object)string);
        }
    }

    public synchronized boolean isVMWareVAppStartupInProgress(String string) {
        boolean bl = false;
        if (this.theVMwareVAppStartupInProgress.contains(string)) {
            bl = true;
        }
        logger.debug("isVMWareVAppStartupInProgress({}) = {}", (Object)string, (Object)bl);
        return bl;
    }

    public synchronized void setHypervVirtualizationStartup() {
        logger.debug("setHypervVirtualizationStartup");
        this.theHypervVirtualizationStartupInProgress = true;
    }

    public synchronized void clearHypervVirtualizationStartup() {
        logger.debug("clearHypervVirtualizationStartup");
        this.theHypervVirtualizationStartupInProgress = false;
    }

    public synchronized boolean isHypervVirtualizationStartupInProgress() {
        logger.debug("isHypervVirtualizationStartup:" + this.theHypervVirtualizationStartupInProgress);
        return this.theHypervVirtualizationStartupInProgress;
    }

    public synchronized void setResumeHostCompleted() {
        this.theResumeHostCompleted = true;
    }

    public synchronized void clearResumeHostCompleted() {
        this.theResumeHostCompleted = false;
    }

    public synchronized boolean isResumeHostCompleted() {
        return this.theResumeHostCompleted;
    }

    public synchronized void setVCenterVMUUID(String string) {
        this.vCenterVMUUID = string;
    }

    public synchronized void clearVCenterVMUUID() {
        this.vCenterVMUUID = null;
    }

    public synchronized String getVCenterVMUUID() {
        return this.vCenterVMUUID;
    }

    public synchronized boolean isvAppShutdownTriggered(String string) {
        return this.theVAppsShutdownSet.contains(string);
    }

    public synchronized boolean setvAppShutdownSet(String string) {
        if (!this.theVAppsShutdownSet.contains(string)) {
            this.theVAppsShutdownSet.add(string);
            return true;
        }
        return false;
    }

    public synchronized void removevAppShutdownSet(String string) {
        if (this.theVAppsShutdownSet.contains(string)) {
            this.theVAppsShutdownSet.remove(string);
        }
    }

    public synchronized void clearvAppShutdownSet() {
        this.theVAppsShutdownSet.clear();
    }

    public synchronized Set<String> getvAppShutdownSet() {
        return this.theVAppsShutdownSet;
    }

    public void setHostWherePCNSInstalled(String string) {
        logger.debug("setHostWherePCNSInstalled - host: " + string);
        this.aPCNSHostIPorName = string;
    }

    public String getHostWherePCNSInstalled() {
        return this.aPCNSHostIPorName;
    }

    public void setHostSystemPCNSInstalled(HostSystem hostSystem) {
        this.aPCNSHostSystem = hostSystem;
    }

    public HostSystem getHostSystemPCNSInstalled() {
        return this.aPCNSHostSystem;
    }

    public boolean removeCriticalShutdownTimer(EventKey eventKey) {
        logger.debug("removeCriticalShutdownTimer:" + String.valueOf(eventKey));
        ShutdownTimer shutdownTimer = this.theCriticalShutdownTimers.remove(eventKey);
        Event event = shutdownTimer.getTriggerEvent();
        if (event instanceof AdvancedGroupEvent) {
            int n = ((AdvancedGroupEvent)event).getGroup();
            if (!this.hasCriticalTimer(n)) {
                logger.info("No more critical events on group:" + n);
                GroupClearedTask groupClearedTask = new GroupClearedTask(n, this.sshActionManager, this.services);
                this.services.getThreadService().execute(groupClearedTask);
            }
        } else if (this.getCriticalShutdownTimersCount() == 0) {
            logger.info("No more critical UPS events");
        }
        return shutdownTimer != null;
    }

    public void addCriticalShutdownTimer(EventKey eventKey, ShutdownTimer shutdownTimer) {
        this.theCriticalShutdownTimers.put(eventKey, shutdownTimer);
    }

    public ShutdownTimer getCriticalShutdownTimer(EventKey eventKey) {
        return this.theCriticalShutdownTimers.get(eventKey);
    }

    public Object getCriticalShutdownTimersLock() {
        return this.theCriticalShutdownTimers;
    }

    public int getCriticalShutdownTimersCount() {
        int n = 0;
        if (this.theCriticalShutdownTimers != null) {
            n = this.theCriticalShutdownTimers.size();
        }
        return n;
    }

    public Collection<ShutdownTimer> getCriticalShutdownTimersList() {
        return this.theCriticalShutdownTimers.values();
    }

    public Map<EventKey, ShutdownTimer> getCriticalShutdownTimersMap() {
        if (logger.isDebugEnabled()) {
            if (this.theCriticalShutdownTimers != null && this.theCriticalShutdownTimers.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (EventKey eventKey : this.theCriticalShutdownTimers.keySet()) {
                    stringBuffer.append(eventKey);
                    stringBuffer.append("[");
                    stringBuffer.append(this.theCriticalShutdownTimers.get(eventKey).getHostsToShutdown());
                    stringBuffer.append("],");
                }
                logger.debug("getCriticalShutdownTimers() - {}", (Object)stringBuffer.toString());
            } else {
                logger.debug("getCriticalShutdownTimers() - no critical timers");
            }
        }
        return this.theCriticalShutdownTimers;
    }

    public void setCriticalShutdownTimers(Map<EventKey, ShutdownTimer> map) {
        logger.debug("setCriticalShutdownTimers");
        if (this.theCriticalShutdownTimers != null) {
            logger.error("setCriticalShutdownTimers replacing existing timer map with {} timers", (Object)this.theCriticalShutdownTimers.size());
        }
        this.theCriticalShutdownTimers = map;
    }

    public synchronized void setVCSAHost(HostSystem hostSystem) {
        logger.debug("setVCSAHost() - Setting VCSA Host to: {}", (Object)hostSystem);
        this.vcsaHostSystem = hostSystem;
    }

    public synchronized HostSystem getVCSAHost() {
        logger.debug("getVCSAHost() - Getting VCSA Host: {}", (Object)this.vcsaHostSystem);
        return this.vcsaHostSystem;
    }

    public synchronized void clearVCSAHost() {
        logger.debug("clearVCSAHost() - Clearing VCSAHostSystem");
        this.vcsaHostSystem = null;
    }

    public synchronized void setVCSAVM(VirtualMachine virtualMachine) {
        logger.debug("setVCSAVM() - Setting VCSA VM to: {}", (Object)virtualMachine);
        this.vcsaVirtualMachine = virtualMachine;
    }

    public synchronized VirtualMachine getVCSAVM() {
        logger.debug("getVCSAVM() - Getting VCSA VM: {}", (Object)this.vcsaVirtualMachine);
        return this.vcsaVirtualMachine;
    }

    public synchronized void clearVCSAVM() {
        logger.debug("clearVCSAVM() - Clearing VCSA VM.");
        this.vcsaVirtualMachine = null;
    }

    public synchronized void setVCSAStartupReattempt(boolean bl) {
        this.isVCSAStartupReattempt = bl;
    }

    public synchronized boolean getVCSAStartupReattempt() {
        return this.isVCSAStartupReattempt;
    }

    public synchronized void setVCSARequiredForVAppStartup(boolean bl) {
        this.isVCSARequiredForAppStartup = bl;
    }

    public synchronized boolean getVCSARequiredForVAppStartup() {
        return this.isVCSARequiredForAppStartup;
    }

    public synchronized String getIPForESXiHost(String string) {
        String string2 = null;
        if (this.ESXiHostIPMap.get(string) != null) {
            string2 = this.ESXiHostIPMap.get(string);
        }
        return string2;
    }

    public synchronized void setIPForESXiHost(String string, String string2) {
        this.ESXiHostIPMap.put(string, string2);
    }

    public synchronized void clearIPForESXiHost(String string) {
        if (this.ESXiHostIPMap.get(string) != null) {
            this.ESXiHostIPMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCriticalTimer(int n) {
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("hasCriticalTimer() - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("hasCriticalTimer() - got Lock");
                for (EventKey eventKey : this.theCriticalShutdownTimers.keySet()) {
                    AdvancedGroupEvent advancedGroupEvent;
                    Event event = eventKey.getKey();
                    if (!(event instanceof AdvancedGroupEvent) || (advancedGroupEvent = (AdvancedGroupEvent)event).getGroup() != n) continue;
                    return true;
                }
            }
            logger.debug("hasCriticalTimer() - free Lock");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<String>> getAllCriticalHostsInAdvancedGroups(int n) {
        HashMap<Integer, Set<String>> hashMap = new HashMap<Integer, Set<String>>();
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("getAllCriticalHostsInAdvancedGroups() - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("getAllCriticalHostsInAdvancedGroups() - got Lock");
                for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                    AdvancedGroupEvent advancedGroupEvent;
                    Event event = shutdownTimer.getTriggerEvent();
                    if (event == null || !(event instanceof AdvancedGroupEvent) || shutdownTimer.getHostsToShutdown().isEmpty() || (advancedGroupEvent = (AdvancedGroupEvent)event).getGroup() == n) continue;
                    logger.debug("getAllCriticalHostsInAdvancedGroups() - adding critical hosts from group: {}", (Object)advancedGroupEvent.getGroup());
                    hashMap.put(advancedGroupEvent.getGroup(), shutdownTimer.getHostsToShutdown().keySet());
                }
            }
            logger.debug("getAllCriticalHostsInAdvancedGroups() - free Lock");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCriticalTimerCount(int n, int n2) {
        int n3 = 0;
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("getCriticalTimerCount() - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("getCriticalTimerCount() - got Lock");
                for (EventKey eventKey : this.theCriticalShutdownTimers.keySet()) {
                    AdvancedGroupEvent advancedGroupEvent;
                    Event event = eventKey.getKey();
                    if (event instanceof AdvancedGroupOutletEvent) {
                        advancedGroupEvent = (AdvancedGroupOutletEvent)event;
                        if (advancedGroupEvent.getGroup() != n || ((AdvancedGroupOutletEvent)advancedGroupEvent).getOutletNumber() != n2) continue;
                        ++n3;
                        continue;
                    }
                    if (!(event instanceof AdvancedGroupEvent) || (advancedGroupEvent = (AdvancedGroupEvent)event).getGroup() != n) continue;
                    ++n3;
                }
            }
            logger.debug("getCriticalTimerCount() - free Lock");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfCriticalEventActive(String string) {
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("checkIfCriticalEventActive(hostname) - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("checkIfCriticalEventActive(hostname) - got Lock");
                for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                    if (shutdownTimer.getHostsToShutdown() == null || !shutdownTimer.getHostsToShutdown().containsKey(string)) continue;
                    logger.debug("checkIfCriticalEventActive() - found active critical event: {} for host: {}", (Object)shutdownTimer.getTriggerEvent(), (Object)string);
                    return true;
                }
            }
            logger.debug("checkIfCriticalEventActive(hostname) - free Lock");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfNonCriticalEventActive(String string) {
        String string2 = string;
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("checkIfNonCriticalEventActive() - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("checkIfNonCriticalEventActive() - got Lock");
                for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                    if (shutdownTimer.getHostsToShutdown() == null || !shutdownTimer.getHostsToShutdown().containsKey(string2) || !shutdownTimer.getHostsToShutdown().get(string2).booleanValue()) continue;
                    return true;
                }
            }
            logger.debug("checkIfNonCriticalEventActive() - free Lock");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfCriticalEventActive(HostSystem hostSystem) {
        if (this.theCriticalShutdownTimers != null) {
            String string = this.services.getHostSystemUtils().getESXiHostIPAddress(hostSystem);
            String string2 = hostSystem.getName();
            logger.debug("checkIfCriticalEventActive(HostSystem) - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("checkIfCriticalEventActive(HostSystem) - got Lock");
                for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                    if ((shutdownTimer.getHostsToShutdown() == null || !shutdownTimer.getHostsToShutdown().containsKey(string2)) && !shutdownTimer.getHostsToShutdown().containsKey(string)) continue;
                    return true;
                }
            }
            logger.debug("checkIfCriticalEventActive(HostSystem) - free Lock");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfCriticalEventActive(int n) {
        if (this.theCriticalShutdownTimers != null) {
            logger.debug("checkIfCriticalEventActive(id) - seek Lock");
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("checkIfCriticalEventActive(id) - got Lock");
                for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                    AdvancedGroupEvent advancedGroupEvent;
                    if (shutdownTimer.getTriggerEvent() == null || !(shutdownTimer.getTriggerEvent() instanceof AdvancedGroupEvent) || (advancedGroupEvent = (AdvancedGroupEvent)shutdownTimer.getTriggerEvent()).getGroup() != n) continue;
                    return true;
                }
            }
            logger.debug("checkIfCriticalEventActive(id) - free Lock");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashSet<String> getClearedHostSet(Set<String> set) {
        logger.debug("getClearedHostSet:" + String.valueOf(set));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        boolean bl = false;
        if (this.theCriticalShutdownTimers != null) {
            Object object = this.getCriticalShutdownTimersLock();
            synchronized (object) {
                for (String string : set) {
                    logger.debug("is there a timer for:" + string);
                    bl = false;
                    for (ShutdownTimer shutdownTimer : this.theCriticalShutdownTimers.values()) {
                        if (shutdownTimer.getHostsToShutdown() == null) continue;
                        logger.debug("timer for:" + String.valueOf(shutdownTimer.getHostsToShutdown()));
                        if (!shutdownTimer.getHostsToShutdown().containsKey(string)) continue;
                        logger.debug("found a timer for:" + string);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    linkedHashSet.add(string);
                }
            }
        }
        logger.debug("getClearedHostSet returns:" + String.valueOf(linkedHashSet));
        return linkedHashSet;
    }

    public boolean isCriticalShutdownTimerAvailable() {
        boolean bl = false;
        if (this.theCriticalShutdownTimers != null && this.theCriticalShutdownTimers.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public void addHostToShutdown(String string, ShutdownTimer shutdownTimer) {
        if (this.theHostsToShutdown.get(string) == null) {
            this.theHostsToShutdown.put(string, shutdownTimer);
        }
    }

    public void clearHostsToShutdown(ShutdownTimer shutdownTimer) {
        ShutdownTimer shutdownTimer2 = this.theHostsToShutdown.get("localhost");
        if (shutdownTimer2 != null && shutdownTimer2.equals(shutdownTimer)) {
            this.theHostsToShutdown.clear();
        }
    }

    public void clearHostsToShutdown(String string) {
        this.theHostsToShutdown.remove(string);
    }

    public boolean hasHostShutdownInitiated(String string) {
        return this.theHostsToShutdown.get(string) != null;
    }

    public void addVAppRunningPCNS(String string) {
        this.vAppsRunningPCNS.add(string);
    }

    public boolean getVAppRunningPCNS(String string) {
        return this.vAppsRunningPCNS.contains(string);
    }

    public void clearVAppsRunningPCNS() {
        if (this.vAppsRunningPCNS != null) {
            this.vAppsRunningPCNS.clear();
        }
    }

    public synchronized void setNutanixClusterStop() {
        logger.debug("setNutanixClusterStop");
        this.nutanixClusterStopInProgress = true;
    }

    public synchronized void clearNutanixClusterStop() {
        logger.debug("clearNutanixClusterStop");
        this.nutanixClusterStopInProgress = false;
    }

    public synchronized boolean isNutanixClusterStopInProgress() {
        logger.debug("isNutanixClusterStopInProgress: {}", (Object)this.nutanixClusterStopInProgress);
        return this.nutanixClusterStopInProgress;
    }

    public synchronized void setNutanixUvmStop() {
        logger.debug("setNutanixUvmStop");
        this.nutanixUvmStopInProgress = true;
    }

    public synchronized void clearNutanixUvmStop() {
        logger.debug("clearNutanixUvmStop");
        this.nutanixUvmStopInProgress = false;
    }

    public synchronized boolean isNutanixUvmStopInProgress() {
        logger.debug("isNutanixUvmStopInProgress: {}", (Object)this.nutanixUvmStopInProgress);
        return this.nutanixUvmStopInProgress;
    }

    public synchronized void setNutanixUvmStart() {
        logger.debug("setNutanixUvmStart");
        this.nutanixUvmStartInProgress = true;
    }

    public synchronized void clearNutanixUvmStart() {
        logger.debug("clearNutanixUvmStart");
        this.nutanixUvmStartInProgress = false;
    }

    public synchronized boolean isNutanixUvmStartInProgress() {
        logger.debug("isNutanixUvmStartInProgress: {}", (Object)this.nutanixUvmStartInProgress);
        return this.nutanixUvmStartInProgress;
    }

    public synchronized void setNutanixCvmStart() {
        logger.debug("setNutanixCvmStart");
        this.nutanixCvmStartInProgress = true;
    }

    public synchronized void clearNutanixCvmStart() {
        logger.debug("clearNutanixCvmStart");
        this.nutanixCvmStartInProgress = false;
    }

    public boolean isNutanixCvmStartInProgress() {
        logger.debug("isNutanixCvmStartInProgress: {}", (Object)this.nutanixCvmStartInProgress);
        return this.nutanixCvmStartInProgress;
    }

    public synchronized void setHyperflexClusterStop() {
        logger.debug("setHyperflexClusterStop");
        this.hyperflexClusterStopInProgress = true;
    }

    public synchronized void clearHyperflexClusterStop() {
        logger.debug("clearHyperflexClusterStop");
        this.hyperflexClusterStopInProgress = false;
    }

    public synchronized boolean isHyperflexClusterStopInProgress() {
        logger.debug("isHyperflexClusterStopInProgress: {}", (Object)this.hyperflexClusterStopInProgress);
        return this.hyperflexClusterStopInProgress;
    }

    public synchronized boolean isVcsaHostShutdown() {
        return this.isVcsaHostShutdown;
    }

    public synchronized void setVcsaHostShutdown(boolean bl) {
        logger.debug("setVcsaHostShutdown() - set to: {}", (Object)bl);
        this.isVcsaHostShutdown = bl;
    }

    public synchronized void setDisablingHAInProgress() {
        logger.debug("setDisablingHAInProgress()");
        if (this.disablingHAInProgress) {
            logger.debug("setDisablingHAInProgress() - already set");
            throw new IllegalStateException("HA disabling progress already set");
        }
        this.disablingHAInProgress = true;
    }

    public synchronized void clearDisablingHAInProgress() {
        logger.debug("clearDisablingHAInProgress()");
        this.disablingHAInProgress = false;
    }

    public synchronized boolean isDisablingHAInProgress() {
        logger.debug("isDisablingHAInProgress(): {}", (Object)this.disablingHAInProgress);
        return this.disablingHAInProgress;
    }

    public synchronized void setDisablingVCLSInProgress(CountdownTimer countdownTimer) {
        logger.debug("setDisablingVCLSInProgress()");
        if (this.disablingVCLSInProgress) {
            logger.debug("setDisablingVCLSInProgress() - already set");
            throw new IllegalStateException("vCLS disabling progress already set");
        }
        this.disablingVCLSInProgress = true;
        this.disableVclsTimer = countdownTimer;
    }

    public synchronized void clearDisablingVCLSInProgress() {
        logger.debug("clearDisablingVCLSInProgress()");
        this.disablingVCLSInProgress = false;
        this.disableVclsTimer = null;
    }

    public synchronized boolean isDisablingVCLSInProgress() {
        logger.debug("isDisablingVCLSInProgress(): {}", (Object)this.disablingVCLSInProgress);
        return this.disablingVCLSInProgress;
    }

    public synchronized void setHasHABeenDisabled() {
        logger.debug("setHasHABeenDisabled()");
        this.hasHABeenDisabled = true;
    }

    public synchronized void clearHasHABeenDisabled() {
        logger.debug("clearHasHABeenDisabled()");
        this.hasHABeenDisabled = false;
    }

    public synchronized boolean hasHABeenDisabled() {
        logger.debug("hasHABeenDisabled(): {}", (Object)this.hasHABeenDisabled);
        return this.hasHABeenDisabled;
    }

    public synchronized void setHasVCLSBeenDisabled() {
        logger.debug("setHasVCLSBeenDisabled()");
        this.hasVCLSBeenDisabled = true;
    }

    public synchronized void clearHasVCLSBeenDisabled() {
        logger.debug("clearHasVCLSBeenDisabled()");
        this.hasVCLSBeenDisabled = false;
    }

    public synchronized boolean hasVCLSBeenDisabled() {
        logger.debug("hasVCLSBeenDisabled(): {}", (Object)this.hasVCLSBeenDisabled);
        return this.hasVCLSBeenDisabled;
    }

    public synchronized void setShutdownVclsVms() {
        logger.debug("setShutdownVclsVms()");
        this.shutdownVclsVms = true;
    }

    public synchronized void clearShutdownVclsVms() {
        logger.debug("clearShutdownVclsVms()");
        this.shutdownVclsVms = false;
    }

    public synchronized boolean isShutdownVclsVmsSet() {
        logger.debug("isShutdownVclsVmsSet(): {}", (Object)this.shutdownVclsVms);
        return this.shutdownVclsVms;
    }

    public synchronized void setEnablingHAInProgress() {
        logger.debug("setEnablingHAInProgress()");
        if (this.enablingHAInProgress) {
            logger.debug("setEnablingHAInProgress() - already set");
            throw new IllegalStateException("HA enabling progress already set");
        }
        this.enablingHAInProgress = true;
    }

    public synchronized void clearEnablingHAInProgress() {
        logger.debug("clearEnablingHAInProgress()");
        this.enablingHAInProgress = false;
    }

    public synchronized boolean isEnablingHAInProgress() {
        logger.debug("isEnablingHAInProgress(): {}", (Object)this.enablingHAInProgress);
        return this.enablingHAInProgress;
    }

    public synchronized void setEnablingVCLSInProgress() {
        logger.debug("setEnablingVCLSInProgress()");
        if (this.enablingVCLSInProgress) {
            logger.debug("setEnablingVCLSInProgress() - already set");
            throw new IllegalStateException("vCLS enabling progress already set");
        }
        this.enablingVCLSInProgress = true;
    }

    public synchronized void clearEnablingVCLSInProgress() {
        logger.debug("clearEnablingVCLSInProgress()");
        this.enablingVCLSInProgress = false;
    }

    public synchronized boolean isEnablingVCLSInProgress() {
        logger.debug("isEnablingVCLSInProgress(): {}", (Object)this.enablingVCLSInProgress);
        return this.enablingVCLSInProgress;
    }

    public synchronized void setVSanPreparationInProgress() {
        logger.debug("setVSanPreparationInProgress()");
        this.vSanPreparationInProgress = true;
    }

    public synchronized void clearVSanPreparationInProgress() {
        logger.debug("clearVSanPreparationInProgress()");
        this.vSanPreparationInProgress = false;
    }

    public synchronized boolean isVSanPreparationInProgress() {
        logger.debug("isVSanPreparationInProgress(): {}", (Object)this.vSanPreparationInProgress);
        return this.vSanPreparationInProgress;
    }

    public synchronized void setVSanRecoveryInProgress() {
        logger.debug("setVSanRecoveryInProgress()");
        this.vSanRecoveryInProgress = true;
    }

    public synchronized void clearVSanRecoveryInProgress() {
        logger.debug("clearVSanPreparationInProgress()");
        this.vSanRecoveryInProgress = false;
    }

    public synchronized boolean isVSanRecoveryInProgress() {
        logger.debug("isVSanRecoveryInProgress(): {}", (Object)this.vSanRecoveryInProgress);
        return this.vSanRecoveryInProgress;
    }

    public synchronized void setHasVsanPreparationRun() {
        logger.debug("setHasVsanPreparationRun()");
        this.hasVsanPreparationRun = true;
    }

    public synchronized void clearHasVsanPreparationRun() {
        logger.debug("clearHasVsanPreparationRun()");
        this.hasVsanPreparationRun = false;
    }

    public synchronized boolean hasVsanPreparationRun() {
        logger.debug("hasVsanPreparationRun(): {}", (Object)this.hasVsanPreparationRun);
        return this.hasVsanPreparationRun;
    }

    public boolean isClusterHandlingInProgress() {
        logger.debug("isClusterHandlingInProgress(): {}", (Object)this.clusterHandlingInProgress);
        return this.clusterHandlingInProgress;
    }

    public void setClusterHandlingInProgress() {
        logger.debug("setClusterHandlingInProgress()");
        this.clusterHandlingInProgress = true;
    }

    public void clearClusterHandlingInProgress() {
        logger.debug("clearClusterHandlingInProgress()");
        this.clusterHandlingInProgress = false;
    }

    @Generated
    public CountdownTimer getDisableVclsTimer() {
        return this.disableVclsTimer;
    }

    @Generated
    public ReentrantLock getMaintenanceModeLock() {
        return this.maintenanceModeLock;
    }
}

