/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.shutdowner.EventKey;
import com.apcc.m11.components.shutdowner.ShutdownSequencer;
import com.apcc.m11.components.shutdowner.formatters.CriticalGroupFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.pcns.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownTimer
extends Thread {
    private static final Logger logger = LogManager.getLogger(ShutdownTimer.class);
    private static final int kSecondsToMilliSecondsConversion = 1000;
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private boolean isEventCleared = false;
    private Event theTriggerEvent = null;
    private ShutdownSequencer theShutdowner = null;
    private boolean theShutdownIsEnabled = true;
    private int theDelayTime = 0;
    private String ranFile;
    private Map<String, Boolean> hostsToShutdown = new HashMap<String, Boolean>();
    private ServiceManager services;
    private boolean firstCriticalTimer = false;

    public ShutdownTimer(Event event, ShutdownSequencer shutdownSequencer, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theTriggerEvent = event;
        this.theShutdowner = shutdownSequencer;
        this.theDelayTime = n;
        this.services = serviceManager;
    }

    public boolean didActualHostShutdown() {
        return this.firstCriticalTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            int n = this.theDelayTime * 1000;
            logger.debug("Shutdown Timer Running for :" + n);
            ShutdownTimer.sleep(n);
            logger.debug("Shutdown Timer finished ");
            logger.debug("run() - seek Lock");
            Object object2 = this.theShutdowner.getShutdownState().getCriticalShutdownTimersLock();
            synchronized (object2) {
                logger.debug("run() - got Lock");
                logger.debug("Shutdown Timer Running continue");
                this.theShutdowner.getShutdownTimerMap().remove(new EventKey(this.theTriggerEvent));
                logger.debug("ShutdownTimer goes critical for: " + String.valueOf(this.theTriggerEvent.getObjectId()));
                if (this.theTriggerEvent instanceof AdvancedGroupOutletEvent) {
                    object = (AdvancedGroupOutletEvent)this.theTriggerEvent;
                    if (this.theShutdowner.getShutdownState().getCriticalTimerCount(((AdvancedGroupEvent)((Object)object)).getGroup(), ((AdvancedGroupOutletEvent)((Object)object)).getOutletNumber()) == 0) {
                        this.firstCriticalTimer = true;
                    } else {
                        this.firstCriticalTimer = false;
                        logger.debug("Shutdown Timer already critical for group: " + ((AdvancedGroupEvent)((Object)object)).getGroup() + ", outlet: " + ((AdvancedGroupOutletEvent)((Object)object)).getOutletNumber());
                        if (logger.isTraceEnabled()) {
                            for (EventKey eventKey : this.theShutdowner.getShutdownState().getCriticalShutdownTimersMap().keySet()) {
                                AdvancedGroupOutletEvent advancedGroupOutletEvent;
                                Event event = eventKey.getKey();
                                if (!(event instanceof AdvancedGroupOutletEvent) || (advancedGroupOutletEvent = (AdvancedGroupOutletEvent)event).getGroup() != ((AdvancedGroupEvent)((Object)object)).getGroup() || advancedGroupOutletEvent.getOutletNumber() != ((AdvancedGroupOutletEvent)((Object)object)).getOutletNumber()) continue;
                                logger.trace("Timer: " + event.toString());
                            }
                        }
                    }
                } else if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
                    object = (AdvancedGroupEvent)this.theTriggerEvent;
                    if (!this.theShutdowner.getShutdownState().hasCriticalTimer(((AdvancedGroupEvent)((Object)object)).getGroup())) {
                        this.firstCriticalTimer = true;
                    } else {
                        this.firstCriticalTimer = false;
                        logger.debug("Shutdown Timer already critical for group: " + ((AdvancedGroupEvent)((Object)object)).getGroup());
                        if (logger.isTraceEnabled()) {
                            for (EventKey eventKey : this.theShutdowner.getShutdownState().getCriticalShutdownTimersMap().keySet()) {
                                Event event = eventKey.getKey();
                                if (!(event instanceof AdvancedGroupEvent) || ((AdvancedGroupEvent)event).getGroup() != ((AdvancedGroupEvent)((Object)object)).getGroup()) continue;
                                logger.trace("Timer:" + event.toString());
                            }
                        }
                    }
                } else if (!this.theShutdowner.getShutdownState().isCriticalShutdownTimerAvailable()) {
                    this.firstCriticalTimer = true;
                } else {
                    this.firstCriticalTimer = false;
                    logger.info("Shutdown Timer already critical");
                    if (logger.isTraceEnabled()) {
                        for (EventKey eventKey : this.theShutdowner.getShutdownState().getCriticalShutdownTimersMap().keySet()) {
                            Event event = eventKey.getKey();
                            logger.trace("Timer: " + event.toString());
                        }
                    }
                }
                this.theShutdowner.getShutdownState().addCriticalShutdownTimer(new EventKey(this.theTriggerEvent), this);
            }
            logger.debug("run() - free Lock");
            if (this.isShutdownEnabled()) {
                logger.debug("Shutdown Enabled");
                if (this.theTriggerEvent.getObjectId().equals((Object)kSinglePowerFailedOid)) {
                    this.theShutdowner.turnOffOnBatteryNow();
                    this.theShutdowner.getShutdownState().removeCriticalShutdownTimer(new EventKey(this.theTriggerEvent));
                } else {
                    logger.trace("Shutdown Enabled");
                    object2 = null;
                    object2 = this.theTriggerEvent instanceof AdvancedGroupEvent ? new AdvancedGroupFormatter(new CriticalGroupFormatter("CriticalGroupWithEvent.Log")) : new CriticalGroupFormatter("CriticalGroupWithEvent.Log");
                    this.services.getApplicationErrorHandler().put(object2.format((Object)this.theTriggerEvent));
                    if (this.firstCriticalTimer) {
                        logger.debug("Run Shutdown");
                        this.theShutdowner.shutdownNow(this.theTriggerEvent);
                        if (this.isEventCleared) {
                            logger.debug("Event cleared while timer was in progress:" + String.valueOf(this.theTriggerEvent));
                            if (!this.theShutdowner.getShutdownState().removeCriticalShutdownTimer(new EventKey(this.theTriggerEvent))) {
                                logger.debug("not removed from criticalTimers map");
                            }
                            this.services.getVirtualConfigurationManager().clearCriticalHosts(this.theShutdowner.getShutdownState(), this.getHostsToShutdown().keySet());
                        }
                    } else {
                        logger.debug("Shutdown Already Running on this group");
                        object = this.services.getVirtualConfigurationManager().getProtectedVirtualHosts(this.theTriggerEvent);
                        if (object != null) {
                            this.addCriticalHosts((Set<String>)object);
                        }
                    }
                }
            } else {
                logger.info("ShutdownTimer isShutdownEnabled is disabled");
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warn("Timer was interupted (cancelled timer)");
        }
        catch (Exception exception) {
            logger.warn("Unhandled Exception running shutdown. ", (Throwable)exception);
        }
    }

    public synchronized void cancel_shutdown() {
        logger.debug("Cancel it");
        this.theShutdownIsEnabled = false;
        this.theShutdowner.getShutdownState().clearHostsToShutdown(this);
    }

    public boolean isShutdownInProgress() {
        return this.isAlive();
    }

    public synchronized boolean isEventCleared() {
        return this.isEventCleared;
    }

    public synchronized void setEventCleared() {
        this.isEventCleared = true;
    }

    public Event getTriggerEvent() {
        return this.theTriggerEvent;
    }

    public synchronized boolean isShutdownEnabled() {
        return this.theShutdownIsEnabled;
    }

    public void setRanFile(String string) {
        this.ranFile = string;
    }

    public String getRanFile() {
        return this.ranFile;
    }

    public Map<String, Boolean> getHostsToShutdown() {
        Map<String, Boolean> map = Collections.emptyMap();
        if (this.hostsToShutdown != null) {
            map = Collections.unmodifiableMap(this.hostsToShutdown);
        }
        return map;
    }

    public void addCriticalHosts(Set<String> set) {
        logger.debug("addCriticalHosts {}", set);
        for (String string : set) {
            this.hostsToShutdown.put(string, false);
        }
    }

    public void addNonCriticalHosts(Set<String> set) {
        logger.debug("addNonCriticalHosts {}", set);
        for (String string : set) {
            this.hostsToShutdown.put(string, true);
        }
    }

    public void removeHosts(Set<String> set) {
        logger.debug("removeHosts {}", set);
        for (String string : set) {
            this.hostsToShutdown.remove(string);
        }
    }
}

