/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.components.shutdowner.ShutdownSequencer;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.Trigger;
import com.apcc.m11.components.shutdowner.VirtualHostStatusTask;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.host.directory.ComponentDirectory;
import com.apcc.m11.ds.host.directory.CurrentDirectory;
import com.apcc.m11.ds.host.directory.ExeDirectory;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.sshservice.SSHActionManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Shutdowner
implements IComponent,
IM11Component,
IDataSource,
IDataConsumer,
IEventProducer {
    public static final String RESOURCE_BUNDLE = "com.apcc.m11.components.shutdowner.i18n.ShutdownFormatters";
    private static final Logger logger = LogManager.getLogger(Shutdowner.class);
    private static final String WINDOWS_OS_NAME = "Windows";
    private static final String COMPONENT_NAME = "Shutdowner";
    private static final String COMPONENT_ID = "shutdowner";
    private static final String COMPONENT_VERSION = "4.0.0";
    private Trigger theTriggers = null;
    private ShutdownState theState = null;
    private ShutdownSequencer theShutdownSequencer = null;
    private SSHActionManager sshActionManager = null;
    private IDataSource theDataSource = null;
    private IPermanentStorage thePermanentStorage;
    private List<IEventConsumer> eventConsumers = new ArrayList<IEventConsumer>();
    private ServiceManager services;
    private EventListener<ConfigurationEvent> configEventListener;
    private EventListener<ReloadingEvent> configReloadListener;

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Shutdowner shutdowner = null;
        if (!objectId.equals((Object)M11Component.kOid)) {
            logger.warn("Invalid Instance" + objectId.toString());
            throw new InvalidObjectIdException();
        }
        shutdowner = this;
        return shutdowner;
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
        if (iPermanentStorage == null) {
            throw new ComponentFailureException("Permanent storage can't be null.");
        }
        logger.debug("Shutdowner Init");
        if (this.services == null) {
            this.services = ServiceManager.getInstance();
        }
        this.thePermanentStorage = iPermanentStorage;
        if (this.sshActionManager == null) {
            this.sshActionManager = new SSHActionManager(this.thePermanentStorage, this.services);
        }
        this.services.getThreadService().execute(this.sshActionManager);
        this.theState = new ShutdownState(this.sshActionManager, this.services);
        try {
            String string = SystemUtils.IS_OS_WINDOWS ? WINDOWS_OS_NAME : System.getProperty("os.name");
            this.theShutdownSequencer = new ShutdownSequencer(this.theState, string, this.services);
            this.theShutdownSequencer.setSshActionManager(this.sshActionManager);
            this.theShutdownSequencer.setVmwareConnection(this.services.getVmWareConnection());
        }
        catch (Exception exception) {
            logger.error("Init:  shutdown sequencer ", (Throwable)exception);
            throw new ComponentFailureException("Shutdowner failed to initialize ");
        }
        this.theTriggers = new Trigger(this.theShutdownSequencer, this.theState);
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        Map<ObjectId, String> map = EventLists.getAllEventsMap();
        for (Map.Entry<ObjectId, String> entry : map.entrySet()) {
            ObjectId objectId = entry.getKey();
            String string = entry.getValue();
            if (!this.isShutdownAllowed(objectId)) continue;
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = this.services.getConfigurationManager().getBoolean(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey(), (boolean)Boolean.FALSE);
            if (bl) {
                Integer n;
                IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(EventLists.getDefaultShutdownDelay(string));
                intRangeSetValidator.add(0, 172800);
                try {
                    n = this.services.getConfigurationManager().getInt(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey(), intRangeSetValidator);
                }
                catch (IllegalArgumentException | ConversionException throwable) {
                    logger.error((Object)throwable);
                    n = (Integer)intRangeSetValidator.getDefault();
                }
                VariableBinding variableBinding = new VariableBinding(objectId, (Object)n);
                this.theTriggers.addTrigger(variableBinding);
                continue;
            }
            this.theTriggers.removeTrigger(new VariableBinding(objectId, (Object)0));
        }
    }

    public void start() throws ComponentFailureException {
        GetResult getResult;
        if (this.configEventListener == null) {
            this.configEventListener = new EventListener<ConfigurationEvent>(){

                public void onEvent(ConfigurationEvent configurationEvent) {
                    try {
                        if (!configurationEvent.isBeforeUpdate() && StringUtils.startsWith((CharSequence)configurationEvent.getPropertyName(), (CharSequence)"Events")) {
                            Shutdowner.this.loadConfiguration();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        if (this.configReloadListener == null) {
            this.configReloadListener = new EventListener<ReloadingEvent>(){

                public void onEvent(ReloadingEvent reloadingEvent) {
                    try {
                        Shutdowner.this.loadConfiguration();
                    }
                    catch (Exception exception) {
                        logger.error("onEvent", (Throwable)exception);
                    }
                }
            };
        }
        this.services.getConfigurationManager().addEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.services.getConfigurationManager().addReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
        this.theShutdownSequencer.setResourceBundleLocation(RESOURCE_BUNDLE);
        this.theShutdownSequencer.setPermanentStorage(this.thePermanentStorage);
        try {
            getResult = this.theDataSource.get(ComponentDirectory.kOid);
            if (getResult != null) {
                String string = (String)getResult.getValue();
            }
        }
        catch (CommunicationException | InvalidObjectIdException throwable) {
            String string = System.getProperty("user.dir");
            logger.error("Can't get component directory from storage. Using default: " + string, throwable);
        }
        try {
            getResult = this.theDataSource.get(ExeDirectory.kOid);
            if (getResult != null) {
                String string = (String)getResult.getValue();
            }
        }
        catch (CommunicationException | InvalidObjectIdException throwable) {
            String string = System.getProperty("user.dir");
            logger.error("Can't read exe directory from storage, using default:  {} {}", (Object)string, (Object)throwable);
        }
        try {
            getResult = this.theDataSource.get(CurrentDirectory.kOid);
            if (getResult != null && getResult.getValue() != null) {
                ServiceManager.getInstance().getApplicationSettings().setApplicationDirectory((String)getResult.getValue());
            }
        }
        catch (CommunicationException | InvalidObjectIdException throwable) {
            String string = System.getProperty("user.dir");
            logger.error("Can't read current directory from storage, using default: {}, {} ", (Object)string, (Object)throwable);
            ServiceManager.getInstance().getApplicationSettings().setApplicationDirectory(string);
        }
        this.theState.enable();
        this.services.getAuthHelper().setPermanentStorage(this.thePermanentStorage);
        this.services.getVirtualConfigurationManager().getProxyUsername();
        this.services.getVirtualConfigurationManager().getProxyPassword();
        this.services.getThreadService().execute(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                String string = Shutdowner.this.services.getVirtualConfigurationManager().getVirtualInstallValue();
                boolean bl2 = bl = string.equalsIgnoreCase("VMWare") || string.equalsIgnoreCase("Hyper-V") || string.equalsIgnoreCase("Nutanix");
                if (bl) {
                    logger.debug("Starting HostStatus Checker");
                    IEventConsumer iEventConsumer = Shutdowner.this.eventConsumers.get(0);
                    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
                    VirtualHostStatusTask virtualHostStatusTask = new VirtualHostStatusTask(Shutdowner.this.theDataSource, Shutdowner.this.theShutdownSequencer, Shutdowner.this.theState, Shutdowner.this.thePermanentStorage, iEventConsumer, Shutdowner.this.services);
                    scheduledExecutorService.scheduleWithFixedDelay(virtualHostStatusTask, 1L, 2L, TimeUnit.MINUTES);
                } else {
                    logger.debug("No HostStatus Checker for this configuration");
                }
                logger.debug("Running SSH startup actions as part of service startup");
                Shutdowner.this.theShutdownSequencer.runAllStartupSSHActions();
            }
        });
    }

    public void start(ITemporaryStorage iTemporaryStorage) throws ComponentFailureException {
        Vector vector = iTemporaryStorage.getVector();
        this.theTriggers = (Trigger)vector.elementAt(0);
        this.theState = (ShutdownState)vector.elementAt(1);
        this.start();
    }

    public void stop() {
        this.services.getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
        this.services.getConfigurationManager().removeReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
        this.theState.disable();
        this.theShutdownSequencer.cancelAllShutdowns();
        this.theDataSource = null;
        this.theTriggers.stop();
        this.theTriggers = null;
        this.theShutdownSequencer = null;
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.theTriggers);
        vector.addElement(this.theState);
        iTemporaryStorage.saveVector(vector);
        this.stop();
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        Object object = null;
        if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventConsumer.kOid)) {
            logger.info("get Event Consumer");
            object = this.theTriggers;
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            object = this;
        } else {
            logger.debug("bad interface ID: " + objectId.toString());
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return object;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public ComponentID getComponentID() {
        return new ComponentID(COMPONENT_ID);
    }

    public String getComponentVersion() {
        return COMPONENT_VERSION;
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
        this.theShutdownSequencer.setDataSource(iDataSource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        GetResult getResult = new GetResult();
        if (this.theState.isShutdownerEnabled()) {
            if (!objectId.equals((Object)ShutdownGroup.ShutdownTriggers.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
            getResult.setValue(this.theTriggers.getTriggers());
            return getResult;
        } else {
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult;
        block8: {
            block7: {
                getResult = new GetResult();
                if (!this.theState.isShutdownerEnabled()) break block7;
                switch (n) {
                    case 0: {
                        getResult = this.get(objectId);
                        break block8;
                    }
                    case 1: {
                        if (this.theState.isShutdownerEnabled()) {
                            getResult.setValue((Object)Availability.AVAILABLE);
                        }
                        break block8;
                    }
                    case 2: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block8;
                    }
                    case 3: {
                        getResult = new GetResult();
                        getResult.setError();
                        break block8;
                    }
                    default: {
                        logger.warn("bad ID or type" + n);
                        throw new InvalidObjectIdException();
                    }
                }
            }
            logger.warn("shutdowner not initialized");
            getResult.setError();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this method.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        if (objectId == null) {
            throw new InvalidObjectIdException("ObjectId can't be null.");
        }
        SetResult setResult = new SetResult();
        if (this.theState.isShutdownerEnabled()) {
            if (objectId.equals((Object)ShutdownGroup.AddShutdownTrigger.getObjectId())) {
                if (!(object instanceof VariableBinding)) {
                    throw new InvalidValueException("Expected a varbind.");
                }
                VariableBinding variableBinding = (VariableBinding)object;
                setResult.setSuccessful(this.addTrigger(variableBinding));
                return setResult;
            } else if (objectId.equals((Object)ShutdownGroup.RemoveShutdownTrigger.getObjectId())) {
                if (!(object instanceof VariableBinding)) {
                    throw new InvalidValueException("Expected a varbind.");
                }
                VariableBinding variableBinding = (VariableBinding)object;
                setResult.setSuccessful(this.removeTrigger(variableBinding));
                return setResult;
            } else {
                if (!objectId.equals((Object)ShutdownGroup.ShutdownSystem.getObjectId())) throw new InvalidObjectIdException("Unsupported operation.");
                if (!(object instanceof Integer)) {
                    throw new InvalidValueException("Expected an integer.");
                }
                logger.info("ShutdownSystem set");
                this.theShutdownSequencer.startShutdown(new Event(objectId), (Integer)object);
                setResult.setSuccessful(true);
            }
            return setResult;
        } else {
            logger.warn("Shutdowner not initialized");
            setResult.setSuccessful(false);
        }
        return setResult;
    }

    private boolean addTrigger(VariableBinding variableBinding) {
        boolean bl = false;
        logger.info("addTrigger:" + String.valueOf(variableBinding.getObjectId()));
        if (this.isShutdownAllowed(variableBinding.getObjectId())) {
            String string = EventLists.getEventNameForObjectId(variableBinding.getObjectId());
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            Integer n = EventLists.getDefaultShutdownDelay(string);
            if (variableBinding.getValue() instanceof Integer) {
                n = (Integer)variableBinding.getValue();
            }
            if (n >= 0 && n <= 172800) {
                this.theTriggers.addTrigger(variableBinding);
                this.services.getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey(), Boolean.TRUE);
                this.services.getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey(), n);
                bl = true;
            } else {
                logger.info("addTrigger failed.  Invalid delay:" + n);
            }
        } else {
            logger.info("addTrigger failed.  shutdown Not allowed");
        }
        return bl;
    }

    private boolean removeTrigger(VariableBinding variableBinding) {
        this.theTriggers.removeTrigger(variableBinding);
        String string = EventLists.getEventNameForObjectId(variableBinding.getObjectId());
        ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
        this.services.getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey(), Boolean.FALSE);
        Integer n = EventLists.getDefaultShutdownDelay(string);
        if (variableBinding.getValue() instanceof Integer) {
            n = (Integer)variableBinding.getValue();
        }
        if (n >= 0 && n <= 172800) {
            this.services.getConfigurationManager().setProperty(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey(), n);
        }
        if (variableBinding.getObjectId().equals((Object)RuntimeVerifierEvents.RunTimeRemaining.getObjectId())) {
            this.services.getConfigurationManager().setProperty("Shutdown", "runtimeRemainingThreshold", n);
        }
        return true;
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(ShutdownGroup.getGroup());
        vector.addElement(ShutdownGroup.AddShutdownTrigger.getObjectId());
        vector.addElement(ShutdownGroup.RemoveShutdownTrigger.getObjectId());
        vector.addElement(ShutdownGroup.ShutdownSystem.getObjectId());
        return vector.elements();
    }

    private boolean isShutdownAllowed(ObjectId objectId) {
        boolean bl = !EventLists.getNonShutdownEvents().contains(objectId);
        logger.debug("Shutdown allowed for " + objectId.toString() + ": " + bl);
        return bl;
    }

    public void registerEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (iEventConsumer == null) {
            throw new RegistrationException("Event Consumer can't be null.");
        }
        this.eventConsumers.add(iEventConsumer);
        this.theShutdownSequencer.registerEventConsumer(iEventConsumer);
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (iEventConsumer == null) {
            throw new RegistrationException("Event Consumer can't be null.");
        }
        this.eventConsumers.remove(iEventConsumer);
        this.theShutdownSequencer.unRegisterEventConsumer(iEventConsumer);
    }

    public ShutdownSequencer getShutdownSequencer() {
        return this.theShutdownSequencer;
    }

    @Generated
    public void setSshActionManager(SSHActionManager sSHActionManager) {
        this.sshActionManager = sSHActionManager;
    }

    @Generated
    public void setServices(ServiceManager serviceManager) {
        this.services = serviceManager;
    }
}

