/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.shutdowner.ShutdownSequencer;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualHostStatusTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VirtualHostStatusTask.class);
    private IDataSource theDataSource;
    private ShutdownSequencer theShutdownSequencer;
    private ShutdownState theShutdownState;
    private IPermanentStorage thePermanentStorage;
    private IEventConsumer theEventConsumer;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;

    public VirtualHostStatusTask(IDataSource iDataSource, ShutdownSequencer shutdownSequencer, ShutdownState shutdownState, IPermanentStorage iPermanentStorage, IEventConsumer iEventConsumer, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.theDataSource = iDataSource;
        this.theShutdownSequencer = shutdownSequencer;
        this.theShutdownState = shutdownState;
        this.thePermanentStorage = iPermanentStorage;
        this.theEventConsumer = iEventConsumer;
        this.virtualisationStatusStore.unlockNonCriticalHosts(this.getCriticalHosts());
        this.clearInvalidLockedHostsFromPropertiesFile();
    }

    @Override
    public void run() {
        if (!this.isAppInitialised()) {
            logger.debug("run() - application not initialized");
            return;
        }
        logger.trace("run() - start");
        try {
            this.checkStopCriticalHostsThatAreRunning();
            this.checkPerformStartup();
        }
        catch (Exception exception) {
            logger.error("run() - Unexpected exception: ", (Throwable)exception);
        }
        logger.trace("run() - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkStopCriticalHostsThatAreRunning() {
        if (this.theShutdownState.getCriticalShutdownTimersCount() <= 0) {
            logger.trace("checkStopCriticalHostsThatAreRunning() - no critical timers, host shutdown not required");
            return;
        }
        logger.debug("checkStopCriticalHostsThatAreRunning() - critical timers, check if hosts need to be shut down");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        logger.debug("checkStopCriticalHostsThatAreRunning() - seek Lock");
        Object object = this.theShutdownState.getCriticalShutdownTimersLock();
        synchronized (object) {
            logger.debug("checkStopCriticalHostsThatAreRunning() - got Lock");
            for (ShutdownTimer shutdownTimer : this.theShutdownState.getCriticalShutdownTimersList()) {
                linkedHashSet.addAll(shutdownTimer.getHostsToShutdown().keySet());
            }
            logger.debug("checkStopCriticalHostsThatAreRunning() - critical timer active for host(s): {}", linkedHashSet);
            for (ShutdownTimer shutdownTimer : this.theShutdownState.getCriticalShutdownTimersList()) {
                if (!shutdownTimer.isShutdownInProgress()) continue;
                logger.debug("checkStopCriticalHostsThatAreRunning() - active shutdown for host(s): {}", shutdownTimer.getHostsToShutdown());
                linkedHashSet.removeAll(shutdownTimer.getHostsToShutdown().keySet());
            }
        }
        logger.debug("checkStopCriticalHostsThatAreRunning() - free Lock");
        if (linkedHashSet.isEmpty()) {
            logger.debug("checkStopCriticalHostsThatAreRunning() - shutdown_hosts is empty.");
            return;
        }
        logger.debug("checkStopCriticalHostsThatAreRunning() - host(s): {} should be off", linkedHashSet);
        object = this.theShutdownSequencer.getHostType();
        ((StandardHost)object).setHostSet(linkedHashSet);
        ((StandardHost)object).initialize(this.theEventConsumer, this.theDataSource, null, this.theShutdownState, this.thePermanentStorage);
        ((StandardHost)object).shutdownCriticalHosts();
    }

    void checkPerformStartup() {
        logger.trace("checkPerformStartup() - start");
        if (this.services.getVirtualConfigurationManager().isESXi() && !this.services.getVirtualConfigurationManager().isManagedHost()) {
            return;
        }
        LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getHostSetFromVirtualizationFileStore(false);
        String string = this.virtualisationStatusStore.getProperty("Witness_VM_HOST");
        if (string != null) {
            logger.debug("checkPerformStartup() - adding vSAN witness host {} to startup list", (Object)string);
            linkedHashSet.add(string);
        }
        linkedHashSet.addAll(this.virtualisationStatusStore.getVMAndVAppHostList());
        String string2 = this.virtualisationStatusStore.getProperty("VCSA_HOST");
        String string3 = this.virtualisationStatusStore.getProperty("VCSA_HOSTNAME");
        if (string2 != null || string3 != null) {
            logger.debug("checkPerformStartup() - checking if vCSA host {} (IP: {}) needs to be added to startup list", (Object)string3, (Object)string2);
            if (!linkedHashSet.contains(string2) && !linkedHashSet.contains(string3)) {
                logger.debug("checkPerformStartup() - adding vCSA host {} (IP: {}) to startup list", (Object)string3, (Object)string2);
                linkedHashSet.add(string2);
            }
        }
        if (linkedHashSet.isEmpty() && this.virtualisationStatusStore.isHAorVCLSDisabled() && string2 != null) {
            logger.debug("checkPerformStartup() - adding vcsaHostIP to hostSet, vCSAHostIP: {}", (Object)string2);
            linkedHashSet.add(string2);
        }
        if (linkedHashSet.isEmpty()) {
            if (!this.isHCIClusterStartupNeeded()) {
                return;
            }
            logger.debug("checkPerformStartup() - only HCI cluster to start");
        } else {
            logger.info("checkPerformStartup() - hostSet: {}", linkedHashSet);
        }
        if (!(this.services.getVirtualConfigurationManager().isStartupWaitsForAllHostsOnlineEnabled() || this.services.getVirtualConfigurationManager().isNutanixESXi() || this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().isHyperflex())) {
            logger.debug("checkPerformStartup() - start hosts, without waiting for all to be ready");
            CountDownLatch countDownLatch = new CountDownLatch(linkedHashSet.size());
            PreConditionsSynchronizer preConditionsSynchronizer = new PreConditionsSynchronizer();
            for (String string4 : linkedHashSet) {
                if (this.services.getVirtualConfigurationManager().isCriticalHost(this.theShutdownState, string4)) {
                    logger.debug("checkPerformStartup() - skipping critical host: {}", (Object)string4);
                    countDownLatch.countDown();
                    continue;
                }
                Runnable runnable = this.createHostStartupThread(string4, countDownLatch, preConditionsSynchronizer);
                this.services.getThreadService().execute(runnable);
            }
            logger.debug("checkPerformStartup() - waiting for host startup threads to complete");
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                logger.warn((Object)interruptedException);
            }
            logger.debug("checkPerformStartup() - startup threads complete");
        } else {
            logger.info("checkPerformStartup() - start all hosts together, wait for all hosts online is enabled");
            StandardHost standardHost = this.theShutdownSequencer.getHostType();
            standardHost.setPerformingStartup(true);
            standardHost.setHostSet(linkedHashSet);
            standardHost.initialize(this.theEventConsumer, this.theDataSource, null, this.theShutdownState, this.thePermanentStorage);
            standardHost.performStartup();
        }
    }

    private boolean isHCIClusterStartupNeeded() {
        if (!this.services.getVirtualConfigurationManager().isHCISystem()) {
            logger.trace("isHCIClusterStartupNeeded - not an HCI system, no cluster startup needed");
            return false;
        }
        if (!this.virtualisationStatusStore.isHCIClusterStopped()) {
            logger.trace("isHCIClusterStartupNeeded - HCI system, but no cluster stopped, no startup needed");
            return false;
        }
        logger.debug("isHCIClusterStartupNeeded - HCI system, cluster stopped, startup needed");
        return true;
    }

    private Runnable createHostStartupThread(String string, final CountDownLatch countDownLatch, final PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("createHostStartupThread() - attempt startup of host: {}", (Object)string);
        final StandardHost standardHost = this.theShutdownSequencer.getHostType();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(string);
        standardHost.setPerformingStartup(true);
        standardHost.setHostSet(linkedHashSet);
        standardHost.initialize(this.theEventConsumer, this.theDataSource, null, this.theShutdownState, this.thePermanentStorage);
        return new Runnable(){
            StandardHost myHost;
            CountDownLatch cdl;
            {
                this.myHost = standardHost;
                this.cdl = countDownLatch;
            }

            @Override
            public void run() {
                logger.debug("createHostStartupThread() - run Startup of host: {}", this.myHost.getHostSet());
                standardHost.performStartup(preConditionsSynchronizer);
                this.cdl.countDown();
            }
        };
    }

    protected boolean isAppInitialised() {
        boolean bl = false;
        logger.trace("isAppInitialised");
        try {
            GetResult getResult = this.theDataSource.get(TCPIPCommunication.IpAddress.getObjectId());
            if (getResult != null && getResult.getValue() != null) {
                if (getResult.getValue() instanceof InetAddress) {
                    bl = true;
                } else if (getResult.getValue() instanceof Vector) {
                    int n = 0;
                    for (Object e : (Vector)getResult.getValue()) {
                        if (!(e instanceof InetAddress)) continue;
                        ++n;
                    }
                    if (n > 0) {
                        bl = true;
                    }
                } else {
                    logger.trace("isAppInitialised() - unexpected type: {}", getResult.getValue().getClass());
                }
            }
        }
        catch (CommunicationException | InvalidObjectIdException throwable) {
            logger.trace("isAppInitialised() - unable to get IPAddress: {}", (Object)throwable.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getCriticalHosts() {
        LinkedHashSet<String> linkedHashSet;
        block6: {
            linkedHashSet = new LinkedHashSet<String>();
            try {
                if (!this.services.getVirtualConfigurationManager().isManagedESXi()) break block6;
                logger.debug("getCriticalHosts() - seek Lock");
                Object object = this.theShutdownState.getCriticalShutdownTimersLock();
                synchronized (object) {
                    logger.debug("getCriticalHosts() - got Lock");
                    for (ShutdownTimer shutdownTimer : this.theShutdownState.getCriticalShutdownTimersList()) {
                        linkedHashSet.addAll(shutdownTimer.getHostsToShutdown().keySet());
                    }
                }
                logger.debug("getCriticalHosts() - free Lock");
            }
            catch (Exception exception) {
                logger.error("getCriticalHosts() - Exception: ", (Throwable)exception);
            }
        }
        logger.debug("getCriticalHosts() - result: {}", linkedHashSet);
        return linkedHashSet;
    }

    private void clearInvalidLockedHostsFromPropertiesFile() {
        LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getHostSetFromVirtualizationFileStore(true);
        if (linkedHashSet != null && !linkedHashSet.isEmpty()) {
            LinkedHashSet<String> linkedHashSet2;
            if (this.services.getVirtualConfigurationManager().isHyperV()) {
                linkedHashSet2 = new LinkedHashSet<String>();
                linkedHashSet2.add("localhost");
            } else {
                linkedHashSet2 = this.services.getVirtualConfigurationManager().getConfiguredHosts();
            }
            for (String string : linkedHashSet) {
                if (this.services.getVirtualConfigurationManager().isHostInCurrentSetup(linkedHashSet2, string)) continue;
                this.virtualisationStatusStore.clearHostForShutdown(string);
                logger.debug("clearInvalidLockedHostsFromPropertiesFile() - removed invalid locked host: {} from property file", (Object)string);
            }
        }
    }
}

