/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.formatters;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunCommandFileFormatter
implements IFormatter,
Serializable {
    private static final transient Logger logger = LogManager.getLogger(RunCommandFileFormatter.class);
    private int alreadyRunning = 0;
    private static final String kShutdownNameKey = "RunShutdownCommandFile_Starting";
    private static final String kNameKey = "RunCommandFile_Starting";
    private static final String kRunningKey = "RunCommandFile_AlreadyRunning";
    private static final String kRunKey = "RunCommandFile_AlreadyRun";
    private static final String kRunDoneKey = "RunCommandFile_Done";
    private String theResourceBundle;

    public RunCommandFileFormatter(String string) {
        this.theResourceBundle = string;
    }

    public RunCommandFileFormatter(String string, int n) {
        this.theResourceBundle = string;
        this.alreadyRunning = n;
    }

    public String format(Object object) {
        Locale locale = Locale.getDefault();
        try {
            return this.format(object, locale);
        }
        catch (UnsupportedLocaleException unsupportedLocaleException) {
            logger.error("Default locale not supported", (Throwable)unsupportedLocaleException);
        }
        catch (Exception exception) {
            logger.error("Unknown error", (Throwable)exception);
        }
        return null;
    }

    public String format(Object object, Locale locale) throws UnsupportedLocaleException {
        Object[] objectArray = new Object[]{""};
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle(this.theResourceBundle, locale);
        if (resourceBundleWrapper != null) {
            Event event;
            String string = Utils.getResourceString(resourceBundleWrapper, kNameKey);
            if (object instanceof Event && (event = (Event)object).getObjectId().equals((Object)ShutdownEvents.ShutdownCmdFileStarting.getObjectId())) {
                string = Utils.getResourceString(resourceBundleWrapper, kShutdownNameKey);
            }
            switch (this.alreadyRunning) {
                case 0: {
                    break;
                }
                case 1: {
                    string = Utils.getResourceString(resourceBundleWrapper, kRunningKey);
                    break;
                }
                case 2: {
                    string = Utils.getResourceString(resourceBundleWrapper, kRunKey);
                    break;
                }
                case 4: {
                    string = Utils.getResourceString(resourceBundleWrapper, kRunDoneKey);
                }
            }
            messageFormat.applyPattern(string);
        }
        return messageFormat.format(objectArray);
    }
}

