/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.formatters;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownInProgressFormatter
implements IFormatter,
Serializable {
    private static final transient Logger logger = LogManager.getLogger(ShutdownInProgressFormatter.class);
    private static final long kMillSecondsToSeconds = 1000L;
    private static final String kNameKey = "Shutdown_In_Progress";
    private String theServerName;
    private String theResourceFileLocation;
    private long theShutdownDelay;
    private Date theTimeOfCreation;

    public ShutdownInProgressFormatter(String string, String string2, long l) {
        this.theResourceFileLocation = string;
        this.theServerName = string2;
        this.theShutdownDelay = l;
        Calendar calendar = Calendar.getInstance();
        this.theTimeOfCreation = calendar.getTime();
    }

    public String format(Object object) {
        Locale locale = Locale.getDefault();
        try {
            return this.format(object, locale);
        }
        catch (UnsupportedLocaleException unsupportedLocaleException) {
            logger.error("Default locale not supported", (Throwable)unsupportedLocaleException);
        }
        catch (Exception exception) {
            logger.error("Unknown error", (Throwable)exception);
        }
        return null;
    }

    public String format(Object object, Locale locale) throws UnsupportedLocaleException {
        Long l = this.getSecondsUntilShutdown();
        Long l2 = this.getMinutesUntilShutdown();
        Object[] objectArray = new Object[]{this.theServerName, l2, l};
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle(this.theResourceFileLocation, locale);
        if (resourceBundleWrapper != null) {
            String string = Utils.getResourceString(resourceBundleWrapper, kNameKey);
            messageFormat.applyPattern(string);
        }
        return messageFormat.format(objectArray);
    }

    private long getSecondsUntilShutdown() {
        long l = 0L;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        long l2 = (date.getTime() - this.theTimeOfCreation.getTime()) / 1000L;
        long l3 = this.theShutdownDelay - l2;
        long l4 = l3 / 60L;
        l = l3 - l4 * 60L;
        return l;
    }

    private long getMinutesUntilShutdown() {
        long l = 0L;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        long l2 = (date.getTime() - this.theTimeOfCreation.getTime()) / 1000L;
        long l3 = this.theShutdownDelay - l2;
        l = l3 / 60L;
        return l;
    }
}

