/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.shutdowner.vmware.DasSettings;
import com.apcc.m11.components.shutdowner.vmware.DrsSettings;
import com.apcc.m11.components.shutdowner.vmware.HostMaintenanceMode;
import com.apcc.m11.components.shutdowner.vmware.HostShutdownRunnable;
import com.apcc.m11.components.shutdowner.vmware.VirtualizationShutdownHost;
import com.apcc.m11.components.shutdowner.vmware.startup.VMVAppStartupRunnable;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanFaultToleranceThreshold;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanHost;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanWitnessVMStartupRunnable;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ClusterUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.CreateVCenterAlarm;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.IPUtils;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.ToolsUnavailable;
import com.vmware.vim25.VirtualMachineGuestState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsRunningStatus;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.OptionManager;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ESXManagedHost
extends StandardHost {
    private static final Logger logger = LogManager.getLogger(ESXManagedHost.class);
    public static final String DISABLING_VCLS_LOG = "EventLog.EnablingRetreatMode";
    public static final String ENABLING_VCLS_LOG = "EventLog.DisablingRetreatMode";
    public static final String SKIPPING_VCLS_SHUTDOWN = "EventLog.SkippingVCLSShutdown";
    public static final String DISABLE_VCLS_CONNECTION_FAILED = "EventLog.VCLSDisableConnectionFailed";
    public static final String ENABLE_VCLS_CONNECTION_FAILED = "EventLog.VCLSEnableConnectionFailed";
    public static final String VCLS_VMS_NOT_SHUTDOWN = "EventLog.VCLSvMsNotShutDown";
    public static final String UNABLE_TO_DISABLE_VCLS = "EventLog.ErrorEnablingRetreatMode";
    public static final String UNABLE_TO_ENABLE_VCLS = "EventLog.ErrorDisablingRetreatMode";
    public static final String UNABLE_TO_ENABLE_HA = "EventLog.ErrorEnablingHA";
    public static final String UNABLE_TO_DISABLE_HA = "EventLog.ErrorDisablingHA";
    public static final String DISABLING_HA_LOG = "EventLog.DisablingHA";
    public static final String ENABLING_HA_LOG = "EventLog.EnablingHA";
    private Collection<Future<?>> futures = Collections.synchronizedList(new ArrayList());
    private Map<String, VirtualizationShutdownHost> utilMap = new HashMap<String, VirtualizationShutdownHost>();
    private Map<String, VsanHost> criticalVsanHostMap = new HashMap<String, VsanHost>();
    private boolean isVCSA = false;
    protected String vcsaVmName = null;
    protected String vcsaHostName = null;
    protected String vcsaHostIP = null;
    private String matchedPCNSHostName = null;
    private HostSystem vCenterHost = null;
    private ServiceInstance vCSAHostServiceInstance = null;
    private boolean isSkipMaintenanceModeEnabled = false;
    protected boolean isAdvancedMode = false;
    protected VsanFaultToleranceThreshold vSanFttFeatures;
    private boolean isAdvancedFTTEnabled = false;
    private boolean isAdvancedFTTExceeded = false;
    private boolean isAdvancedShutdownAllVsanVms = false;
    private boolean isShutdownVcsaVmOnNonCriticalHost = false;
    private boolean isVcsaVmInVmShutdownPriorityList = false;
    private String vSanDatastoreName = null;
    private String vSanWitnessHostIp = null;
    private String vSanWitnessHostVmName = null;
    private String vSanManagementHost = null;
    private ClusterComputeResource cluster = null;
    protected VMWareConnection vmwareConnection = null;
    private VsanUtils vsanUtils = this.services.getVsanUtils();
    private HostSystemUtils hostSystemUtils;
    private VirtualConfigurationManager virtualConfigManager;
    private boolean pcnsHostOutsideCluster = false;
    private boolean vcsaHostOutsideCluster = false;
    private static final int MAX_MAINTENANCE_MODE_TIMEOUT = 300;
    private static final int WAIT_VCENTER_CONNECTION_SECONDS = 60;
    public static final int DELAY_AFTER_VCSA_POWERED_ON_AND_CONNECTED = 30;

    public ESXManagedHost(ServiceManager serviceManager) {
        super(serviceManager);
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.hostSystemUtils = this.services.getHostSystemUtils();
        this.virtualConfigManager = this.services.getVirtualConfigurationManager();
    }

    @Override
    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        super.setBaseProperties(iEventConsumer, iDataSource, event, shutdownState, iPermanentStorage);
        logger.debug("initialize() - start, ups_setup_idx: {}", (Object)this.ups_setup_idx);
        this.isAdvancedMode = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode();
        if (this.isAdvancedMode) {
            this.isAdvancedFTTEnabled = this.virtualConfigManager.isVsanFTTEnabled();
        }
        if (event != null) {
            super.checkAdvancedPhysicalUpsGroup();
            super.setVirtualHostsToShutdownList();
            this.protectedHosts = this.services.getVsanUtils().removeVsanTagsFromSet(this.protectedHosts, true);
        }
        super.updateCriticalShutdownTimerHosts();
        if (event != null) {
            super.logApplicationErrorEvent();
            super.addSnmpCriticalEventTrap();
        }
        shutdownState.clearVAppsRunningPCNS();
        this.checkIsVCSA();
        if (!this.performingStartup) {
            this.criticalVsanHostMap = this.services.getVsanUtils().checkVsanHosts(this.virtualHostsToShutdown);
            this.checkVCSAStatus();
            this.checkFaultToleranceThreshold();
        }
        this.virtualHostsToShutdown = this.services.getVsanUtils().removeVsanTagsFromSet(this.virtualHostsToShutdown);
        if (!this.performingStartup) {
            this.setVsanWitnessConfig();
        }
        this.isSkipMaintenanceModeEnabled = this.virtualConfigManager.isSkipMaintenanceModeEnabled();
        logger.debug("initialize() - end");
    }

    private void setVsanWitnessConfig() {
        logger.debug("setVsanWitnessConfig() - start()");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("setVsanWitnessConfig() - no hosts to shutdown");
            return;
        }
        String string = null;
        for (String string2 : this.virtualHostsToShutdown) {
            if (string2 == null || !this.isVsanWitnessHost(string2)) continue;
            string = string2;
            break;
        }
        if (string == null) {
            return;
        }
        if ((string = this.hostSystemUtils.getWitnessHostIp(string)) != null) {
            this.vSanWitnessHostIp = string;
            for (String string2 : this.virtualHostsToShutdown) {
                HostSystem hostSystem;
                VirtualMachine virtualMachine;
                if (string2 == null || this.isVsanHost(string2) || this.isVsanWitnessHost(string2) || (virtualMachine = this.hostSystemUtils.isVMPresentOnHost(hostSystem = this.getHostSystemForHost(string2), string)) == null) continue;
                logger.info("setVsanWitnessConfig() - found vSAN Witness VM: {} on host: {}", (Object)virtualMachine.getName(), (Object)string2);
                this.vSanWitnessHostVmName = virtualMachine.getName();
                this.vSanManagementHost = string2;
                break;
            }
        }
        logger.debug("setVsanWitnessConfig() - Witness Host IP: {}", (Object)this.vSanWitnessHostIp);
    }

    private void checkForVmShutdownOfNonCriticalHosts() {
        if (!this.isAdvancedMode || !this.isAdvancedFTTEnabled) {
            logger.debug("checkForVmShutdownOfNonCriticalHosts() - only applies to Advanced configurations with FTT enabled");
            return;
        }
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("checkForVmShutdownOfNonCriticalHosts() - virtualHostsToShutdown is null or empty: {}", (Object)this.virtualHostsToShutdown);
            return;
        }
        if (this.isNonCriticalVirtShutdownActive()) {
            logger.info("checkForVmShutdownOfNonCriticalHosts() - waiting for VM shutdown of non-critical host to complete");
            this.services.getVirtualLoggingUtils().logVirtShutdownOfNonCriticalHostInProgressEvent(this.theTriggerEvent);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isNonCriticalVirtShutdownActive());
            logger.info("checkForVirtShutdownOfNonCriticalHosts() - completed waiting for virtualization shutdown of non-critical host to complete");
        }
    }

    private boolean isNonCriticalVirtShutdownActive() {
        boolean bl = false;
        for (String string : this.virtualHostsToShutdown) {
            if (!this.theState.checkIfNonCriticalEventActive(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void checkFaultToleranceThreshold() {
        logger.debug("checkFaultToleranceThreshold() - start");
        if (!this.isAdvancedMode) {
            logger.debug("checkFaultToleranceThreshold() - only applicable for Advanced mode");
            return;
        }
        if (!this.isAdvancedFTTEnabled) {
            logger.debug("checkFaultToleranceThreshold() - isAdvancedFTTEnabled not set");
            return;
        }
        this.vSanFttFeatures = this.vsanUtils.getVsanFaultToleranceThreshold(this.theState, this.services);
        if (this.theTriggerEvent == null) {
            logger.debug("checkFaultToleranceThreshold() - not checking FTT, triggerEvent is null");
            return;
        }
        if (this.isVirtualHostsShutdownEnabled) {
            logger.debug("checkFaultToleranceThreshold() - critical event on Physical UPS Group, creating locks on all groups with vSAN hosts");
            this.vSanFttFeatures.createGroupLocksForAllGroups();
            return;
        }
        this.vSanFttFeatures.createGroupLock(this.ups_setup_idx);
        this.vSanFttFeatures.createMapOfNonCriticalVsanGroups(this.ups_setup_idx);
        if (!this.vSanFttFeatures.getNonCriticalVsanGroupMap().isEmpty()) {
            this.vSanFttFeatures.setUnhealthySingleUpsGroups(this.services.getVsanUtils().getUnhealthyVsanSingleUpsGroups(this.vSanFttFeatures.getNonCriticalVsanGroupMap()));
        }
        this.isAdvancedFTTExceeded = this.vSanFttFeatures.isFTTExceeded();
        if (!this.isAdvancedFTTExceeded) {
            return;
        }
        this.isAdvancedShutdownAllVsanVms = this.virtualConfigManager.isShutdownAllVsanVMsEnabled();
        if (this.isAdvancedShutdownAllVsanVms) {
            this.services.getVirtualLoggingUtils().logVirtShutdownOfNonCriticalHostsEvent(this.vSanFttFeatures.getNonCriticalVsanGroupMap(), this.theTriggerEvent);
            if (!this.vSanFttFeatures.getNonCriticalVsanGroupMap().isEmpty()) {
                this.vSanFttFeatures.addNonCriticalVsanHostsToCriticalTimer(this.theTriggerEvent);
                this.vSanDatastoreName = this.vSanFttFeatures.getVsanDatastoreName();
            }
        }
        logger.debug("checkFaultToleranceThreshold() - end");
    }

    private void checkIsVCSA() {
        logger.debug("checkIsVCSA() - start");
        VirtualMachine virtualMachine = this.hostSystemUtils.getVCenterServerVM();
        if (virtualMachine == null) {
            logger.debug("checkIsVCSA() - end, no vCSA VM found");
            return;
        }
        this.vcsaVmName = virtualMachine.getName();
        if (this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled()) {
            logger.debug("checkIsVCSA() - checking if vCSA VM is in VM Priority list");
            this.isVcsaVmInVmShutdownPriorityList = this.services.getVMPrioritizationUtils().checkIfVMExistsInPrioritizedVMList(this.vcsaVmName) != null;
        }
        logger.debug("checkIsVCSA() - using vCSA, name: {}", (Object)this.vcsaVmName);
        this.isVCSA = true;
    }

    @Override
    public void vMTasks() {
        logger.debug("vMTasks() - start");
        boolean bl = false;
        this.checkForVmShutdownOfNonCriticalHosts();
        logger.debug("vMTasks() - shutdownVirtualizationFeatures");
        this.shutdownVirtualizationFeatures(this.virtualHostsToShutdown, this.ups_setup_idx, bl);
        if (this.isAdvancedShutdownAllVsanVms && this.vSanFttFeatures != null && !this.vSanFttFeatures.getNonCriticalVsanGroupMap().isEmpty()) {
            logger.debug("vMTasks() - shutdown All vSAN host VMs");
            bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<Integer, LinkedHashSet<VsanHost>> entry : this.vSanFttFeatures.getNonCriticalVsanGroupMap().entrySet()) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                entry.getValue().forEach(vsanHost -> {
                    linkedHashSet.add(vsanHost.getName());
                    logger.debug("vMTasks() - non-critical group: {}, host: {}, witness: {}", entry.getKey(), (Object)vsanHost.getName(), (Object)vsanHost.isWitness());
                });
                this.shutdownVirtualizationFeatures(linkedHashSet, entry.getKey(), bl);
                hashSet.addAll(linkedHashSet);
            }
            logger.debug("vMTasks() - waitForShutdownVirtualizationFeaturesToComplete");
            this.waitForShutdownVirtualizationFeaturesToComplete();
            Set<String> set = this.checkShutdownOfVcsaVmOnNonCriticalHost(hashSet);
            this.vSanFttFeatures.unlockNonCriticalHosts(set, this.theTriggerEvent);
        } else {
            logger.debug("vMTasks() - waitForShutdownVirtualizationFeaturesToComplete");
            this.waitForShutdownVirtualizationFeaturesToComplete();
        }
        logger.debug("vMTasks() - end");
    }

    private Set<String> checkShutdownOfVcsaVmOnNonCriticalHost(Set<String> set) {
        logger.debug("checkShutdownOfVcsaVMOnNonCriticalHost() - start");
        if (this.isVcsaHostCritical(set)) {
            if (VsanUtils.isVmUsingDatastore(this.theState.getVCSAVM(), this.vSanDatastoreName) && !this.isVcsaVmInVmShutdownPriorityList) {
                logger.debug("checkShutdownOfVcsaVMOnNonCriticalHost() - vCSA VM: {} is located on vSAN datastore: {} so will get shut down", (Object)this.vcsaVmName, (Object)this.vSanDatastoreName);
                this.isShutdownVcsaVmOnNonCriticalHost = true;
                set.remove(this.vcsaHostName);
            }
            if (!this.isShutdownVcsaVmOnNonCriticalHost) {
                logger.debug("checkShutdownOfVcsaVMOnNonCriticalHost() - vCSA VM: {} is not located on vSAN datastore: {} so will not get shut down", (Object)this.vcsaVmName, (Object)this.vSanDatastoreName);
                this.clearStateVcsaSettings();
            }
        }
        return set;
    }

    @Override
    public void VCSAVMShutdown() {
        logger.debug("VCSAVMShutdown() - start");
        this.checkIsVCSA();
        boolean bl = false;
        if (!this.isShutdownVcsaVmOnNonCriticalHost) {
            bl = this.isVcsaHostCritical(this.virtualHostsToShutdown);
            if (this.isVcsaVmInVmShutdownPriorityList) {
                logger.info("VCSAVMShutdown() - found VCSA VM: {} in prioritized VM list, not proceeding with VCSA VM shutdown", (Object)this.vcsaVmName);
                return;
            }
        }
        try {
            if (bl || this.isShutdownVcsaVmOnNonCriticalHost) {
                if (this.hostSystemUtils.checkIfHostIsPoweredOn(this.theState.getVCSAHost())) {
                    logger.debug("VCSAVMShutdown() - vCSA Host is powered on, proceeding with VCSA VM shutdown");
                    this.performVCSAVMShutdown();
                } else {
                    logger.debug("VCSAVMShutdown() - vCSA Host is not powered on");
                }
                if (this.isShutdownVcsaVmOnNonCriticalHost) {
                    this.vSanFttFeatures.unlockNonCriticalHosts(new HashSet<String>(Arrays.asList(this.vcsaHostName)), this.theTriggerEvent);
                    this.clearStateVcsaSettings();
                }
            }
        }
        catch (Exception exception) {
            logger.error("VCSAVMShutdown() - Exception: ", (Throwable)exception);
        }
        logger.debug("VCSAVMShutdown() - end");
    }

    @Override
    public void handleVCLS() {
        logger.debug("handleVCLS() - start");
        if (!this.isClusterHandlingRequired()) {
            logger.debug("handleVCLS() - no vCLS or HA handling needed");
            return;
        }
        this.theState.setClusterHandlingInProgress();
        this.disableHA();
        if (this.vmwareConnection.isVCenterOffline() || !this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            logger.error("handleVCLS() - vCSA connection not successful");
            this.logToEventLog(DISABLE_VCLS_CONNECTION_FAILED);
            this.theState.setShutdownVclsVms();
            this.theState.clearClusterHandlingInProgress();
            return;
        }
        this.theState.clearShutdownVclsVms();
        if (!this.isVCLSHandlingNeeded()) {
            logger.debug("handleVCLS() - no vCLS handling needed");
            this.logToEventLog(SKIPPING_VCLS_SHUTDOWN);
            this.theState.clearClusterHandlingInProgress();
            return;
        }
        try {
            int n = this.virtualConfigManager.getDisableVClsDelay();
            logger.debug("handleVCLS() - Start Disabling vCLS timer with {} seconds", (Object)n);
            CountdownTimer countdownTimer = new CountdownTimer(n);
            try {
                this.theState.setDisablingVCLSInProgress(countdownTimer);
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("handleVCLS() - vCLS handling already in progress");
                this.waitForVclsHandlingThread();
                this.theState.clearClusterHandlingInProgress();
                return;
            }
            this.logToEventLog(DISABLING_VCLS_LOG);
            boolean bl = this.toggleRetreatMode(true);
            countdownTimer.sleep();
            if (!bl) {
                this.logToEventLog(UNABLE_TO_DISABLE_VCLS);
                this.theState.clearDisablingVCLSInProgress();
                this.theState.clearClusterHandlingInProgress();
                logger.debug("handleVCLS() - failed to disable vCLS.");
                return;
            }
            this.virtualisationStatusStore.setVclsDisabled(true);
            this.theState.setHasVCLSBeenDisabled();
            this.theState.clearDisablingVCLSInProgress();
            if (this.services.getClusterUtils().isVCLSvMCurrentlyRunning()) {
                this.logToEventLog(VCLS_VMS_NOT_SHUTDOWN, n);
            }
        }
        catch (RemoteException remoteException) {
            logger.debug("handleVCLS() - RemoteException {}", (Throwable)remoteException);
            this.theState.clearDisablingVCLSInProgress();
        }
        this.theState.clearClusterHandlingInProgress();
        logger.debug("handleVCLS() - end");
    }

    private boolean toggleRetreatMode(boolean bl) throws RemoteException {
        logger.debug("toggleRetreatMode() - start");
        if (this.vmwareConnection.isVCenterOffline() || !this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            logger.error("toggleRetreatMode() - vCSA connection not successful");
            return false;
        }
        ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance();
        if (serviceInstance == null) {
            logger.error("toggleRetreatMode() - ServiceInstance is null");
            return false;
        }
        OptionManager optionManager = serviceInstance.getOptionManager();
        if (optionManager == null) {
            logger.error("toggleRetreatMode() - OptionManager is null");
            return false;
        }
        OptionValue[] optionValueArray = this.getOptionValuesForRetreatMode(bl);
        if (optionValueArray == null) {
            logger.error("toggleRetreatMode() - OptionValue update Array is null");
            return false;
        }
        optionManager.updateOptions(optionValueArray);
        return true;
    }

    private OptionValue[] getOptionValuesForRetreatMode(Boolean bl) {
        logger.debug("getOptionValuesForRetreatMode() - start");
        boolean bl2 = bl == false;
        ClusterUtils clusterUtils = this.services.getClusterUtils();
        OptionValue optionValue = new OptionValue();
        ClusterComputeResource clusterComputeResource = this.getCluster();
        if (clusterComputeResource == null) {
            logger.error("getOptionValuesForRetreatMode() - cluster is null");
            return null;
        }
        optionValue.setKey(this.buildRetreatModeString(clusterUtils.getClusterDomainID(clusterComputeResource)));
        optionValue.setValue((Object)Boolean.toString(bl2));
        OptionValue[] optionValueArray = new OptionValue[]{optionValue};
        logger.debug("getOptionValuesForRetreatMode() - end");
        return optionValueArray;
    }

    private ClusterComputeResource getCluster() {
        logger.trace("getCluster() - start");
        Set<String> set = this.getHostSet();
        if (this.cluster != null) {
            try {
                logger.debug("getCluster() - cluster was already set, returning: {}", (Object)this.cluster.getName());
            }
            catch (Exception exception) {
                logger.error("getCluster() - exception when getting name from cluster: {}", (Object)exception.getMessage());
            }
        }
        if (!set.isEmpty()) {
            for (String object : set) {
                logger.trace("getCluster() - retrieve the cluster from the critical host {}", (Object)object);
                this.cluster = this.getClusterForHost(object);
                if (this.cluster == null) continue;
                logger.debug("getCluster() - cluster found for host {}", (Object)object);
                break;
            }
        }
        if (this.cluster == null) {
            logger.debug("getCluster() - cluster is null, trying configured hosts to find cluster");
            LinkedHashSet<String> linkedHashSet = this.virtualConfigManager.getConfiguredHosts();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (set.contains(string) || this.virtualisationStatusStore.isHostLockedForShutdown(string) || this.virtualisationStatusStore.isHostUnlockedForShutdown(string)) {
                    logger.debug("getCluster() - host not suitable for retrieving cluster: {}", (Object)string);
                    continue;
                }
                this.cluster = this.getClusterForHost(string);
                if (this.cluster == null) continue;
                logger.debug("getCluster() - cluster found for host {}", (Object)string);
                break;
            }
        }
        return this.cluster;
    }

    private ClusterComputeResource getClusterForHost(String string) {
        logger.debug("getClusterForHost() - retrieving cluster for host {}", (Object)string);
        HostSystem hostSystem = this.hostSystemUtils.getHostSystem(string);
        if (hostSystem == null) {
            logger.error("getClusterForHost() - HostSystem for host {} is null", (Object)string);
            return null;
        }
        return this.services.getClusterUtils().getClusterForHost(hostSystem);
    }

    private String buildRetreatModeString(String string) {
        return String.format("config.vcls.clusters.%s.enabled", string);
    }

    private void disableHA() {
        logger.debug("disableHA() - start");
        if (this.virtualConfigManager.getDisableHAOnShutdown()) {
            if (this.isAdvancedMode && this.theState.hasHABeenDisabled()) {
                logger.debug("disableHA() - HA has already been disabled, skipping step");
                return;
            }
            if (this.theState.isDisablingHAInProgress()) {
                this.waitForHaHandlingThread();
                return;
            }
            try {
                this.theState.setDisablingHAInProgress();
            }
            catch (IllegalStateException illegalStateException) {
                this.waitForHaHandlingThread();
                return;
            }
            this.handleAutoStart();
            ClusterComputeResource clusterComputeResource = this.getCluster();
            if (clusterComputeResource == null) {
                logger.error("disableHA() - ClusterComputeResource is null");
                this.logToEventLog(UNABLE_TO_DISABLE_HA);
                this.theState.clearDisablingHAInProgress();
                return;
            }
            if (this.vmwareConnection.isVCenterOffline() || !this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                logger.error("disableHA() - vCSA connection not successful");
                this.logToEventLog(UNABLE_TO_DISABLE_HA);
                this.theState.clearDisablingHAInProgress();
                return;
            }
            logger.debug("disableHA() - Disabling HA");
            DasSettings dasSettings = new DasSettings(this.services);
            try {
                if (dasSettings.isHAEnabled(clusterComputeResource)) {
                    this.logToEventLog(DISABLING_HA_LOG);
                    dasSettings.disableHA(clusterComputeResource);
                    this.virtualisationStatusStore.setHaDisabled(true);
                    this.theState.setHasHABeenDisabled();
                } else {
                    logger.debug("disableHA() - HA is not enabled, skipping disabling HA");
                }
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("disableHA() - RuntimeFault {}", (Throwable)runtimeFault);
                this.logToEventLog(UNABLE_TO_DISABLE_HA);
            }
            catch (InterruptedException interruptedException) {
                logger.error("disableHA() - InterruptedException {}", (Throwable)interruptedException);
                this.logToEventLog(UNABLE_TO_DISABLE_HA);
            }
            catch (Exception exception) {
                logger.error("disableHA() - Exception {}", (Throwable)exception);
                this.logToEventLog(UNABLE_TO_DISABLE_HA);
            }
            this.theState.clearDisablingHAInProgress();
        } else {
            logger.debug("disableHA() - HA configured not to be disabled");
        }
        logger.debug("disableHA() - end");
    }

    protected void enableHA() {
        logger.debug("enableHA() - start");
        if (this.theState.isEnablingHAInProgress()) {
            logger.debug("enableHA() - enbling HA is already in progress in another thread.");
            return;
        }
        if (this.virtualisationStatusStore.isHaDisabled()) {
            if (!this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                logger.debug("enableHA() - vCSA connection not successful");
                return;
            }
            ClusterComputeResource clusterComputeResource = this.getCluster();
            if (clusterComputeResource == null) {
                logger.error("enableHA() - ClusterComputeResource is null");
                this.logToEventLog(UNABLE_TO_ENABLE_HA);
                return;
            }
            logger.debug("enableHA() - Enabling HA");
            DasSettings dasSettings = new DasSettings(this.services);
            try {
                this.theState.setEnablingHAInProgress();
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("enableHA() - enbling HA just started on different thread, skipping it in this one");
                return;
            }
            try {
                this.logToEventLog(ENABLING_HA_LOG);
                dasSettings.enableHA(clusterComputeResource);
                this.virtualisationStatusStore.clearHA();
                this.theState.clearHasHABeenDisabled();
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("enableHA() - RuntimeFault {}", (Throwable)runtimeFault);
                this.logToEventLog(UNABLE_TO_ENABLE_HA);
            }
            catch (InterruptedException interruptedException) {
                logger.error("enableHA() - InterruptedException {}", (Throwable)interruptedException);
                this.logToEventLog(UNABLE_TO_ENABLE_HA);
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                logger.error("enableHA() - Exception {}", (Throwable)exception);
                this.logToEventLog(UNABLE_TO_ENABLE_HA);
            }
        } else {
            logger.debug("enableHA() - HA not disabled, not enabling it.");
        }
        this.theState.clearEnablingHAInProgress();
        logger.debug("enableHA() - end");
    }

    protected void enableVCLS() {
        logger.debug("enableVCLS() - start");
        if (this.theState.isEnablingVCLSInProgress()) {
            logger.debug("enableVCLS() - enbling vCLS is already in progress in another thread.");
            return;
        }
        if (this.virtualisationStatusStore.isVclsDisabled()) {
            if (!this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                logger.debug("enableVCLS() - vCSA connection not successful");
                this.logToEventLog(ENABLE_VCLS_CONNECTION_FAILED);
                return;
            }
            logger.debug("enableVCLS() - vCLS is disabled, trying to enable it now");
            try {
                this.theState.setEnablingVCLSInProgress();
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("enableVCLS() - enbling vCLS just started on different thread, skipping it in this one");
                return;
            }
            try {
                this.logToEventLog(ENABLING_VCLS_LOG);
                boolean bl = this.toggleRetreatMode(false);
                if (!bl) {
                    logger.debug("enableVCLS() - Unable to enable vCLS");
                    this.logToEventLog(UNABLE_TO_ENABLE_VCLS);
                    this.theState.clearEnablingVCLSInProgress();
                    return;
                }
                this.virtualisationStatusStore.clearVclsDisabled();
                this.theState.clearHasVCLSBeenDisabled();
                this.theState.clearShutdownVclsVms();
                int n = this.virtualConfigManager.getEnableVClsDelay();
                logger.debug("enableVCLS() - Start vCLS  with {} seconds", (Object)n);
                CountdownTimer countdownTimer = new CountdownTimer(n);
                countdownTimer.sleep();
            }
            catch (RemoteException remoteException) {
                logger.debug("enableVCLS() - RemoteException {}", (Throwable)remoteException);
                this.logToEventLog(UNABLE_TO_ENABLE_VCLS);
            }
        }
        this.theState.clearEnablingVCLSInProgress();
        logger.debug("enableVCLS() - end");
    }

    @Override
    public void enterMaintenanceMode() {
        logger.debug("enterMaintenanceMode() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("enterMaintenanceMode() - virtualHostsToShutdown is null or empty");
            return;
        }
        if (this.isSkipMaintenanceModeEnabled) {
            logger.debug("enterMaintenanceMode() - skip Maintenance Mode is enabled");
            return;
        }
        int n = 0;
        String string2 = null;
        String object = null;
        Semaphore semaphore = new Semaphore(0);
        boolean bl = false;
        logger.info("enterMaintenanceMode() - checking if any critical hosts have Delay Maintenance Mode enabled");
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(this.virtualHostsToShutdown.size());
            Set<String> set = this.virtualHostsToShutdown.stream().filter(string -> this.isHostSuitableForMaintenanceMode((String)string)).collect(Collectors.toSet());
            List<String> list = this.reorderHostSet(set);
            for (String object2 : list) {
                if (object2 == null) continue;
                logger.info("enterMaintenanceMode() - checking host: {}", (Object)object2);
                if (!this.isHostSuitableForMaintenanceMode(object2)) {
                    logger.info("enterMaintenanceMode() - skipping host: {} at this point", (Object)object2);
                    continue;
                }
                if (this.isVsanWitnessHost(object2)) {
                    string2 = object2;
                    logger.info("enterMaintenanceMode() - skipping vSAN Witness host: {} at this point", (Object)object2);
                    continue;
                }
                logger.debug("enterMaintenanceMode() - check vSanManagementHost: {}", (Object)this.vSanManagementHost);
                if (this.vSanManagementHost != null && this.vSanManagementHost.equals(object2)) {
                    object = object2;
                    logger.info("enterMaintenanceMode() - skipping vSAN Management host: {} at this point", (Object)object2);
                    continue;
                }
                if (this.matchedPCNSHostName != null && this.matchedPCNSHostName.equals(object2)) {
                    logger.info("enterMaintenanceMode() - skipping PCNS host: {} at this point", (Object)object2);
                    continue;
                }
                boolean bl2 = this.isDelayMaintenanceModeEnabled(object2);
                if (!bl2) {
                    logger.debug("enterMaintenanceMode() - delay Maintenance Mode not enabled for host: {}", (Object)object2);
                    continue;
                }
                logger.info("enterMaintenanceMode() - delay Maintenance Mode enabled for host: {}", (Object)object2);
                int n2 = this.getDelayMaintenanceModeTimeout(object2);
                HostShutdownRunnable hostShutdownRunnable = new HostShutdownRunnable(object2, this.theState, this.ups_setup_idx, this.services);
                hostShutdownRunnable.setVsanHost(this.isVsanHost(object2));
                hostShutdownRunnable.setVirtualHostsShutdownEnabled(this.isVirtualHostsShutdownEnabled);
                hostShutdownRunnable.setDelayMaintenanceModeTimeout(n2);
                hostShutdownRunnable.setSemaphore(semaphore);
                if (!this.theState.isVcsaHostShutdown() && this.isVcsaHost(object2)) {
                    hostShutdownRunnable.setVcsaHost(true);
                    bl = true;
                }
                logger.info("enterMaintenanceMode() - delay Maintenance Mode shutting down host: {}", (Object)object2);
                executorService.execute(hostShutdownRunnable);
                ++n;
                logger.debug("enterMaintenanceMode() - delaying: {} seconds", (Object)n2);
                new CountdownTimer(n2).sleep();
            }
            logger.debug("enterMaintenanceMode() - normal hosts shutdown started");
            if (n > 0) {
                try {
                    logger.info("enterMaintenanceMode() - waiting for:{} Host Shutdown thread(s) to complete", (Object)n);
                    semaphore.acquire(n);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("enterMaintenanceMode() - semaphore.acquire InterruptedException: ", (Throwable)interruptedException);
                }
                logger.info("enterMaintenanceMode() - Host Shutdown has completed");
            } else {
                logger.debug("enterMaintenanceMode() - no shutdowns in progress");
            }
            if (string2 != null) {
                logger.debug("enterMaintenanceMode() - checking if Witness Host needs to be shut down");
                int n3 = this.getDelayMaintenanceModeTimeout(string2);
                logger.debug("enterMaintenanceMode() - Start maintenance mode timer with {} seconds", (Object)n3);
                CountdownTimer countdownTimer = new CountdownTimer(n3);
                if (this.putHostIntoMaintenanceModeAndShutdown(string2, false)) {
                    this.setWitnessHostVmProperties();
                }
                logger.debug("enterMaintenanceMode() - Awaiting maintenance mode timer...", (Object)n3);
                countdownTimer.sleep();
                logger.debug("enterMaintenanceMode() - Maintenance mode timer complete.", (Object)n3);
            }
            if (object != null) {
                logger.debug("enterMaintenanceMode() - Management Host needs to be shut down {}", object);
                bl = !this.theState.isVcsaHostShutdown() && this.isVcsaHost(object);
                this.putHostIntoMaintenanceModeAndShutdown(object, bl);
            }
            if (bl) {
                this.clearStateVcsaSettings();
            }
        }
        catch (Exception exception) {
            logger.error("enterMaintenanceMode() - Exception: ", (Throwable)exception);
        }
        logger.debug("enterMaintenanceMode() - end");
    }

    public boolean isHostSuitableForMaintenanceMode(String string) {
        return true;
    }

    private boolean putHostIntoMaintenanceModeAndShutdown(String string, boolean bl) {
        logger.info("putHostIntoMaintenanceModeAndShutdown() - start, host: {}", (Object)string);
        int n = this.getDelayMaintenanceModeTimeout(string);
        boolean bl2 = false;
        try {
            HostShutdownRunnable hostShutdownRunnable = new HostShutdownRunnable(string, this.theState, this.ups_setup_idx, this.services);
            hostShutdownRunnable.setDelayMaintenanceModeTimeout(n);
            hostShutdownRunnable.setVcsaHost(bl);
            hostShutdownRunnable.run();
            bl2 = hostShutdownRunnable.isShutdownResult();
        }
        catch (Exception exception) {
            logger.error("putHostIntoMaintenanceModeAndShutdown() - Exception: ", (Throwable)exception);
        }
        return bl2;
    }

    public List<String> reorderHostSet(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = set.stream().filter(string -> this.isVsanHost((String)string)).collect(Collectors.toList());
        logger.debug("reorderHostSet() - vSan Hosts: {}", list);
        arrayList.addAll(list.stream().filter(string -> !arrayList.contains(string)).collect(Collectors.toList()));
        List list2 = set.stream().filter(string -> this.isVsanWitnessHost((String)string)).collect(Collectors.toList());
        logger.debug("reorderHostSet() - vSan Witness Hosts: {}", list2);
        arrayList.addAll(list2.stream().filter(string -> !arrayList.contains(string)).collect(Collectors.toList()));
        List list3 = set.stream().filter(string -> !this.isVsanHost((String)string)).collect(Collectors.toList());
        logger.debug("reorderHostSet() - Non-vSan Hosts: {}", list3);
        arrayList.addAll(list3.stream().filter(string -> !arrayList.contains(string)).collect(Collectors.toList()));
        ServiceInstance serviceInstance = null;
        if (this.vmwareConnection.validateServiceInstance()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        } else {
            logger.debug("reorderHostSet() - no vcenter service instance, trying ESXi host service instance");
            serviceInstance = this.vmwareConnection.getESXiHostInstance(this.theState.getHostWherePCNSInstalled());
        }
        if (serviceInstance != null) {
            HostSystem hostSystem = this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(serviceInstance);
            if (hostSystem != null) {
                String string2 = hostSystem.getName();
                logger.debug("reorderHostSet() - PCNS found on host {}", (Object)string2);
                for (String string3 : set) {
                    if (!this.hostSystemUtils.isPCNSHost(serviceInstance, string3, hostSystem)) continue;
                    this.matchedPCNSHostName = string3;
                    logger.debug("reorderHostSet() - PCNS host {} matched critical host {}", (Object)string2, (Object)string3);
                    break;
                }
                if (this.matchedPCNSHostName != null) {
                    logger.debug("reorderHostSet() - moving PCNS host {} to last position", (Object)this.matchedPCNSHostName);
                    arrayList.remove(this.matchedPCNSHostName);
                    arrayList.add(this.matchedPCNSHostName);
                }
            }
        } else {
            logger.error("reorderHostSet() - unable to retrieve any service instance to check PCNS host!");
        }
        logger.debug("reorderHostSet() - Result host order: {}", arrayList);
        return arrayList;
    }

    protected boolean isVsanHost(String string) {
        boolean bl;
        if (this.criticalVsanHostMap.size() == 0) {
            return false;
        }
        boolean bl2 = bl = this.criticalVsanHostMap.containsKey(string) && !this.criticalVsanHostMap.get(string).isWitness();
        if (bl) {
            logger.debug("isVsanHost() - detected vSAN host: {}", (Object)string);
        }
        return bl;
    }

    protected boolean isVsanWitnessHost(String string) {
        boolean bl;
        if (this.criticalVsanHostMap.size() == 0) {
            return false;
        }
        boolean bl2 = bl = this.criticalVsanHostMap.containsKey(string) && this.criticalVsanHostMap.get(string).isWitness();
        if (bl) {
            logger.debug("isVsanWitnessHost() - detected vSAN Witness host: {}", (Object)string);
        }
        return bl;
    }

    @Override
    public void hostShutdown() {
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("hostShutdown() - virtualHostsToShutdown is null or empty");
            return;
        }
        try {
            for (String string : this.virtualHostsToShutdown) {
                if (string == null) continue;
                logger.debug("hostShutdown() - checking host: {}", (Object)string);
                if (!this.isHostSuitableForShutdown(string)) {
                    logger.debug("hostShutdown() - skipping shutdown of host: {} for this host type", (Object)string);
                    continue;
                }
                if (!this.isSkipMaintenanceModeEnabled && this.isDelayMaintenanceModeEnabled(string)) {
                    logger.debug("hostShutdown() - skipping shutdown of host: {} as Delay Maintenance Mode is enabled", (Object)string);
                    continue;
                }
                HostSystem hostSystem = this.getHostSystemForHost(string);
                if (this.shutdownHost(hostSystem, string) || this.services.getShutdownLogger().findAndRemoveLogsByHostname(string)) continue;
                this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(string);
            }
        }
        catch (Exception exception) {
            logger.error("hostShutdown() - Exception: ", (Throwable)exception);
        }
    }

    private HostSystem getHostSystemForHost(String string) {
        ServiceInstance serviceInstance = this.getVCenterServiceInstance();
        HostSystem hostSystem = null;
        hostSystem = serviceInstance == null || this.hostSystemUtils.isVCenterServerInstalledOnTargetHost() ? this.getHostSystemFromConnectionToHost(serviceInstance, string) : this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
        if (hostSystem == null) {
            logger.error("getHostSystemForHost() - unable to get HostSystem for host: {}", (Object)string);
        }
        return hostSystem;
    }

    private boolean shutdownHost(HostSystem hostSystem, String string) {
        boolean bl = true;
        if (hostSystem == null) {
            return false;
        }
        if (this.isPCNSHost(hostSystem) || !this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
            return true;
        }
        if (!this.isSkipMaintenanceModeEnabled && !this.isDelayMaintenanceModeEnabled(string)) {
            boolean bl2 = false;
            logger.debug("shutdownHost() - looking up map for host: {}", (Object)string);
            VirtualizationShutdownHost virtualizationShutdownHost = this.utilMap.get(string);
            if (virtualizationShutdownHost != null) {
                bl2 = virtualizationShutdownHost.checkMaintenanceModeResult();
            } else {
                logger.debug("shutdownHost() - host: {} not found in map", (Object)string);
            }
            if (bl2) {
                this.verifyHostInMaintenanceMode(hostSystem, string);
            }
        } else {
            logger.debug("shutdownHost() - skip or delay Maintenance Mode is enabled");
        }
        if (this.checkIfVCSAHostShutdown(hostSystem)) {
            logger.debug("shutdownHost() - VCSA installed on this host, performing VCSA host shutdown instead");
            this.startVCSAHostShutdown();
            return true;
        }
        this.services.getVirtualLoggingUtils().logTargetHostShutdownEvent(string);
        if (!this.triggerShutdownHost(hostSystem, string)) {
            logger.error("shutdownHost() - failed to shut down host: {}", (Object)string);
            bl = false;
        }
        return bl;
    }

    public boolean isHostSuitableForShutdown(String string) {
        return true;
    }

    protected ServiceInstance getVCenterServiceInstance() {
        ServiceInstance serviceInstance = null;
        if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        }
        return serviceInstance;
    }

    private HostSystem getHostSystemFromConnectionToHost(ServiceInstance serviceInstance, String string) {
        logger.debug("getHostSystemFromConnectionToHost() - start");
        HostSystem hostSystem = null;
        String string2 = null;
        try {
            string2 = this.hostSystemUtils.getESXIConnStr(serviceInstance, string);
            if (this.theState.getIPForESXiHost(string) != null) {
                string2 = this.theState.getIPForESXiHost(string);
            }
            serviceInstance = this.vmwareConnection.getESXiHostInstance(string2, true);
        }
        catch (Exception exception) {
            logger.error("getHostSystemFromConnectionToHost() - cannot obtain ESXiHostInstance with host connection str: " + string2, (Throwable)exception);
        }
        if (serviceInstance != null) {
            hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string2);
            if (hostSystem == null) {
                logger.error("getHostSystemFromConnectionToHost() - unable to get HostSystem for host: {}", (Object)string2);
            } else {
                logger.debug("getHostSystemFromConnectionToHost() - got HostSystem for host: {}", (Object)string2);
            }
        } else {
            logger.error("getHostSystemFromConnectionToHost() - unable to establish a connection to the host");
        }
        return hostSystem;
    }

    @Override
    public void pcnsHostShutdown() {
        logger.debug("pcnsHostShutdown() - start");
        if (this.virtualConfigManager.isPCNSInstalledOnVMA()) {
            this.startPCNSShutdown();
        }
        this.virtualHostsToShutdown.forEach(string -> this.theState.clearIPForESXiHost((String)string));
        logger.debug("pcnsHostShutdown() - end");
    }

    @Override
    public void pcnsOSShutdown() {
        logger.debug("pcnsOSShutdown() - start");
        if (!this.virtualConfigManager.isPCNSInstalledOnVMA()) {
            super.pcnsOSShutdown();
        }
        for (String string : this.virtualHostsToShutdown) {
            logger.debug("pcnsOSShutdown() - before waitForCriticalHostToPowerOffCompletely, host: {}", (Object)string);
            this.waitForCriticalHostToPowerOffCompletely(string);
            logger.debug("pcnsOSShutdown() - after waitForCriticalHostToPowerOffCompletely");
            this.virtualisationStatusStore.unlockHostForShutdown(string);
            logger.debug("pcnsOSShutdown() - after unlockHostForShutdown");
        }
        this.theState.setVCSAStartupReattempt(true);
        logger.debug("pcnsOSShutdown() - end");
    }

    private boolean isVcenterToolsAvailable(ServiceInstance serviceInstance) {
        VirtualMachine virtualMachine;
        boolean bl = true;
        if (serviceInstance != null && this.isVCSA && (virtualMachine = this.hostSystemUtils.getVirtualMachineUsingUUID(serviceInstance, this.theState.getVCenterVMUUID())) != null && !virtualMachine.getGuest().getToolsRunningStatus().equalsIgnoreCase(VirtualMachineToolsRunningStatus.guestToolsRunning.toString())) {
            bl = false;
        }
        logger.debug("isVcenterToolsAvailable() - result: {}", (Object)bl);
        return bl;
    }

    protected boolean isVcsaHostCritical(Set<String> set) {
        boolean bl = false;
        logger.debug("isVcsaHostCritical() - start");
        try {
            if (set == null) {
                logger.debug("isVcsaHostCritical() - hosts is null");
                return false;
            }
            for (String string : set) {
                if (string == null) continue;
                logger.debug("isVcsaHostCritical() - host: {}", (Object)string);
                String string2 = null;
                ServiceInstance serviceInstance = this.getVCenterServiceInstance();
                boolean bl2 = this.isVcenterToolsAvailable(serviceInstance);
                if (serviceInstance == null || !bl2 || this.hostSystemUtils.isVCenterServerInstalledOnTargetHost()) {
                    logger.debug("isVcsaHostCritical() - using ESXi for serviceInstance");
                    try {
                        if (serviceInstance != null && !IPUtils.isValidIPAddress(string) && !this.virtualConfigManager.isHostnameResolvable(string)) {
                            logger.debug("isVcsaHostCritical() - critical host name: {} cannot be resolved; trying getIPAddressFromHostname", (Object)string);
                            string2 = this.hostSystemUtils.getIPAddressFromHostname(serviceInstance, string);
                            logger.debug("isVcsaHostCritical() - getIPAddressFromHostname returns: {} for critical host: {}", (Object)string2, (Object)string);
                            if (string2 != null) {
                                serviceInstance = this.vmwareConnection.getESXiHostInstance(string2);
                            }
                        }
                        if (string2 == null) {
                            serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("isVcsaHostCritical() - cannot obtain ESXi service instance", (Throwable)exception);
                    }
                }
                HostSystem hostSystem = null;
                hostSystem = string2 != null ? this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string2) : this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
                if (hostSystem != null) {
                    logger.debug("isVcsaHostCritical() - hostSystem != null");
                    String string3 = this.theState.getVCenterVMUUID();
                    HostSystem hostSystem2 = this.hostSystemUtils.getHostSystemUsingVMUUID(serviceInstance, string3);
                    if (hostSystem2 == null || !hostSystem2.getName().equalsIgnoreCase(hostSystem.getName())) continue;
                    VirtualMachine virtualMachine = this.hostSystemUtils.getVirtualMachineUsingUUID(serviceInstance, string3);
                    logger.debug("isVcsaHostCritical() - setting vCSA VM: {}", (Object)virtualMachine);
                    this.theState.setVCSAVM(virtualMachine);
                    logger.debug("isVcsaHostCritical() - setting vCenterHost: {}", (Object)hostSystem2);
                    this.theState.setVCSAHost(hostSystem2);
                    this.vcsaHostName = string;
                    if (string2 != null) {
                        this.vcsaHostIP = string2;
                        logger.debug("isVcsaHostCritical() - setting vCSAHostIp: {}", (Object)this.vcsaHostIP);
                    }
                    bl = true;
                    break;
                }
                logger.error("isVcsaHostCritical() - cannot obtain HostSystem using findByIP or findByDnsName for critical host: {}", (Object)string);
            }
        }
        catch (Exception exception) {
            logger.error("isVcsaHostCritical() - Exception: ", (Throwable)exception);
        }
        logger.debug("isVcsaHostCritical() - result: {}", (Object)bl);
        return bl;
    }

    private boolean isPCNSHost(@NonNull HostSystem hostSystem) {
        if (hostSystem == null) {
            throw new IllegalArgumentException("hostSystem is marked non-null but is null");
        }
        boolean bl = false;
        try {
            String string = this.theState.getHostWherePCNSInstalled();
            if (string != null && (string.equalsIgnoreCase(hostSystem.getName()) || this.hostSystemUtils.isESXiHostIPAddress(string, hostSystem))) {
                logger.info("checkIfHostShutdownValid() - not valid for shutdown, PCNS is installed on this host");
                return true;
            }
            logger.debug("checkIfHostShutdownValid() - shutdown valid for Host: {}", (Object)hostSystem.getName());
        }
        catch (Exception exception) {
            logger.error("checkIfHostShutdownValid() - Exception: ", (Throwable)exception);
        }
        return bl;
    }

    private boolean checkIfVCSAHostShutdown(HostSystem hostSystem) {
        logger.debug("checkIfVCSAHostShutdown() - start");
        try {
            if (hostSystem == null) {
                logger.info("checkIfVCSAHostShutdown() - hostSystem is null");
                return false;
            }
            String string = hostSystem.getName();
            logger.debug("checkIfVCSAHostShutdown() - comparing vCSA host with host {}", (Object)string);
            if (!this.theState.isVcsaHostShutdown() && this.theState.getVCSAHost() != null && this.theState.getVCSAHost().getName() != null && this.theState.getVCSAHost().getName().equalsIgnoreCase(string)) {
                logger.info("checkIfVCSAHostShutdown() - vCSA is installed on this host {} (vCSA host: {})", (Object)string, (Object)this.theState.getVCSAHost().getName());
                return true;
            }
        }
        catch (Exception exception) {
            logger.error("checkIfVCSAHostShutdown() - Exception: ", (Throwable)exception);
        }
        logger.debug("checkIfVCSAHostShutdown() - end, not the vCSA host");
        return false;
    }

    protected ServiceInstance getESXiServiceInstanceConnection(String string) {
        ServiceInstance serviceInstance = null;
        try {
            serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
        }
        catch (Exception exception) {
            logger.error("getESXiServiceInstanceConnection() - cannot obtain ESXi service instance", (Throwable)exception);
        }
        return serviceInstance;
    }

    private void shutdownVirtualizationFeatures(Set<String> set, int n, boolean bl) {
        try {
            logger.debug("shutdownVirtualizationFeatures() - start hosts: {}", set);
            if (set == null) {
                return;
            }
            ServiceInstance serviceInstance = null;
            for (String string : set) {
                if (bl) {
                    logger.debug("shutdownVirtualizationFeatures() - kick off VM features for non-critical host: {}", (Object)string);
                } else {
                    logger.debug("shutdownVirtualizationFeatures() - kick off VM features for critical host: {}", (Object)string);
                }
                if (this.vmwareConnection.validateServiceInstance()) {
                    serviceInstance = this.vmwareConnection.getVCenterConnection();
                } else {
                    logger.debug("shutdownVirtualizationFeatures() - trying ESXi service instance for host: {}", (Object)string);
                    serviceInstance = this.getESXiServiceInstanceConnection(string);
                }
                HostSystem hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
                if (hostSystem == null) {
                    logger.debug("shutdownVirtualizationFeatures() - hostSystem is null; trying ESXi service instance for host: {}", (Object)string);
                    serviceInstance = this.getESXiServiceInstanceConnection(string);
                    hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
                }
                if (hostSystem == null) {
                    logger.error("shutdownVirtualizationFeatures() - hostSystem is null");
                    continue;
                }
                this.executeShutdownVirtFeatures(serviceInstance, hostSystem, set, n, string, bl);
            }
        }
        catch (Exception exception) {
            logger.error("shutdownVirtualizationFeatures() - Exception: ", (Throwable)exception);
        }
        logger.debug("shutdownVirtualizationFeatures() - end hosts: {}", set);
    }

    private void executeShutdownVirtFeatures(ServiceInstance serviceInstance, HostSystem hostSystem, Set<String> set, int n, String string, boolean bl) {
        logger.debug("executeShutdownVirtFeatures() - start");
        if (!bl && serviceInstance.getAboutInfo().getApiType().equalsIgnoreCase("VirtualCenter")) {
            CreateVCenterAlarm.getInstance().createUPSCriticalEvent(hostSystem.getName(), "warning");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        VirtualizationShutdownHost virtualizationShutdownHost = new VirtualizationShutdownHost(this.theState, hostSystem, serviceInstance, n, set, string, this.services);
        virtualizationShutdownHost.setVsanNonCriticalHost(bl);
        virtualizationShutdownHost.setVsanWitnessHostIp(this.vSanWitnessHostIp);
        virtualizationShutdownHost.setVsanDatastoreName(this.vSanDatastoreName);
        virtualizationShutdownHost.setHostType(this);
        Future<?> future = executorService.submit(virtualizationShutdownHost);
        this.futures.add(future);
        executorService.shutdown();
        logger.debug("executeShutdownVirtFeatures() - storing reference for host: {}", (Object)string);
        this.utilMap.put(string, virtualizationShutdownHost);
        logger.debug("executeShutdownVirtFeatures() - end");
    }

    protected void waitForShutdownVirtualizationFeaturesToComplete() {
        logger.debug("waitForShutdownVirtualizationFeaturesToComplete() - start");
        try {
            Object[] objectArray = this.futures.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Future)) continue;
                try {
                    ((Future)objectArray[i]).get();
                    continue;
                }
                catch (ExecutionException executionException) {
                    logger.error("waitForShutdownVirtualizationFeaturesToComplete() - ExecutionException: ", (Throwable)executionException);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.error("waitForShutdownVirtualizationFeaturesToComplete() - InterruptedException: ", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception exception) {
            logger.error("waitForShutdownVirtualizationFeaturesToComplete() - Exception: ", (Throwable)exception);
        }
        logger.debug("waitForShutdownVirtualizationFeaturesToComplete() - end");
    }

    protected void startPCNSShutdown() {
        logger.debug("startPCNSShutdown() - start");
        try {
            ServiceInstance serviceInstance = this.getVCenterServiceInstance();
            if (serviceInstance == null) {
                serviceInstance = this.vmwareConnection.getESXiHostInstance(this.theState.getHostWherePCNSInstalled());
            }
            this.theState.setHostSystemPCNSInstalled(this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(serviceInstance));
            HostSystem hostSystem = this.theState.getHostSystemPCNSInstalled();
            if (hostSystem != null) {
                String string = hostSystem.getName();
                String string2 = null;
                if (this.virtualHostsToShutdown != null) {
                    String string3 = this.hostSystemUtils.getESXiHostIPAddress(hostSystem);
                    HashMap<String, HostSystem> hashMap = new HashMap<String, HostSystem>();
                    for (String string4 : this.virtualHostsToShutdown) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)string4, (CharSequence)string) || StringUtils.equalsIgnoreCase((CharSequence)string4, (CharSequence)string3)) {
                            string2 = string4;
                            break;
                        }
                        HostSystem hostSystem2 = this.hostSystemUtils.getHostSystem(string4);
                        if (hostSystem2 == null) continue;
                        hashMap.put(string4, hostSystem2);
                    }
                    if (string2 == null) {
                        logger.debug("startPCNSShutdown() - unable to find PCNS host, checking host systems");
                        string2 = this.hostSystemUtils.getPCNSHostFromHostSystems(hashMap, string3);
                    }
                }
                if (string2 != null) {
                    if (this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                        this.services.getVirtualLoggingUtils().logTargetHostShutdownEvent(string);
                        if (!this.triggerShutdownHost(hostSystem, string2)) {
                            logger.error("startPCNSShutdown() - failed to shut down host: {}", string2);
                            this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(string2);
                        }
                    }
                    this.theState.setHostWherePCNSInstalled(null);
                    this.theState.setHostSystemPCNSInstalled(null);
                } else {
                    logger.debug("startPCNSShutdown() - PCNS host {} did not match any critical hosts", (Object)string);
                }
            }
        }
        catch (Exception exception) {
            logger.error("startPCNSShutdown() - Exception: ", (Throwable)exception);
        }
        logger.debug("startPCNSShutdown() - end");
    }

    protected void waitForCriticalHostToPowerOffCompletely(String string) {
        try {
            HostSystem hostSystem;
            boolean bl = true;
            ServiceInstance serviceInstance = this.getVCenterServiceInstance();
            if (serviceInstance == null) {
                serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
                bl = false;
            }
            if (serviceInstance != null && (hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string)) != null) {
                if (bl && !this.isVCenterPartOfCriticalHosts(serviceInstance)) {
                    if (this.hostSystemUtils.isHostShutdownTriggered(serviceInstance, hostSystem)) {
                        logger.debug("waitForCriticalHostToPowerOffCompletely() - before host poweredOn/disconnected state wait");
                        while (hostSystem.getRuntime() != null && hostSystem.getRuntime().getPowerState() == HostSystemPowerState.poweredOff && hostSystem.getRuntime().getConnectionState() == HostSystemConnectionState.connected) {
                            logger.debug("waitForCriticalHostToPowerOffCompletely() - waiting for host poweredOn/disconnected state");
                            Thread.sleep(1000L);
                        }
                        logger.debug("waitForCriticalHostToPowerOffCompletely() - after host poweredOn/disconnected state wait");
                    }
                } else if (this.hostSystemUtils.isHostShutdownTriggered(serviceInstance, hostSystem)) {
                    logger.debug("waitForCriticalHostToPowerOffCompletely() - before host poweredOff state wait");
                    while (this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                        logger.debug("waitForCriticalHostToPowerOffCompletely() - waiting for host poweredOff state");
                        Thread.sleep(1000L);
                    }
                    logger.debug("waitForCriticalHostToPowerOffCompletely() - after host poweredOff state wait");
                }
            }
        }
        catch (Exception exception) {
            logger.error("waitForCriticalHostToPowerOffCompletely() - Exception: ", (Throwable)exception);
        }
    }

    protected boolean isVCenterPartOfCriticalHosts(ServiceInstance serviceInstance) {
        boolean bl = false;
        if (!this.isAdvancedMode) {
            if (this.hostSystemUtils.isVCenterServerInstalledOnTargetHost()) {
                bl = true;
            }
        } else if (this.hostSystemUtils.isVCenterServerInstalledOnCriticalHost(this.virtualHostsToShutdown, serviceInstance)) {
            bl = true;
        }
        logger.debug("isVCenterPartOfCriticalHosts() - returns:{}", (Object)bl);
        return bl;
    }

    private void startVCSAHostShutdown() {
        logger.debug("startVCSAHostShutdown() - start");
        try {
            if (this.hostSystemUtils.checkIfHostIsPoweredOn(this.theState.getVCSAHost())) {
                this.performVCSAHostShutdown(this.theState.getVCSAHost());
            }
        }
        catch (Exception exception) {
            logger.error("startVCSAHostShutdown() - Exception: ", (Throwable)exception);
        }
        finally {
            this.clearStateVcsaSettings();
        }
        logger.debug("startVCSAHostShutdown() - end");
    }

    private void clearStateVcsaSettings() {
        logger.debug("clearStateVcsaSettings() - clearing vCSA settings from state");
        this.theState.clearVCenterVMUUID();
        this.theState.clearVCSAHost();
        this.theState.clearVCSAVM();
    }

    private void performVCSAVMShutdown() {
        try {
            logger.debug("performVCSAVMShutdown() - start");
            VirtualMachine virtualMachine = this.theState.getVCSAVM();
            if (virtualMachine == null) {
                logger.debug("performVCSAVMShutdown() - vCSAVM is null");
                return;
            }
            if (virtualMachine.getRuntime() != null && virtualMachine.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn && !virtualMachine.getGuest().getGuestState().equalsIgnoreCase(VirtualMachineGuestState.shuttingDown.toString())) {
                logger.debug("performVCSAVMShutdown() - ready to perform VCSA VM shutdown");
                this.vmwareConnection.setVCenterOffline(true);
                long l = this.virtualConfigManager.getActualVCSAVMShutdownDuration();
                this.services.getVirtualLoggingUtils().logVCSAVMShutdownEvent(virtualMachine.getName());
                CountdownTimer countdownTimer = new CountdownTimer(l, TimeUnit.SECONDS);
                String string = virtualMachine.getName();
                if (virtualMachine.getGuest().getToolsRunningStatus().equalsIgnoreCase(VirtualMachineToolsRunningStatus.guestToolsRunning.toString())) {
                    String string2 = this.hostSystemUtils.getVCSAHost();
                    logger.debug("performVCSAVMShutdown() - Found current VCSA Host Name as: {}", (Object)string2);
                    if (string2 != null) {
                        if (StringUtils.isEmpty((CharSequence)this.vcsaHostName)) {
                            this.vcsaHostName = string2;
                        }
                        CreateVCenterAlarm.getInstance().createUPSCriticalEvent(string2, "alert");
                    }
                    this.shutdownGuestVCSAVm(virtualMachine);
                    this.waitForVCSAVMShutdown(string, countdownTimer);
                    this.setVcsaDetailsToVirtualisationStatusStore(string);
                } else {
                    if (StringUtils.isEmpty((CharSequence)this.vcsaHostName)) {
                        this.vcsaHostName = this.theState.getVCSAHost().getName();
                    }
                    this.powerOffVCSAVm(virtualMachine);
                    this.waitForVCSAVMShutdown(string, countdownTimer);
                    this.setVcsaDetailsToVirtualisationStatusStore(string);
                }
            }
        }
        catch (Exception exception) {
            logger.error("performVCSAVMShutdown() - Exception: ", (Throwable)exception);
        }
    }

    private void waitForVCSAVMShutdown(String string, CountdownTimer countdownTimer) {
        logger.debug("waitForVCSAVMShutdown() - start");
        try {
            long l = this.virtualConfigManager.getDurationGlobal("VCSA_shutdown_duration");
            CountdownTimer countdownTimer2 = new CountdownTimer(l, TimeUnit.SECONDS);
            if (this.theState.getVCSAHost() != null) {
                String string2 = null;
                if (this.vcsaHostName != null) {
                    string2 = this.vcsaHostName;
                } else {
                    try {
                        string2 = this.theState.getVCSAHost().getName();
                    }
                    catch (Exception exception) {
                        logger.error("waitForVCSAVMShutdown() - failed to retrieve vCSA hostname, exception: ", (Throwable)exception);
                    }
                }
                boolean bl = this.isDelayMaintenanceModeEnabled(string2);
                if (!bl && !this.isSkipMaintenanceModeEnabled) {
                    this.services.getVirtualLoggingUtils().logMaintenanceModeCancelledEvent(string2);
                }
            }
            logger.debug("waitForVCSAVMShutdown() - waiting rest of VCSA VM shutdown duration before checking connection");
            countdownTimer.sleep();
            if (this.vmwareConnection.validateServiceInstance()) {
                this.services.getVirtualLoggingUtils().logVCSAVMUngracefulShutdownEvent(string);
            }
            logger.debug("waitForVCSAVMShutdown() - waiting rest of VCSA VM shutdown duration after connection check");
            countdownTimer2.sleep();
        }
        catch (Exception exception) {
            logger.error("waitForVCSAVMShutdown() - Exception: ", (Throwable)exception);
        }
        logger.debug("waitForVCSAVMShutdown() - end");
    }

    protected void setVcsaDetailsToVirtualisationStatusStore(String string) {
        logger.debug("setVcsaDetailsToVirtualisationStatusStore() - start, Vcsa VM: {}", (Object)string);
        this.virtualisationStatusStore.setProperty("VCSA_VM", string);
        logger.debug("setVcsaDetailsToVirtualisationStatusStore() - State VCSA Host: {}, Vcsa Host Name: {}, Vcsa Host IP: {}", (Object)this.theState.getVCSAHost(), (Object)this.vcsaHostName, (Object)this.vcsaHostIP);
        String string2 = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.vcsaHostIP, this.theState.getVcsaHostIp()});
        String string3 = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.vcsaHostName, this.theState.getVcsaHostName()});
        logger.debug("setVcsaDetailsToVirtualisationStatusStore() - Cached values of Vcsa Host: {}, Vcsa IP: {}", (Object)string3, (Object)string2);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            this.virtualisationStatusStore.setVcsaHost(string2, string3);
        } else if (this.theState.getVCSAHost() != null && StringUtils.isNotEmpty((CharSequence)this.vcsaHostName)) {
            if (StringUtils.isNotEmpty((CharSequence)this.vcsaHostIP)) {
                this.virtualisationStatusStore.setVcsaHost(this.vcsaHostIP, this.vcsaHostName);
            } else {
                string2 = this.hostSystemUtils.getESXiHostIPAddress(this.theState.getVCSAHost());
                this.virtualisationStatusStore.setVcsaHost(string2, this.vcsaHostName);
            }
        }
        logger.debug("setVcsaDetailsToVirtualisationStatusStore() - end");
    }

    private void shutdownGuestVCSAVm(VirtualMachine virtualMachine) {
        String string = virtualMachine.getName();
        try {
            virtualMachine.shutdownGuest();
        }
        catch (TaskInProgress taskInProgress) {
            logger.error("shutdownGuestVCSAVm() - TaskInProgress shutdownGuest VM: {}", (Object)string);
        }
        catch (InvalidState invalidState) {
            logger.error("shutdownGuestVCSAVm() - InvalidState shutdownGuest VM: {}", (Object)string);
        }
        catch (ToolsUnavailable toolsUnavailable) {
            logger.error("shutdownGuestVCSAVm() - ToolsUnavailable shutdownGuest VM: {}", (Object)string);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("shutdownGuestVCSAVm() - RuntimeFault shutdownGuest VM: {}", (Object)string);
        }
        catch (RemoteException remoteException) {
            logger.error("shutdownGuestVCSAVm() - RemoteException shutdownGuest VM: {}", (Object)string);
        }
        logger.debug("shutdownGuestVCSAVm() - shutdown VM: {}", (Object)string);
    }

    private void powerOffVCSAVm(VirtualMachine virtualMachine) {
        String string = virtualMachine.getName();
        try {
            virtualMachine.powerOffVM_Task();
        }
        catch (TaskInProgress taskInProgress) {
            logger.error("powerOffVCSAVm() - TaskInProgress powerOffVM_Task VM: {} ", (Object)string);
        }
        catch (InvalidState invalidState) {
            logger.error("powerOffVCSAVm() - InvalidState powerOffVM_Task VM: {}", (Object)string);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("powerOffVCSAVm() - RuntimeFault powerOffVM_Task VM: {}", (Object)string);
        }
        catch (RemoteException remoteException) {
            logger.error("powerOffVCSAVm() - RemoteException powerOffVM_Task VM: {}", (Object)string);
        }
        logger.debug("powerOffVCSAVm() - power off VM: {}", (Object)string);
    }

    private void performVCSAHostShutdown(HostSystem hostSystem) {
        logger.debug("performVCSAHostShutdown() - start");
        try {
            if (this.theState.getVCSAVM() != null) {
                logger.debug("performVCSAHostShutdown() - VCSAVM != null");
            }
            if (hostSystem == null) {
                logger.debug("performVCSAHostShutdown() - vCSA host is null");
                return;
            }
            String string = null;
            string = this.vcsaHostName != null ? this.vcsaHostName : hostSystem.getName();
            this.verifyHostInMaintenanceMode(hostSystem, string);
            if (!this.isPCNSAndVCSAVMOnSameHost(hostSystem)) {
                if (this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                    this.services.getVirtualLoggingUtils().logVCenterServerHostShutdownEvent(string);
                    if (!this.triggerShutdownHost(hostSystem, string)) {
                        this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(string);
                    } else {
                        this.theState.setVcsaHostShutdown(true);
                    }
                } else {
                    logger.debug("performVCSAHostShutdown() - vCSA host already shutdown");
                }
            }
        }
        catch (Exception exception) {
            logger.error("performVCSAHostShutdown() - Exception: ", (Throwable)exception);
        }
    }

    private void verifyHostInMaintenanceMode(HostSystem hostSystem, String string) {
        try {
            logger.debug("verifyHostInMaintenanceMode() - start, host: {}", (Object)string);
            if (this.isSkipMaintenanceModeEnabled) {
                logger.info("verifyHostInMaintenanceMode() - skip Maintenance Mode is enabled");
                return;
            }
            if (!this.hostSystemUtils.areAllVMsPoweredOff(hostSystem, true)) {
                logger.info("verifyHostInMaintenanceMode() - Host {} still has VMs powered on.  Skipping Maintenance Mode", (Object)string);
                return;
            }
            logger.debug("verifyHostInMaintenanceMode() - Maintenance Mode may be required");
            if (this.hostSystemUtils.checkIfHostIsInMaintenanceMode(hostSystem)) {
                logger.debug("verifyHostInMaintenanceMode() - host already in Maintenance Mode");
                this.services.getVirtualLoggingUtils().logMaintenanceModeEnteredEvent(string);
                return;
            }
            if (!this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                return;
            }
            this.services.getVirtualLoggingUtils().logMaintenanceModeEnterEvent(string);
            int n = this.virtualConfigManager.getMaintenanceModeTimeoutDuration();
            String string2 = this.hostSystemUtils.executeHostMaintenanceModeWithWait(hostSystem, n);
            if (string2 == null) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeEnteredEvent(string);
            } else {
                this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(string, string2);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.error("verifyHostInMaintenanceMode() - Exception: ", (Throwable)interruptedException);
        }
        catch (Exception exception) {
            logger.error("verifyHostInMaintenanceMode() - Exception: ", (Throwable)exception);
        }
        logger.debug("verifyHostInMaintenanceMode() - end");
    }

    private boolean isPCNSAndVCSAVMOnSameHost(HostSystem hostSystem) {
        boolean bl = false;
        try {
            HostSystem hostSystem2 = null;
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(this.hostSystemUtils.getESXiHostIPAddress(hostSystem));
            if (serviceInstance != null) {
                hostSystem2 = this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(serviceInstance);
            }
            if (hostSystem != null && hostSystem2 != null && hostSystem.getName().equalsIgnoreCase(hostSystem2.getName())) {
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error("isPCNSAndVCSAVMOnSameHost", (Throwable)exception);
        }
        return bl;
    }

    private boolean triggerShutdownHost(HostSystem hostSystem, String string) {
        if (!this.hostSystemUtils.executeHostShutdown(hostSystem, string, this.theState.getHostWherePCNSInstalled())) {
            return false;
        }
        if (this.isVsanWitnessHost(string)) {
            this.setWitnessHostVmProperties();
        }
        return true;
    }

    private void setWitnessHostVmProperties() {
        if (this.vSanWitnessHostVmName != null && this.vSanManagementHost != null) {
            this.virtualisationStatusStore.setProperty("Witness_VM", this.vSanWitnessHostVmName);
            this.virtualisationStatusStore.setProperty("Witness_VM_HOST", this.vSanManagementHost);
        } else {
            logger.debug("setWitnessHostVmProperties() - not setting Witness Host VM properties; Witness Host VM Name: {}, Management Host: {}", (Object)this.vSanWitnessHostVmName, (Object)this.vSanManagementHost);
        }
    }

    protected void getHostsOutOfMaintenanceMode(Set<String> set) {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        logger.debug("getHostsOutOfMaintenanceMode() - check Maintenance Mode for online hosts: {}", (Object)this.virtualHostsToShutdown);
        if (set == null || set.isEmpty()) {
            logger.debug("getHostsOutOfMaintenanceMode() - no hosts to take out of maintenance mode");
            return;
        }
        HostSystemUtils hostSystemUtils = this.hostSystemUtils;
        for (String string : set) {
            if (!this.virtualisationStatusStore.isHostUnlockedForShutdown(string) || this.theState.checkIfCriticalEventActive(string)) continue;
            logger.debug("getHostsOutOfMaintenanceMode() - attempting to take host: {} out of Maintenance Mode", (Object)string);
            String string2 = string;
            executorService.execute(() -> {
                if (hostSystemUtils.getOnlineHostOutOfMaintenanceMode(string2, false)) {
                    logger.debug("getHostsOutOfMaintenanceMode() - successfully taken host: {} out of Maintenance Mode", (Object)string2);
                } else {
                    logger.error("getHostsOutOfMaintenanceMode() - failed to take host: {} out of Maintenance Mode", (Object)string2);
                }
            });
        }
        executorService.shutdown();
        try {
            int n = Math.max(300, this.virtualConfigManager.getMaintenanceModeTimeoutDuration());
            if (!executorService.awaitTermination(n, TimeUnit.SECONDS)) {
                logger.debug("getHostsOutOfMaintenanceMode() - one or more tasks are stuck, trying to terminate them");
                executorService.shutdownNow();
            }
            logger.debug("getHostsOutOfMaintenanceMode() - tasks completed");
        }
        catch (InterruptedException interruptedException) {
            logger.debug("getHostsOutOfMaintenanceMode() - InterruptedException: {}", (Object)interruptedException.getMessage());
        }
        logger.debug("getHostsOutOfMaintenanceMode() - end");
    }

    protected Boolean meetPreconditions() {
        logger.debug("meetPreconditions() - start");
        boolean bl = false;
        logger.debug("meetPreconditions() - checking vSAN cluster requirements");
        bl = this.performVsanClusterRecovery();
        logger.debug("meetPreconditions() - checking VCSA requirements");
        bl = this.handleVcsaRequirement();
        logger.debug("meetPreconditions() - end, preconditions met: {}", (Object)bl);
        return bl;
    }

    public void handleAutoStart() {
        logger.debug("handleAutoStart() - start");
        if (!this.hostSystemUtils.isHostPartOfCluster(this.theState.getHostSystemPCNSInstalled())) {
            this.pcnsHostOutsideCluster = true;
            logger.info("handleAutoStart() - PCNS is on a host outside the Cluster");
        } else {
            logger.info("handleAutoStart() - PCNS is on a host inside the Cluster");
        }
        this.isVcsaHostCritical(this.virtualHostsToShutdown);
        if (!this.hostSystemUtils.isHostPartOfCluster(this.theState.getVCSAHost())) {
            this.vcsaHostOutsideCluster = true;
            logger.info("handleAutoStart() - VCSA is on a host outside the Cluster");
        } else {
            logger.info("handleAutoStart() - VCSA is on a host inside the Cluster");
        }
        ServiceInstance serviceInstance = this.getVCenterServiceInstance();
        if (serviceInstance == null) {
            logger.debug("handleAutoStart() - vCenter connection null, trying host connection");
            try {
                serviceInstance = this.vmwareConnection.getESXiHostInstance(this.virtualConfigManager.getPCNSHostIp());
            }
            catch (Exception exception) {
                logger.error("handleAutoStart() - failed to retrieve host connection. Cannot handle AutoStart policy, error: {}", (Throwable)exception);
                return;
            }
        }
        this.setAutoStartPolicy(serviceInstance, this.pcnsHostOutsideCluster, this.vcsaHostOutsideCluster);
        logger.debug("handleAutoStart() - end");
    }

    protected void setAutoStartPolicy(ServiceInstance serviceInstance, boolean bl, boolean bl2) {
        if (serviceInstance != null && (bl || bl2)) {
            logger.debug("setAutoStartPolicy() - Setting PCNS Autostart Policy.");
            this.hostSystemUtils.setAutoStartPolicy(serviceInstance);
        } else {
            logger.info("setAutoStartPolicy() - Conditions not met to set Auto Start Policy. vCSA connection: {}, PCNS outside cluster: {}, vCSA outside cluster: {}", (Object)(serviceInstance != null ? 1 : 0), (Object)bl, (Object)bl2);
        }
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup() - start");
        if (this.performESXStartup(preConditionsSynchronizer)) {
            this.doVMVAppStartupForAllHosts();
            if (!this.allVmsAndVAppsStarted()) {
                logger.debug("performStartup() - not all VMs and vApps started, not disabling retreat mode nor enabling HA");
                return;
            }
            this.handleVCLSAndHAStartup();
        }
        this.checkDrsSettings();
        logger.debug("performStartup() - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performESXStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performESXStartup() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("performESXStartup() - no hosts to start");
            return false;
        }
        logger.debug("performESXStartup() - hosts: {}", (Object)this.virtualHostsToShutdown);
        this.getHostsOutOfMaintenanceMode(this.virtualHostsToShutdown);
        this.checkWitnessHostVmStartup();
        Object object = preConditionsSynchronizer;
        synchronized (object) {
            logger.debug("performESXStartup() - check preconditions=" + preConditionsSynchronizer.arePreConditionsMet());
            if (preConditionsSynchronizer.arePreConditionsMet() == null) {
                logger.debug("performESXStartup() - run preconditions");
                preConditionsSynchronizer.setPreConditionsMet(this.meetPreconditions());
                logger.debug("performESXStartup() - run preconditions = " + preConditionsSynchronizer.arePreConditionsMet());
            }
        }
        logger.debug("performESXStartup() preconditions = " + preConditionsSynchronizer.arePreConditionsMet());
        if (!preConditionsSynchronizer.arePreConditionsMet().booleanValue()) {
            return false;
        }
        if (this.virtualConfigManager.isVsanFTTEnabled()) {
            this.vSanFttFeatures = this.vsanUtils.getVsanFaultToleranceThreshold(this.theState, this.services);
            this.vSanFttFeatures.checkGroupLockRemoval();
            if (!this.vSanFttFeatures.isFTTResolved()) {
                return false;
            }
        }
        if (((HashSet)(object = this.virtualisationStatusStore.getVMAndVAppHostList())).isEmpty()) {
            logger.debug("performESXStartup() - no VM/vApps found for startup");
            return false;
        }
        if (!this.canWePerformVMAndVAppStartup((LinkedHashSet<String>)object)) {
            logger.debug("performESXStartup() - VM/vApp startup can't be performed yet");
            return false;
        }
        logger.debug("performESXStartup() - end");
        return true;
    }

    protected void checkWitnessHostVmStartup() {
        logger.debug("checkWitnessHostVmStartup() - start");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(new VsanWitnessVMStartupRunnable(this.theState, this.services));
        executorService.shutdown();
        try {
            int n = this.virtualConfigManager.getWitnessVmStartupDuration();
            logger.debug("checkWitnessHostVm() - Witness VM startup duration: {}", (Object)n);
            if (!executorService.awaitTermination(n, TimeUnit.SECONDS)) {
                logger.warn("checkWitnessHostVm() - Witness VM startup had insufficient time to complete");
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.debug("checkWitnessHostVm() - InterruptedException: " + String.valueOf(interruptedException));
        }
        logger.debug("checkWitnessHostVmStartup() - end");
    }

    protected void doVMVAppStartupForAllHosts() {
        logger.debug("doVMVAppStartupForAllHosts() - start");
        ExecutorService executorService = Executors.newFixedThreadPool(this.virtualHostsToShutdown.size());
        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>();
        for (String string : this.virtualHostsToShutdown) {
            arrayList.add(Executors.callable(new VMVAppStartupRunnable(string, this.theState, this.services)));
        }
        try {
            executorService.invokeAll(arrayList);
            executorService.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            logger.error("doVMVAppStartupForAllHosts() - InterruptedException: ", (Throwable)interruptedException);
        }
        logger.debug("doVMVAppStartupForAllHosts() - end");
    }

    @Override
    public void shutdownCriticalHosts() {
        logger.debug("shutdownCriticalHosts() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("shutdownCriticalHosts() - Host Set is null or empty.  No hosts to shut down.");
            return;
        }
        for (String string : this.virtualHostsToShutdown) {
            if (string == null) {
                logger.debug("shutdownCriticalHosts() - Skipping null host from host set.");
                continue;
            }
            logger.debug("shutdownCriticalHosts() - host: {}", (Object)string);
            String string2 = null;
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
            if (serviceInstance == null || this.hostSystemUtils.isVCenterServerInstalledOnTargetHost()) {
                logger.debug("shutdownCriticalHosts() - serviceInstance is null || vCenter is on target host");
                try {
                    string2 = this.hostSystemUtils.getESXIConnStr(serviceInstance, string);
                    serviceInstance = this.vmwareConnection.getESXiHostInstance(string2);
                }
                catch (Exception exception) {
                    logger.error("shutdownCriticalHosts() - Exception: cannot obtain ESXi service instance", (Throwable)exception);
                }
            }
            if (serviceInstance != null) {
                HostSystem hostSystem;
                String string3;
                if (string2 == null) {
                    string2 = string;
                }
                if ((string3 = (hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string2)).getName()) != null && !this.virtualisationStatusStore.isHostLockedForShutdown(string3)) {
                    logger.debug("shutdownCriticalHosts() - ensure host: {} is off and not started before critical event was cleared", (Object)string);
                    this.processShutdownOnCriticalHost(serviceInstance, hostSystem, string);
                    continue;
                }
                logger.debug("shutdownCriticalHosts() - host: {} already locked for shutdown", (Object)string);
                continue;
            }
            logger.debug("shutdownCriticalHosts() - serviceInstance is null, not able to shutdown host: {}", (Object)string);
        }
        logger.debug("shutdownCriticalHosts() - All hosts processed.");
    }

    private void processShutdownOnCriticalHost(ServiceInstance serviceInstance, HostSystem hostSystem, String string) {
        try {
            logger.debug("processShutdownOnCriticalHost() - host: {}", (Object)string);
            this.virtualisationStatusStore.lockHostForShutdown(string);
            if (this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                logger.debug("processShutdownOnCriticalHost() - host: {} came online and event is active", (Object)hostSystem.getName());
                if (!this.theState.checkIfCriticalEventActive(string)) {
                    logger.debug("processShutdownOnCriticalHost() - critical event no longer active on host: {}", (Object)string);
                } else {
                    if (!this.isSkipMaintenanceModeEnabled && this.hostSystemUtils.areAllVMsPoweredOff(hostSystem, true)) {
                        HostMaintenanceMode hostMaintenanceMode = this.hostSystemUtils.getHostMaintenanceModeInstance(string, this.isDelayMaintenanceModeEnabled(string), this.theState, this.ups_setup_idx, this.services);
                        hostMaintenanceMode.setVirtualHostsShutdownEnabled(this.isAdvancedFTTEnabled);
                        hostMaintenanceMode.setVsanHost(this.isVsanHost(string));
                        hostMaintenanceMode.setDelayMaintenanceModeTimeout(this.getDelayMaintenanceModeTimeout(string));
                        boolean bl = false;
                        hostMaintenanceMode.putHostIntoMaintenanceMode(hostSystem, bl);
                    }
                    if (!this.theState.checkIfCriticalEventActive(string)) {
                        logger.debug("processShutdownOnCriticalHost() - critical event no longer active on host: {}", (Object)string);
                    } else {
                        this.services.getVirtualLoggingUtils().logHostShutdownEvent(string);
                        if (!this.triggerShutdownHost(hostSystem, string)) {
                            logger.error("processShutdownOnCriticalHost() - failed to shut down host: {}", (Object)string);
                        }
                        if (this.hostSystemUtils.isHostShutdownTriggered(serviceInstance, hostSystem)) {
                            while (this.hostSystemUtils.checkIfHostIsPoweredOff(hostSystem)) {
                                logger.debug("processShutdownOnCriticalHost() - waiting for host to be in notResponding/disconnected state");
                                Thread.sleep(3000L);
                            }
                        }
                    }
                }
            } else {
                logger.debug("processShutdownOnCriticalHost() - shutdown not required, host powered off");
            }
            this.virtualisationStatusStore.unlockHostForShutdown(string);
        }
        catch (Exception exception) {
            logger.error("processShutdownOnCriticalHost() - Exception: ", (Throwable)exception);
        }
    }

    private boolean isVcsaHost(String string) {
        logger.debug("isVcsaHost() - start, host: {}", (Object)string);
        if (this.theState.getVCSAHost() == null) {
            return false;
        }
        try {
            logger.debug("isVcsaHost() - vCSA host to match: {}", (Object)this.theState.getVCSAHost().getName());
            if (string.equalsIgnoreCase(this.theState.getVCSAHost().getName())) {
                logger.debug("isVcsaHost() - found vCSA host in VCSAHost.getName");
                return true;
            }
            if (this.virtualConfigManager.isCheckVcsaIpAddressEnabled() && this.hostSystemUtils.isESXiHostIPAddress(string, this.theState.getVCSAHost())) {
                logger.debug("isVcsaHost() - found vCSA host in ESXi host IP address");
                return true;
            }
            if (string.length() > this.theState.getVCSAHost().getName().length() && string.toLowerCase().startsWith(this.theState.getVCSAHost().getName().toLowerCase(), 0) || string.length() < this.theState.getVCSAHost().getName().length() && this.theState.getVCSAHost().getName().toLowerCase().startsWith(string.toLowerCase(), 0)) {
                logger.debug("isVCSAHost() - found vCSA host");
                return true;
            }
        }
        catch (Exception exception) {
            logger.error("isVcsaHost() - Exception: " + String.valueOf(exception));
        }
        logger.debug("isVcsaHost() - end, not vCSA host");
        return false;
    }

    private void checkVCSAStatus() {
        Integer n = this.vmwareConnection.getVCSAStatus();
        Integer n2 = this.vmwareConnection.getLoggedVCSAStatus();
        boolean bl = false;
        logger.debug("checkVCSAStatus() - status: {}, loggedStatus: {}", (Object)n, (Object)n2);
        if (n != null && !n.equals(n2)) {
            bl = true;
            logger.debug("checkVCSAStatus() - logging the event");
            this.vmwareConnection.setLoggedVCSAStatus(n);
        }
        if (VMWareConnection.VM_NOT_FOUND.equals(n) || VMWareConnection.VM_HOST_NOT_FOUND.equals(n) && bl) {
            this.services.getVirtualLoggingUtils().logVCSANotFoundEvent();
        } else if (VMWareConnection.VM_POWERED_OFF.equals(n) && bl) {
            this.services.getVirtualLoggingUtils().logVCSAVMPoweredOffEvent(this.hostSystemUtils.getVCSAHost());
        }
    }

    private boolean isDelayMaintenanceModeEnabled(String string) {
        boolean bl = false;
        if (this.isAdvancedMode) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(string);
            if (uPSSetup != null) {
                bl = uPSSetup.getVMSettings().isHostMaintenanceModeDelayed();
            }
        } else {
            bl = this.virtualConfigManager.isDelayMaintenanceModeEnabled();
        }
        return bl;
    }

    private int getDelayMaintenanceModeTimeout(String string) {
        int n = 0;
        if (this.isAdvancedMode) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(string);
            if (uPSSetup != null) {
                n = uPSSetup.getVMSettings().getHostMaintenanceModeTimeout();
            }
        } else {
            n = this.virtualConfigManager.getDelayMaintenanceModeTimeout();
        }
        return n;
    }

    public boolean canWePerformVMAndVAppStartup(LinkedHashSet<String> linkedHashSet) {
        logger.debug("canWePerformVMAndVAppStartup() - start");
        boolean bl = this.virtualConfigManager.isStartupWaitsForAllHostsOnlineEnabled();
        if (!bl) {
            logger.debug("canWePerformVMAndVAppStartup() - not waiting for all hosts online, returning: true");
            return true;
        }
        if (!this.allHostsStarted(linkedHashSet)) {
            logger.debug("canWePerformVMAndVAppStartup() - all hosts not online, returning: false");
            return false;
        }
        boolean bl2 = true;
        logger.debug("canWePerformVMAndVAppStartup() - all hosts are online");
        boolean bl3 = false;
        if (this.virtualisationStatusStore.getVcsaHost() != null && this.virtualisationStatusStore.getVcsaVmName() != null) {
            logger.debug("canWePerformVMAndVAppStartup() - found vCSA startup keys in properties file");
            bl3 = true;
        }
        if (this.services.getVMPrioritizationUtils().checkIfVCSAVMInVMPrioritizedList() == null && (bl3 || ESXManagedHost.isVirtualAppShutdownByPCNS()) && this.vmwareConnection.getVCenterConnection() == null) {
            logger.debug("canWePerformVMAndVAppStartup() - unable to start vApps as serviceInstance is null");
            bl2 = false;
        }
        logger.debug("canWePerformVMAndVAppStartup() - end, result: {}", (Object)bl2);
        return bl2;
    }

    private static boolean isVirtualAppShutdownByPCNS() {
        boolean bl = false;
        List<List<String>> list = ServiceManager.getInstance().getVirtualisationStatusStore().getVApps();
        for (List<String> list2 : list) {
            if (list2 == null || list2.size() <= 0) continue;
            bl = true;
            break;
        }
        logger.debug("isVirtualAppShutdownByPCNS() - end, returning: {}", (Object)bl);
        return bl;
    }

    protected boolean isVCSAStartupRequired() {
        this.vcsaHostIP = this.virtualisationStatusStore.getVcsaHost();
        if (this.vcsaHostIP == null) {
            logger.debug("isVCSAStartupRequired() - vCenterHostIP is null, no startup needed");
            return false;
        }
        this.vcsaHostName = this.virtualisationStatusStore.getVcsaHostName();
        if (this.virtualisationStatusStore.isHostLockedForShutdown(this.vcsaHostIP) || this.virtualisationStatusStore.isHostLockedForShutdown(this.vcsaHostName)) {
            logger.debug("isVCSAStartupRequired() - vCSA host is locked, returning false");
            return false;
        }
        this.vcsaVmName = this.hostSystemUtils.getVirtualCentreServerApplianceVirtualMachineName();
        if (this.vcsaVmName == null) {
            logger.debug("isVCSAStartupRequired() - vCSAVmName is null, returning false");
            return false;
        }
        return true;
    }

    protected boolean isVCSAHostAvailable() {
        logger.debug("isVCSAHostAvailable() - start");
        this.vCSAHostServiceInstance = null;
        try {
            this.vCSAHostServiceInstance = this.vmwareConnection.getESXiHostInstance(this.vcsaHostIP);
        }
        catch (Exception exception) {
            logger.error("isVCSAHostAvailable() - cannot obtain ESXi service instance", (Throwable)exception);
            return false;
        }
        if (this.vCSAHostServiceInstance == null) {
            logger.debug("isVCSAHostAvailable() - serviceInstance is null, returning false");
            return false;
        }
        if (this.checkIfCriticalEventActive(this.theState, this.vCSAHostServiceInstance, this.vcsaHostIP)) {
            logger.debug("isVCSAHostAvailable() - critical event active on vCSA host, returning false");
            return false;
        }
        logger.debug("isVCSAHostAvailable() - critical event not active on vCSA host: {}", (Object)this.vcsaHostIP);
        if (!this.hostSystemUtils.getOnlineHostOutOfMaintenanceMode(this.vcsaHostIP, false)) {
            logger.debug("isVCSAHostAvailable() - getOnlineHostOutOfMaintenanceMode returned false, returning false");
            return false;
        }
        logger.debug("isVCSAHostAvailable() - end, host available");
        return true;
    }

    private boolean startupVCSAVM() throws RemoteException, InterruptedException, IllegalStateException {
        ManagedEntity managedEntity;
        logger.debug("startupVCSAVM() - start");
        boolean bl = false;
        VirtualMachine virtualMachine = null;
        if (this.vCSAHostServiceInstance == null) {
            logger.debug("startupVCSAVM() - serviceInstance is null, should be set to ESX host service instance");
            throw new IllegalStateException("VCSA host service instance null");
        }
        try {
            if (this.getVsanFtt() != null && !this.getVsanFtt().isFTTResolved()) {
                logger.info("startupVCSAVM() - not starting vCSA VM as FTT is not resolved, returning true to stop startup");
                return true;
            }
            managedEntity = new InventoryNavigator((ManagedEntity)this.vCSAHostServiceInstance.getRootFolder()).searchManagedEntity("VirtualMachine", this.vcsaVmName);
            if (managedEntity == null) {
                logger.info("startupVCSAVM() - failed to find vCSA VM: {} in Inventory, returning false to proceed with startup", (Object)this.vcsaVmName);
                return false;
            }
            if (!(managedEntity instanceof VirtualMachine)) {
                logger.error("startupVCSAVM() - managedEntity is not an instance of a VM, returning true to stop startup");
                return true;
            }
            virtualMachine = (VirtualMachine)managedEntity;
            this.vCenterHost = this.hostSystemUtils.getHostOfVirtualMachine(virtualMachine, this.vCSAHostServiceInstance);
            if (!this.hostSystemUtils.checkIfHostIsPoweredOn(this.vCenterHost)) {
                logger.info("startupVCSAVM() - vCSA host not Powered On, returning true to stop startup");
                return true;
            }
            if (!this.services.getVirtualMachineUtils().isConnected(virtualMachine)) {
                logger.error("startupVCSAVM() - vCSA VM is not connected, returning true to stop startup");
                return true;
            }
            this.theState.setVcsaHostShutdown(false);
            if (this.vCenterHost.getRuntime().isInMaintenanceMode()) {
                logger.info("startupVCSAVM() - vCSA host in Maintenance Mode, returning true to stop startup");
                return true;
            }
            if (this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled() && this.services.getVMPrioritizationUtils().checkIfVMExistsInPrioritizedVMList(this.vcsaVmName) != null) {
                logger.info("startupVCSAVM() - vCSA VM name found in VM Prioritization group, returning false to proceed with startup");
                return false;
            }
        }
        catch (Exception exception) {
            logger.error("startupVCSAVM() - Exception: ", (Throwable)exception);
            return true;
        }
        if (this.services.getVirtualMachineUtils().isPoweredOff(virtualMachine)) {
            this.services.getVirtualLoggingUtils().logVCSAVMStartupLogEvent(this.vcsaVmName);
            managedEntity = virtualMachine.powerOnVM_Task(this.vCenterHost);
            if (managedEntity.waitForTask().equals("success")) {
                logger.info("startupVCSAVM() - vCSA VM: {} power-on successful", (Object)virtualMachine.getName());
            } else {
                logger.warn("startupVCSAVM() - vCSA VM: {} power-on failed", (Object)virtualMachine.getName());
                bl = true;
            }
        }
        this.vmwareConnection.setVCenterOffline(false);
        if (!bl) {
            this.virtualisationStatusStore.removeVcsaKeys();
            if (!this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                int n = 0;
                boolean bl2 = true;
                while (bl2) {
                    logger.debug("startupVCSAVM() - waiting {} seconds before checking vCenter connection, attempt {}", (Object)60, (Object)n);
                    try {
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("startupVCSAVM() - sleep InterruptedException: " + interruptedException.getMessage());
                    }
                    managedEntity = this.vmwareConnection.getVCenterConnection();
                    bl2 = managedEntity == null && ++n < 15;
                }
                if (n >= 15) {
                    logger.debug("startupVCSAVM() - vCenter connection unavailable after {} attempts", (Object)15);
                }
            }
            int n = 30;
            try {
                n = this.services.getConfigurationManager().getInt("HostConfigSettings", "delay_after_vcsa_powered_on_and_connected");
            }
            catch (NoSuchElementException noSuchElementException) {
                logger.debug("startupVCSAVM() - Failed to get DELAY_AFTER_VCSA_POWERED_ON_AND_CONNECTED", (Throwable)noSuchElementException);
            }
            logger.debug("startupVCSAVM() - vCenter VM powered on; sleeping {} seconds to allow initialization to complete before attempting vApp / VM Startup", (Object)n);
            try {
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.theState.setVCSARequiredForVAppStartup(false);
            logger.info("startupVCSAVM() - ========================= NORMAL EVENT Clear critical Event ===================================");
            CreateVCenterAlarm.getInstance().createUPSCriticalEvent(this.vcsaHostIP, "normal");
        }
        logger.debug("startupVCSAVM() - VCSAStartupRequired: {}", (Object)bl);
        return bl;
    }

    private VsanFaultToleranceThreshold getVsanFtt() {
        if (this.vSanFttFeatures == null && this.virtualConfigManager.isManagedESXi() && this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() && this.virtualConfigManager.isVsanFTTEnabled()) {
            this.vSanFttFeatures = this.vsanUtils.getVsanFaultToleranceThreshold(this.theState, this.services);
        }
        return this.vSanFttFeatures;
    }

    private boolean checkIfCriticalEventActive(ShutdownState shutdownState, ServiceInstance serviceInstance, String string) {
        boolean bl = false;
        if (serviceInstance != null) {
            HostSystem hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
            if (hostSystem != null && shutdownState.checkIfCriticalEventActive(hostSystem)) {
                logger.debug("checkIfCriticalEventActive() - critical event active, VCSA startup not required; serviceInstance not null");
                bl = true;
            }
        } else if (shutdownState.checkIfCriticalEventActive(string)) {
            logger.debug("checkIfCriticalEventActive() - critical event active, VCSA startup not required; serviceInstance is null");
            bl = true;
        }
        return bl;
    }

    protected void checkDrsSettings() {
        if (this.getVsanFtt() != null) {
            this.getVsanFtt().checkGroupLockRemoval();
        }
        new DrsSettings(this.services).checkDrsSettingInPropertiesFile();
        this.vSanFttFeatures = null;
    }

    protected boolean handleVcsaRequirement() {
        logger.debug("handleVcsaRequirement() - start");
        if (!this.isVCSAStartupRequired()) {
            logger.debug("handleVcsaRequirement() - VCSA startup is not required");
            return true;
        }
        boolean bl = false;
        logger.debug("handleVcsaRequirement() - VCSA startup is required");
        if (!this.isVCSAHostAvailable()) {
            logger.debug("handleVcsaRequirement() - VCSA not handled, VCSA host not available");
            bl = true;
        } else {
            try {
                bl = this.startupVCSAVM();
            }
            catch (InterruptedException | RemoteException exception) {
                logger.error("handleVcsaRequirement() - Exception: ", (Throwable)exception);
            }
        }
        if (bl) {
            boolean bl2 = this.virtualConfigManager.isStartupWaitsForAllHostsOnlineEnabled();
            logger.debug("handleVcsaRequirement() - VCSA VM did not start, startup is still required");
            if (bl2) {
                logger.debug("handleVcsaRequirement() - wait for all hosts online");
                return false;
            }
            if (this.theState.getVCSAStartupReattempt()) {
                logger.debug("handleVcsaRequirement() - setting VCSAStartupReattempt to false");
                this.theState.setVCSAStartupReattempt(false);
                logger.debug("handleVcsaRequirement() - VCSA startup 1st attempt, VCSA not handled");
                return false;
            }
            this.theState.setVCSARequiredForVAppStartup(true);
            logger.debug("handleVcsaRequirement() - setting VCSARequiredForVAppStartup to true");
            logger.debug("handleVcsaRequirement() - VCSA startup reattempt, VCSA not handled. Trying to start VMs via hosts");
            return true;
        }
        logger.debug("handleVcsaRequirement() - end, VCSA handled");
        return true;
    }

    protected void refreshVcsaHostName() {
        logger.debug("refreshVcsaHostName() - start");
        try {
            if (this.theState.getVCSAHost() != null) {
                this.vcsaHostName = this.theState.getVCSAHost().getName();
                this.theState.setVcsaHostName(this.vcsaHostName);
                logger.debug("refreshVcsaHostName() - Set vcsaHostName: {}", (Object)this.vcsaHostName);
            }
        }
        catch (Exception exception) {
            logger.debug("refreshVcsaHostName() - Failed to get VCSA Host name. {}", (Throwable)exception);
        }
        logger.debug("refreshVcsaHostName() - end, Vcsa Host Name: {}", (Object)this.vcsaHostName);
    }

    protected void refreshVcsaHostIp() {
        logger.debug("refreshVcsaHostIp() - start");
        String string = this.theState.getVcsaHostName();
        try {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String string2 = this.hostSystemUtils.getIPAddressFromHostname(this.services.getVmWareConnection().getVCenterConnection(), string);
                logger.debug("refreshVcsaHostIp() - Setting Vcsa Host Ip to: {}", (Object)string2);
                this.theState.setVcsaHostIp(string2);
            }
        }
        catch (Exception exception) {
            logger.debug("refreshVcsaHostIp() - Failed to get VCSA Host IP. {}", (Throwable)exception);
        }
        logger.debug("refreshVcsaHostIp() - end");
    }

    protected void refreshVcsaVmName() {
        logger.debug("refreshVcsaVmName() - start");
        try {
            if (this.theState.getVCSAVM() != null) {
                this.vcsaVmName = this.theState.getVCSAVM().getName();
                logger.debug("refreshVcsaVmName() - Set vcsaVmName: {}", (Object)this.vcsaVmName);
            }
        }
        catch (Exception exception) {
            logger.debug("refreshVcsaVmName() - Failed to get VCSA VM name. {}", (Throwable)exception);
        }
        logger.debug("refreshVcsaVmName() - end, Vcsa VM Name: {}", (Object)this.vcsaVmName);
    }

    protected void cacheVcsaDetails(HostSystem hostSystem, VirtualMachine virtualMachine) {
        logger.debug("isVcsaHostCritical() - Setting VCSA Host: {}", (Object)hostSystem);
        this.theState.setVCSAHost(hostSystem);
        this.refreshVcsaHostName();
        this.refreshVcsaHostIp();
        logger.debug("isVcsaHostCritical() - Setting VCSA VM: {}", (Object)virtualMachine);
        this.theState.setVCSAVM(virtualMachine);
        this.refreshVcsaVmName();
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        if (this.criticalVsanHostMap == null || this.criticalVsanHostMap.isEmpty() || !this.isVsanHostHandlingRequired()) {
            logger.debug("performClusterStopOps() - no cluster operations required");
            return;
        }
        if (this.theState.isVSanPreparationInProgress() || this.theState.hasVsanPreparationRun()) {
            logger.debug("performClusterStopOps() - cluster operations already in progress: {} or executed {}", (Object)this.theState.isVSanPreparationInProgress(), (Object)this.theState.hasVsanPreparationRun());
            return;
        }
        logger.debug("performClusterStopOps() - vSAN cluster, cluster operations required");
        int n = this.vsanUtils.getClusterPrepareDuration(this.isAdvancedMode, this.ups_setup_idx);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.prepareVSanCluster());
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("performClusterStopOps() - timed out while preparing vSAN cluster for shutdown");
            this.vsanUtils.logVsanClusterPrepareFailEvent();
        }
        catch (InterruptedException interruptedException) {
            logger.error("performClusterStopOps() - failed to execute commands to prepare vSAN cluster for shutdown: {}", (Throwable)interruptedException);
            this.vsanUtils.logVsanClusterPrepareFailEvent();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.error("performClusterStopOps() - failed to execute commands to prepare vSAN cluster for shutdown: {}", (Throwable)executionException);
            this.vsanUtils.logVsanClusterPrepareFailEvent();
        }
        logger.debug("performClusterStopOps() - waiting rest of vSAN cluster preparation duration");
        countdownTimer.sleep();
    }

    private void prepareVSanCluster() {
        logger.debug("prepareVSanCluster() - set to ignore member list updates");
        this.vsanUtils.logVsanClusterPrepareEvent();
        this.theState.setVSanPreparationInProgress();
        this.vsanUtils.activateIgnoreClusterMemberListUpdates(this.criticalVsanHostMap.keySet());
        logger.debug("prepareVSanCluster() - prepare cluster for shutdown");
        this.vsanUtils.prepareClusterShutown(this.criticalVsanHostMap.keySet());
        this.theState.clearVSanPreparationInProgress();
        this.theState.setHasVsanPreparationRun();
        this.virtualisationStatusStore.setVsanRecoveryNeeded(true);
    }

    private void recoverVSanCluster() {
        logger.trace("recoverVSanCluster() - start");
        if (!this.virtualisationStatusStore.isVsanRecoveryNeeded()) {
            logger.debug("recoverVSanCluster() - vSAN cluster recovery not needed.");
            return;
        }
        if (this.theState.isVSanRecoveryInProgress()) {
            logger.debug("recoverVSanCluster() - vSAN cluster recovery already in progress.");
            return;
        }
        try {
            this.theState.setVSanRecoveryInProgress();
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug("recoverVSanCluster() - vSAN cluster recovery just started on different thread, skipping it in this one");
            return;
        }
        this.vsanUtils.logVsanClusterRecoverEvent();
        logger.debug("recoverVSanCluster() - recover cluster");
        this.vsanUtils.recoverCluster(this.virtualHostsToShutdown);
        logger.debug("recoverVSanCluster() - reenable member list updates");
        this.vsanUtils.deactivateIgnoreClusterMemberListUpdates(this.virtualHostsToShutdown);
        this.theState.clearHasVsanPreparationRun();
        this.theState.clearVSanRecoveryInProgress();
        this.virtualisationStatusStore.clearVsanRecoveryNeeded();
        logger.trace("recoverVSanCluster() - end");
    }

    private boolean allHostsStarted(LinkedHashSet<String> linkedHashSet) {
        logger.trace("allHostsStarted() - start for given hosts set");
        Optional<String> optional = linkedHashSet.stream().filter(string -> this.virtualisationStatusStore.isHostLockedForShutdown((String)string) || this.virtualisationStatusStore.isHostUnlockedForShutdown((String)string)).findAny();
        if (optional.isPresent()) {
            logger.debug("allHostsStarted() - not started host found: {}", (Object)optional.get());
            return false;
        }
        if (this.hostSystemUtils.haveHostsStarted(this.virtualHostsToShutdown) != HostSystemUtils.HostsStarted.ALL) {
            logger.debug("allHostsStarted() - not started host found");
            return false;
        }
        logger.trace("allHostsStarted() - end");
        return true;
    }

    private boolean allHostsStarted() {
        logger.trace("allHostsStarted() - start, for all virtual hosts");
        return this.allHostsStarted(this.virtualHostsToShutdown);
    }

    private boolean isClusterHandlingRequired() {
        logger.debug("isClusterHandlingRequired() - start");
        if (!this.isAdvancedMode) {
            logger.debug("isClusterHandlingRequired() - not advanced setup, cluster handling is required");
            return true;
        }
        if (this.isVirtualHostsShutdownEnabled) {
            logger.debug("isClusterHandlingRequired() - VirtualHosts shutdown is enabled, cluster handling is required");
            return true;
        }
        Optional<String> optional = this.virtualHostsToShutdown.stream().filter(string -> this.getClusterForHost((String)string) != null).findAny();
        if (this.virtualConfigManager.isHCISystem() && optional.isPresent()) {
            logger.debug("isClusterHandlingRequired() - cluster host {} is critical, cluster handling is required", (Object)optional.get());
            return true;
        }
        if (!this.isAnyHealthyHostNotCritical()) {
            logger.debug("isClusterHandlingRequired() - no configured hosts healthy and not critical, cluster handling required");
            return true;
        }
        if (this.isVsanClusterHandlingRequired()) {
            logger.debug("isClusterHandlingRequired() - vSAN cluster handling required");
            return true;
        }
        logger.debug("isClusterHandlingRequired() - end, no cluster handling required");
        return false;
    }

    private boolean isVsanHostHandlingRequired() {
        logger.debug("isVsanHostHandlingRequired() - start");
        return this.virtualHostsToShutdown.stream().anyMatch(string -> this.isVsanHost((String)string));
    }

    private boolean isVsanClusterHandlingRequired() {
        logger.debug("isVsanClusterHandlingRequired() - start");
        Map<Integer, LinkedHashSet<VsanHost>> map = this.vsanUtils.getProtectedVsanGroupMap();
        logger.debug("isVsanClusterHandlingRequired() - {} groups with protected vSAN hosts found", (Object)map.size());
        if (this.isAdvancedFTTEnabled && (this.vSanFttFeatures.isFTTExceeded() || this.isAdvancedFTTExceeded)) {
            logger.debug("isVsanClusterHandlingRequired() - FTT exceeded, vSAN cluster handling needed");
            return true;
        }
        if (map.size() > 0) {
            Optional<Integer> optional = map.entrySet().stream().filter(entry -> {
                if (!this.theState.hasCriticalTimer((Integer)entry.getKey())) {
                    logger.trace("isVsanClusterHandlingRequired() - group {} is not critical", entry.getKey());
                    Optional<VsanHost> optional = ((LinkedHashSet)entry.getValue()).stream().filter(vsanHost -> !vsanHost.isWitness()).findAny();
                    if (optional.isPresent()) {
                        logger.trace("isVsanClusterHandlingRequired() - non-critical group {} has a vSAN host {}", entry.getKey(), (Object)optional.get().getName());
                        return true;
                    }
                    logger.trace("isVsanClusterHandlingRequired() - group {} has no vSAN host", entry.getKey());
                }
                logger.trace("isVsanClusterHandlingRequired() - group {} qualifies for cluster handling", entry.getKey());
                return false;
            }).map(Map.Entry::getKey).findAny();
            if (optional.isEmpty()) {
                logger.debug("isVsanClusterHandlingRequired() - all groups with vSAN hosts are critical, cluster handling is required");
                return true;
            }
            logger.debug("isVsanClusterHandlingRequired() - group {} with vSAN host(s) is not critical, cluster handling is not required", (Object)optional.get());
        }
        return false;
    }

    protected boolean isAnyHealthyHostNotCritical() {
        logger.trace("isAnyHealthyHostNotCritical() - start");
        LinkedHashSet<String> linkedHashSet = this.virtualConfigManager.getConfiguredHosts();
        Optional<String> optional = linkedHashSet.stream().filter(string -> StringUtils.isNotBlank((CharSequence)string)).filter(string -> !this.theState.checkIfCriticalEventActive((String)string)).filter(string -> this.hostSystemUtils.isHostHealthy((String)string)).findAny();
        if (optional.isPresent()) {
            logger.debug("isAnyHealthyHostNotCritical() - not-critical and available host found: {}", (Object)optional.get());
            return true;
        }
        logger.debug("isAnyHealthyHostNotCritical() - no not-critical and available host found, returning false");
        return false;
    }

    private boolean allVmsAndVAppsStarted() {
        logger.trace("allVmsAndVAppsStarted() - start");
        Optional<String> optional = this.virtualHostsToShutdown.stream().filter(string -> this.virtualisationStatusStore.hasVmsToStart((String)string) || this.virtualisationStatusStore.hasVAppsToStart((String)string)).findAny();
        if (optional.isPresent()) {
            logger.debug("allVmsAndVAppsStarted() - host with VMs or vApps to start found: {}", optional);
            return false;
        }
        logger.trace("allVmsAndVAppsStarted() - end");
        return true;
    }

    private boolean isVCLSHandlingNeeded() {
        logger.debug("isVCLSHandlingNeeded() - start");
        if (!this.services.getClusterUtils().isVCLSvMCurrentlyRunning()) {
            logger.debug("isVCLSHandlingNeeded() - no vCLS VMs currently running, vCenter Cluster Services handling is not required");
            return false;
        }
        if (this.isAdvancedMode && this.theState.hasVCLSBeenDisabled()) {
            logger.debug("isVCLSHandlingNeeded() - vCenter Cluster Services has already been disabled, skipping step");
            return false;
        }
        if (this.theState.isDisablingVCLSInProgress()) {
            this.waitForVclsHandlingThread();
            logger.debug("isVCLSHandlingNeeded() - vCenter Cluster Services has been disabled in another thread, skipping step");
            return false;
        }
        logger.debug("isVCLSHandlingNeeded() - end, vCenter Cluster Services  handling is required");
        return true;
    }

    private void waitForVclsHandlingThread() {
        CountdownTimer countdownTimer = this.theState.getDisableVclsTimer();
        if (countdownTimer != null && !countdownTimer.hasElapsed()) {
            logger.debug("waitForVclsHandlingThread() - vCenter Cluster Services is being disabled in another thread, waiting for thread to finish");
            countdownTimer.sleep();
        }
    }

    private void waitForHaHandlingThread() {
        logger.debug("waitForHaHandlingThread() - HA is being disabled in another thread, waiting for thread to finish");
        while (this.theState.isDisablingHAInProgress() && !this.theState.hasHABeenDisabled()) {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                logger.error("waitForHaHandlingThread() - interruped while waiting for HA disbale progress to finish");
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void handleVCLSAndHAStartup() {
        logger.debug("handleVCLSAndHAStartup() - start");
        this.getVsanFtt();
        if (this.vSanFttFeatures != null && (this.vSanFttFeatures.isFTTExceeded() || !this.vSanFttFeatures.isFTTResolved())) {
            logger.debug("handleVCLSAndHAStartup() - HA / vCLS startup cannot be performed, FTT requirement not met.");
            return;
        }
        Set<String> set = this.getHostSet();
        if (set == null || set.isEmpty()) {
            logger.debug("handleVCLSAndHAStartup() - HA / vCLS startup cannot be performed, host set is empty.");
            return;
        }
        if (set.size() == 1 && set.contains(this.vsanUtils.getWitnessHost(this.isAdvancedMode))) {
            logger.debug("handleVCLSAndHAStartup() - HA / vCLS startup cannot be performed, handling only the witness host");
            return;
        }
        LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getVMAndVAppHostList();
        if (!linkedHashSet.isEmpty() && !this.canWePerformVMAndVAppStartup(linkedHashSet)) {
            logger.debug("handleVCLSAndHAStartup() - HA / vCLS startup can't be performed yet");
            return;
        }
        boolean bl = true;
        for (String string : set) {
            if (!this.virtualisationStatusStore.isHostLockedForShutdown(string)) continue;
            bl = false;
            break;
        }
        if (this.theState.isClusterHandlingInProgress()) {
            logger.debug("handleVCLSAndHAStartup() - HA / vCLS startup can't be performed, cluster is currently stopping.");
            return;
        }
        if (bl) {
            logger.debug("handleVCLSAndHAStartup() - valid state for handling HA and VCLS");
            this.vmwareConnection.setVCenterOffline(false);
            this.vmwareConnection.getVCenterConnection();
            this.enableVCLS();
            this.enableHA();
            if (!this.virtualisationStatusStore.isHAorVCLSDisabled()) {
                logger.debug("handleVCLSAndHAStartup() - removing VCSA keys");
                this.virtualisationStatusStore.removeVcsaKeys();
            }
        } else {
            logger.debug("handleVCLSAndHAStartup() - not in a valid state for handling HA and VCLS");
        }
    }

    private boolean performVsanClusterRecovery() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.virtualHostsToShutdown != null && !this.virtualHostsToShutdown.isEmpty()) {
            bl = this.virtualHostsToShutdown.stream().anyMatch(string -> this.vsanUtils.isHostConfiguredAsVsanHost((String)string));
        }
        if (!bl) {
            logger.debug("performVsanClusterRecovery() - no VSAN hosts to start, no VSAN cluster operations required");
            return true;
        }
        if (this.virtualConfigManager.isVsanFTTEnabled()) {
            this.vSanFttFeatures = this.vsanUtils.getVsanFaultToleranceThreshold(this.theState, this.services);
            this.vSanFttFeatures.checkGroupLockRemoval();
            if (!this.vSanFttFeatures.isFTTResolved()) {
                logger.debug("performVsanClusterRecovery() - vSAN FTT not resolved, cannot recover vSAN cluster");
                return false;
            }
        }
        if (!this.allHostsStarted()) {
            logger.debug("performVsanClusterRecovery() - not all hosts started, cannot recover vSAN cluster");
            return false;
        }
        logger.debug("performVsanClusterRecovery() - VSAN cluster operations required");
        int n = this.vsanUtils.getClusterRecoveryDuration(this.isAdvancedMode, this.ups_setup_idx);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.recoverVSanCluster());
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
            bl2 = true;
        }
        catch (TimeoutException timeoutException) {
            logger.error("performVsanClusterRecovery() - timed out while running tasks to recover vSAN cluster");
            this.vsanUtils.logVsanClusterRecoverFailEvent();
        }
        catch (InterruptedException interruptedException) {
            logger.error("performVsanClusterRecovery() - failed to execute commands to recover vSAN cluster: {}", (Throwable)interruptedException);
            this.vsanUtils.logVsanClusterRecoverFailEvent();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.error("performVsanClusterRecovery() - failed to execute commands to recover vSAN cluster: {}", (Throwable)executionException);
            this.vsanUtils.logVsanClusterRecoverFailEvent();
        }
        if (bl2) {
            logger.debug("performVsanClusterRecovery() - waiting rest of vSAN cluster recovery duration");
            countdownTimer.sleep();
        }
        logger.debug("performVsanClusterRecovery() - VSAN cluster recovered and preconditions met: {}", (Object)bl2);
        return bl2;
    }
}

