/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ESXUnmanagedStandaloneHost
extends StandardHost {
    private static final Logger logger = LogManager.getLogger(ESXUnmanagedStandaloneHost.class);
    private VMWareConnection vmwareConnection;

    public ESXUnmanagedStandaloneHost(ServiceManager serviceManager) {
        super(serviceManager);
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    @Override
    public void hostShutdown() {
        logger.debug("start hostShutdown:" + this.virtualHostsToShutdown.toString());
        if (this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("no hosts in need of shutting down");
            return;
        }
        ServiceInstance serviceInstance = null;
        try {
            HostSystem hostSystem = null;
            boolean bl = false;
            HostSystemUtils hostSystemUtils = this.services.getHostSystemUtils();
            serviceInstance = this.vmwareConnection.getESXiHostInstance();
            String string = this.services.getVirtualConfigurationManager().getIPFromHostName(this.services.getVirtualConfigurationManager().getServerIP());
            if (string != null && serviceInstance != null && (hostSystem = hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string)) != null) {
                logger.debug("Standalone Host: " + hostSystem.getName());
                this.services.getVirtualLoggingUtils().logHostShutdownEvent(this.services.getVirtualConfigurationManager().getServerIP());
                Task task = hostSystem.shutdownHost_Task(true);
                if (task.waitForTask().equals("success")) {
                    logger.debug("Host Shutdown Successfully");
                    bl = true;
                } else {
                    logger.debug("Host could not be Shutdown Successfully");
                }
            }
            if (bl) {
                logger.debug("Before wait for host to be in poweredOn/disconnected state");
                while (hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                    logger.trace("Waiting for standalone host to be in poweredOff/disconnected state");
                    Thread.sleep(1000L);
                }
                logger.debug("After wait for host to be in poweredOn/disconnected state");
            }
        }
        catch (Exception exception) {
            logger.error("hostShutdown", (Throwable)exception);
        }
    }

    @Override
    public void pcnsOSShutdown() {
        if (this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("not shutting down the host, so not shutting down OS");
            return;
        }
        if (!this.services.getVirtualConfigurationManager().isPCNSInstalledOnVMA()) {
            super.doOSShutdown();
        }
    }
}

