/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.util.virtualization.hyperv.HyperVUtils;
import com.apcc.pcns.ServiceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVManagedHost
extends StandardHost {
    private static final Logger logger = LogManager.getLogger(HyperVManagedHost.class);
    private static final String logFile = ".\\psScripts\\powershellDebug.log";

    public HyperVManagedHost(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        super.initialize(iEventConsumer, iDataSource, event, shutdownState, iPermanentStorage);
        boolean bl = false;
        try {
            File file = new File(logFile);
            if (!file.exists()) {
                bl = file.createNewFile();
            }
        }
        catch (IOException iOException) {
            logger.debug("initialize() - Error creating log file ", (Throwable)iOException);
        }
        if (!bl) {
            logger.debug("initialize() - Failed to create log file.");
        }
    }

    @Override
    public void vMTasks() {
        boolean bl = false;
        int n = 0;
        if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
            bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "enable_host_maintenance");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "host_maintenance_duration");
            }
        } else {
            bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_host_maintenance");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationGlobal("host_maintenance_duration");
            }
        }
        if (bl) {
            this.hostsStartMaintenanceMode(n);
        } else {
            logger.debug("Host Maintenance is disabled");
        }
    }

    private void hostsStartMaintenanceMode(int n) {
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.size() == 0) {
            return;
        }
        String string = this.services.getVirtualConfigurationManager().getServerIP();
        if (string != null) {
            logger.debug("hostsStartMaintenanceMode HyperV, hosts:" + String.valueOf(this.virtualHostsToShutdown));
            try {
                Object object2;
                Vector<String> vector = new Vector<String>();
                for (Object object2 : this.virtualHostsToShutdown) {
                    vector.add((String)object2);
                }
                Object object3 = null;
                try {
                    object3 = this.virtualHostsToShutdown.size() == 1 ? new VirtualizationFeaturesFormatter((Integer)87, vector).format(null) : new VirtualizationFeaturesFormatter((Integer)88, vector).format(null);
                    if (object3 != null) {
                        this.services.getApplicationErrorHandler().put((String)object3);
                    }
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.error("Hyperv_HostStartingMaintenanceMode_Event: Unable to log event");
                }
                object2 = new ArrayList();
                for (Object object4 : this.virtualHostsToShutdown) {
                    if (object4 == null) continue;
                    Thread thread = new Thread(new StartMaintenanceThread(string, (String)object4, n, this.services.getHyperVUtils()));
                    thread.start();
                    object2.add(thread);
                }
                try {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object object4;
                        object4 = (Thread)iterator.next();
                        ((Thread)object4).join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.error("InterruptedException hostsStartMaintenanceMode: " + interruptedException.getMessage());
                }
            }
            catch (Exception exception) {
                logger.error("hostsStartMaintenanceMode: " + exception.getMessage());
            }
        } else {
            logger.debug("hostsStartMaintenanceMode: Unable to get Server_IP from config");
        }
    }

    @Override
    public void hostShutdown() {
        logger.debug("hostShutdown");
        boolean bl = false;
        int n = 300;
        if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
            logger.debug("hostShutdown AdvancedGroupEvent");
            bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "enable_host_shutdown");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "host_shutdown_duration");
            }
        } else {
            logger.debug("hostShutdown standard Event");
            bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_host_shutdown");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationGlobal("host_shutdown_duration");
            }
        }
        if (bl) {
            logger.debug("Shutdown enabled. Duration:{}", (Object)n);
            String string = this.services.getVirtualConfigurationManager().getServerIP();
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            for (String object : this.virtualHostsToShutdown) {
                if (object == null) continue;
                Thread thread = new Thread(new StopHostThread(string, object, n, this.services));
                thread.start();
                arrayList.add(thread);
            }
            try {
                logger.debug("Waitng for all threads to stop");
                for (Thread thread : arrayList) {
                    thread.join();
                }
                logger.debug("All threads stopped");
            }
            catch (InterruptedException interruptedException) {
                logger.error("InterruptedException hostShutdown: " + interruptedException.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        String string = this.services.getVirtualConfigurationManager().getServerIP();
        List<Object> list = new ArrayList();
        if (string != null) {
            logger.debug("performStartup(): virtualHostsToShutdown {}", (Object)this.virtualHostsToShutdown);
            list = this.hostsStopMaintenanceMode(this.virtualHostsToShutdown, string);
        } else {
            logger.debug("performStartup: Unable to get Server_IP from config");
        }
    }

    public List<String> hostsStopMaintenanceMode(Set<String> set, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        logger.debug("hostsStopMaintenanceMode HyperV: hostSet {}", set);
        try {
            for (String string2 : set) {
                if (string2 == null || this.theState.checkIfCriticalEventActive(string2)) continue;
                logger.debug("hostsStopMaintenanceMode: " + string2);
                if (this.virtualisationStatusStore.isHostLockedForShutdown(string2)) {
                    logger.debug("Host locked for shutdown, cancelling stop maintenance: " + string2);
                    continue;
                }
                if (!this.services.getHyperVUtils().hostStopMaintenanceMode(string, string2)) continue;
                this.virtualisationStatusStore.clearHostForShutdown(string2);
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            logger.error("hostsStopMaintenanceMode: {}", (Throwable)exception);
        }
        logger.debug("hostsStopMaintenanceMode() - end.  hostSet {}, recoveredHosts: {}", set, arrayList);
        return arrayList;
    }

    @Override
    public void pcnsHostShutdown() {
        logger.debug("pcnsHostShutdown");
        super.pcnsHostShutdown();
        for (String string : this.virtualHostsToShutdown) {
            if (this.services.getVirtualConfigurationManager().isCriticalHost(this.theState, string)) continue;
            this.virtualisationStatusStore.unlockHostForShutdown(string);
        }
    }

    private static class StartMaintenanceThread
    implements Runnable {
        private String VMMServer;
        private String hostName;
        private int duration;
        private HyperVUtils hyperVUtils;

        public StartMaintenanceThread(String string, String string2, int n, @NonNull HyperVUtils hyperVUtils) {
            if (hyperVUtils == null) {
                throw new IllegalArgumentException("hyperVUtils is marked non-null but is null");
            }
            this.VMMServer = string;
            this.hostName = string2;
            this.duration = n;
            this.hyperVUtils = hyperVUtils;
        }

        @Override
        public void run() {
            this.hyperVUtils.hostStartMaintenanceMode(this.VMMServer, this.hostName, this.duration);
        }
    }

    private static class StopHostThread
    implements Runnable {
        private String VMMServer;
        private String hostName;
        private int duration;
        private ServiceManager services;

        public StopHostThread(String string, String string2, int n, @NonNull ServiceManager serviceManager) {
            if (serviceManager == null) {
                throw new IllegalArgumentException("services is marked non-null but is null");
            }
            this.VMMServer = string;
            this.hostName = string2;
            this.duration = n;
            this.services = serviceManager;
        }

        @Override
        public void run() {
            logger.debug("StopHostThread.run()");
            this.services.getVirtualLoggingUtils().logTargetHostShutdownEvent(this.hostName);
            this.services.getHyperVUtils().stopHost(this.VMMServer, this.hostName, this.duration);
            logger.debug("StopHostThread.run() end");
        }
    }
}

