/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVMigrationPriorityGroup {
    private static final Logger logger = LogManager.getLogger(HyperVMigrationPriorityGroup.class);
    private static final String SCRIPT_NAME = ".\\psScripts\\LiveMigrateVMs.ps1";
    private static final String SCRIPT_ARG_DURATION = "-duration";
    private static final String SCRIPT_ARG_VM_NAMES = "-VMNames";
    private static final int ADDITIONAL_WAIT_TIME = 2;
    private Map<Integer, Integer> errorStatusCount = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> errorCodeToEventCodeMap;
    private final ServiceManager services;
    private final List<PrioritizedVM> vmList;
    private final boolean isPrioritizationEnabled;
    private final VMPrioritizationDurations durations;
    private final int unPrioritizedDuration;

    public HyperVMigrationPriorityGroup(ServiceManager serviceManager, int n) {
        this.errorStatusCount.put(115, 0);
        this.errorStatusCount.put(117, 0);
        this.errorStatusCount.put(102, 0);
        this.errorStatusCount.put(116, 0);
        this.errorStatusCount.put(100, 0);
        this.errorCodeToEventCodeMap = Map.of(100, 107, 117, 110, 102, 105, 116, 106, 115, 101);
        this.services = serviceManager;
        this.isPrioritizationEnabled = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
        this.unPrioritizedDuration = n;
        if (this.isPrioritizationEnabled) {
            this.vmList = this.services.getHyperVUtils().getPrioritizationVMs();
            if (this.vmList.isEmpty()) {
                logger.info("HyperVMigrationPriorityGroup() - No running VMs were found");
            } else {
                logger.info("HyperVMigrationPriorityGroup() - Found {} running VMs", (Object)this.vmList.size());
            }
        } else {
            this.vmList = Collections.emptyList();
        }
        this.durations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION);
    }

    public void run() {
        logger.debug("run() - start");
        this.errorStatusCount.replaceAll((n, n2) -> 0);
        if (this.isPrioritizationEnabled) {
            List<VMPriority> list = this.services.getVMPrioritizationUtils().getPriorities();
            ListIterator<VMPriority> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                VMPriority vMPriority = listIterator.previous();
                logger.info("run() - running live migration for priority group: {}", (Object)vMPriority);
                int n3 = this.getDurationForPriority(vMPriority);
                if (n3 == 0) {
                    logger.info("run() - duration is 0, no VM migration for priority: {}", (Object)vMPriority);
                    continue;
                }
                String string = this.generatePSScriptArgs(vMPriority);
                this.runMigration(n3, string, vMPriority.toString());
            }
        } else {
            logger.info("run() - VMPrioritization not enabled - migrating all VMs");
            String string = this.generatePSScriptArgs(null);
            this.runMigration(this.unPrioritizedDuration, string, "unPrioritized");
        }
        this.logVMMigrationEvents();
    }

    private void runMigration(int n, String string, String string2) {
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        if (this.isPrioritizationEnabled && StringUtils.isBlank((CharSequence)string)) {
            logger.debug("run() - no VMs to migrate for priority group: {}", (Object)string2);
            this.incrementErrorStatusCount(117);
            logger.info("run() - waiting for the rest of the duration to elapse");
            countdownTimer.sleep();
            return;
        }
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> {
            logger.debug("run() - calling migration script {} with args {} for priority group {}", (Object)SCRIPT_NAME, (Object)string, (Object)string2);
            return this.services.getHyperVUtils().executeScript(SCRIPT_NAME, string, n);
        });
        try {
            Integer n2 = completableFuture.get(n + 2, TimeUnit.SECONDS);
            logger.debug("run() - migration script returned code: {}", (Object)n2);
            this.incrementErrorStatusCount(n2);
        }
        catch (TimeoutException timeoutException) {
            logger.error("run() - timed out while migrating the Hyper-V VMs: {}", (Throwable)timeoutException);
            this.incrementErrorStatusCount(100);
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("run() - failed to execute the Hyper-V migration script: {}", (Throwable)exception);
        }
        logger.info("run() - waiting for the rest of the duration to elapse");
        countdownTimer.sleep();
        logger.info("run() - migration completed for priority group: {}", (Object)string2);
    }

    private int getDurationForPriority(VMPriority vMPriority) {
        if (!this.isPrioritizationEnabled) {
            return this.unPrioritizedDuration;
        }
        return this.durations.getDuration(vMPriority);
    }

    private String generatePSScriptArgs(VMPriority vMPriority) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(SCRIPT_ARG_DURATION).append(" ").append(this.getDurationForPriority(vMPriority));
        if (!this.isPrioritizationEnabled) {
            return stringBuilder.toString();
        }
        List<String> list = this.services.getHyperVUtils().filterVMsByPriority(this.vmList, vMPriority);
        if (!list.isEmpty()) {
            stringBuilder.append(" ").append(SCRIPT_ARG_VM_NAMES).append(" ").append("\\\"").append(String.join((CharSequence)",", list)).append("\\\"");
        } else {
            stringBuilder.setLength(0);
        }
        return stringBuilder.toString();
    }

    private void logVMMigrationEvents() {
        this.errorStatusCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> {
            Integer n = this.errorCodeToEventCodeMap.get(entry.getKey());
            this.logApplicationEvent(n);
        });
        int n = this.errorStatusCount.values().stream().mapToInt(Integer::intValue).sum();
        if (n == 0) {
            this.logApplicationEvent(108);
        }
    }

    private void logApplicationEvent(Integer n) {
        try {
            String string = new VirtualizationFeaturesFormatter(n).format(null);
            this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.debug("unable to log event");
        }
    }

    private void incrementErrorStatusCount(Integer n3) {
        if (!this.errorStatusCount.containsKey(n3)) {
            logger.error("incrementErrorStatusCount() - unknown status code: {}", (Object)n3);
        } else {
            this.errorStatusCount.compute(n3, (n, n2) -> n2 + 1);
        }
    }
}

