/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVShutdownPriorityGroup {
    private static final Logger logger = LogManager.getLogger(HyperVShutdownPriorityGroup.class);
    private static final String VM_SHUTDOWN_SCRIPT = ".\\psScripts\\shutdownvm.ps1";
    private static final int ADDITIONAL_WAIT_TIME = 2;
    private ServiceManager services;
    private List<PrioritizedVM> vmList;
    private boolean isPrioritizationEnabled;
    private VMPrioritizationDurations durations;
    private int unPrioritizedDuration;
    private CountDownLatch latch;

    public HyperVShutdownPriorityGroup(ServiceManager serviceManager, int n) {
        this.services = serviceManager;
        this.isPrioritizationEnabled = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
        this.unPrioritizedDuration = n;
        if (this.isPrioritizationEnabled) {
            this.vmList = this.services.getHyperVUtils().getPrioritizationVMs();
            if (this.vmList.isEmpty()) {
                logger.info("HyperVShutdownPriorityGroup() - No running VMs were found");
            } else {
                logger.info("HyperVShutdownPriorityGroup() - Found {} running VMs", (Object)this.vmList.size());
            }
        } else {
            this.vmList = new ArrayList<PrioritizedVM>();
        }
        this.durations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN);
    }

    public void run() {
        logger.debug("run() - start");
        if (this.isPrioritizationEnabled) {
            List<VMPriority> list = this.services.getVMPrioritizationUtils().getPriorities();
            for (VMPriority vMPriority : list) {
                logger.info("run() - running shutdown for priority group: {}", (Object)vMPriority);
                int n = this.getDurationForPriority(vMPriority);
                if (n == 0) {
                    logger.info("run() - duration is 0, no VM shutdown for priority: {}", (Object)vMPriority);
                    continue;
                }
                String string = this.generatePSScriptArgs(vMPriority);
                this.runShutdown(n, string, vMPriority.toString(), this.latch);
            }
        } else {
            logger.info("run() - VMPrioritization not enabled - running shutdown for all VMs");
            this.runShutdown(this.unPrioritizedDuration, null, "unPrioritized", this.latch);
        }
    }

    private void runShutdown(int n, String string, String string2, CountDownLatch countDownLatch) {
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        if (this.isPrioritizationEnabled && StringUtils.isBlank((CharSequence)string)) {
            logger.debug("run() - no VMs to shut down for priority group: {}", (Object)string2);
            logger.info("run() - waiting for the rest of the shutdown duration to elapse");
            countdownTimer.sleep();
            return;
        }
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> {
            logger.debug("run() - calling shutdown script {} with args {} for priority group {}", (Object)VM_SHUTDOWN_SCRIPT, (Object)string, (Object)string2);
            int n2 = this.services.getHyperVUtils().executeScript(VM_SHUTDOWN_SCRIPT, string, n);
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
            return n2;
        });
        try {
            Integer n2 = completableFuture.get(n + 2, TimeUnit.SECONDS);
            if (n2 != 0) {
                logger.info("run() - shutdown task completed for priority group: {}", (Object)string2);
            } else {
                logger.error("run() - shutdown task not completed for priority group: {}", (Object)string2);
            }
        }
        catch (TimeoutException timeoutException) {
            logger.error("run() - timed out while shutting down the Hyper-V VMs: {}", (Throwable)timeoutException);
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("run() - failed to execute the Hyper-V shutdown script: {}", (Throwable)exception);
        }
        logger.info("run() - waiting for the rest of the shutdown duration to elapse");
        countdownTimer.sleep();
        logger.info("run() - shutdown completed for priority group: {}", (Object)string2);
    }

    private int getDurationForPriority(VMPriority vMPriority) {
        if (!this.isPrioritizationEnabled) {
            return this.unPrioritizedDuration;
        }
        return this.durations.getDuration(vMPriority);
    }

    private String generatePSScriptArgs(VMPriority vMPriority) {
        if (!this.isPrioritizationEnabled) {
            return null;
        }
        List<String> list = this.services.getHyperVUtils().filterVMsByPriority(this.vmList, vMPriority);
        if (!list.isEmpty()) {
            return " -shutdownVMNames \\\"" + String.join((CharSequence)",", list) + "\\\"";
        }
        return "";
    }

    @Generated
    public void setLatch(CountDownLatch countDownLatch) {
        this.latch = countDownLatch;
    }
}

