/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.hosts.HyperVMigrationPriorityGroup;
import com.apcc.m11.components.shutdowner.hosts.HyperVUnmanagedStandaloneHost;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.pcns.ServiceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVUnmanagedClusterHost
extends HyperVUnmanagedStandaloneHost {
    private static final Logger logger = LogManager.getLogger(HyperVUnmanagedClusterHost.class);
    private static final String suspendScript = ".\\psScripts\\suspend-host.ps1";
    private static final String resumeScript = ".\\psScripts\\Resume-host.ps1";
    private static final String stopClusterScript = ".\\psScripts\\Stop-cluster.ps1";
    private static final String startClusterScript = ".\\psScripts\\Start-cluster.ps1";
    private static final String clusterTestScript = ".\\psScripts\\clustertest.ps1";

    public HyperVUnmanagedClusterHost(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        logger.debug("initialize");
        super.initialize(iEventConsumer, iDataSource, event, shutdownState, iPermanentStorage);
        if (event != null) {
            if (this.isPerformHyperVUnmanagedVirtShutdown() && HyperVUnmanagedClusterHost.isClusterServiceRunning()) {
                String string = null;
                try {
                    string = new VirtualizationFeaturesFormatter(83).format(null);
                    this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.debug("unable to log msg");
                }
                logger.debug("Suspending Host");
                if (this.services.getHyperVUtils().executeScript(suspendScript, null, -1) == 1) {
                    logger.debug("Host status changed to paused");
                    shutdownState.clearResumeHostCompleted();
                } else {
                    logger.debug("Unabled to put the host in paused state");
                    try {
                        string = new VirtualizationFeaturesFormatter(103).format(null);
                        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    }
                    catch (FormatterException | UnsupportedLocaleException throwable) {
                        logger.debug("unable to log msg");
                    }
                }
            } else {
                logger.debug("Cluster not running - Cluster Service is not suspended");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vMTasks() {
        logger.debug("vmTasks");
        Object object = VMLock;
        synchronized (object) {
            logger.debug("vmTasks: Got Lock");
            if (!this.isPerformHyperVUnmanagedVirtShutdown()) {
                logger.debug("no Virtualisation Shutdown needed");
                return;
            }
            this.vmMigrate();
            super.VMShutdown();
        }
    }

    public void vmMigrate() {
        logger.debug("vmMigrate");
        boolean bl = false;
        int n = 0;
        if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
            bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "enable_guest_vm_migration");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "guest_vm_migration_duration");
            }
        } else {
            bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_migration");
            if (bl) {
                n = this.services.getVirtualConfigurationManager().getDurationGlobal("guest_vm_migration_duration");
            }
        }
        if (bl) {
            try {
                String string = new VirtualizationFeaturesFormatter(80).format(null);
                this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.debug("unable to log event");
            }
            HyperVMigrationPriorityGroup hyperVMigrationPriorityGroup = new HyperVMigrationPriorityGroup(this.services, n);
            hyperVMigrationPriorityGroup.run();
        } else {
            logger.debug("Live Migration is disabled");
        }
    }

    @Override
    public void pcnsOSShutdown() {
        this.theState.clearHostsToShutdown("localhost");
        for (String string : this.virtualHostsToShutdown) {
            if (this.services.getVirtualConfigurationManager().isCriticalHost(this.theState, string)) continue;
            this.virtualisationStatusStore.unlockHostForShutdown(string);
        }
        if (!this.isPerformHyperVUnmanagedVirtShutdown()) {
            logger.debug("no Virtualisation Shutdown needed");
            return;
        }
        if (this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_hvstopcluster")) {
            this.stopCluster();
        }
        super.doOSShutdown();
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup");
        String string = "";
        if (this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_hvstopcluster")) {
            this.startCluster();
        }
        if (HyperVUnmanagedClusterHost.isClusterServiceRunning()) {
            if (!this.theState.isResumeHostCompleted()) {
                logger.debug("Resuming cluster host");
                int n = this.services.getHyperVUtils().executeScript(resumeScript, null, -1);
                if (n == 0) {
                    try {
                        string = new VirtualizationFeaturesFormatter(85).format(null);
                        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    }
                    catch (FormatterException | UnsupportedLocaleException throwable) {
                        // empty catch block
                    }
                    logger.debug("Unabled to resume the host, cannot start VMs");
                    return;
                }
                logger.debug("Host status changed to UP");
                try {
                    if (n != 109) {
                        string = new VirtualizationFeaturesFormatter(84).format(null);
                        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    }
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    // empty catch block
                }
                this.theState.setResumeHostCompleted();
            }
        } else {
            logger.debug("Cluster not running - Cluster node not resumed");
        }
        super.performStartup(preConditionsSynchronizer);
    }

    private void resumeClusterNode() {
        if (!HyperVUnmanagedClusterHost.isClusterServiceRunning()) {
            logger.debug("resumeClusterNode - Cluster service is not running.  No resume Cluster Node");
            return;
        }
        if (!this.theState.isResumeHostCompleted()) {
            if (this.services.getHyperVUtils().executeScript(resumeScript, null, -1) == 1) {
                this.theState.setResumeHostCompleted();
                try {
                    String string = new VirtualizationFeaturesFormatter(84).format(null);
                    if (string != null && !string.trim().equals("")) {
                        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot log event ", (Throwable)exception);
                }
            } else {
                try {
                    String string = new VirtualizationFeaturesFormatter(104).format(null);
                    if (string != null && !string.trim().equals("")) {
                        this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot log event ", (Throwable)exception);
                }
            }
        }
    }

    private void stopCluster() {
        logger.warn("HyperV Unmanaged Cluster Host:  Stopping Cluster.");
        if (!HyperVUnmanagedClusterHost.isClusterServiceRunning()) {
            logger.debug("Cluster is not Running no need to stop");
            return;
        }
        try {
            String string = new VirtualizationFeaturesFormatter(112).format(null);
            if (string != null && !string.trim().equals("")) {
                this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot log event ", (Throwable)exception);
        }
        int n = this.services.getVirtualConfigurationManager().getDurationGlobal("hvstopcluster_duration");
        if (this.services.getHyperVUtils().executeScript(stopClusterScript, null, n) == 101) {
            logger.info("Stop Cluster Succeeded");
        } else {
            try {
                String string = new VirtualizationFeaturesFormatter(113).format(null);
                if (string != null && !string.trim().equals("")) {
                    this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                }
            }
            catch (Exception exception) {
                logger.error("Cannot log event ", (Throwable)exception);
            }
        }
    }

    private void startCluster() {
        logger.warn("HyperV Unmanaged Cluster Host:  Starting Cluster.");
        try {
            String string = new VirtualizationFeaturesFormatter(114).format(null);
            if (string != null && !string.trim().equals("")) {
                this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot log event ", (Throwable)exception);
        }
        int n = this.services.getVirtualConfigurationManager().getDurationGlobal("hvstartcluster_duration");
        if (this.services.getHyperVUtils().executeScript(startClusterScript, null, n) == 101) {
            logger.info("Cluster Start Succeeded");
        } else {
            try {
                String string = new VirtualizationFeaturesFormatter(115).format(null);
                if (string != null && !string.trim().equals("")) {
                    this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                }
            }
            catch (Exception exception) {
                logger.error("Cannot log event ", (Throwable)exception);
            }
        }
    }

    public static boolean isClusterServiceInstalled() {
        int n = ServiceManager.getInstance().getHyperVUtils().executeScript(clusterTestScript, null, -1);
        return n != 120;
    }

    public static boolean isClusterServiceRunning() {
        int n = ServiceManager.getInstance().getHyperVUtils().executeScript(clusterTestScript, null, -1);
        return n == 101;
    }
}

