/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.hosts.HyperVShutdownPriorityGroup;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVUnmanagedStandaloneHost
extends StandardHost {
    private static final Logger logger = LogManager.getLogger(HyperVUnmanagedStandaloneHost.class);
    private static final String logFile = ".\\psScripts\\powershellDebug.log";
    private static final String vmStartupScript = ".\\psScripts\\startvm.ps1";
    private boolean isPrioritizationEnabled;
    private List<PrioritizedVM> vmList;
    private VMPrioritizationDurations durations;
    private int vmStartupDuration = 0;
    private int vmStartupDelayDuration = 0;
    protected static Object VMLock = new Object();

    public HyperVUnmanagedStandaloneHost(ServiceManager serviceManager) {
        super(serviceManager);
        this.durations = serviceManager.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
    }

    @Override
    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        Object object;
        logger.debug("initialize");
        if (event != null) {
            if (shutdownState.isHypervVirtualizationStartupInProgress()) {
                object = "Hyperv_VirtualizationStartupInProgress";
                try {
                    object = new VirtualizationFeaturesFormatter(86).format(null);
                }
                catch (FormatterException formatterException) {
                }
                catch (UnsupportedLocaleException unsupportedLocaleException) {
                    // empty catch block
                }
                this.services.getConfigurationManager().getApplicationErrorHandler().put((String)object);
                while (shutdownState.isHypervVirtualizationStartupInProgress()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.virtualisationStatusStore.lockHostForShutdown("localhost");
        }
        super.initialize(iEventConsumer, iDataSource, event, shutdownState, iPermanentStorage);
        if (this.isPerformHyperVUnmanagedVirtShutdown()) {
            try {
                object = new File(logFile);
                boolean bl = false;
                if (!((File)object).exists()) {
                    bl = ((File)object).createNewFile();
                }
                if (!bl) {
                    logger.debug("initialize() - Failed to create log file.");
                }
            }
            catch (IOException iOException) {
                logger.debug("initialize() - Error creating log file ", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vMTasks() {
        logger.debug("vmTasks");
        Object object = VMLock;
        synchronized (object) {
            logger.debug("vmTasks: Got Lock");
            if (!this.isPerformHyperVUnmanagedVirtShutdown()) {
                logger.debug("no Virtualisation Shutdown needed");
                return;
            }
            this.VMShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void VMShutdown() {
        block9: {
            logger.debug("VMShutdown");
            boolean bl = false;
            int n = 0;
            if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
                bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "enable_guest_vm_vapp_shutdown");
                if (bl) {
                    n = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "guest_vm_vapp_shutdown_duration");
                }
            } else {
                bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_vapp_shutdown");
                if (bl) {
                    n = this.services.getVirtualConfigurationManager().getDurationGlobal("guest_vm_vapp_shutdown_duration");
                }
            }
            try {
                if (bl) {
                    String string = new VirtualizationFeaturesFormatter(81).format(null);
                    this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                    this.virtualisationStatusStore.initialiseHypervKeys();
                    HyperVShutdownPriorityGroup hyperVShutdownPriorityGroup = new HyperVShutdownPriorityGroup(this.services, n);
                    hyperVShutdownPriorityGroup.run();
                    break block9;
                }
                logger.debug("VM Shutdown is disabled");
            }
            catch (Exception exception) {
                logger.error("Failed to execute Virtualization operations ", (Throwable)exception);
            }
        }
    }

    @Override
    public void pcnsOSShutdown() {
        this.theState.clearHostsToShutdown("localhost");
        if (!this.isPerformHyperVUnmanagedVirtShutdown()) {
            logger.debug("no Virtualisation Shutdown needed");
            return;
        }
        super.doOSShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        try {
            block28: {
                logger.debug("performStartup");
                boolean bl = false;
                this.isPrioritizationEnabled = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
                logger.debug("performStartup isPrioritizationEnabled=" + this.isPrioritizationEnabled);
                if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
                    bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "enable_guest_vm_vapp_startup");
                    if (bl) {
                        this.vmStartupDuration = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "guest_vm_vapp_startup_duration");
                        this.vmStartupDelayDuration = this.services.getVirtualConfigurationManager().getDurationAdvanced(this.ups_setup_idx, "vm_startup_delay_duration");
                    }
                } else {
                    bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_vapp_startup");
                    if (bl) {
                        this.vmStartupDuration = this.services.getVirtualConfigurationManager().getDurationGlobal("guest_vm_vapp_startup_duration");
                        this.vmStartupDelayDuration = this.services.getVirtualConfigurationManager().getDurationGlobal("vm_startup_delay_duration");
                    }
                }
                logger.debug("Check if startup is required: enabled=" + bl);
                if (bl) {
                    String string = this.virtualisationStatusStore.getProperty("ClusterVMList");
                    String string2 = this.virtualisationStatusStore.getProperty("NonClusterVMList");
                    try {
                        String string3;
                        logger.debug("do startup");
                        this.theState.setHypervVirtualizationStartup();
                        if (this.isPrioritizationEnabled) {
                            logger.debug("performStartup - vm prioritization enabled");
                            try {
                                string3 = new VirtualizationFeaturesFormatter(82).format(null);
                                this.services.getConfigurationManager().getApplicationErrorHandler().put(string3);
                            }
                            catch (FormatterException | UnsupportedLocaleException throwable) {
                                // empty catch block
                            }
                            this.runVMPrioritizationStartup();
                        } else if ((string == null || string.trim().equals("")) && (string2 == null || string2.trim().equals(""))) {
                            logger.debug("No startup entries in file");
                        } else {
                            try {
                                string3 = new VirtualizationFeaturesFormatter(82).format(null);
                                this.services.getConfigurationManager().getApplicationErrorHandler().put(string3);
                            }
                            catch (FormatterException | UnsupportedLocaleException throwable) {
                                // empty catch block
                            }
                            logger.debug("run startup script:.\\psScripts\\startvm.ps1");
                            if (this.services.getHyperVUtils().executeScript(vmStartupScript, Integer.toString(this.vmStartupDelayDuration) + " false", this.vmStartupDuration) != 0) {
                                logger.debug("VM Start task executed");
                            } else {
                                logger.debug("VM Start task failed");
                            }
                        }
                        string3 = this.virtualisationStatusStore.getProperty("Retry_ClusterVMList");
                        String string4 = this.virtualisationStatusStore.getProperty("Retry_NonClusterVMList");
                        if ((string3 == null || string3.trim().equals("")) && (string4 == null || string4.trim().equals(""))) {
                            logger.debug("No Reattempts needed");
                            break block28;
                        }
                        logger.debug("Reattempts needed");
                        if (this.theState.getCriticalShutdownTimersCount() != 0) {
                            logger.info("Host is critical again, not re-attempting startup");
                        } else {
                            logger.info("Wait 2 minutes before re-attempt");
                            new CountdownTimer(2L, TimeUnit.MINUTES).sleep();
                        }
                        if (this.theState.getCriticalShutdownTimersCount() != 0) {
                            logger.info("Host is critical again, not re-attempting startup");
                            break block28;
                        }
                        try {
                            String string5 = new VirtualizationFeaturesFormatter(94).format(null);
                            this.services.getConfigurationManager().getApplicationErrorHandler().put(string5);
                        }
                        catch (FormatterException | UnsupportedLocaleException throwable) {
                            // empty catch block
                        }
                        logger.debug("run startup script:.\\psScripts\\startvm.ps1");
                        if (this.services.getHyperVUtils().executeScript(vmStartupScript, Integer.toString(this.vmStartupDelayDuration) + " true", this.vmStartupDuration) != 0) {
                            logger.debug("VM Start task executed");
                        } else {
                            logger.debug("VM Start task failed");
                        }
                    }
                    finally {
                        this.theState.clearHypervVirtualizationStartup();
                    }
                }
            }
            this.virtualisationStatusStore.clearHostForShutdown("localhost");
        }
        catch (Exception exception) {
            logger.error("Error during startup", (Throwable)exception);
        }
        logger.debug("performStartup() - end");
    }

    private void runVMPrioritizationStartup() {
        logger.debug("runVMPrioritizationStartup() - start");
        this.durations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
        List<VMPriority> list = this.services.getVMPrioritizationUtils().getPriorities();
        ListIterator<VMPriority> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            VMPriority vMPriority = listIterator.previous();
            logger.info("runVMPrioritizationStartup() - running startup for priority group: {}", (Object)vMPriority);
            int n = this.getDurationForPriority(vMPriority);
            if (n == 0) {
                logger.info("runVMPrioritizationStartup() - duration is 0, no VM startup for priority: {}", (Object)vMPriority);
                continue;
            }
            String string = this.generatePSScriptArgs(vMPriority);
            this.services.getHyperVUtils().executeScript(vmStartupScript, string, n);
        }
    }

    private int getDurationForPriority(VMPriority vMPriority) {
        return this.durations.getDuration(vMPriority);
    }

    private String generatePSScriptArgs(VMPriority vMPriority) {
        this.vmList = this.services.getHyperVUtils().getPrioritizationVMs();
        List<String> list = this.services.getHyperVUtils().filterVMsByPriority(this.vmList, vMPriority);
        if (!list.isEmpty()) {
            return Integer.toString(this.vmStartupDelayDuration) + " false  -startupVMNames \\\"" + String.join((CharSequence)",", list) + "\\\"";
        }
        return "";
    }
}

