/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.webserver.util.virtualization.hyperflex.HyperflexUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.hyperflex.ClusterState;
import com.apcc.pcns.hyperflex.HyperflexConnection;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineToolsRunningStatus;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperflexHost
extends ESXManagedHost {
    private static final Logger logger = LogManager.getLogger(HyperflexHost.class);
    private HyperflexConnection hyperflexConnection = null;
    private HyperflexUtils hyperflexUtils = null;
    private String clusterUuid = null;

    public HyperflexHost(@NonNull ServiceManager serviceManager) {
        super(serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.hyperflexUtils = serviceManager.getHyperflexUtils();
        this.hyperflexConnection = serviceManager.getHyperflexConnectionManager().getConnection(this.hyperflexUtils.loadHyperflexDetails());
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            return;
        }
        if (!this.services.getVirtualConfigurationManager().isHyperflex()) {
            logger.debug("performClusterStopOps() - no HyperFlex support, skipping cluster operations");
            return;
        }
        if (this.virtualisationStatusStore.isHyperflexClusterStopped()) {
            logger.debug("performClusterStopOps() - HyperFlex cluster is already stopped, checking CVMs and skipping cluster stop operation");
            if (this.anyCvmsOn()) {
                logger.debug("performClusterStopOps() - HyperFlex cluster already stopped, but CVMs are on, waiting CVM startup duration before shutting them down");
                int n = this.hyperflexUtils.getCvmStartupDuration(this.isAdvancedMode, this.ups_setup_idx);
                new CountdownTimer(n, TimeUnit.SECONDS).sleep();
                this.shutdownCVMs();
            }
            return;
        }
        if (this.theState.isHyperflexClusterStopInProgress()) {
            logger.debug("performClusterStopOps() - HyperFlex cluster already stopping, waiting cluster stop duration");
            int n = this.hyperflexUtils.getClusterShutdownDuration(this.isAdvancedMode, this.ups_setup_idx);
            new CountdownTimer(n, TimeUnit.SECONDS).sleep();
            if (this.anyCvmsOn()) {
                logger.debug("performClusterStopOps() - HyperFlex cluster already stopping, shutting down any CVMs still powered on");
                this.shutdownCVMs();
            }
            return;
        }
        this.theState.setHyperflexClusterStop();
        this.stopCluster();
        this.virtualisationStatusStore.setHyperflexClusterStopped();
        this.shutdownCVMs();
        this.theState.clearHyperflexClusterStop();
        logger.debug("performClusterStopOps() - end");
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup() - start");
        this.performStartupSteps();
        this.checkDrsSettings();
        if (this.virtualisationStatusStore.isHyperflexClusterStopped() || this.hyperflexUtils.isClusterLocked()) {
            logger.debug("performStartup() - clutser is stopped: {} or locked: {}, not handling vCLS or HA", (Object)this.virtualisationStatusStore.isHyperflexClusterStopped(), (Object)this.hyperflexUtils.isClusterLocked());
            return;
        }
        this.handleVCLSAndHAStartup();
        logger.debug("performStartup() - end");
    }

    void performStartupSteps() {
        logger.debug("performStartupSteps() - start");
        this.getHostsOutOfMaintenanceMode(this.virtualHostsToShutdown);
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            if (this.virtualisationStatusStore.isHyperflexClusterStopped()) {
                logger.debug("performStartupSteps() - only HyperFlex cluster to start");
                try {
                    this.performClusterStartup();
                }
                catch (IllegalStateException illegalStateException) {
                    logger.warn("performStartupSteps() - cluster not in correct state for proceeding with startup: {}", (Throwable)illegalStateException);
                    return;
                }
                logger.debug("performStartupSteps() - only HyperFlex cluster started, performStartup() end");
            } else {
                logger.debug("performStartupSteps() - no hosts or cluster to start");
            }
        } else {
            logger.debug("performStartupSteps() - hosts: {}", (Object)this.virtualHostsToShutdown);
            try {
                this.performClusterStartup();
            }
            catch (IllegalStateException illegalStateException) {
                logger.warn("performStartupSteps() - cluster not in correct state for proceeding with startup: {}", (Throwable)illegalStateException);
                return;
            }
            if (!this.handleVcsaRequirement()) {
                logger.debug("performStartupSteps() - VCSA handling not successful");
                return;
            }
            LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getVMAndVAppHostList();
            if (linkedHashSet.isEmpty()) {
                logger.debug("performStartupSteps() - no VM/vApps found for startup");
                return;
            }
            if (!this.canWePerformVMAndVAppStartup(linkedHashSet)) {
                logger.debug("performStartupSteps() - VM/vApp startup can't be performed yet");
                return;
            }
            this.doVMVAppStartupForAllHosts();
        }
        logger.debug("performStartupSteps() - end");
    }

    private void performClusterStartup() throws IllegalStateException {
        logger.debug("performClusterStartup() - start");
        if (this.theState.isHyperflexClusterStopInProgress()) {
            logger.error("performClusterStartup() - cluster stop is currently in progress, cannot proceed with startup");
            throw new IllegalStateException("Cluster stop in progress, not starting cluster");
        }
        this.clusterUuid = this.hyperflexUtils.getClusterUuidFromConfig();
        if (!this.virtualisationStatusStore.isHyperflexClusterStopped()) {
            logger.debug("performClusterStartup() - cluster was not stopped previously, no need to start it");
            return;
        }
        if (!this.isClusterStartNeeded()) {
            logger.debug("performClusterStartup() - cluster already running, no need to start it");
            this.virtualisationStatusStore.clearHyperflexClusterStopped();
            this.hyperflexUtils.logClusterAlreadyUpEvent();
            return;
        }
        this.canClusterBeStarted();
        Map<VirtualMachine, ServiceInstance> map = this.getCVMsToPowerOn();
        boolean bl = this.getCVMsToPowerOn().isEmpty();
        if (!bl && this.hyperflexUtils.isCvmStartupEnabled(this.ups_setup_idx)) {
            try {
                this.powerOnCVMs(map);
            }
            catch (IllegalStateException illegalStateException) {
                logger.error("performClusterStartup() - unable to start Controller VMs");
                throw illegalStateException;
            }
        } else if (!this.hyperflexUtils.isCvmStartupEnabled(this.ups_setup_idx)) {
            logger.debug("performClusterStartup() - Controller VM startup not enabled");
        } else {
            logger.debug("performClusterStartup() - Controller VMs already up");
        }
        int n = this.hyperflexUtils.getCvmStartupDuration(this.isAdvancedMode, this.ups_setup_idx);
        try {
            this.hyperflexUtils.logCVMStartupWaitEvent();
            TimeUnit.SECONDS.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            logger.warn("performClusterStartup() - failed to wait for Controller VM start up: {}", (Throwable)interruptedException);
        }
        bl = this.getCVMsToPowerOn().isEmpty();
        if (!this.canClusterBeStarted() || !bl) {
            logger.error("performClusterStartup() - failed to start Controller VMs, cannot proceed with startup");
            throw new IllegalStateException("Failed to start CVM");
        }
        this.startCluster();
        this.virtualisationStatusStore.clearHyperflexClusterStopped();
        logger.debug("performClusterStartup() - end");
    }

    private boolean canClusterBeStarted() throws IllegalStateException {
        if (this.hyperflexUtils.isClusterLocked()) {
            logger.debug("canStartCluster() - cluster is locked for shutdown");
            throw new IllegalStateException("Cluster locked for shutdown, cannot start cluster.");
        }
        if (this.hyperflexUtils.hasClusterActiveCriticalEvent(this.theState)) {
            logger.debug("canStartCluster() - cluster has active critical event");
            throw new IllegalStateException("Cluster has active critical event, cannot start cluster.");
        }
        if (this.hyperflexUtils.isClusterHostUnhealthy()) {
            logger.debug("canStartCluster() - cluster has unhealthy hosts with Controller VMs");
            throw new IllegalStateException("Cluster has unhealthy hosts with Controller VMs, cannot start cluster.");
        }
        return true;
    }

    private void shutdownCVMs() {
        logger.debug("shutdownCVMs() - start");
        int n = this.hyperflexUtils.getCvmShutdownDuration(this.isAdvancedMode, this.ups_setup_idx);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.shutdownOrPowerOffCvms());
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("shutdownCvms() - timed out while shutting down HyperFlex Controller VMs");
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("shutdownCvms() - failed to shut down HyperFlex Controller VMs: {}", (Throwable)exception);
        }
        logger.debug("shutdownCvms() - waiting rest of Controller VM shutdown duration");
        countdownTimer.sleep();
        logger.debug("shutdownCvms() - end");
    }

    private void stopCluster() {
        logger.debug("stopCluster() - start, performing HyperFlex cluster stop");
        int n = this.hyperflexUtils.getClusterShutdownDuration(this.isAdvancedMode, this.ups_setup_idx);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.hyperflexUtils.logClusterShutdownEvent();
        this.clusterUuid = this.hyperflexUtils.getClusterUuidFromConfig();
        if (StringUtils.isBlank((CharSequence)this.clusterUuid)) {
            try {
                this.clusterUuid = this.hyperflexConnection.getClusterUuid();
            }
            catch (RemoteException remoteException) {
                logger.error("stopCluster() - failed to retrieve cluster uuid, error: {}", (Throwable)remoteException);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.clusterUuid)) {
            logger.error("stopCluster() - failed to retrieve cluster uuid, cannot stop cluster");
            this.hyperflexUtils.logClusterFailedShutdownEvent();
            logger.debug("stopCluster() - waiting rest of cluster stop duration after failed to retrieve cluster uuid");
            countdownTimer.sleep();
            return;
        }
        boolean bl = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.debug("stopCluster() - triggering cluster stop for cluster uuid {}", (Object)HyperflexHost.this.clusterUuid);
                    HyperflexHost.this.hyperflexConnection.stopCluster(HyperflexHost.this.clusterUuid);
                }
                catch (Exception exception) {
                    throw new CompletionException("Failed to stop HyperFlex cluster", exception);
                }
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> future = executorService.submit(runnable);
        try {
            future.get(n, TimeUnit.SECONDS);
            bl = true;
        }
        catch (TimeoutException timeoutException) {
            logger.error("stopCluster() - timed out while shutting down Hyperflex cluster");
            this.hyperflexUtils.logClusterShutdownTimeoutEvent();
            future.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            logger.error("stopCluster() - interrupted while waiting for cluster stop call to finish, error: ", (Throwable)interruptedException);
            future.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (CompletionException | ExecutionException exception) {
            logger.error("stopCluster() - failed to stop Hyperflex cluster: ", (Throwable)exception);
        }
        executorService.shutdownNow();
        logger.debug("stopCluster() - waiting rest of cluster stop duration");
        countdownTimer.sleep();
        if (bl) {
            logger.debug("stopCluster() - end, cluster stopped at first attempt");
            this.hyperflexUtils.logClusterShutdownSuccessEvent();
            return;
        }
        int n2 = this.hyperflexUtils.getClusterStopMaxRetries();
        int n3 = 0;
        ExecutorService executorService2 = Executors.newSingleThreadExecutor();
        while (!bl && n3 < n2) {
            this.services.getVirtualLoggingUtils().logClusterStopNotCompleteEvent();
            countdownTimer.reset();
            future = executorService2.submit(runnable);
            logger.debug("stopCluster() - stop cluster, retry number {}", (Object)(++n3));
            try {
                future.get(n, TimeUnit.SECONDS);
                bl = true;
            }
            catch (TimeoutException timeoutException) {
                logger.error("stopCluster() - timed out while shutting down Hyperflex cluster");
                future.cancel(true);
            }
            catch (InterruptedException interruptedException) {
                logger.error("stopCluster() - interrupted while waiting for cluster stop call to finish, error: ", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
            catch (CompletionException | ExecutionException exception) {
                logger.error("stopCluster() - failed to stop Hyperflex cluster: {}", (Throwable)exception);
            }
            logger.debug("stopCluster() - waiting rest of cluster stop duration");
            countdownTimer.sleep();
        }
        executorService2.shutdownNow();
        if (!bl) {
            logger.error("stopCluster() - maximum number of retries ({}) reached, cluster stop failed", (Object)n2);
            this.hyperflexUtils.logClusterFailedShutdownEvent();
        } else {
            logger.error("stopCluster() - cluster successfully stopped. ({} retries needed)", (Object)n3);
            this.hyperflexUtils.logClusterShutdownSuccessEvent();
        }
        logger.debug("stopCluster() - end");
    }

    private void shutdownOrPowerOffCvms() {
        logger.debug("shutdownOrPowerOffCvms() - start");
        Map<String, String> map = this.hyperflexUtils.getCVMsFromConfig();
        this.virtualHostsToShutdown.forEach(string -> {
            block12: {
                ServiceInstance serviceInstance;
                VirtualMachine virtualMachine = null;
                String string2 = null;
                if (map.containsKey(string)) {
                    string2 = (String)map.get(string);
                    logger.debug("shutdownOrPowerOffCvms() - Controller VM for host {} found in INI, retrieving VM entity for it", string);
                    serviceInstance = this.vmwareConnection.getServiceInstance((String)string);
                    if (serviceInstance == null) {
                        logger.error("shutdownOrPowerOffCvms() - failed to retrieve VMWare service instance for host {}, unable to handle Controller VM {}", string, (Object)string2);
                        this.hyperflexUtils.logCVMShutdownFailEvent(string2);
                        return;
                    }
                    try {
                        virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string2);
                    }
                    catch (RemoteException remoteException) {
                        logger.error("shutdownOrPowerOffCvms() - failed to retrieve VM entity for Controller VM {}, error: {}", (Object)string2, (Object)remoteException);
                        this.hyperflexUtils.logCVMShutdownFailEvent(string2);
                    }
                } else {
                    logger.debug("shutdownOrPowerOffCvms() - no Controller VM for host {} found in INI, trying host inventory", string);
                    virtualMachine = this.hyperflexUtils.getCvmOnHost((String)string);
                }
                if (virtualMachine != null) {
                    string2 = virtualMachine.getName();
                    if (!this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) {
                        logger.debug("shutdownOrPowerOffCvms() - Controller VM {} not powered on, skipping shutdown", (Object)string2);
                        return;
                    }
                    this.hyperflexUtils.logCVMShutdownEvent(string2);
                    try {
                        if (virtualMachine.getGuest().getToolsRunningStatus().equalsIgnoreCase(VirtualMachineToolsRunningStatus.guestToolsRunning.toString())) {
                            virtualMachine.shutdownGuest();
                            logger.info("shutdownOrPowerOffCvms() - CVM: {} successfully shut down", (Object)string2);
                            this.virtualisationStatusStore.saveCvmToPropertyFile((String)string, string2);
                            break block12;
                        }
                        logger.debug("shutdownOrPowerOffCvms() - No guest tools found, using power off instead of shutdown for CVM {}", (Object)string2);
                        serviceInstance = virtualMachine.powerOffVM_Task();
                        String string3 = serviceInstance.waitForTask();
                        if (string3.equals("success")) {
                            logger.info("shutdownOrPowerOffCvms() - CVM: {} successfully powered off", (Object)string2);
                            this.virtualisationStatusStore.saveCvmToPropertyFile((String)string, string2);
                            break block12;
                        }
                        logger.error("shutdownOrPowerOffCvms() - CVM: {} failed to power off with taskResult: {}", (Object)string2, (Object)string3);
                        this.hyperflexUtils.logCVMShutdownFailEvent(string2);
                    }
                    catch (Exception exception) {
                        logger.error("shutdownOrPowerOffCvms() - error shutting down CVM: {} - {}", (Object)string2, (Object)exception);
                        this.hyperflexUtils.logCVMShutdownFailEvent(string2);
                    }
                } else {
                    logger.warn("shutdownOrPowerOffCvms() - did not find a Controller VM entity for host {}", string);
                }
            }
        });
        logger.debug("shutdownOrPowerOffCvms() - end");
    }

    private void startCluster() {
        logger.debug("startCluster() - start, performing Hyperflex cluster start");
        int n = this.hyperflexUtils.getClusterStartupDuration(this.isAdvancedMode, this.ups_setup_idx);
        logger.debug("startCluster() - starting countdown for cluster startup with duration {}", (Object)n);
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.hyperflexUtils.logClusterStartupEvent();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (StringUtils.isBlank((CharSequence)HyperflexHost.this.clusterUuid)) {
                        logger.debug("startCluster() - cluster uuid not found in config, retrieving from service instead");
                        HyperflexHost.this.clusterUuid = HyperflexHost.this.hyperflexConnection.getClusterUuid();
                    }
                    if (HyperflexHost.this.isClusterUp(HyperflexHost.this.clusterUuid)) {
                        logger.debug("startCluster() - cluster already up, no need to start it");
                        return;
                    }
                    HyperflexHost.this.hyperflexConnection.startCluster(HyperflexHost.this.clusterUuid);
                }
                catch (IllegalStateException | RemoteException exception) {
                    logger.error("startCluster() - failed to start Hyperflex cluster: {}", (Throwable)exception);
                }
            }
        };
        Future<?> future = executorService.submit(runnable);
        try {
            future.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("startCluster() - timed out while starting up HyperFlex Cluster");
            this.hyperflexUtils.logClusterStartupTimeoutEvent();
            future.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            logger.error("startCluster() - interrupted while waiting for cluster start call to finish, error: ", (Throwable)interruptedException);
            future.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.error("startCluster() - failed to start Hyperflex cluster: {}", (Throwable)executionException);
        }
        executorService.shutdownNow();
        logger.debug("startCluster() - waiting rest of cluster start duration");
        countdownTimer.sleep();
        if (!this.isClusterUp()) {
            logger.error("startCluster() - failed to start Hyperflex cluster");
            this.hyperflexUtils.logClusterFailedStartupEvent();
            throw new IllegalStateException("Failed to start cluster");
        }
        logger.error("startCluster() - Hyperflex cluster successfully started");
        this.hyperflexUtils.logClusterAlreadyUpEvent();
        logger.debug("startCluster() - end");
    }

    private boolean isClusterStartNeeded() {
        logger.debug("isClusterStartNeeded() - start");
        if (!this.hyperflexUtils.isClusterHostUp()) {
            logger.debug("isClusterStartNeeded() - cluster IP/host is not available yet, need to start cluster");
            return true;
        }
        return !this.isClusterUp();
    }

    private boolean isClusterUp() {
        try {
            if (StringUtils.isBlank((CharSequence)this.clusterUuid)) {
                this.clusterUuid = this.hyperflexConnection.getClusterUuid();
            }
            return this.isClusterUp(this.clusterUuid);
        }
        catch (IllegalStateException | RemoteException exception) {
            logger.error("isClusterUp() - failed to check Hyperflex cluster state: {}", (Throwable)exception);
            logger.debug("isClusterUp() - could not determine cluster state, returning false");
            return false;
        }
    }

    private boolean isClusterUp(String string) {
        logger.debug("isClusterUp() - start");
        CompletableFuture<ClusterState> completableFuture = CompletableFuture.supplyAsync(() -> {
            ClusterState clusterState = ClusterState.UNKNOWN;
            try {
                clusterState = this.hyperflexConnection.getClusterState(string);
            }
            catch (IllegalStateException | RemoteException exception) {
                logger.error("isClusterUp() - failed to check Hyperflex cluster state: {}", (Throwable)exception);
            }
            return clusterState;
        });
        int n = this.hyperflexUtils.getJobQueryWait();
        try {
            ClusterState clusterState = completableFuture.get(n, TimeUnit.SECONDS);
            logger.debug("isClusterUp() - cluster in state {}", (Object)clusterState.toString());
            return clusterState == ClusterState.ONLINE;
        }
        catch (TimeoutException timeoutException) {
            logger.error("isClusterUp() - timed out while retrieving HyperFlex Cluster state");
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.error("isClusterUp() - failed to retrieve HyperFlex Cluster state: {}", (Throwable)exception);
        }
        logger.debug("isClusterUp() - could not determine cluster state, returning false");
        return false;
    }

    private Map<VirtualMachine, ServiceInstance> getCVMsToPowerOn() {
        logger.debug("getCVMsToPowerOn() - start");
        HashMap<VirtualMachine, ServiceInstance> hashMap = new HashMap<VirtualMachine, ServiceInstance>();
        List<String> list = this.hyperflexUtils.getMappedHostsList();
        list.forEach(string -> {
            String string2 = this.virtualisationStatusStore.getCvmName((String)string);
            if (string2 == null) {
                logger.debug("getCVMsToPowerOn() - no Controller VM entry found for host: {}", string);
                return;
            }
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
            if (serviceInstance == null) {
                serviceInstance = this.vmwareConnection.getESXiHostInstance((String)string);
            }
            if (serviceInstance == null) {
                throw new IllegalStateException("Unable to connect to VCenter");
            }
            logger.debug("getCVMsToPowerOn() - retrieved Controller VM name: {} for host: {}", (Object)string2, string);
            VirtualMachine virtualMachine = null;
            try {
                virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string2);
            }
            catch (InvalidProperty invalidProperty) {
                logger.error("getCVMsToPowerOn() - InvalidProperty: ", (Throwable)invalidProperty);
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("getCVMsToPowerOn() - RuntimeFault: ", (Throwable)runtimeFault);
            }
            catch (RemoteException remoteException) {
                logger.error("getCVMsToPowerOn() - RemoteException: ", (Throwable)remoteException);
            }
            catch (Exception exception) {
                logger.error("getCVMsToPowerOn() - Exception: ", (Throwable)exception);
            }
            if (virtualMachine == null) {
                logger.debug("getCVMsToPowerOn() - no virtual machine found for CVM: {}", (Object)string2);
                return;
            }
            if (this.isCVMOff(virtualMachine, (String)string)) {
                logger.debug("getCVMsToPowerOn() - Controller VM: {} needs to be powered on", (Object)virtualMachine.getName());
                hashMap.put(virtualMachine, serviceInstance);
            }
        });
        return hashMap;
    }

    private void powerOnCVMs(Map<VirtualMachine, ServiceInstance> map) throws IllegalStateException {
        logger.debug("powerOnCVMs() - start");
        map.forEach((virtualMachine, serviceInstance) -> {
            HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine((VirtualMachine)virtualMachine, (ServiceInstance)serviceInstance);
            String string2 = virtualMachine.getName();
            if (hostSystem == null) {
                logger.error("powerOnCVMs() - hostSystem is null for Controller VM: {}", (Object)string2);
                throw new IllegalStateException("Host system is null");
            }
            Predicate<String> predicate = string -> this.virtualisationStatusStore.isHostLockedForShutdown((String)string);
            if (this.virtualHostsToShutdown.stream().anyMatch(predicate)) {
                logger.debug("powerOnCVMs() - hosts shutting down, not starting Controller VM: {}", (Object)string2);
                throw new IllegalStateException("Hosts are shutting down");
            }
            String string3 = hostSystem.getName();
            if (!this.isCVMOff((VirtualMachine)virtualMachine, string3)) {
                logger.debug("powerOnCVMs() - Controller VM {} already powered on, skipping", (Object)string2);
            }
            if (this.canCVMPowerOn((VirtualMachine)virtualMachine)) {
                logger.debug("powerOnCVMs() - Controller VM to be started on host: {}", (Object)string3);
                try {
                    this.hyperflexUtils.logCVMStartupEvent(string2);
                    Task task = virtualMachine.powerOnVM_Task(hostSystem);
                    String string4 = task.waitForTask();
                    if (!string4.equals("success")) {
                        logger.error("powerOnCVMs() - Controller VM: {} failed to power on with taskResult: {}", (Object)string2, (Object)string4);
                        throw new IllegalStateException("Failed to power on Controller VM");
                    }
                    logger.info("powerOnCVMs() - Controller VM: {} successfully powered on", (Object)string2);
                    this.virtualisationStatusStore.clearCvm(string3);
                }
                catch (Exception exception) {
                    logger.error("powerOnCVMs() - error starting Controller VM: {} - {}", (Object)string2, (Object)exception);
                    throw new IllegalStateException("Failed to power on Controller VM", exception);
                }
            }
        });
        logger.debug("powerOnCVMs() - end");
    }

    private boolean canCVMPowerOn(VirtualMachine virtualMachine) {
        if (!this.services.getVirtualMachineUtils().isConnected(virtualMachine)) {
            logger.error("canCVMPowerOn() - Controller VM: {} is not connected, unable to start", (Object)virtualMachine.getName());
            throw new IllegalStateException("Controller VM is not connected");
        }
        return true;
    }

    private boolean isCVMOff(VirtualMachine virtualMachine, String string) {
        if (this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) {
            logger.debug("isCVMOff() - Controller VM: {} is already powered on", (Object)virtualMachine.getName());
            this.virtualisationStatusStore.clearCvm(string);
            return false;
        }
        return true;
    }

    private boolean anyCvmsOn() {
        Map<String, String> map = this.hyperflexUtils.getCVMsFromConfig();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            logger.debug("anyCvmsOn() - Checking Controller VM {} on hst {}", (Object)string2, (Object)string);
            VirtualMachine virtualMachine = null;
            ServiceInstance serviceInstance = this.vmwareConnection.getServiceInstance(string);
            if (serviceInstance == null) {
                logger.error("anyCvmsOn() - failed to retrieve VMWare service instance for host {}, unable to check Controller VM {}", (Object)string, (Object)string2);
                continue;
            }
            try {
                virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string2);
                if (!this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) continue;
                logger.debug("anyCvmsOn() - Controller VM {} is powered on", (Object)string2);
                return true;
            }
            catch (RemoteException remoteException) {
                logger.error("anyCvmsOn() - failed to retrieve VM entity for Controller VM {}, error: {}", (Object)string2, (Object)remoteException);
            }
        }
        return false;
    }
}

