/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.shutdowner.NutanixClusterOps;
import com.apcc.m11.components.shutdowner.NutanixUvmHandler;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.hosts.StandardHost;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixAHVHost
extends StandardHost {
    private static final Logger logger = LogManager.getLogger(NutanixAHVHost.class);
    private NutanixConnection connection = null;
    private NutanixClusterOps nutanixClusterOps = null;
    private String clusterIp = null;
    private boolean isAdvancedMode = false;
    private NutanixUtils nutanixUtils = null;

    public NutanixAHVHost(ServiceManager serviceManager) {
        super(serviceManager);
        this.nutanixUtils = serviceManager.getNutanixUtils();
    }

    @Override
    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        super.initialize(iEventConsumer, iDataSource, event, shutdownState, iPermanentStorage);
        this.isAdvancedMode = this.isAdvancedMode();
        if (!this.performingStartup) {
            this.setUpClusterConnection();
            this.setUpClusterOps();
            this.clusterIp = this.nutanixUtils.getClusterIp();
        }
        logger.debug("initialize() - end");
    }

    private boolean isAdvancedMode() {
        return this.services.getAdvancedSetupHelper().isAdvancedShutdownMode();
    }

    private void setUpClusterConnection() {
        try {
            this.connection = this.getClusterConnection();
            this.connection.connect();
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("setUpClusterConnection() - unable to connect to the Nutanix cluster, error: {}", (Throwable)exception);
        }
    }

    protected NutanixConnection getClusterConnection() throws IllegalArgumentException, IOException {
        return NutanixService.getInstance().getClusterConnection();
    }

    private void setUpCvmConnection(String string) throws IllegalStateException {
        try {
            this.connection = this.getCvmConnection(string);
            this.connection.connect();
            logger.debug("setUpCvmConnection() - successfully connected to {}: {}", (Object)string, (Object)this.connection.isConnected());
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("setUpCvmConnection() - unable to connect to the Nutanix CVM {}, error: {}", (Object)string, (Object)exception);
            throw new IllegalStateException("Failed to connect to CVM");
        }
    }

    protected NutanixConnection getCvmConnection(String string) throws IllegalArgumentException, IOException {
        return NutanixService.getInstance().getCvmNutanixConnection(string);
    }

    protected NutanixClusterOps getNutanixClusterOps() {
        return new NutanixClusterOps(this.connection, this.isAdvancedMode, this.ups_setup_idx, this.services);
    }

    private void setUpClusterOps() {
        this.nutanixClusterOps = this.getNutanixClusterOps();
    }

    protected NutanixUvmHandler getNutanixUvmHandler() {
        return new NutanixUvmHandler(this.theState, this.connection, this.ups_setup_idx, this.services);
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            return;
        }
        if (!this.nutanixClusterOps.isClusterUp()) {
            logger.debug("performClusterStopOps() - Nutanix cluster is not up, cannot perform any cluster operations");
            this.nutanixUtils.logClusterStopOpsFailEvent(this.clusterIp);
            return;
        }
        this.theState.setNutanixClusterStop();
        logger.info("performClusterStopOps() - performing Nutanix cluster operations");
        try {
            this.nutanixClusterOps.stopAfs();
            this.nutanixClusterOps.abortActiveReplications();
            this.nutanixClusterOps.stopCluster();
            boolean bl = this.nutanixUtils.isCvmStartupEnabled(this.isAdvancedMode, this.ups_setup_idx);
            if (bl && this.theState.isNutanixCvmStartInProgress()) {
                try {
                    CompletableFuture.runAsync(() -> this.waitIfCVMStartupInProgress()).get(this.nutanixUtils.getCvmStartupDuration(this.isAdvancedMode, this.ups_setup_idx), TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException exception) {
                    logger.debug("performClusterStopOps() - failed to wait for CVM startup to finish");
                }
                catch (TimeoutException timeoutException) {
                    logger.debug("performClusterStopOps() - timed out waiting for CVM startup to finish, continue with shutdown");
                }
            }
            this.nutanixClusterOps.shutdownCvms();
            this.virtualisationStatusStore.setNutanixClusterStopped();
        }
        catch (Exception exception) {
            logger.error("performClusterStopOps() - failed to execute cluster stop operations, error: {}", (Throwable)exception);
        }
        this.theState.clearNutanixClusterStop();
    }

    @Override
    public void vMTasks() {
        logger.debug("vMTasks() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            return;
        }
        this.virtualHostsToShutdown.stream().forEach(string -> this.virtualisationStatusStore.lockHostForShutdown((String)string));
        NutanixUvmHandler nutanixUvmHandler = this.getNutanixUvmHandler();
        nutanixUvmHandler.stopAllUVMs();
        logger.debug("vMTasks() - end");
    }

    private void waitIfCVMStartupInProgress() {
        logger.debug("waitIfCVMStartupInProgress() - start");
        if (this.theState.isNutanixCvmStartInProgress()) {
            this.nutanixUtils.logCvmStartupInProgressEvent(this.clusterIp);
            do {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.theState.isNutanixCvmStartInProgress());
        }
        logger.debug("waitIfCVMStartupInProgress() - end");
    }

    @Override
    public void hostShutdown() {
        logger.debug("hostShutdown() - start");
        if (this.nutanixUtils.isAhvHostShutdownDisabled()) {
            logger.debug("hostShutdown() - AHV host shutdown disabled, skipping AHV host shutdown");
            return;
        }
        if (this.virtualHostsToShutdown != null) {
            String string;
            Iterator iterator = this.virtualHostsToShutdown.iterator();
            while (iterator.hasNext() && (string = (String)iterator.next()) != null) {
                logger.debug("hostShutdown() - checking host: {}", (Object)string);
                if (StringUtils.equalsIgnoreCase((CharSequence)this.services.getVirtualConfigurationManager().getLocalHostIP(), (CharSequence)string)) {
                    logger.debug("hostShutdown() - PCNS is installed on this host: {}, skipping shutdown", (Object)string);
                    this.theState.setHostWherePCNSInstalled(string);
                    break;
                }
                this.executeHostShutdown(string);
            }
        }
        logger.debug("hostShutdown() - host shutdown completed");
        this.cleanUp();
    }

    private void executeHostShutdown(String string) {
        logger.info("executeHostShutdown() - start, host: {}", (Object)string);
        this.services.getVirtualLoggingUtils().logTargetHostShutdownEvent(string);
        try {
            this.connection.shutdownAHV(string);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error("executeHostShutdown() - failed to shut down AHV host: {}, error: {}", (Object)string, (Object)illegalStateException);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)illegalStateException);
            if (throwable instanceof AuthenticationException) {
                this.services.getShutdownLogger().sendSingleEventToEventLog(string, 229);
            } else if (throwable instanceof UnknownHostException) {
                this.services.getShutdownLogger().sendSingleEventToEventLog(string, 230);
            } else {
                this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(string);
            }
        }
        catch (RemoteException remoteException) {
            logger.debug("executeHostShutdown() - Exception while shutting down the AHV host: {}. Most likely ok as host closed connection, error: {}", (Object)string, (Object)remoteException);
        }
        logger.info("executeHostShutdown() - end");
    }

    private void cleanUp() {
        logger.debug("cleanUp() - all AHV steps performed, disconnecting connections, unlocking hosts for shutdown");
        this.virtualHostsToShutdown.stream().forEach(string -> this.virtualisationStatusStore.unlockHostForShutdown((String)string));
        this.nutanixClusterOps = null;
        try {
            this.connection.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.connection = null;
        logger.debug("cleanUp() - end");
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("performStartup() - no hosts to wait for");
            return;
        }
        if (this.nutanixUtils.isClusterLocked(this.isAdvancedMode)) {
            logger.debug("performStartup() - not performing start up, cluster is locked for shutdown");
            return;
        }
        if (this.nutanixUtils.hasClusterActiveCriticalEvent(this.isAdvancedMode, this.theState)) {
            logger.debug("performStartup() - not performing start up, cluster has active critical event");
            return;
        }
        if (!this.nutanixUtils.isCvmStartupEnabled(this.isAdvancedMode, this.ups_setup_idx)) {
            logger.debug("performStartup() - skipping Nutanix startup, CVM startup not enabled");
            return;
        }
        List<String> list = this.nutanixUtils.getNutanixHostIpsFromConfig(this.isAdvancedMode);
        logger.info("performStartup() - hosts: {}", list);
        if (!this.nutanixUtils.isAllHostsUp(list)) {
            logger.debug("performStartup() - not all AHV hosts are back online yet");
            return;
        }
        list.forEach(string -> this.virtualisationStatusStore.clearHostForShutdown((String)string));
        int n = this.nutanixUtils.getCvmStartupDuration(this.isAdvancedMode, this.ups_setup_idx);
        List<String> list2 = this.nutanixUtils.getCvmIPsFromConfig();
        logger.debug("performStartup() - checking if CVMs:{} are up", list2);
        if (!this.nutanixUtils.isAllHostsUp(list2)) {
            logger.debug("performStartup() - not all CVMs are back online yet");
            return;
        }
        String string2 = list2.get(0);
        logger.debug("performStartup() - trying to connect to CVM: {}", (Object)string2);
        this.setUpCvmConnection(string2);
        this.setUpClusterOps();
        boolean bl = this.nutanixClusterOps.isClusterUp();
        logger.debug("performStartup() - Cluster is already up: {}", (Object)bl);
        if (!bl) {
            try {
                this.nutanixUtils.logCvmStartupWaitEvent(this.clusterIp);
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                logger.warn("performStartup() - failed to wait for CVM start up: {}", (Throwable)interruptedException);
            }
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.nutanixClusterOps.isAfsActive();
            logger.debug("performStartup() - AFS is Active: {}", (Object)bl2);
            if (bl2 && !this.nutanixUtils.isUvmStartupEnabled(this.isAdvancedMode, this.ups_setup_idx)) {
                logger.debug("performStartup() - AFS is active and User VM start up not enabled, end perform startup");
                return;
            }
        }
        if (this.nutanixUtils.isClusterLocked(this.isAdvancedMode)) {
            logger.debug("performStartup() - not performing start up, cluster is locked for shutdown");
            return;
        }
        if (this.nutanixUtils.hasClusterActiveCriticalEvent(this.isAdvancedMode, this.theState)) {
            logger.debug("performStartup() - not performing start up, cluster has active critical event");
            return;
        }
        this.clusterIp = this.nutanixUtils.getClusterIp();
        if (this.theState.isNutanixClusterStopInProgress()) {
            logger.debug("performStartup() - cluster stop in progress, cannot start cluster");
            return;
        }
        if (!bl) {
            try {
                this.nutanixClusterOps.startCluster();
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        } else {
            logger.debug("performStartup() - cluster already started, skipping cluster start up");
        }
        this.nutanixUtils.logClusterAlreadyUpEvent(this.clusterIp);
        if (!bl2) {
            try {
                this.nutanixClusterOps.startAFS();
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("performStartup() - Nutanix AFS did not start, continuing start up!");
            }
        }
        logger.debug("performStartup() - disconnecting from CVM: {}", (Object)string2);
        try {
            this.connection.disconnect();
        }
        catch (RemoteException remoteException) {
            logger.debug("performStartup() - disconnect failed, session might be timed out by now: {}", (Throwable)remoteException);
        }
        this.connection = null;
        this.nutanixClusterOps = null;
        logger.debug("performStartup() - connecting to cluster");
        this.setUpClusterConnection();
        this.setUpClusterOps();
        this.virtualisationStatusStore.clearNutanixClusterStopped();
        if (!this.nutanixUtils.isUvmStartupEnabled(this.isAdvancedMode, this.ups_setup_idx)) {
            logger.debug("performStartup() - User VM start up not enabled, skipping UVM start");
            return;
        }
        NutanixUvmHandler nutanixUvmHandler = this.getNutanixUvmHandler();
        nutanixUvmHandler.startUpUvms(this.virtualHostsToShutdown);
        logger.debug("performStartup() - end");
    }
}

