/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.shutdowner.NutanixClusterOps;
import com.apcc.m11.components.shutdowner.NutanixEsxiStartupHandler;
import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanFaultToleranceThreshold;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.sshservice.GenericConnection;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixESXHost
extends ESXManagedHost {
    private static final Logger logger = LogManager.getLogger(NutanixESXHost.class);
    private NutanixClusterOps nutanixClusterOps = null;
    private NutanixUtils nutanixUtils = null;

    public NutanixESXHost(ServiceManager serviceManager) {
        super(serviceManager);
        this.nutanixUtils = serviceManager.getNutanixUtils();
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup() - start");
        this.performStartupSteps();
        this.checkDrsSettings();
        if (this.virtualisationStatusStore.isNutanixClusterStopped() || this.nutanixUtils.isClusterLocked(this.isAdvancedMode)) {
            logger.debug("performStartup() - cluster is stopped: {} or locked: {}, not handling vCLS or HA", (Object)this.virtualisationStatusStore.isNutanixClusterStopped(), (Object)this.nutanixUtils.isClusterLocked(this.isAdvancedMode));
            return;
        }
        this.handleVCLSAndHAStartup();
        logger.debug("performStartup() - end");
    }

    void performStartupSteps() {
        logger.debug("performStartupSteps() - start");
        this.getHostsOutOfMaintenanceMode(this.virtualHostsToShutdown);
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            if (this.virtualisationStatusStore.isNutanixClusterStopped()) {
                logger.debug("performStartup() - only Nutanix cluster to start");
                NutanixEsxiStartupHandler nutanixEsxiStartupHandler = new NutanixEsxiStartupHandler(this.virtualHostsToShutdown, this.theState, this.isAdvancedMode, this.ups_setup_idx, this.services);
                try {
                    nutanixEsxiStartupHandler.performNutanixStartup();
                }
                catch (IllegalStateException illegalStateException) {
                    logger.warn("performStartup() - cluster not in correct state for proceeding with startup: {}", (Throwable)illegalStateException);
                }
                logger.debug("performStartup() - only Nutanix cluster started, performStartup() end");
            } else {
                logger.debug("performStartup() - no hosts or cluster to start");
            }
        } else {
            Object object;
            logger.debug("performStartup() - hosts: {}", (Object)this.virtualHostsToShutdown);
            this.checkWitnessHostVmStartup();
            if (!this.handleVcsaRequirement()) {
                logger.debug("performStartup() - VCSA handling not successful");
                return;
            }
            if (this.services.getVirtualConfigurationManager().isVsanFTTEnabled() && !((VsanFaultToleranceThreshold)(object = this.services.getVsanUtils().getVsanFaultToleranceThreshold(this.theState, this.services))).isFTTResolved()) {
                return;
            }
            object = new NutanixEsxiStartupHandler(this.virtualHostsToShutdown, this.theState, this.isAdvancedMode, this.ups_setup_idx, this.services);
            try {
                ((NutanixEsxiStartupHandler)object).performNutanixStartup();
            }
            catch (IllegalStateException illegalStateException) {
                logger.warn("performStartup() - cluster not in correct state for proceeding with startup: {}", (Throwable)illegalStateException);
                return;
            }
            LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getVMAndVAppHostList();
            if (linkedHashSet.isEmpty()) {
                logger.debug("performStartup() - no VM/vApps found for startup");
                return;
            }
            if (!this.canWePerformVMAndVAppStartup(linkedHashSet)) {
                logger.debug("performStartup() - VM/vApp startup can't be performed yet");
                return;
            }
            this.doVMVAppStartupForAllHosts();
        }
        logger.debug("performStartup() - end");
    }

    @Override
    public void VCSAVMShutdown() {
        this.stopAfs();
        super.VCSAVMShutdown();
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            return;
        }
        if (!this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            logger.debug("performClusterStopOps() - no Nutanix support, skipping Cluster operations");
            return;
        }
        try {
            this.saveCvmsToPropertyFile();
        }
        catch (Exception exception) {
            logger.error("performClusterStopOps() - failed to write CVMs to property file, error {}", (Throwable)exception);
        }
        String string = this.nutanixUtils.getClusterIp();
        try {
            NutanixConnection nutanixConnection = this.getNutanixClusterConnection();
            this.nutanixClusterOps = this.getNutanixClusterOps(nutanixConnection);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)remoteException);
            if (throwable instanceof AuthenticationException) {
                logger.error("performClusterStopOps() - authentication error when connecting to the Nutanix cluster, error: {}", (Throwable)remoteException);
                this.nutanixUtils.logClusterAuthFailEvent(string);
            } else if (throwable instanceof IOException) {
                logger.error("performClusterStopOps() - connection error when connecting to the Nutanix cluster, error: {}", (Throwable)remoteException);
                this.nutanixUtils.logClusterConnectionFailEvent(string);
            } else {
                logger.error("performClusterStopOps() - unable to connect to the Nutanix cluster, error: {}", (Throwable)remoteException);
                this.nutanixUtils.logClusterStopOpsFailEvent(string);
            }
            return;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("performClusterStopOps() - unable to connect to the Nutanix cluster, error: {}", (Throwable)exception);
            this.nutanixUtils.logClusterStopOpsFailEvent(string);
            return;
        }
        if (!this.nutanixClusterOps.isClusterUp()) {
            logger.debug("performClusterStopOps() - Nutanix cluster is not up, cannot perform any cluster operations");
            this.nutanixUtils.logClusterNotUpFailEvent(string);
            return;
        }
        this.theState.setNutanixClusterStop();
        logger.debug("performClusterStopOps() - performing Nutanix cluster operations");
        try {
            this.nutanixClusterOps.abortActiveReplications();
            this.nutanixClusterOps.disableMetroAvailability();
            this.nutanixClusterOps.stopCluster();
            this.nutanixClusterOps.shutdownCvms();
            this.cleanUpNutanixConnection();
            this.virtualisationStatusStore.setNutanixClusterStopped();
            this.theState.clearNutanixClusterStop();
        }
        catch (Exception exception) {
            logger.error("performClusterStopOps() - failed to execute cluster stop operations, error: {}", (Throwable)exception);
        }
        logger.debug("performClusterStopOps() - end");
    }

    void stopAfs() {
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("stopAFS() - no critical hosts to handle, skipping AFS shutdown step");
            return;
        }
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            this.stopAfsWithoutVCSA();
        } else {
            String string = this.nutanixUtils.getClusterIp();
            try {
                if (this.nutanixClusterOps == null) {
                    NutanixConnection nutanixConnection = this.getNutanixClusterConnection();
                    this.nutanixClusterOps = this.getNutanixClusterOps(nutanixConnection);
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                logger.error("performClstopAfsusterStopOps() - unable to connect to the Nutanix cluster, error: {}", (Throwable)exception);
                this.nutanixUtils.logClusterStopOpsFailEvent(string);
                return;
            }
            this.nutanixClusterOps.stopAfs();
        }
    }

    NutanixClusterOps getNutanixClusterOps(NutanixConnection nutanixConnection) throws IllegalStateException, IllegalArgumentException, IOException, RemoteException {
        logger.debug("getNutanixClusterOps() - start");
        nutanixConnection.connect();
        return new NutanixClusterOps(nutanixConnection, this.isAdvancedMode, this.ups_setup_idx, this.services);
    }

    NutanixConnection getNutanixClusterConnection() throws IllegalArgumentException, IOException {
        logger.debug("getNutanixClusterConnection() - start");
        return NutanixService.getInstance().getClusterConnection();
    }

    private void cleanUpNutanixConnection() {
        logger.debug("cleanUpNutanixConnection() - all Nutanix steps performed, disconnecting from cluster");
        this.nutanixClusterOps.disconnect();
        this.nutanixClusterOps = null;
    }

    void stopAfsWithoutVCSA() {
        if (!this.nutanixUtils.getBoolean(this.isAdvancedMode, this.ups_setup_idx, "afs_shutdown_enable")) {
            logger.debug("stopAfsWithoutVCSA() - skipping stop AFS");
            return;
        }
        int n = this.services.getVirtualConfigurationManager().getDurationGlobal("afs_shutdown_duration");
        logger.info("stopAfsWithoutVCSA() - performing Nutanix AFS stop");
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        this.services.getVirtualLoggingUtils().logNutanixAfsStopEvent();
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
            Map<String, VirtualMachine> map = this.getAfsVmsFromVmName();
            GenericConnection genericConnection = null;
            boolean bl = false;
            for (String string : map.keySet()) {
                VirtualMachine virtualMachine = map.get(string);
                String string2 = virtualMachine.getGuest().getIpAddress();
                if (StringUtils.isBlank((CharSequence)string2)) {
                    logger.debug("stopAfsWithoutVCSA() - retrieved NULL as IP address for AFS VM name {}, skipping to next AFS VM", (Object)string);
                    continue;
                }
                logger.debug("stopAfsWithoutVCSA() - retrieved IP {} for AFS VM name {} - AFS IP: {}", (Object)string2, (Object)string);
                try {
                    genericConnection = this.getNutanixService().getCvmNutanixConnection(string2);
                    genericConnection.connect();
                }
                catch (RemoteException remoteException) {
                    if (ExceptionUtils.getRootCause((Throwable)remoteException) instanceof AuthenticationException) {
                        logger.error("stopAfsWithoutVCSA() - authentication error when connecting to AFS VM {}, error: {}", (Object)string2, (Object)remoteException);
                        bl = true;
                    }
                }
                catch (IOException | IllegalArgumentException exception) {
                    logger.error("stopAfsWithoutVCSA() - failed to connect to AFS VM {} via SSH", (Object)string2);
                }
                if (genericConnection == null || !genericConnection.isConnected()) continue;
                logger.debug("stopAfsWithoutVCSA() - successfully connected to AFS VM {} via SSH", (Object)string2);
                break;
            }
            if (genericConnection == null || !genericConnection.isConnected()) {
                logger.error("stopAfsWithoutVCSA() - unable to connect to any AFS VM via SSH, cannot stop AFS cluster");
                if (bl) {
                    logger.error("stopAfsWithoutVCSA() - authentication error when connecting to AFS VMs via SSH");
                    throw new CompletionException(new AuthenticationException("Authentication error when connecting to AFS VMs"));
                }
                throw new CompletionException(new ConnectException("Unable to connect to any AFS VMs via SSH"));
            }
            try {
                genericConnection.stopAfsCluster(n);
            }
            catch (RemoteException remoteException) {
                logger.error("stopAfsWithoutVCSA() - failed to stop Nutanix AFS: {}", (Throwable)remoteException);
                throw new CompletionException(remoteException);
            }
            this.powerOffAfsVMs(map);
        });
        try {
            completableFuture.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            logger.error("stopAfsWithoutVCSA() - timed out while trying to stop Nutanix AFS: {}", (Throwable)timeoutException);
            this.nutanixUtils.logAFSStopTimeoutEvent();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)executionException);
            if (throwable instanceof AuthenticationException) {
                logger.error("stopAfsWithoutVCSA() - authentication error when connecting to AFS VMs via SSH: {}", (Throwable)executionException);
                this.nutanixUtils.logClusterAuthFailEvent(null);
            } else if (throwable instanceof ConnectException) {
                logger.error("stopAfsWithoutVCSA() - connection error when connecting to AFS VMs via SSH: {}", (Throwable)executionException);
                this.nutanixUtils.logClusterConnectionFailEvent(null);
            } else {
                logger.error("stopAfsWithoutVCSA() - failed to stop Nutanix AFS: {}", (Throwable)executionException);
                this.nutanixUtils.logAFSForceStopFailedEvent();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("stopAfsWithoutVCSA() - failed to stop Nutanix AFS: {}", (Throwable)interruptedException);
            this.nutanixUtils.logAFSForceStopFailedEvent();
        }
        logger.debug("stopAfsWithoutVCSA() - waiting rest of AFS stop duration");
        countdownTimer.sleep();
        logger.debug("stopAfsWithoutVCSA() - end");
    }

    protected Map<String, VirtualMachine> getAfsVmsFromVmName() {
        List<String> list = this.nutanixUtils.getNutanixHostIpsFromConfig(this.isAdvancedMode);
        List<String> list2 = this.nutanixUtils.getAfsVmsFromConfig();
        logger.debug("getAfsVmsFromVmName() - retrieved AFS VM names: {}", list2);
        HashMap<String, VirtualMachine> hashMap = new HashMap<String, VirtualMachine>();
        list.forEach(string -> {
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance((String)string);
            if (serviceInstance == null) {
                logger.error("getAfsVmsFromVmName() - unable to connect to ESXi host {}", string);
                return;
            }
            ArrayList arrayList = new ArrayList();
            list2.forEach(string2 -> {
                if (arrayList.contains(string2)) {
                    return;
                }
                logger.debug("getAfsVmsFromVmName() - looking for AFS VM {} on host {}", string2, string);
                VirtualMachine virtualMachine = null;
                try {
                    virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, (String)string2);
                }
                catch (InvalidProperty invalidProperty) {
                }
                catch (RuntimeFault runtimeFault) {
                    logger.error("getAfsVmsFromVmName() - RuntimeFault: ", (Throwable)runtimeFault);
                }
                catch (RemoteException remoteException) {
                    logger.error("getAfsVmsFromVmName() - RemoteException: ", (Throwable)remoteException);
                }
                catch (Exception exception) {
                    logger.error("getAfsVmsFromVmName() - Exception: ", (Throwable)exception);
                }
                if (virtualMachine == null) {
                    return;
                }
                logger.debug("getAfsVmsFromVmName() - successfully retrieved Virtual Machine from host inventory for AFS VM {}", string2);
                hashMap.put((String)string2, virtualMachine);
                arrayList.add(string2);
            });
        });
        logger.debug("getAfsVmsFromVmName() - end");
        return hashMap;
    }

    private void powerOffAfsVMs(Map<String, VirtualMachine> map) {
        logger.debug("powerOffAfsVMs() - start");
        map.forEach((string, virtualMachine) -> {
            if (virtualMachine == null) {
                logger.error("powerOffAfsVMs() - VirtualMachine is null for AFS VM {}", string);
                return;
            }
            try {
                Task task = virtualMachine.powerOffVM_Task();
                String string2 = task.waitForTask();
                if (string2.equals("success")) {
                    if (virtualMachine.getRuntime().getPowerState() != VirtualMachinePowerState.poweredOff) {
                        logger.error("powerOffAfsVMs() - AFS VM: {} failed to power off still in powered on state", (Object)virtualMachine.getName());
                    } else {
                        logger.info("powerOffAfsVMs() - AFS VM: {} successfully powered off", (Object)virtualMachine.getName());
                    }
                } else {
                    logger.error("powerOffAfsVMs() - AFS VM: {} failed to power off with taskResult: {}", (Object)virtualMachine.getName(), (Object)string2);
                }
            }
            catch (Exception exception) {
                logger.error("powerOffAfsVMs() - error powering off AFS VM: {} - {}", (Object)virtualMachine.getName(), (Object)exception);
            }
        });
        logger.debug("powerOffAfsVMs() - end");
    }

    private void saveCvmsToPropertyFile() {
        logger.debug("saveCvmsToPropertyFile() - start");
        List<String> list = this.nutanixUtils.getCvmNamesFromConfig();
        this.virtualHostsToShutdown.forEach(string -> {
            logger.debug("saveCvmsToPropertyFile() - host: {}", string);
            ServiceInstance serviceInstance = null;
            if (this.vmwareConnection.validateServiceInstance()) {
                serviceInstance = this.vmwareConnection.getVCenterConnection();
            } else {
                logger.debug("saveCvmsToPropertyFile() - trying ESXi service instance");
                serviceInstance = this.getESXiServiceInstanceConnection((String)string);
            }
            HostSystem hostSystem = this.services.getHostSystemUtils().getHostUsingIPOrDNSName(serviceInstance, (String)string);
            if (hostSystem == null) {
                logger.debug("saveCvmsToPropertyFile() - hostSystem is null; trying ESXi service instance");
                serviceInstance = this.getESXiServiceInstanceConnection((String)string);
                hostSystem = this.services.getHostSystemUtils().getHostUsingIPOrDNSName(serviceInstance, (String)string);
            }
            if (hostSystem == null) {
                logger.error("saveCvmsToPropertyFile() - hostSystem is null");
                return;
            }
            try {
                VirtualMachine[] virtualMachineArray;
                for (VirtualMachine virtualMachine : virtualMachineArray = hostSystem.getVms()) {
                    String string2 = virtualMachine.getName();
                    logger.debug("saveCvmsToPropertyFile() - checking CVM list for VM: {}", (Object)string2);
                    if (!list.contains(string2)) continue;
                    this.virtualisationStatusStore.saveCvmToPropertyFile((String)string, string2);
                }
            }
            catch (InvalidProperty invalidProperty) {
                logger.error("saveCvmsToPropertyFile() - InvalidProperty: ", (Throwable)invalidProperty);
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("saveCvmsToPropertyFile() - RuntimeFault: ", (Throwable)runtimeFault);
            }
            catch (RemoteException remoteException) {
                logger.error("saveCvmsToPropertyFile() - RemoteException: ", (Throwable)remoteException);
            }
        });
        logger.debug("saveCvmsToPropertyFile() - end");
    }

    protected NutanixService getNutanixService() {
        return NutanixService.getInstance();
    }
}

