/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.webserver.util.virtualization.simplivity.SimplivityUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplivityHost
extends ESXManagedHost {
    private static final Logger logger = LogManager.getLogger(SimplivityHost.class);
    private SimplivityUtils simplivityUtils;
    private VirtualConfigurationManager virtualConfigurationManager;
    private HostSystemUtils hostSystemUtils;

    public SimplivityHost(@NonNull ServiceManager serviceManager) {
        super(serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("serviceManager is marked non-null but is null");
        }
        this.simplivityUtils = serviceManager.getSimplivityUtils();
        this.virtualConfigurationManager = serviceManager.getVirtualConfigurationManager();
        this.hostSystemUtils = serviceManager.getHostSystemUtils();
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        CountdownTimer countdownTimer = new CountdownTimer(this.simplivityUtils.getOvcShutdownDuration(this.ups_setup_idx), TimeUnit.SECONDS);
        Set<CountDownLatch> set = this.simplivityUtils.queueOvcShutdownTasks(this.virtualHostsToShutdown, countdownTimer);
        for (CountDownLatch countDownLatch : set) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                logger.warn("performClusterStopOps() - InterruptedException: {}", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        if (countdownTimer.hasElapsed()) {
            logger.debug("performClusterStopOps() - insufficient time allocated for cluster stop");
            this.services.getVirtualLoggingUtils().logSimplivityOvcShutdownInsufficientTimeEvent();
        } else {
            logger.debug("performClusterStopOps() - waiting for remaining OVC Shutdown Duration...");
            countdownTimer.sleep();
            logger.debug("performClusterStopOps() - OVC Shutdown Duration elapsed.");
        }
        logger.debug("performClusterStopOps() - end");
    }

    @Override
    protected Boolean meetPreconditions() {
        logger.debug("meetPreconditions() - start");
        boolean bl = false;
        if (this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty()) {
            logger.debug("meetPreconditions() - virtualHostsToShutdown is null or empty.  Nothing to process.");
            return false;
        }
        if (this.virtualConfigurationManager.isStartupWaitsForAllHostsOnlineEnabled() && !this.hostSystemUtils.areAllHostsOnline(this.virtualHostsToShutdown)) {
            logger.debug("meetPreconditions() - All hosts online requirement not yet met.");
            return false;
        }
        Map<String, VirtualMachine> map = this.simplivityUtils.getStartupOVCs();
        if (this.virtualConfigurationManager.isSkipMaintenanceModeEnabled()) {
            logger.debug("meetPreconditions() - Skip Maintenance Mode enabled, skipping request to start OVCs...");
        } else {
            logger.debug("meetPreconditions() - Request OVC power on for hosts: {}", (Object)this.virtualHostsToShutdown);
            if (!this.simplivityUtils.startOVCs(this.virtualHostsToShutdown, this.ups_setup_idx)) {
                logger.debug("meetPreconditions() - OVC startup not successful.");
                return false;
            }
        }
        logger.debug("meetPreconditions() - Check if cluster services are running.");
        if (!this.simplivityUtils.isSimplivityUp(this.virtualHostsToShutdown, map)) {
            logger.debug("meetPreconditions() - Simplivity Cluster services have not started yet.");
            return false;
        }
        if (this.virtualConfigurationManager.isSkipMaintenanceModeEnabled() && this.simplivityUtils.isFirstStartupIteration()) {
            logger.debug("meetPreconditions() - Skip Maintenance Mode enabled, so wait for OVC startup duration...");
            new CountdownTimer(this.simplivityUtils.getOvcStartupDuration(this.ups_setup_idx), TimeUnit.SECONDS).sleep();
            logger.debug("meetPreconditions() - startup duration elapsed.");
            this.simplivityUtils.setFirstStartupIteration(false);
        }
        logger.debug("meetPreconditions() - checking VCSA requirements");
        bl = this.handleVcsaRequirement();
        logger.debug("meetPreconditions() - end, preconditions met: {}", (Object)bl);
        return bl;
    }

    @Override
    protected boolean isAnyHealthyHostNotCritical() {
        logger.trace("isAnyHealthyHostNotCritical() - start");
        LinkedHashSet<String> linkedHashSet = this.virtualConfigurationManager.getConfiguredHosts();
        List<String> list = this.simplivityUtils.getOvcHostnames();
        Optional<String> optional = linkedHashSet.stream().filter(string -> StringUtils.isNotBlank((CharSequence)string)).filter(string -> list.contains(string)).filter(string -> !this.theState.checkIfCriticalEventActive((String)string)).filter(string -> this.hostSystemUtils.isHostHealthy((String)string)).findAny();
        if (optional.isPresent()) {
            logger.debug("isAnyHealthyHostNotCritical() - not-critical and available host found: {}", (Object)optional.get());
            return true;
        }
        logger.debug("isAnyHealthyHostNotCritical() - no not-critical and available host found, returning false");
        return false;
    }
}

