/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.DelayedOSShutdowner;
import com.apcc.m11.components.shutdowner.EventKey;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.formatters.ShutdownStartingFormatter;
import com.apcc.m11.components.shutdowner.formatters.TurnOffUpsStartingFormatter;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.OIdEventMapping;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.sshservice.SSHActionManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardHost {
    private static final Logger logger = LogManager.getLogger(StandardHost.class);
    private ApplicationErrorHandler errorHandler;
    private ResourceBundleWrapper bundle;
    protected IEventConsumer theEventConsumer = null;
    protected IDataSource theDataSource = null;
    protected Event theTriggerEvent = null;
    protected ShutdownState theState;
    protected IPermanentStorage thePermanentStorage;
    protected static final String kResourceBundle = "com.apcc.m11.components.shutdowner.i18n.ShutdownFormatters";
    protected static final String kWindowsOSName = "Windows";
    protected String os_name;
    protected LinkedHashSet<String> protectedHosts = null;
    protected LinkedHashSet<String> virtualHostsToShutdown = null;
    protected int ups_setup_idx = -1;
    protected boolean isVirtualHostsShutdownEnabled = false;
    private boolean isAdvancedPhysicalUpsGroupNoHostShutdown = false;
    protected boolean performHyperVUnmanagedVirtShutdown = true;
    protected boolean performingStartup = false;
    protected SSHActionManager sshActionManager;
    protected Utils webUtils;
    protected ServiceManager services;
    protected VirtualisationStatusStore virtualisationStatusStore;

    public StandardHost(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("serviceManager is marked non-null but is null");
        }
        logger.debug("constructor()");
        this.services = serviceManager;
        this.webUtils = serviceManager.getWebServerUtils();
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.errorHandler = this.services.getApplicationErrorHandler();
        this.bundle = Utils.getWebServerResourceBundle(Locale.getDefault());
    }

    public void setHostSet(LinkedHashSet<String> linkedHashSet) {
        logger.debug("setHostSet() - Input: {}", linkedHashSet);
        this.virtualHostsToShutdown = null;
        if (linkedHashSet != null) {
            this.virtualHostsToShutdown = new LinkedHashSet<String>(linkedHashSet);
        }
        logger.debug("setHostSet() - virtualHostsToShutdown set to {}", this.virtualHostsToShutdown);
    }

    public final Set<String> getHostSet() {
        Set<String> set = Collections.emptySet();
        if (this.virtualHostsToShutdown != null) {
            set = Collections.unmodifiableSet(this.virtualHostsToShutdown);
        }
        logger.debug("getHostSet() - Result: {}", set);
        return set;
    }

    public Set<String> getProtectedHostList() {
        return this.protectedHosts;
    }

    protected void checkAdvancedPhysicalUpsGroup() {
        if (!(this.theTriggerEvent instanceof AdvancedGroupEvent)) {
            return;
        }
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.ups_setup_idx);
        if (uPSSetup == null) {
            return;
        }
        if (uPSSetup.isVirtualHostsShutdownEnabled()) {
            logger.debug("checkAdvancedPhysicalUpsGroup() - isVirtualHostsShutdownEnabled=true");
            this.isVirtualHostsShutdownEnabled = true;
        }
        if (uPSSetup.getHosts().isEmpty() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
            this.isAdvancedPhysicalUpsGroupNoHostShutdown = true;
            logger.debug("checkAdvancedPhysicalUpsGroup() - isAdvancedPhysicalUpsGroupNoHostShutdown=true");
        }
    }

    protected void logShutdownStartingEvent() {
        if (this.services.getVirtualConfigurationManager().isESXi() || this.services.getVirtualConfigurationManager().isHyperV()) {
            return;
        }
        DetailedEvent detailedEvent = null;
        logger.trace("logShutdownStartingEvent() - shutdown starting");
        if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)this.theTriggerEvent;
            ShutdownStartingFormatter shutdownStartingFormatter = new ShutdownStartingFormatter(kResourceBundle, StringEscapeUtils.escapeHtml4((String)advancedGroupEvent.getGroupName()));
            detailedEvent = new AdvancedGroupEvent(ShutdownEvents.ShutdownStarting.getObjectId(), shutdownStartingFormatter, advancedGroupEvent.getGroup(), advancedGroupEvent.getGroupName(), false, ShutdownEvents.ShutdownStarting.getEventId());
        } else {
            this.os_name = SystemUtils.IS_OS_WINDOWS ? kWindowsOSName : System.getProperty("os.name");
            ShutdownStartingFormatter shutdownStartingFormatter = new ShutdownStartingFormatter(kResourceBundle, this.os_name);
            detailedEvent = new DetailedEvent(ShutdownEvents.ShutdownStarting.getObjectId(), shutdownStartingFormatter, false, ShutdownEvents.ShutdownStarting.getEventId());
        }
        this.theEventConsumer.update((Event)detailedEvent);
    }

    protected void setVirtualHostsToShutdownList() {
        if (this.virtualHostsToShutdown != null) {
            return;
        }
        this.protectedHosts = this.services.getVirtualConfigurationManager().getProtectedVirtualHostsWithVsanTags(this.theTriggerEvent);
        logger.debug("setVirtualHostsToShutdownList() - list is null, setting it with protectedHosts: {}", this.protectedHosts);
        if (this.protectedHosts == null) {
            return;
        }
        this.setHostSet(this.protectedHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCriticalShutdownTimerHosts() {
        logger.debug("updateCriticalShutdownTimerHosts() - start Host protected:{} To shutdown:{}", this.protectedHosts, this.virtualHostsToShutdown);
        logger.debug("updateCriticalShutdownTimerHosts() - seek Lock");
        Object object = this.theState.getCriticalShutdownTimersLock();
        synchronized (object) {
            Object object2;
            Object object3;
            logger.debug("updateCriticalShutdownTimerHosts() - got Lock");
            if (this.virtualHostsToShutdown != null && !this.virtualHostsToShutdown.isEmpty()) {
                object3 = this.virtualHostsToShutdown.iterator();
                block3: while (object3.hasNext()) {
                    object2 = VsanUtils.removeVsanTagsFromHostname((String)object3.next());
                    logger.debug("updateCriticalShutdownTimerHosts() - host:{}", object2);
                    for (ShutdownTimer shutdownTimer : this.theState.getCriticalShutdownTimersList()) {
                        logger.debug("updateCriticalShutdownTimerHosts() - timer event:{} hosts: {}", (Object)shutdownTimer.getTriggerEvent(), shutdownTimer.getHostsToShutdown().keySet());
                        if (!shutdownTimer.didActualHostShutdown() || !shutdownTimer.getHostsToShutdown().containsKey(object2)) continue;
                        if (shutdownTimer.getHostsToShutdown().get(object2).booleanValue()) {
                            logger.debug("updateCriticalShutdownTimerHosts() - non-critical host: {}, not removing from virtualHostsToShutdown", object2);
                            continue block3;
                        }
                        if (!shutdownTimer.isShutdownInProgress()) continue;
                        logger.debug("updateCriticalShutdownTimerHosts() - no Shutdown/Startup as host: {} already critical, removing from virtualHostsToShutdown", object2);
                        object3.remove();
                        continue block3;
                    }
                }
            }
            if (this.theTriggerEvent != null && this.protectedHosts != null && !this.protectedHosts.isEmpty() && (object2 = this.theState.getCriticalShutdownTimer((EventKey)(object3 = new EventKey(this.theTriggerEvent)))) != null) {
                ((ShutdownTimer)object2).addCriticalHosts(this.protectedHosts);
                logger.debug("updateCriticalShutdownTimerHosts() - adding protected hosts: {} to shutdown list for event timer: {}", this.protectedHosts, object3);
            }
        }
        logger.debug("updateCriticalShutdownTimerHosts() - free Lock");
        logger.debug("updateCriticalShutdownTimerHosts() - end Host to shutdown:{}", this.virtualHostsToShutdown);
    }

    protected void logApplicationErrorEvent() {
        if ((this.services.getVirtualConfigurationManager().isESXi() || this.services.getVirtualConfigurationManager().isHyperV()) && !this.isAdvancedPhysicalUpsGroupNoHostShutdown) {
            LinkedHashSet<String> linkedHashSet = this.services.getVsanUtils().removeVsanTagsFromSet(this.virtualHostsToShutdown);
            this.services.getVirtualLoggingUtils().logCriticalEvent(linkedHashSet, this.theTriggerEvent);
        }
    }

    protected void addSnmpCriticalEventTrap() {
        Object object;
        Object object2;
        if (!PcnsTrapGenerator.isSNMPEnabled(this.services)) {
            return;
        }
        String string = OIdEventMapping.getEventName(this.theTriggerEvent);
        String string2 = null;
        if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
            object2 = (AdvancedGroupEvent)this.theTriggerEvent;
            string2 = ((AdvancedGroupEvent)((Object)object2)).getGroupName();
        }
        object2 = "";
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(Locale.getDefault());
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        if (resourceBundleWrapper != null) {
            object = this.virtualHostsToShutdown == null || this.virtualHostsToShutdown.isEmpty() ? (string2 == null ? Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEvent") : Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventAdv")) : (this.virtualHostsToShutdown.size() == 1 ? (string2 == null ? Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventHost") : Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventHostAdv")) : (string2 == null ? Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventHosts") : Utils.getResourceString(resourceBundleWrapper, "SNMPTRAP.CriticalEventHostsAdv")));
            messageFormat.applyPattern((String)object);
        }
        object = this.services.getVsanUtils().removeVsanTagsFromSet(this.virtualHostsToShutdown);
        Object[] objectArray = new Object[]{string, string2, Utils.vectorToString(new Vector<String>((Collection<String>)object))};
        object2 = messageFormat.format(objectArray);
        PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).startTrap(PcnsTrapGenerator.pcnsCriticalEventActive, (String)object2);
    }

    protected void setBaseProperties(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        this.theEventConsumer = iEventConsumer;
        this.theDataSource = iDataSource;
        this.thePermanentStorage = iPermanentStorage;
        this.theTriggerEvent = event;
        this.theState = shutdownState;
        if (event != null && event instanceof AdvancedGroupEvent) {
            this.ups_setup_idx = ((AdvancedGroupEvent)this.theTriggerEvent).getGroup();
        }
    }

    public void initialize(IEventConsumer iEventConsumer, IDataSource iDataSource, Event event, ShutdownState shutdownState, IPermanentStorage iPermanentStorage) {
        logger.debug("initialize() - start");
        this.theEventConsumer = iEventConsumer;
        this.theDataSource = iDataSource;
        this.thePermanentStorage = iPermanentStorage;
        this.theTriggerEvent = event;
        this.theState = shutdownState;
        if (event != null) {
            if (event instanceof AdvancedGroupEvent) {
                this.ups_setup_idx = ((AdvancedGroupEvent)this.theTriggerEvent).getGroup();
            }
            this.checkAdvancedPhysicalUpsGroup();
            this.logShutdownStartingEvent();
            this.setVirtualHostsToShutdownList();
        }
        this.updateCriticalShutdownTimerHosts();
        if (event != null) {
            this.logApplicationErrorEvent();
            this.addSnmpCriticalEventTrap();
        }
    }

    public void vMTasks() {
    }

    public void VCSAVMShutdown() {
    }

    public void enterMaintenanceMode() {
    }

    public void handleVCLS() {
    }

    public void hostShutdown() {
    }

    public void pcnsHostShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOffUpsOrOutlet(Event event) {
        Object object;
        logger.trace("turnOffUpsOrOutlet() - start, event: {}", (Object)event.getObjectId());
        if (event instanceof AdvancedGroupEvent) {
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
            object = "advanced_ups_setup_" + advancedGroupEvent.getGroup();
        } else {
            object = "Shutdown";
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.services.getConfigurationManager().getBoolean((String)object, "turnOffUps");
            bl2 = this.services.getConfigurationManager().getBoolean((String)object, "turnOffSOG");
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("turnOffUpsOrOutlet() - NoSuchElementException: {}", (Object)noSuchElementException.getMessage());
        }
        catch (ConversionException conversionException) {
            logger.error("turnOffUpsOrOutlet() - ConversionException: {}", (Object)conversionException.getMessage());
        }
        if ((bl || bl2) && !event.getObjectId().equals((Object)ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId()) && !event.getObjectId().equals((Object)ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId())) {
            Event event2;
            logger.info("turnOffUpsOrOutlet() - send Turn Off UPS event");
            TurnOffUpsStartingFormatter turnOffUpsStartingFormatter = new TurnOffUpsStartingFormatter(kResourceBundle, bl2);
            if (event instanceof AdvancedGroupEvent) {
                AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
                logger.info("turnOffUpsOrOutlet() - turn off SOG/UPS on Group: {}", (Object)advancedGroupEvent.getGroup());
                ObjectId objectId = null;
                if (event.getObjectId().equals((Object)UtilityLineStatus.PowerFailed.getObjectId()) || event.getObjectId().equals((Object)Battery.LowBattery.getObjectId())) {
                    boolean bl3 = false;
                    logger.debug("turnOffUpsOrOutlet() - seek Lock");
                    Object object2 = this.theState.getCriticalShutdownTimersLock();
                    synchronized (object2) {
                        logger.debug("turnOffUpsOrOutlet() - got Lock");
                        for (ShutdownTimer shutdownTimer : this.theState.getCriticalShutdownTimersList()) {
                            if (shutdownTimer.getTriggerEvent() == null || !(shutdownTimer.getTriggerEvent() instanceof AdvancedGroupEvent)) continue;
                            AdvancedGroupEvent advancedGroupEvent2 = (AdvancedGroupEvent)shutdownTimer.getTriggerEvent();
                            if (advancedGroupEvent.getGroup() != advancedGroupEvent2.getGroup() || !shutdownTimer.isEventCleared() || !advancedGroupEvent2.getObjectId().equals((Object)UtilityLineStatus.PowerFailed.getObjectId()) && !advancedGroupEvent2.getObjectId().equals((Object)Battery.LowBattery.getObjectId())) continue;
                            bl3 = true;
                            logger.debug("turnOffUpsOrOutlet() - critical event has been resolved");
                        }
                    }
                    logger.debug("turnOffUpsOrOutlet() - free Lock");
                    if (!bl3) {
                        objectId = ShutdownEvents.ShutdownOnBattery.getObjectId();
                        logger.debug("turnOffUpsOrOutlet() - turn off SOG/UPS onBattery");
                    } else {
                        objectId = ShutdownEvents.TurnOffUpsStarting.getObjectId();
                        logger.debug("turnOffUpsOrOutlet() - turn off SOG/UPS");
                    }
                } else {
                    objectId = ShutdownEvents.TurnOffUpsStarting.getObjectId();
                    logger.debug("turnOffUpsOrOutlet() - turn off SOG/UPS");
                }
                event2 = new AdvancedGroupEvent(objectId, (IFormatter)turnOffUpsStartingFormatter, advancedGroupEvent.getGroup(), advancedGroupEvent.getGroupName());
            } else {
                logger.info("turnOffUpsOrOutlet() - send simple Turn off UPS event");
                event2 = new Event(ShutdownEvents.TurnOffUpsStarting.getObjectId(), (IFormatter)turnOffUpsStartingFormatter);
            }
            this.theEventConsumer.update(event2);
        }
    }

    public void pcnsOSShutdown() {
        boolean bl = true;
        boolean bl2 = false;
        logger.debug("pcnsOSShutdown() - start");
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            bl = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "shutdownPowerchuteServer");
            boolean bl3 = this.services.getVirtualConfigurationManager().isESXi();
            boolean bl4 = this.services.getVirtualConfigurationManager().isHyperV();
            boolean bl5 = this.services.getVirtualConfigurationManager().isNutanixAHV();
            boolean bl6 = false;
            if (bl3 || bl4 || bl5) {
                bl2 = this.services.getVirtualConfigurationManager().getBooleanAdvanced(this.ups_setup_idx, "ShutdownVirtualHosts");
                bl6 = true;
            }
            if (!bl && (bl6 && bl2 || !bl6)) {
                this.services.getVirtualLoggingUtils().logShutdownPCNSDisabled(this.ups_setup_idx);
            }
            if (!bl && this.theTriggerEvent instanceof AdvancedGroupEvent && !bl3 && !bl4) {
                AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)this.theTriggerEvent;
                AdvancedGroupEvent advancedGroupEvent2 = new AdvancedGroupEvent(ShutdownEvents.ShutdownStarting.getObjectId(), false, advancedGroupEvent.getGroup(), advancedGroupEvent.getGroupName());
                this.theEventConsumer.update((Event)advancedGroupEvent2);
                AdvancedGroupEvent advancedGroupEvent3 = new AdvancedGroupEvent(ShutdownEvents.ShutdownCanceled.getObjectId(), true, advancedGroupEvent.getGroup(), advancedGroupEvent.getGroupName());
                this.theEventConsumer.update((Event)advancedGroupEvent3);
            }
        }
        if (!bl) {
            logger.debug("pcnsOSShutdown() - PCNS OS shutdown disabled, not shutting down PCNS host");
            return;
        }
        this.doOSShutdown();
        logger.debug("pcnsOSShutdown() - end");
    }

    protected void doOSShutdown() {
        logger.debug("doOSShutdown() - shutting down PCNS host");
        if (!this.theState.checkAndSetOSShutdownInProgress(true)) {
            logger.debug("doOSShutdown() - Not already In Progress");
            try {
                String string = null;
                Object object = new VirtualizationFeaturesFormatter(15);
                if (this.theTriggerEvent instanceof AdvancedGroupEvent) {
                    object = new AdvancedGroupFormatter((IFormatter)object);
                    string = object.format((Object)new AdvancedGroupEvent(ShutdownEvents.PhysicalMachineShutdown.getObjectId(), ((AdvancedGroupEvent)this.theTriggerEvent).getGroup(), ((AdvancedGroupEvent)this.theTriggerEvent).getGroupName()));
                } else {
                    string = object.format(null);
                }
                if (string != null) {
                    this.services.getOperatingSystemEventLogger().warn(string, ShutdownEvents.PhysicalMachineShutdown.getEventId());
                    this.services.getConfigurationManager().getApplicationErrorHandler().put(string);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
            this.doDelayedOSShutdown();
            this.theState.checkAndSetOSShutdownInProgress(false);
            logger.debug("doOSShutdown() - end");
        } else {
            logger.debug("doOSShutdown() - Already In Progress");
        }
    }

    protected void doDelayedOSShutdown() {
        DelayedOSShutdowner delayedOSShutdowner = new DelayedOSShutdowner(this.thePermanentStorage, this.services);
        delayedOSShutdowner.start();
        try {
            delayedOSShutdowner.join();
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)interruptedException);
        }
    }

    public CommandFile getCommandFile(Event event) {
        logger.debug("getCommandFile() - start");
        CommandFile commandFile = null;
        if (event instanceof AdvancedGroupEvent) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(((AdvancedGroupEvent)event).getGroup());
            if (uPSSetup != null && uPSSetup.getCmdFileEnabled()) {
                commandFile = new CommandFile(uPSSetup.getCmdFilePath(), null, 0, uPSSetup.getCmdFileDuration());
            }
        } else {
            ConfigurationManager configurationManager = this.services.getConfigurationManager();
            Boolean bl = false;
            try {
                bl = configurationManager.getBoolean("Shutdown", "shutdownCommandFileEnabled");
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.error((Object)throwable);
            }
            if (bl.booleanValue()) {
                String string = null;
                int n = 0;
                try {
                    string = configurationManager.getString("Shutdown", "shutdownCommandFile");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error((Object)throwable);
                }
                try {
                    n = configurationManager.getInt("Shutdown", "shutdownCommandFileDuration");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error((Object)throwable);
                }
                if (string != null && string.length() > 0) {
                    commandFile = new CommandFile(string, null, 0, n);
                }
            }
        }
        logger.debug("getCommandFile() - end");
        return commandFile;
    }

    public boolean isExecuteCommandFileAfterHostShutdown(Event event) {
        logger.debug("isExecuteCommandFileAfterHostShutdown() - start");
        boolean bl = false;
        if (this.services.getVirtualConfigurationManager().isExecuteCommandFileAfterHostShutdownSupported()) {
            if (event instanceof AdvancedGroupEvent) {
                UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(((AdvancedGroupEvent)event).getGroup());
                boolean bl2 = true;
                if (uPSSetup != null && this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && uPSSetup.getHosts().isEmpty() && !uPSSetup.isVirtualHostsShutdownEnabled()) {
                    bl2 = false;
                }
                if (uPSSetup != null && uPSSetup.getCmdFileEnabled() && bl2) {
                    bl = uPSSetup.isExecuteCommandFileAfterHostShutdown();
                }
            } else {
                ConfigurationManager configurationManager = this.services.getConfigurationManager();
                try {
                    if (configurationManager.getBoolean("Shutdown", "shutdownCommandFileEnabled").booleanValue()) {
                        bl = configurationManager.getBoolean("Shutdown", "executeCommandFileAfterHostShutdown");
                    }
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.debug((Object)throwable);
                }
            }
        }
        logger.debug("isExecuteCommandFileAfterHostShutdown() - end, result: {}", (Object)bl);
        return bl;
    }

    public int getDelayBeforeExecuteCommandFile(Event event) {
        int n = 0;
        if (event instanceof AdvancedGroupEvent) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(((AdvancedGroupEvent)event).getGroup());
            if (uPSSetup != null) {
                n = uPSSetup.getCmdFileDelay();
            }
        } else {
            try {
                n = this.services.getConfigurationManager().getInt("Shutdown", "shutdownCommandFileDelay");
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
        }
        logger.debug("getDelayBeforeExecuteCommandFile() - end, result: {}", (Object)n);
        return n;
    }

    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
    }

    public void performStartup() {
        this.performStartup(new PreConditionsSynchronizer());
    }

    public void shutdownCriticalHosts() {
        logger.debug("shutdownCriticalHosts() - not applicable");
    }

    public void performClusterStopOps() {
    }

    protected boolean isInvalidStateForStartup() {
        return this.virtualHostsToShutdown.stream().anyMatch(string -> {
            if (this.virtualisationStatusStore.isHostLockedForShutdown((String)string)) {
                logger.debug("isInvalidStateForStartup() - host: {} locked for shutdown, not performing SSH startup actions", string);
                return true;
            }
            if (this.theState.checkIfCriticalEventActive((String)string)) {
                logger.debug("isInvalidStateForStartup() - critical event on host: {}, not performing SSH startup actions", string);
                return true;
            }
            return false;
        });
    }

    public void logToEventLog(String string) {
        String string2 = Utils.getResourceString(this.bundle, string);
        this.errorHandler.put(string2);
    }

    public void logToEventLog(String string, Object object) {
        String string2 = MessageFormat.format(Utils.getResourceString(this.bundle, string), object);
        this.errorHandler.put(string2);
    }

    @Generated
    public LinkedHashSet<String> getVirtualHostsToShutdown() {
        return this.virtualHostsToShutdown;
    }

    @Generated
    public void setPerformHyperVUnmanagedVirtShutdown(boolean bl) {
        this.performHyperVUnmanagedVirtShutdown = bl;
    }

    @Generated
    public boolean isPerformHyperVUnmanagedVirtShutdown() {
        return this.performHyperVUnmanagedVirtShutdown;
    }

    @Generated
    public void setPerformingStartup(boolean bl) {
        this.performingStartup = bl;
    }

    @Generated
    public boolean isPerformingStartup() {
        return this.performingStartup;
    }

    @Generated
    public void setSshActionManager(SSHActionManager sSHActionManager) {
        this.sshActionManager = sSHActionManager;
    }
}

