/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.hosts;

import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.shutdowner.hosts.PreConditionsSynchronizer;
import com.apcc.m11.components.webserver.util.virtualization.vxrail.VxRailUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VxRailHost
extends ESXManagedHost {
    private static final Logger logger = LogManager.getLogger(VxRailHost.class);
    private boolean pcnsHostOutsideCluster = false;
    private boolean vcsaHostOutsideCluster = false;
    private Set<String> hostPartOfCluster = null;

    public VxRailHost(@NonNull ServiceManager serviceManager) {
        super(serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("serviceManager is marked non-null but is null");
        }
    }

    private boolean isHostSuitableToProcess(String string) {
        logger.debug("isHostPartOfCluster() - start() {}", (Object)string);
        if (this.hostPartOfCluster == null) {
            logger.debug("isHostPartOfCluster() - retrieving all hosts part of a cluster");
            this.hostPartOfCluster = this.services.getHostSystemUtils().getHostsPartOfCluster(this.virtualHostsToShutdown);
        }
        if (this.hostPartOfCluster.isEmpty()) {
            logger.debug("isHostPartOfCluster() - no host found to be part of a cluster, returning false");
            return false;
        }
        if (this.hostPartOfCluster.contains(string)) {
            logger.info("isHostPartOfCluster() - host {} is part of a cluster", (Object)string);
            return false;
        }
        return true;
    }

    @Override
    public boolean isHostSuitableForMaintenanceMode(String string) {
        logger.debug("isHostSuitableForMaintenanceMode() - start() {}", (Object)string);
        boolean bl = this.isHostSuitableToProcess(string);
        if (!bl) {
            logger.info("isHostSuitableForMaintenanceMode() - VxRail shutdown does not put Cluster hosts into maintenance mode. That is handled by the cluster shutdown.  Skipping host {}", (Object)string);
        }
        return bl;
    }

    @Override
    public boolean isHostSuitableForShutdown(String string) {
        logger.debug("isHostSuitableForShutdown() -  start () {}", (Object)string);
        boolean bl = this.isHostSuitableToProcess(string);
        if (!bl) {
            logger.info("isHostSuitableForShutdown() - VxRail shutdown does not shutdown Cluster hosts. That is handled by the cluster shutdown.  Skipping host {}", (Object)string);
        }
        return bl;
    }

    @Override
    public void performClusterStopOps() {
        logger.debug("performClusterStopOps() - start");
        if (!this.services.getHostSystemUtils().isHostPartOfCluster(this.theState.getHostSystemPCNSInstalled())) {
            this.pcnsHostOutsideCluster = true;
            logger.info("performClusterStopOps() - PCNS is on a host outside the Cluster");
        } else {
            logger.info("performClusterStopOps() - PCNS is on a host inside the Cluster");
        }
        this.isVcsaHostCritical(this.virtualHostsToShutdown);
        if (!this.services.getHostSystemUtils().isHostPartOfCluster(this.theState.getVCSAHost())) {
            this.vcsaHostOutsideCluster = true;
            logger.info("performClusterStopOps() - VCSA is on a host outside the Cluster");
        } else {
            logger.info("performClusterStopOps() - VCSA is on a host inside the Cluster");
        }
        ServiceInstance serviceInstance = this.getVCenterServiceInstance();
        this.setStartupTask(serviceInstance);
        super.setAutoStartPolicy(serviceInstance, this.pcnsHostOutsideCluster, this.vcsaHostOutsideCluster);
        this.services.getVxRailUtils().doClusterShutdown();
        if (this.pcnsHostOutsideCluster) {
            VxRailUtils vxRailUtils = this.services.getVxRailUtils();
            int n = vxRailUtils.getShutdownDuration() + vxRailUtils.getShutdownDelay();
            logger.info("performClusterStopOps() - PCNS host is outside the cluster, so waiting the cluster shutdown delay and duration:{}", (Object)n);
            new CountdownTimer(n, TimeUnit.SECONDS).sleep();
        }
        if (this.vcsaHostOutsideCluster) {
            logger.debug("performClusterStopOps() - VCSA host is outside of cluster, retrieving hosts part of cluster before VCSA VM shutdown");
            this.hostPartOfCluster = this.services.getHostSystemUtils().getHostsPartOfCluster(this.virtualHostsToShutdown);
            logger.info("performClusterStopOps() - VCSA host is outside of cluster, VCSA VM shutdown required");
            super.refreshVcsaHostName();
            super.refreshVcsaVmName();
            if (this.isVCenterPartOfCriticalHosts(this.getVCenterServiceInstance())) {
                super.setVcsaDetailsToVirtualisationStatusStore(this.vcsaVmName);
            }
            super.VCSAVMShutdown();
        }
        logger.debug("performClusterStopOps() - end");
    }

    private void setStartupTask(ServiceInstance serviceInstance) {
        if (serviceInstance != null && !this.pcnsHostOutsideCluster && !this.vcsaHostOutsideCluster) {
            logger.debug("setStartupTask() - Register PCNS Scheduled Startup Task...");
            this.services.getHostSystemUtils().addStartupTaskForPcns(serviceInstance);
        } else {
            logger.info("setStartupTask() - Conditions not met to set Scheduled Startup Task.  ServiceInstance available: {}, PCNS outside cluster: {}, vCSA within cluster: {}", (Object)(serviceInstance != null ? 1 : 0), (Object)(!this.pcnsHostOutsideCluster ? 1 : 0), (Object)(!this.vcsaHostOutsideCluster ? 1 : 0));
        }
    }

    @Override
    public void pcnsHostShutdown() {
        logger.info("pcnsHostShutdown() - VxRail shutdown does not shutdown any hosts.  That is handled by the cluster shutdown");
        for (String string : this.virtualHostsToShutdown) {
            this.virtualisationStatusStore.unlockHostForShutdown(string);
            logger.debug("pcnsOSShutdown() - after unlockHostForShutdown");
        }
        if (this.pcnsHostOutsideCluster) {
            super.pcnsHostShutdown();
        } else {
            logger.info("pcnsHostShutdown() - PCNS is inside the cluster, skipping pcns host shutdown");
        }
    }

    @Override
    public void VCSAVMShutdown() {
        logger.debug("VCSAVMShutdown() - VCSA VM shutdown for VxRail Host takes no action at this point.  VCSA VM shutdown deferred to later in the shutdown sequence.");
    }

    @Override
    protected boolean isVcsaHostCritical(Set<String> set) {
        HostSystem hostSystem = this.services.getHostSystemUtils().getHostSystemWithVCSAInstalled();
        VirtualMachine virtualMachine = this.services.getHostSystemUtils().getVCenterServerVM();
        this.cacheVcsaDetails(hostSystem, virtualMachine);
        boolean bl = this.services.getHostSystemUtils().isVCenterServerInstalledOnCriticalHost(set, this.getVCenterServiceInstance());
        boolean bl2 = this.services.getHostSystemUtils().isHostPartOfCluster(hostSystem);
        if (bl && bl2) {
            logger.info("isVcsaHostCritical() - VCSA host critical: {}, part of a cluster: {}, setting critical to false to prevent PCNS from shutting it down.", (Object)bl, (Object)bl2);
            bl = false;
        }
        return bl;
    }

    @Override
    public void pcnsOSShutdown() {
        logger.debug("pcnsOSShutdown() - start");
        if (this.pcnsHostOutsideCluster) {
            logger.info("pcnsOSShutdown() - PCNS is on a host outside the cluster, skipping OS shutdown");
        } else {
            logger.debug("pcnsOSShutdown() - PCNS is inside the cluster, do OS shutdown");
            this.doOSShutdown();
        }
        logger.debug("pcnsOSShutdown() - end");
    }

    @Override
    public boolean canWePerformVMAndVAppStartup(LinkedHashSet<String> linkedHashSet) {
        logger.debug("canWePerformVMAndVAppStartup() - VxRail standard cluster, returning true");
        return true;
    }

    @Override
    public void handleVCLS() {
    }

    @Override
    public void performStartup(PreConditionsSynchronizer preConditionsSynchronizer) {
        logger.debug("performStartup() - start");
        if (this.performESXStartup(preConditionsSynchronizer)) {
            this.doVMVAppStartupForAllHosts();
        }
        this.checkDrsSettings();
        logger.debug("performStartup() - end");
    }
}

