/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.ClusterConfigInfoEx;
import com.vmware.vim25.ClusterConfigSpecEx;
import com.vmware.vim25.ClusterDasConfigInfo;
import com.vmware.vim25.ComputeResourceConfigSpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DasSettings {
    private static Logger logger = LogManager.getLogger(DasSettings.class);
    private ServiceManager services;

    public DasSettings(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    public void enableHA(@NonNull ClusterComputeResource clusterComputeResource) throws InterruptedException, RuntimeFault, Exception {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        logger.debug("enableHA() - start");
        if (!this.isHAEnabled(clusterComputeResource)) {
            logger.debug("enableHA() - enabling HA");
            this.toggleHA(clusterComputeResource, true);
            int n = this.services.getVirtualConfigurationManager().getEnableHADelay();
            logger.debug("enableHA() - Starting enable HA delay with {} seconds", (Object)n);
            CountdownTimer countdownTimer = new CountdownTimer(n);
            countdownTimer.sleep();
        } else {
            logger.debug("enableHA() - HA is already enabled: ");
        }
        logger.debug("enableHA() - end");
    }

    public void disableHA(@NonNull ClusterComputeResource clusterComputeResource) throws InterruptedException, RuntimeFault, Exception {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        logger.debug("disableHA() - start");
        if (this.isHAEnabled(clusterComputeResource)) {
            logger.debug("disableHA() - disabling HA");
            this.toggleHA(clusterComputeResource, false);
            int n = this.services.getVirtualConfigurationManager().getDisableHADelay();
            logger.debug("disableHA() - Starting disabling HA delay with {} seconds", (Object)n);
            CountdownTimer countdownTimer = new CountdownTimer(n);
            countdownTimer.sleep();
        } else {
            logger.debug("disableHA() - HA is already disabled");
        }
        logger.debug("disableHA() - end");
    }

    public boolean isHAEnabled(ClusterComputeResource clusterComputeResource) {
        ClusterConfigInfoEx clusterConfigInfoEx = (ClusterConfigInfoEx)clusterComputeResource.getConfigurationEx();
        if (clusterConfigInfoEx == null) {
            logger.debug("isHAEnabled() - ClusterConfigInfo is null");
            return false;
        }
        ClusterDasConfigInfo clusterDasConfigInfo = clusterConfigInfoEx.getDasConfig();
        if (clusterDasConfigInfo == null) {
            logger.debug("isHAEnabled() - ClusterDasConfigInfo is null");
            return false;
        }
        return clusterDasConfigInfo.getEnabled();
    }

    private void toggleHA(@NonNull ClusterComputeResource clusterComputeResource, boolean bl) throws InterruptedException, RuntimeFault, Exception {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        logger.debug("toggleHA() - start");
        ClusterConfigInfoEx clusterConfigInfoEx = (ClusterConfigInfoEx)clusterComputeResource.getConfigurationEx();
        ClusterDasConfigInfo clusterDasConfigInfo = null;
        if (clusterConfigInfoEx != null) {
            logger.debug("toggleHA() - Reading DAS Config from cluster...");
            clusterDasConfigInfo = clusterConfigInfoEx.getDasConfig();
        }
        if (clusterDasConfigInfo == null) {
            logger.debug("toggleHA() - Failed to read DAS Config from cluster, making a new one...");
            clusterDasConfigInfo = new ClusterDasConfigInfo();
        }
        clusterDasConfigInfo.setEnabled(Boolean.valueOf(bl));
        ClusterConfigSpecEx clusterConfigSpecEx = new ClusterConfigSpecEx();
        clusterConfigSpecEx.setDasConfig(clusterDasConfigInfo);
        try {
            Task task = clusterComputeResource.reconfigureComputeResource_Task((ComputeResourceConfigSpec)clusterConfigSpecEx, true);
            task.waitForTask();
        }
        catch (InterruptedException | RemoteException exception) {
            logger.debug("toggleHA() - Exception during reconfiguration attempt.", (Throwable)exception);
            throw exception;
        }
        logger.debug("toggleHA() - end");
    }
}

