/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.ClusterConfigInfoEx;
import com.vmware.vim25.ClusterConfigSpecEx;
import com.vmware.vim25.ClusterDrsConfigInfo;
import com.vmware.vim25.ComputeResourceConfigSpec;
import com.vmware.vim25.DrsBehavior;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DrsSettings {
    private static Logger logger = LogManager.getLogger(DrsSettings.class);
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public DrsSettings(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    public void checkDrsSettingInPropertiesFile() {
        if (!this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            return;
        }
        Set<String> set = this.virtualisationStatusStore.getClusterSetWithDrsChanged();
        if (set.size() <= 0) {
            return;
        }
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            logger.debug("checkDrsSettingInPropertiesFile() - serviceInstance is null");
            return;
        }
        LinkedHashSet<String> linkedHashSet = this.virtualisationStatusStore.getHostSetFromVirtualizationFileStore(true);
        LinkedHashSet<String> linkedHashSet2 = this.virtualisationStatusStore.getHostSetFromVirtualizationFileStore(false);
        for (String string : set) {
            ClusterComputeResource clusterComputeResource = this.services.getClusterUtils().getCluster(serviceInstance, string);
            if (clusterComputeResource == null) {
                logger.info("checkDrsSettingInPropertiesFile() - cluster: {} not found, removing from property file", (Object)string);
                this.virtualisationStatusStore.removeClusterDrsChangedKey(string);
                continue;
            }
            logger.info("checkDrsSettingInPropertiesFile() - found cluster: {}", (Object)string);
            this.checkAndRevertDrsAutomationLevel(clusterComputeResource, linkedHashSet, linkedHashSet2);
        }
    }

    public void checkAndRevertDrsAutomationLevel(@NonNull ClusterComputeResource clusterComputeResource, Set<String> set, Set<String> set2) {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        boolean bl = false;
        if (set.size() > 0 || set2.size() > 0) {
            logger.debug("checkAndRevertDrsAutomationLevel() - locked hosts: {}, unlocked hosts: {}", set, set2);
            for (HostSystem hostSystem : clusterComputeResource.getHosts()) {
                if (!set.contains(hostSystem.getName()) && !set2.contains(hostSystem.getName())) continue;
                logger.info("checkAndRevertDrsAutomationLevel() - found host: {}", (Object)hostSystem.getName());
                bl = true;
                break;
            }
        }
        if (!bl) {
            boolean bl2 = true;
            if (this.isDrsEnabled(clusterComputeResource) && !this.isDrsFullyAutomated(clusterComputeResource)) {
                bl2 = this.setDrsDefaultBehavior(clusterComputeResource, DrsBehavior.fullyAutomated);
            }
            if (bl2) {
                this.virtualisationStatusStore.removeClusterDrsChangedKey(clusterComputeResource.getName());
            }
        }
    }

    public boolean isDrsEnabled(ClusterComputeResource clusterComputeResource) {
        logger.info("isDrsEnabled() - DRS enabled is: {} for cluster: {}", (Object)this.getClusterConfigInfo(clusterComputeResource).getDrsConfig().getEnabled(), (Object)clusterComputeResource.getName());
        return this.getClusterConfigInfo(clusterComputeResource).getDrsConfig().getEnabled();
    }

    public boolean isDrsFullyAutomated(ClusterComputeResource clusterComputeResource) {
        boolean bl = false;
        ClusterDrsConfigInfo clusterDrsConfigInfo = this.getClusterConfigInfo(clusterComputeResource).getDrsConfig();
        if (clusterDrsConfigInfo.getDefaultVmBehavior() != null) {
            String string = clusterDrsConfigInfo.getDefaultVmBehavior().toString();
            bl = DrsBehavior.fullyAutomated.toString().equalsIgnoreCase(string);
            logger.info("isDrsFullyAutomated() - DRS automation: {}", (Object)string);
        }
        return bl;
    }

    public boolean setDrsDefaultBehavior(@NonNull ClusterComputeResource clusterComputeResource, DrsBehavior drsBehavior) {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        boolean bl = false;
        ClusterConfigSpecEx clusterConfigSpecEx = new ClusterConfigSpecEx();
        ClusterDrsConfigInfo clusterDrsConfigInfo = this.getClusterConfigInfo(clusterComputeResource).getDrsConfig();
        clusterDrsConfigInfo.setDefaultVmBehavior(drsBehavior);
        clusterConfigSpecEx.setDrsConfig(clusterDrsConfigInfo);
        try {
            Task task = clusterComputeResource.reconfigureComputeResource_Task((ComputeResourceConfigSpec)clusterConfigSpecEx, true);
            task.waitForTask();
            bl = true;
        }
        catch (RemoteException remoteException) {
            logger.error("setDrsDefaultBehavior() - RemoteException: " + String.valueOf(remoteException));
        }
        catch (InterruptedException interruptedException) {
            logger.error("setDrsDefaultBehavior() - InterruptedException: " + String.valueOf(interruptedException));
        }
        catch (Exception exception) {
            logger.error("setDrsDefaultBehavior() - Exception: " + String.valueOf(exception));
        }
        if (!bl) {
            logger.warn("setDrsDefaultBehavior() - failed to set DRS Default Behavior on cluster: {} to: {}", (Object)clusterComputeResource.getName(), (Object)drsBehavior);
        } else {
            logger.info("setDrsDefaultBehavior() - set DRS Default Behavior on cluster: {} to: {}", (Object)clusterComputeResource.getName(), (Object)drsBehavior);
        }
        return bl;
    }

    private ClusterConfigInfoEx getClusterConfigInfo(@NonNull ClusterComputeResource clusterComputeResource) {
        if (clusterComputeResource == null) {
            throw new IllegalArgumentException("cluster is marked non-null but is null");
        }
        return (ClusterConfigInfoEx)clusterComputeResource.getConfigurationEx();
    }
}

