/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanFaultToleranceThreshold;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.HostMaintenanceSpec;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.Timedout;
import com.vmware.vim25.VsanHostDecommissionMode;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostMaintenanceMode {
    private static final Logger logger = LogManager.getLogger(HostMaintenanceMode.class);
    private static final String vSanMaintenanceMode_NoAction = "noAction";
    private static final String vSanMaintenanceMode_EnsureAccessibility = "ensureObjectAccessibility";
    private ShutdownState theState;
    private String host;
    private boolean isDelayMaintenanceModeEnabled;
    private VsanFaultToleranceThreshold vSanFttFeatures;
    private int upsSetupIdx = 0;
    private boolean isVirtualHostsShutdownEnabled;
    private boolean isVsanHost;
    private int delayMaintenanceModeTimeout = 0;
    private ServiceManager services;

    public HostMaintenanceMode(String string, boolean bl, ShutdownState shutdownState, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.host = string;
        this.isDelayMaintenanceModeEnabled = bl;
        this.theState = shutdownState;
        this.upsSetupIdx = n;
    }

    public boolean putHostIntoMaintenanceMode(HostSystem hostSystem, boolean bl) {
        boolean bl2 = false;
        logger.debug("putHostIntoMaintenanceMode() - start, retry: {}", (Object)bl);
        if (hostSystem == null) {
            logger.info("putHostIntoMaintenanceMode() - Null hostSystem passed. Assuming host is already down.");
            return true;
        }
        if (hostSystem.getRuntime().isInMaintenanceMode()) {
            logger.debug("putHostIntoMaintenanceMode() - host: {} already in Maintenance Mode", (Object)this.host);
            return true;
        }
        if (hostSystem.getRuntime().getPowerState() != HostSystemPowerState.poweredOn) {
            logger.debug("putHostIntoMaintenanceMode() - host: {} is Powered Off", (Object)this.host);
            return true;
        }
        HostMaintenanceSpec hostMaintenanceSpec = null;
        if (this.isVsanHost) {
            logger.info("putHostIntoMaintenanceMode() - detected vSAN host: {}", (Object)this.host);
            hostMaintenanceSpec = this.getVsanMaintenanceModeType();
            if (!bl) {
                this.services.getVirtualLoggingUtils().logVsanMaintenanceModeEnterEvent(this.host, hostMaintenanceSpec.getVsanMode().getObjectAction());
            }
        } else if (!bl) {
            this.services.getVirtualLoggingUtils().logMaintenanceModeEnterEvent(this.host);
        }
        try {
            Task task;
            if (this.isVsanHost) {
                task = hostSystem.enterMaintenanceMode(this.delayMaintenanceModeTimeout, false, hostMaintenanceSpec);
            } else {
                int n = 0;
                task = hostSystem.enterMaintenanceMode(n, false);
            }
            if (this.isDelayMaintenanceModeEnabled) {
                try {
                    logger.debug("putHostIntoMaintenanceMode() - waiting for: {} secs - Delay Host Maintenance Mode Timeout", (Object)this.delayMaintenanceModeTimeout);
                    TimeUnit.SECONDS.sleep(this.delayMaintenanceModeTimeout);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("putHostIntoMaintenanceMode() - InterruptedException: {}", (Object)interruptedException.getMessage());
                }
            }
            bl2 = this.checkMaintenanceModeTaskResult(task, this.host);
        }
        catch (Timedout timedout) {
            logger.error("putHostIntoMaintenanceMode() - Timeout: " + String.valueOf((Object)timedout));
        }
        catch (InvalidState invalidState) {
            logger.error("putHostIntoMaintenanceMode() - InvalidState: " + String.valueOf((Object)invalidState));
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("putHostIntoMaintenanceMode() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
        }
        catch (RemoteException remoteException) {
            logger.error("putHostIntoMaintenanceMode() - RemoteException: " + String.valueOf(remoteException));
        }
        catch (Exception exception) {
            logger.error("putHostIntoMaintenanceMode() - Exception: " + String.valueOf(exception));
        }
        logger.debug("putHostIntoMaintenanceMode() - end, result: {}", (Object)bl2);
        return bl2;
    }

    private boolean checkMaintenanceModeTaskResult(Task task, String string) {
        boolean bl = false;
        logger.debug("checkMaintenanceModeTaskResult() - start, host: {}", (Object)string);
        if (task == null) {
            logger.debug("checkMaintenanceModeTaskResult() - task is null");
            return bl;
        }
        try {
            if (this.isDelayMaintenanceModeEnabled) {
                if (task.getTaskInfo().getState() == TaskInfoState.running) {
                    logger.debug("checkMaintenanceModeTaskResult() - task running, attempting to cancel ~ longer Delay Maintenance Mode Timeout may be required");
                    task.cancelTask();
                    return bl;
                }
            } else {
                logger.debug("checkMaintenanceModeTaskResult() - waiting for Maintenance Mode task to complete");
                task.waitForTask();
            }
            if (task.getTaskInfo().getState() == TaskInfoState.error) {
                String string2;
                logger.debug("checkMaintenanceModeTaskResult() - task in error");
                String string3 = string2 = task.getTaskInfo().getError() != null ? task.getTaskInfo().getError().getLocalizedMessage() : null;
                if (!this.isDelayMaintenanceModeEnabled) {
                    this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(string, string2);
                } else {
                    logger.info("checkMaintenanceModeTaskResult() - failed to put Host: {} into Maintenance Mode, reason: {}", (Object)string, (Object)string2);
                }
            } else if (task.getTaskInfo().getState() == TaskInfoState.success) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeEnteredEvent(string);
                bl = true;
            }
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("checkMaintenanceModeTaskResult() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
        }
        catch (RemoteException remoteException) {
            logger.error("checkMaintenanceModeTaskResult() - RemoteException: " + String.valueOf(remoteException));
        }
        catch (InterruptedException interruptedException) {
            logger.error("checkMaintenanceModeTaskResult() - InterruptedException: " + String.valueOf(interruptedException));
        }
        catch (Exception exception) {
            logger.error("checkMaintenanceModeTaskResult() - Exception: " + String.valueOf(exception));
        }
        logger.debug("checkMaintenanceModeTaskResult() - end, result: {}", (Object)bl);
        return bl;
    }

    private HostMaintenanceSpec getVsanMaintenanceModeType() {
        logger.debug("getVsanMaintenanceModeType() - start");
        VsanHostDecommissionMode vsanHostDecommissionMode = new VsanHostDecommissionMode();
        HostMaintenanceSpec hostMaintenanceSpec = new HostMaintenanceSpec();
        if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            logger.info("getVsanMaintenanceModeType() - setting mode to: {}", (Object)vSanMaintenanceMode_NoAction);
            vsanHostDecommissionMode.setObjectAction(vSanMaintenanceMode_NoAction);
        } else if (this.isVirtualHostsShutdownEnabled) {
            logger.info("getVsanMaintenanceModeType() - VirtualHostsShutdown enabled, setting mode to: {}", (Object)vSanMaintenanceMode_NoAction);
            vsanHostDecommissionMode.setObjectAction(vSanMaintenanceMode_NoAction);
        } else if (this.services.getVirtualConfigurationManager().isVsanFTTEnabled()) {
            if (this.isAdvancedFTTExceeded()) {
                logger.info("getVsanMaintenanceModeType() - FTT exceeded, setting mode to: {}", (Object)vSanMaintenanceMode_NoAction);
                vsanHostDecommissionMode.setObjectAction(vSanMaintenanceMode_NoAction);
            } else {
                logger.info("getVsanMaintenanceModeType() - FTT OK, setting mode to: {}", (Object)vSanMaintenanceMode_EnsureAccessibility);
                vsanHostDecommissionMode.setObjectAction(vSanMaintenanceMode_EnsureAccessibility);
            }
        } else {
            logger.info("getVsanMaintenanceModeType() - FTT not enabled, setting mode to: {}", (Object)vSanMaintenanceMode_NoAction);
            vsanHostDecommissionMode.setObjectAction(vSanMaintenanceMode_NoAction);
        }
        hostMaintenanceSpec.setVsanMode(vsanHostDecommissionMode);
        logger.debug("getVsanMaintenanceModeType() - end");
        return hostMaintenanceSpec;
    }

    private boolean isAdvancedFTTExceeded() {
        boolean bl;
        logger.debug("isAdvancedFTTExceeded() - start");
        if (this.vSanFttFeatures == null) {
            this.vSanFttFeatures = new VsanFaultToleranceThreshold(this.theState, this.services);
        }
        if (!(bl = this.vSanFttFeatures.isFTTExceeded())) {
            this.vSanFttFeatures.createMapOfNonCriticalVsanGroups(this.upsSetupIdx);
            if (!this.vSanFttFeatures.getNonCriticalVsanGroupMap().isEmpty()) {
                this.vSanFttFeatures.setUnhealthySingleUpsGroups(this.services.getVsanUtils().getUnhealthyVsanSingleUpsGroups(this.vSanFttFeatures.getNonCriticalVsanGroupMap()));
                bl = this.vSanFttFeatures.isFTTExceeded();
            }
        }
        logger.debug("isAdvancedFTTExceeded() - end, result: {}", (Object)bl);
        return bl;
    }

    @Generated
    public void setVirtualHostsShutdownEnabled(boolean bl) {
        this.isVirtualHostsShutdownEnabled = bl;
    }

    @Generated
    public void setVsanHost(boolean bl) {
        this.isVsanHost = bl;
    }

    @Generated
    public void setDelayMaintenanceModeTimeout(int n) {
        this.delayMaintenanceModeTimeout = n;
    }
}

