/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.HostMaintenanceMode;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanSyncTraffic;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.mo.HostSystem;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostShutdownRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(HostShutdownRunnable.class);
    private HostSystem hostSystem;
    private String host;
    private ShutdownState theState;
    private int ups_setup_idx;
    private int retry_limit = 0;
    private boolean isVirtualHostsShutdownEnabled = false;
    private boolean isVsanHost = false;
    private int delayMaintenanceModeTimeout = 0;
    private Semaphore semaphore;
    private boolean isVcsaHost = false;
    private boolean isShutdownResult = false;
    private ServiceManager services;

    public HostShutdownRunnable(String string, ShutdownState shutdownState, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        logger.debug("HostShutdownRunnable() - host: {}", (Object)string);
        this.services = serviceManager;
        this.host = string;
        this.theState = shutdownState;
        this.ups_setup_idx = n;
    }

    @Override
    public void run() {
        logger.info("run() - start, host: {}, isVsan: {}", (Object)this.host, (Object)this.isVsanHost);
        try {
            if (this.isVsanHost) {
                logger.debug("run() - vSan Host");
                this.retry_limit = this.services.getVirtualConfigurationManager().getVsanSyncRetryLimit();
                if (this.isMaintenanceModeValidForHost() && !this.putHostIntoMaintenanceMode(false)) {
                    if (new VsanSyncTraffic().isSyncTrafficActiveForHost(this.getValidHostSystem())) {
                        this.waitIfSyncActiveOnVsanHost();
                        this.putHostIntoMaintenanceModeWithRetry();
                    } else {
                        this.putHostIntoMaintenanceModeWithRetry();
                        this.waitIfSyncActiveOnVsanHost();
                    }
                } else {
                    this.waitIfSyncActiveOnVsanHost();
                }
                this.shutdownHost();
            } else {
                logger.debug("run() - non-vSan Host");
                this.putHostIntoMaintenanceMode(true);
                this.shutdownHost();
            }
        }
        catch (Exception exception) {
            logger.warn("run() - Exception raised during Host Shutdown: {}", (Throwable)exception);
            throw exception;
        }
        finally {
            if (this.semaphore != null) {
                logger.debug("run() - release semaphore");
                this.semaphore.release();
            }
            logger.debug("run() - end");
        }
    }

    private boolean isMaintenanceModeValidForHost() {
        boolean bl = true;
        logger.debug("isMaintenanceModeValidForHost() - start, host: {}", (Object)this.host);
        if (this.getValidHostSystem() == null) {
            this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(this.host);
            bl = false;
        } else if (!this.services.getHostSystemUtils().areAllVMsPoweredOff(this.getValidHostSystem(), true)) {
            this.services.getVirtualLoggingUtils().logMaintenanceModeInvalidEvent(this.host);
            bl = false;
        }
        logger.info("isMaintenanceModeValidForHost() - end, result: {}", (Object)bl);
        return bl;
    }

    private boolean putHostIntoMaintenanceMode(boolean bl) {
        return this.putHostIntoMaintenanceMode(0, bl);
    }

    private boolean putHostIntoMaintenanceModeWithRetry() {
        return this.putHostIntoMaintenanceMode(this.retry_limit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putHostIntoMaintenanceMode(int n, boolean bl) {
        logger.info("putHostIntoMaintenanceMode() - start, host: {}", (Object)this.host);
        boolean bl2 = true;
        HostMaintenanceMode hostMaintenanceMode = this.services.getHostSystemUtils().getHostMaintenanceModeInstance(this.host, bl2, this.theState, this.ups_setup_idx, this.services);
        hostMaintenanceMode.setVsanHost(this.isVsanHost);
        hostMaintenanceMode.setVirtualHostsShutdownEnabled(this.isVirtualHostsShutdownEnabled);
        hostMaintenanceMode.setDelayMaintenanceModeTimeout(this.delayMaintenanceModeTimeout);
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        do {
            try {
                logger.info("putHostIntoMaintenanceMode() - looking for Maintenance Mode lock, attempt: {}", (Object)n2);
                this.theState.getMaintenanceModeLock().lock();
                logger.info("putHostIntoMaintenanceMode() - Maintenance Mode lock acquired, putting host into Mainteance Mode, attempt: {}", (Object)n2);
                bl3 = hostMaintenanceMode.putHostIntoMaintenanceMode(this.getValidHostSystem(), bl4);
            }
            catch (Exception exception) {
                logger.warn("putHostIntoMaintenanceMode() - Attempt failed due to exception", (Throwable)exception);
            }
            finally {
                logger.info("putHostIntoMaintenanceMode() - removing Maintenance Mode lock, attempt: {}", (Object)n2);
                this.theState.getMaintenanceModeLock().unlock();
            }
            bl4 = true;
        } while (!bl3 && ++n2 < n);
        if (!bl3 && bl) {
            this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(this.host);
        }
        logger.debug("putHostIntoMaintenanceMode() - end, result: {}", (Object)bl3);
        return bl3;
    }

    public void waitIfSyncActiveOnVsanHost() {
        if (this.getValidHostSystem() == null) {
            logger.warn("waitIfSyncActiveOnVsanHost() - hostSystem is null");
            return;
        }
        logger.debug("waitIfSyncActiveOnVsanHost() - start, host: {}", (Object)this.host);
        VsanSyncTraffic vsanSyncTraffic = new VsanSyncTraffic();
        boolean bl = vsanSyncTraffic.isSyncTrafficActiveForHost(this.getValidHostSystem());
        if (!bl) {
            logger.info("waitIfSyncActiveOnVsanHost() - data resynchronization is not active on host: {}", (Object)this.host);
            return;
        }
        int n = this.getVsanSyncDuration(this.host);
        if (n <= 0) {
            logger.warn("waitIfSyncActiveOnVsanHost() - detected data resynchronization on host: {}, not delaying as vSAN sync duration: {}", (Object)this.host, (Object)n);
            return;
        }
        int n2 = 0;
        do {
            this.services.getVirtualLoggingUtils().logVsanHostSyncDelayEvent(this.host);
            logger.info("waitIfSyncActiveOnVsanHost() - data resynchronization active, waiting: {} seconds - vSAN Synchronization Duration, retry: {}", (Object)n, (Object)n2);
            new CountdownTimer(n).sleep();
        } while ((bl = vsanSyncTraffic.isSyncTrafficActiveForHost(this.getValidHostSystem())) && ++n2 < this.retry_limit);
        if (!bl) {
            logger.info("waitIfSyncActiveOnVsanHost() - data resynchronization is no longer active on vSAN host: {}");
        } else {
            this.services.getVirtualLoggingUtils().logVsanHostSyncRetryLimitReachedEvent(this.host);
        }
        logger.debug("waitIfSyncActiveOnVsanHost() - end");
    }

    private int getVsanSyncDuration(String string) {
        int n = 0;
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(string);
            if (uPSSetup == null) {
                logger.warn("getVsanSyncDuration() - failed to find group for host: {}", (Object)string);
            } else {
                n = uPSSetup.getVMSettings().getVsanSyncTimeout();
            }
        } else {
            n = this.services.getVirtualConfigurationManager().getVsanSyncDuration();
        }
        logger.debug("getVsanSyncDuration() - end, host: {}, timeout: {}", (Object)string, (Object)n);
        return n;
    }

    private void shutdownHost() {
        logger.info("shutdownHost() - start, host: {}", (Object)this.host);
        if (this.getValidHostSystem() == null) {
            logger.debug("shutdownHost() - hostSystem is null for host: {}", (Object)this.host);
            if (!this.services.getShutdownLogger().findAndRemoveLogsByHostname(this.host)) {
                this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(this.host);
            }
            return;
        }
        if (!this.services.getHostSystemUtils().checkIfHostIsPoweredOn(this.getValidHostSystem())) {
            return;
        }
        if (this.isVcsaHost) {
            this.services.getVirtualLoggingUtils().logVCenterServerHostShutdownEvent(this.host);
        } else {
            this.services.getVirtualLoggingUtils().logTargetHostShutdownEvent(this.host);
        }
        if (!this.services.getHostSystemUtils().executeHostShutdown(this.getValidHostSystem(), this.host, this.theState.getHostWherePCNSInstalled())) {
            if (!this.services.getShutdownLogger().findAndRemoveLogsByHostname(this.host)) {
                this.services.getVirtualLoggingUtils().logTargetHostShutdownFailEvent(this.host);
            }
        } else {
            this.isShutdownResult = true;
            if (this.isVcsaHost) {
                this.theState.setVcsaHostShutdown(true);
            }
        }
        logger.debug("shutdownHost() - end");
    }

    private HostSystem getValidHostSystem() {
        this.hostSystem = this.services.getHostSystemUtils().getValidHostSystem(this.hostSystem, this.host);
        return this.hostSystem;
    }

    @Generated
    public void setVirtualHostsShutdownEnabled(boolean bl) {
        this.isVirtualHostsShutdownEnabled = bl;
    }

    @Generated
    public void setVsanHost(boolean bl) {
        this.isVsanHost = bl;
    }

    @Generated
    public void setDelayMaintenanceModeTimeout(int n) {
        this.delayMaintenanceModeTimeout = n;
    }

    @Generated
    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Generated
    public void setVcsaHost(boolean bl) {
        this.isVcsaHost = bl;
    }

    @Generated
    public boolean isShutdownResult() {
        return this.isShutdownResult;
    }
}

