/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.model.VMPriorityVector;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualApp;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMHostState {
    public static final Logger logger = LogManager.getLogger(VMHostState.class);
    private ServiceInstance serviceInstance = null;
    private HostSystem hostSystem = null;
    private int groupIdx = 0;
    private Set<String> virtualHostsToShutdown = null;
    private String mappedHostName = null;
    private boolean isAdvancedMode = false;
    private boolean isSkipMaintenanceModeEnabled = false;
    private boolean isVMPrioritizationEnabled = false;
    private List<VMPriority> priorities = null;
    private boolean isDelayMaintenanceModeEnabled = false;
    private String hostSystemName = null;
    private String criticalHostName = null;
    private boolean isVsanNonCriticalHost = false;
    private String vsanDatastoreName = null;
    private String vsanWitnessHostIp = null;
    private String vCSAName = null;
    private String connESXiHost = null;
    private String vCSAUuid = null;
    private String PCNSVMName = null;
    private boolean isVAppVMShutdownEventLogged = false;
    private boolean isVAppVCenterOfflineEventLogged = false;
    private boolean isVCSAVMShutdown = false;
    private Map<String, List<String>> vAppVMMap = new HashMap<String, List<String>>();
    private Set<VirtualApp> vAppShutdownSet = new LinkedHashSet<VirtualApp>();
    private Set<VirtualApp> vAppShutdownSetOnHealthyHost = new LinkedHashSet<VirtualApp>();
    private Map<String, List<String>> masterVAppMap = new HashMap<String, List<String>>();

    public VMHostState(ServiceInstance serviceInstance, HostSystem hostSystem, int n, Set<String> set, String string, boolean bl, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.serviceInstance = serviceInstance;
        this.hostSystem = hostSystem;
        this.groupIdx = n;
        this.virtualHostsToShutdown = set;
        this.mappedHostName = string;
        this.isAdvancedMode = bl;
        this.isVMPrioritizationEnabled = serviceManager.getVMPrioritizationUtils().isVMPrioritizationEnabled();
        this.priorities = new VMPriorityVector(this.isVMPrioritizationEnabled()).getPriorities();
    }

    public Map<String, List<String>> getVAppVMMap() {
        return this.vAppVMMap;
    }

    public Set<VirtualApp> getVAppShutdownSet() {
        return this.vAppShutdownSet;
    }

    public Map<String, List<String>> getMasterVAppMap() {
        return this.masterVAppMap;
    }

    public Set<VirtualApp> getVAppShutdownSetOnHealthyHost() {
        return this.vAppShutdownSetOnHealthyHost;
    }

    public void setConnESXiHost(String string) {
        logger.debug("setConnESXiHost() - Setting connESXiHost to: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)string, (CharSequence)"NULL"));
        this.connESXiHost = string;
    }

    public String getConnESXiHost() {
        logger.debug("getConnESXiHost() - Getting connESXiHost: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)this.connESXiHost, (CharSequence)"NULL"));
        return this.connESXiHost;
    }

    public void setCriticalHostName(String string) {
        logger.debug("setCriticalHostName() - Setting criticalHostname to: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)string, (CharSequence)"NULL"));
        this.criticalHostName = string;
    }

    public String getCriticalHostName() {
        logger.debug("getCriticalHostName() - Getting criticalHostname: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)this.criticalHostName, (CharSequence)"NULL"));
        return this.criticalHostName;
    }

    @Generated
    public void setServiceInstance(ServiceInstance serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    @Generated
    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    @Generated
    public void setHostSystem(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    @Generated
    public HostSystem getHostSystem() {
        return this.hostSystem;
    }

    @Generated
    public void setGroupIdx(int n) {
        this.groupIdx = n;
    }

    @Generated
    public int getGroupIdx() {
        return this.groupIdx;
    }

    @Generated
    public Set<String> getVirtualHostsToShutdown() {
        return this.virtualHostsToShutdown;
    }

    @Generated
    public String getMappedHostName() {
        return this.mappedHostName;
    }

    @Generated
    public boolean isAdvancedMode() {
        return this.isAdvancedMode;
    }

    @Generated
    public boolean isSkipMaintenanceModeEnabled() {
        return this.isSkipMaintenanceModeEnabled;
    }

    @Generated
    public void setSkipMaintenanceModeEnabled(boolean bl) {
        this.isSkipMaintenanceModeEnabled = bl;
    }

    @Generated
    public boolean isVMPrioritizationEnabled() {
        return this.isVMPrioritizationEnabled;
    }

    @Generated
    public List<VMPriority> getPriorities() {
        return this.priorities;
    }

    @Generated
    public boolean isDelayMaintenanceModeEnabled() {
        return this.isDelayMaintenanceModeEnabled;
    }

    @Generated
    public void setDelayMaintenanceModeEnabled(boolean bl) {
        this.isDelayMaintenanceModeEnabled = bl;
    }

    @Generated
    public String getHostSystemName() {
        return this.hostSystemName;
    }

    @Generated
    public void setHostSystemName(String string) {
        this.hostSystemName = string;
    }

    @Generated
    public boolean isVsanNonCriticalHost() {
        return this.isVsanNonCriticalHost;
    }

    @Generated
    public void setVsanNonCriticalHost(boolean bl) {
        this.isVsanNonCriticalHost = bl;
    }

    @Generated
    public String getVsanDatastoreName() {
        return this.vsanDatastoreName;
    }

    @Generated
    public void setVsanDatastoreName(String string) {
        this.vsanDatastoreName = string;
    }

    @Generated
    public String getVsanWitnessHostIp() {
        return this.vsanWitnessHostIp;
    }

    @Generated
    public void setVsanWitnessHostIp(String string) {
        this.vsanWitnessHostIp = string;
    }

    @Generated
    public String getVCSAName() {
        return this.vCSAName;
    }

    @Generated
    public void setVCSAName(String string) {
        this.vCSAName = string;
    }

    @Generated
    public String getVCSAUuid() {
        return this.vCSAUuid;
    }

    @Generated
    public void setVCSAUuid(String string) {
        this.vCSAUuid = string;
    }

    @Generated
    public String getPCNSVMName() {
        return this.PCNSVMName;
    }

    @Generated
    public void setPCNSVMName(String string) {
        this.PCNSVMName = string;
    }

    @Generated
    public boolean isVAppVMShutdownEventLogged() {
        return this.isVAppVMShutdownEventLogged;
    }

    @Generated
    public void setVAppVMShutdownEventLogged(boolean bl) {
        this.isVAppVMShutdownEventLogged = bl;
    }

    @Generated
    public boolean isVAppVCenterOfflineEventLogged() {
        return this.isVAppVCenterOfflineEventLogged;
    }

    @Generated
    public void setVAppVCenterOfflineEventLogged(boolean bl) {
        this.isVAppVCenterOfflineEventLogged = bl;
    }

    @Generated
    public boolean isVCSAVMShutdown() {
        return this.isVCSAVMShutdown;
    }

    @Generated
    public void setVCSAVMShutdown(boolean bl) {
        this.isVCSAVMShutdown = bl;
    }
}

