/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.hosts.ESXManagedHost;
import com.apcc.m11.components.shutdowner.vmware.DrsSettings;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.vappshutdown.VAppShutdownHost;
import com.apcc.m11.components.shutdowner.vmware.vmmigration.VMMigrationHost;
import com.apcc.m11.components.shutdowner.vmware.vmshutdown.VMShutdownHost;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.IPUtils;
import com.vmware.vim25.DrsBehavior;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.Timedout;
import com.vmware.vim25.VirtualMachineGuestState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Executors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualizationShutdownHost
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VirtualizationShutdownHost.class);
    private ShutdownState theState = null;
    private VMHostState hostState = null;
    private Task hostInMaintenanceModeTask;
    private boolean bMaintenanceResultLogged = false;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;
    private ESXManagedHost hostType;

    public VirtualizationShutdownHost(ShutdownState shutdownState, HostSystem hostSystem, ServiceInstance serviceInstance, int n, Set<String> set, String string, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.theState = shutdownState;
        logger.debug("VirtualizationShutdownRunnable ctor - HostSystem: {}", (Object)(hostSystem != null ? hostSystem.getName() : "NULL"));
        this.hostState = new VMHostState(serviceInstance, hostSystem, n, set, string, serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode(), serviceManager);
        this.hostState.setSkipMaintenanceModeEnabled(this.services.getVirtualConfigurationManager().isSkipMaintenanceModeEnabled());
    }

    public void setVsanNonCriticalHost(boolean bl) {
        this.hostState.setVsanNonCriticalHost(bl);
    }

    public void setVsanDatastoreName(String string) {
        this.hostState.setVsanDatastoreName(string);
    }

    public void setVsanWitnessHostIp(String string) {
        this.hostState.setVsanWitnessHostIp(string);
    }

    @Override
    public void run() {
        logger.debug("run() - start, host: {}", (Object)this.hostState.getMappedHostName());
        if (!this.canVirtualizationShutdownProceed()) {
            return;
        }
        this.setProperties();
        UPSSetup uPSSetup = null;
        if (this.hostState.isAdvancedMode() && (uPSSetup = this.getAdvancedUPSSetup()) == null) {
            return;
        }
        this.setDelayMaintenanceMode(uPSSetup);
        boolean bl = this.checkSkipVirtualizationShutdown();
        this.virtualisationStatusStore.lockHostForShutdown(this.hostState.getMappedHostName());
        this.checkDrsWithDelayMaintenanceMode();
        this.checkIfPCNSRunningOnVM();
        this.services.getVAppShutdownUtils().computeVirtualAppsToShutdown(this.theState, this.hostState);
        this.services.getVmShutdownUtils().waitIfVMStartupInProgress(this.theState, this.hostState);
        this.services.getVAppShutdownUtils().waitIfVAppStartupInProgress(this.theState, this.hostState);
        this.initiateHostMaintenanceMode();
        if (!bl) {
            this.virtualizationVMVAppFeatures(uPSSetup);
        } else {
            logger.debug("virtualizationShutdown() - skipping VMMigration, VM/vApp Shutdown, because FTT already turned off the VMs ");
        }
        this.checkPcnsHostMaintenanceMode();
        this.logEnterMaintenanceModeResult();
        logger.debug("run() - end");
    }

    private void checkDrsWithDelayMaintenanceMode() {
        logger.debug("checkDrsWithDelayMaintenanceMode() - start");
        if (!this.hostState.isDelayMaintenanceModeEnabled()) {
            return;
        }
        ClusterComputeResource clusterComputeResource = this.services.getClusterUtils().getClusterEntity(this.getHostSystem());
        if (clusterComputeResource == null) {
            logger.debug("checkDRSWithDelayMaintenanceMode() - host: {} not part of cluster", (Object)this.hostState.getHostSystemName());
            return;
        }
        DrsSettings drsSettings = new DrsSettings(this.services);
        if (!drsSettings.isDrsEnabled(clusterComputeResource) || !drsSettings.isDrsFullyAutomated(clusterComputeResource)) {
            return;
        }
        if (drsSettings.setDrsDefaultBehavior(clusterComputeResource, DrsBehavior.partiallyAutomated)) {
            this.virtualisationStatusStore.addClusterDrsChangedKey(clusterComputeResource.getName());
        }
        logger.debug("checkDrsWithDelayMaintenanceMode() - end");
    }

    private void setDelayMaintenanceMode(UPSSetup uPSSetup) {
        this.hostState.setDelayMaintenanceModeEnabled(uPSSetup != null ? uPSSetup.getVMSettings().isHostMaintenanceModeDelayed() : this.services.getVirtualConfigurationManager().isDelayMaintenanceModeEnabled());
        logger.debug("setDelayMaintenanceMode() - isDelayMaintenanceModeEnabled: {}", (Object)this.hostState.isDelayMaintenanceModeEnabled());
    }

    private boolean canVirtualizationShutdownProceed() {
        logger.debug("canVirtualizationShutdownProceed() - start");
        if (this.hostState.getHostSystem() == null) {
            logger.error("canVirtualizationShutdownProceed() - HostSystem is null, cannot execute virtualization shutdown");
            return false;
        }
        logger.debug("canVirtualizationShutdownProceed() - check host state");
        if (this.services.getHostSystemUtils().checkIfHostIsInInvalidState(this.getHostSystem())) {
            logger.error("canVirtualizationShutdownProceed() - host: {} not in valid state, cannot execute virtualization shutdown", (Object)this.hostState.getMappedHostName());
            return false;
        }
        logger.debug("canVirtualizationShutdownProceed() - check host responding");
        if (!this.services.getHostSystemUtils().checkIfHostIsResponding(this.getHostSystem())) {
            logger.error("canVirtualizationShutdownProceed() - host: {} not responding, cannot execute virtualization shutdown", (Object)this.hostState.getMappedHostName());
            return false;
        }
        logger.debug("canVirtualizationShutdownProceed() - check host powered on");
        if (!this.services.getHostSystemUtils().checkIfHostIsPoweredOn(this.getHostSystem())) {
            logger.error("canVirtualizationShutdownProceed() - host: {} powered off, cannot execute virtualization shutdown", (Object)this.hostState.getMappedHostName());
            return false;
        }
        if (!this.services.getVirtualConfigurationManager().isManagedHost() && !this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            logger.debug("canVirtualizationShutdownProceed() - host: {} is not managed", (Object)this.hostState.getMappedHostName());
            return false;
        }
        if (this.services.getVirtualConfigurationManager().getUPSConfigMode() == null) {
            logger.debug("canVirtualizationShutdownProceed() - ups config mode not found");
            return false;
        }
        logger.debug("canVirtualizationShutdownProceed() - end");
        return true;
    }

    private void setProperties() {
        String string;
        logger.debug("setProperties() - start");
        HostSystem hostSystem = this.getHostSystem();
        if (hostSystem != null) {
            this.hostState.setHostSystemName(hostSystem.getName());
            logger.debug("setProperties() - hostSystemName: {}", (Object)this.hostState.getHostSystemName());
            this.hostState.setCriticalHostName(hostSystem.getName());
            logger.debug("setProperties() - criticalHostName: {}", (Object)this.hostState.getCriticalHostName());
        } else {
            logger.debug("setProperties() - criticalHostName not set as reference was null.");
        }
        this.setVCSADetails();
        this.hostState.setConnESXiHost(this.hostState.getCriticalHostName());
        if (!IPUtils.isValidIPAddress(this.hostState.getCriticalHostName()) && !this.services.getVirtualConfigurationManager().isHostnameResolvable(this.hostState.getCriticalHostName()) && (string = this.services.getHostSystemUtils().getIPAddressFromHostname(this.hostState.getServiceInstance(), this.hostState.getCriticalHostName())) != null) {
            this.hostState.setConnESXiHost(string);
            this.theState.setIPForESXiHost(this.hostState.getCriticalHostName(), string);
        }
        logger.debug("setProperties() - end, connESXiHost: {}", (Object)this.hostState.getConnESXiHost());
    }

    private UPSSetup getAdvancedUPSSetup() {
        UPSSetup uPSSetup;
        if (this.services.getAdvancedSetupHelper().isPhysicalUPS(this.hostState.getGroupIdx())) {
            logger.debug("getAdvancedUPSSetup() - physical UPS setup, looking up upsSetup");
            uPSSetup = this.getVMSettingsOfHost();
        } else {
            uPSSetup = this.services.getAdvancedSetupHelper().isShutdownVirtualHostsEnabled(this.hostState.getGroupIdx()) ? this.getVMSettingsOfHost() : this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.hostState.getGroupIdx());
        }
        if (uPSSetup == null) {
            logger.debug("getAdvancedUPSSetup() - upsSetup is null");
        }
        return uPSSetup;
    }

    private UPSSetup getVMSettingsOfHost() {
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(this.hostState.getMappedHostName());
        if (uPSSetup != null) {
            logger.debug("getVMSettingsOfHost() - using upsSetup: {} to execute virtualizaton shutdown", (Object)uPSSetup.getName());
            this.hostState.setGroupIdx(uPSSetup.getGroup());
        } else {
            logger.debug("getVMSettingsOfHost() - unable to find upsSetup");
        }
        return uPSSetup;
    }

    private void virtualizationVMVAppFeatures(UPSSetup uPSSetup) {
        Object object;
        Object object2;
        logger.debug("virtualizationVMVAppFeatures() - start");
        if (this.isVMMigrationEnabled(uPSSetup)) {
            logger.debug("virtualizationVMVAppFeatures() - VMMigration");
            object2 = this.services.getVAppShutdownUtils().getESXiAPITypeFromServiceInstance(this.hostState);
            object = new VMMigrationHost(this.theState, this.hostState, this.services);
            ((VMMigrationHost)object).startVMMigration((String)object2);
        }
        if (this.isVMVAppShutdownEnabled(uPSSetup)) {
            logger.debug("virtualizationVMVAppFeatures() - VMVAppShutdown");
            object2 = Executors.newFixedThreadPool(2);
            object = new ArrayList();
            VMShutdownHost vMShutdownHost = new VMShutdownHost(this.theState, this.hostState, this.services);
            VAppShutdownHost vAppShutdownHost = new VAppShutdownHost(this.theState, this.hostState, this.services);
            object.add(Executors.callable(vAppShutdownHost));
            object.add(Executors.callable(vMShutdownHost));
            try {
                object2.invokeAll(object);
                object2.shutdownNow();
            }
            catch (InterruptedException interruptedException) {
                logger.error("virtualizationVMVAppFeatures() - InterruptedException: ", (Throwable)interruptedException);
            }
        }
        logger.debug("virtualizationVMVAppFeatures() - end");
    }

    private boolean isVMMigrationEnabled(UPSSetup uPSSetup) {
        return uPSSetup != null ? uPSSetup.getVMSettings().isGuestVMMigrationEnabled() : this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_migration");
    }

    private boolean isVMVAppShutdownEnabled(UPSSetup uPSSetup) {
        return uPSSetup != null ? uPSSetup.getVMSettings().isGuestVMVAppShutdownEnabled() : this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_vapp_shutdown");
    }

    private void logEnterMaintenanceModeResult() {
        logger.debug("logEnterMaintenanceModeResult() - start");
        if (this.hostInMaintenanceModeTask == null) {
            logger.debug("logEnterMaintenanceModeResult() - task is null");
            return;
        }
        if (this.bMaintenanceResultLogged) {
            logger.debug("logEnterMaintenanceModeResult() - bMaintenanceResultLogged is true");
            return;
        }
        if (this.hostState.isVCSAVMShutdown()) {
            logger.debug("logEnterMaintenanceModeResult() - not checking Maintenance Mode task result as vCSA VM has been shut down");
            return;
        }
        try {
            if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.success) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeEnteredEvent(this.hostState.getHostSystemName());
                this.bMaintenanceResultLogged = true;
            } else if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.error) {
                String string = this.hostInMaintenanceModeTask.getTaskInfo().getError() != null ? this.hostInMaintenanceModeTask.getTaskInfo().getError().getLocalizedMessage() : null;
                this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(this.hostState.getHostSystemName(), string);
                this.bMaintenanceResultLogged = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.vmwareConnection.isVCenterOffline()) {
                logger.debug("logEnterMaintenanceModeResult() - unable to get Maintenance Mode task result as vCenter connection is not available");
            } else {
                logger.error("logEnterMaintenanceModeResult() - NullPointerException: " + String.valueOf(nullPointerException));
            }
        }
        catch (Exception exception) {
            logger.error("logEnterMaintenanceModeResult() - Exception: ", (Throwable)exception);
        }
        logger.debug("logEnterMaintenanceModeResult() - end");
    }

    private void setVCSADetails() {
        logger.debug("setVCSADetails() - start");
        VirtualMachine virtualMachine = this.services.getHostSystemUtils().getVCenterServerVM(this.hostState.getServiceInstance());
        if (virtualMachine == null) {
            logger.debug("setVCSADetails() - vCSAVM is null");
            return;
        }
        this.hostState.setVCSAName(virtualMachine.getName());
        HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, this.hostState.getServiceInstance());
        if (hostSystem == null) {
            logger.debug("setVCSADetails() - vCSAHostSystem is null");
            return;
        }
        if (hostSystem.getName().equalsIgnoreCase(this.hostState.getCriticalHostName()) || hostSystem.getName().equalsIgnoreCase(this.hostState.getHostSystemName()) || this.services.getVirtualConfigurationManager().isCheckVcsaIpAddressEnabled() && this.services.getHostSystemUtils().isESXiHostIPAddress(this.hostState.getCriticalHostName(), hostSystem)) {
            this.hostState.setVCSAUuid(virtualMachine.getConfig().getUuid());
        }
        logger.debug("setVCSADetails() - end");
    }

    private void checkIfPCNSRunningOnVM() {
        logger.debug("checkIfPCNSRunningOnVM() - start");
        VirtualMachine virtualMachine = this.services.getHostSystemUtils().getVirtualMachineOnWhichPCNSInstalled(this.hostState.getServiceInstance());
        if (virtualMachine != null) {
            this.hostState.setPCNSVMName(virtualMachine.getName());
            logger.debug("checkIfPCNSRunningOnVM() - PCNS on VM: {}", (Object)this.hostState.getPCNSVMName());
        } else {
            logger.debug("checkIfPCNSRunningOnVM() - PCNS not found on cluster.");
        }
    }

    private void cancelMaintenanceModeTask() {
        HostSystem hostSystem = this.getHostSystem();
        if (hostSystem != null && this.services.getHostSystemUtils().checkIfHostIsInMaintenanceMode(hostSystem)) {
            logger.debug("getCriticalHostOutofMaintenanceMode() - host in maintenance mode");
            return;
        }
        try {
            if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.running || this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.queued) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeFailedEvent(this.hostState.getMappedHostName());
                this.hostInMaintenanceModeTask.cancelTask();
                logger.debug("getCriticalHostOutofMaintenanceMode() - cancelled Maintenance Mode on host: {}", (Object)this.hostState.getHostSystemName());
                this.bMaintenanceResultLogged = true;
            }
        }
        catch (Timedout timedout) {
            logger.error("getCriticalHostOutofMaintenanceMode() - Timedout: " + String.valueOf((Object)timedout));
        }
        catch (InvalidState invalidState) {
            logger.error("getCriticalHostOutofMaintenanceMode() - InvalidState: " + String.valueOf((Object)invalidState));
        }
        catch (NotAuthenticated notAuthenticated) {
            logger.error("getCriticalHostOutofMaintenanceMode() - NotAuthenticated: " + String.valueOf((Object)notAuthenticated));
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("getCriticalHostOutofMaintenanceMode() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
        }
        catch (RemoteException remoteException) {
            logger.error("getCriticalHostOutofMaintenanceMode() - RemoteException: " + String.valueOf(remoteException));
        }
        catch (Exception exception) {
            logger.error("getCriticalHostOutofMaintenanceMode() - Exception: " + String.valueOf(exception));
        }
    }

    private void checkPcnsHostMaintenanceMode() {
        try {
            logger.debug("checkPcnsHostMaintenanceMode() - start");
            if (!this.vmwareConnection.validateServiceInstance()) {
                this.hostState.setServiceInstance(null);
                this.hostState.setServiceInstance(this.vmwareConnection.getESXiHostInstance(this.hostState.getConnESXiHost()));
                this.hostState.setHostSystem(this.services.getHostSystemUtils().getHostUsingIPOrDNSName(this.hostState.getServiceInstance(), this.hostState.getConnESXiHost()));
            }
            HostSystem hostSystem = null;
            if (this.hostState.getServiceInstance() != null) {
                hostSystem = this.services.getHostSystemUtils().getHostSystemOnWhichPCNSInstalled(this.hostState.getServiceInstance());
                if (this.hostInMaintenanceModeTask != null && !this.services.getHostSystemUtils().areAllVMsPoweredOff(this.getHostSystem(), true) && hostSystem != null) {
                    this.cancelMaintenanceModeTask();
                }
                this.checkPcnsHost(hostSystem);
            } else {
                logger.error("checkPcnsHostMaintenanceMode() - service instance not retrieved, unable to perform check for PCNS host");
            }
        }
        catch (Exception exception) {
            logger.error("checkPcnsHostMaintenanceMode() - Exception: ", (Throwable)exception);
        }
        logger.debug("checkPcnsHostMaintenanceMode() - end");
    }

    private void checkPcnsHost(HostSystem hostSystem) {
        HostSystem hostSystem2 = null;
        VirtualMachine virtualMachine = this.services.getHostSystemUtils().getVCenterServerVM(this.hostState.getServiceInstance());
        if (virtualMachine != null) {
            hostSystem2 = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, this.hostState.getServiceInstance());
            if (hostSystem2 != null) {
                String string = hostSystem2.getName();
                logger.debug("checkPcnsHost() - vCenterServerName: {}", (Object)string);
                if (string.equalsIgnoreCase(this.hostState.getCriticalHostName()) || string.equalsIgnoreCase(this.hostState.getHostSystemName()) || this.services.getVirtualConfigurationManager().isCheckVcsaIpAddressEnabled() && this.services.getHostSystemUtils().isESXiHostIPAddress(this.hostState.getCriticalHostName(), hostSystem2)) {
                    String string2 = virtualMachine.getConfig().getUuid();
                    this.theState.setVCenterVMUUID(string2);
                }
            } else {
                logger.warn("checkPcnsHost() - hostSystemWithvCenterServer is null");
            }
        } else {
            logger.debug("checkPcnsHost() - vCenterVM is null");
            if (this.hostState.getVCSAUuid() != null) {
                logger.debug("checkPcnsHost() - Unable to getVCenterServerVM using vCSAUuid");
                this.theState.setVCenterVMUUID(this.hostState.getVCSAUuid());
            }
        }
        this.setPcnsHost(hostSystem, hostSystem2);
        logger.debug("checkPcnsHost() - end");
    }

    private void setPcnsHost(HostSystem hostSystem, HostSystem hostSystem2) {
        logger.debug("setPcnsHost() - start");
        String string = null;
        string = this.hostState.getServiceInstance().getAboutInfo().getApiType();
        if (hostSystem != null) {
            String string2 = hostSystem.getName();
            logger.debug("setPcnsHost() - PCNS host: {}", (Object)string2);
            if (hostSystem2 != null && hostSystem2.getName().equalsIgnoreCase(string2) || this.services.getHostSystemUtils().isPCNSHost(this.hostState.getServiceInstance(), this.hostState.getCriticalHostName(), hostSystem)) {
                logger.debug("setPcnsHost() - setting hostSystem with PCNS");
                this.theState.setHostSystemPCNSInstalled(hostSystem);
                if ("VirtualCenter".equalsIgnoreCase(string)) {
                    if (!this.services.getVirtualConfigurationManager().isHostnameResolvable(string2)) {
                        this.theState.setHostWherePCNSInstalled(this.services.getHostSystemUtils().getESXiHostIPAddress(hostSystem));
                    } else {
                        this.theState.setHostWherePCNSInstalled(string2);
                    }
                } else if ("HostAgent".equalsIgnoreCase(string)) {
                    this.theState.setHostWherePCNSInstalled(this.services.getHostSystemUtils().getESXiHostIPAddress(hostSystem));
                }
            } else {
                logger.debug("setPcnsHost() - this is not the PCNS Host");
            }
        } else {
            logger.warn("setPcnsHost() - hostSystemWithPCNS is null");
        }
        logger.debug("setPcnsHost() - end");
    }

    private Task initiateHostMaintenanceMode() {
        logger.debug("initiateHostMaintenanceMode() - start");
        if (this.hostType != null && !this.hostType.isHostSuitableForMaintenanceMode(this.hostState.getMappedHostName())) {
            logger.debug("initiateHostMaintenanceMode() - not putting host into Maintenance Mode, because it is not suitable for this type");
        } else if (this.hostState.isSkipMaintenanceModeEnabled()) {
            logger.debug("initiateHostMaintenanceMode() - skip Maintenance Mode is enabled, not putting host into Maintenance Mode");
        } else if (this.hostState.isDelayMaintenanceModeEnabled()) {
            logger.debug("initiateHostMaintenanceMode() - delay Maintenance Mode is enabled, not putting host into Maintenance Mode");
        } else {
            try {
                HostSystem hostSystem = this.getHostSystem();
                if (hostSystem == null) {
                    logger.debug("initiateHostMaintenanceMode() - hostSystem is null");
                } else {
                    int n = this.services.getVirtualConfigurationManager().getMaintenanceModeTimeoutDuration();
                    this.hostInMaintenanceModeTask = this.services.getHostSystemUtils().executeHostMaintenanceMode(hostSystem, n);
                    if (this.hostInMaintenanceModeTask != null) {
                        this.services.getVirtualLoggingUtils().logMaintenanceModeEnterEvent(this.hostState.getMappedHostName());
                    }
                    logger.debug("initiateHostMaintenanceMode() - after initiating maintenance mode");
                }
            }
            catch (Timedout timedout) {
                logger.error("initiateHostMaintenanceMode() - Timeout: " + String.valueOf((Object)timedout));
            }
            catch (InvalidState invalidState) {
                logger.error("initiateHostMaintenanceMode() - InvalidState: " + String.valueOf((Object)invalidState));
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("initiateHostMaintenanceMode() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
            }
            catch (RemoteException remoteException) {
                logger.error("initiateHostMaintenanceMode() - RemoteException: " + String.valueOf(remoteException));
            }
        }
        logger.debug("initiateHostMaintenanceMode() - end");
        return this.hostInMaintenanceModeTask;
    }

    public boolean checkMaintenanceModeResult() {
        boolean bl = true;
        logger.debug("checkMaintenanceModeResult() - start, host: {}", (Object)this.hostState.getHostSystemName());
        if (this.hostInMaintenanceModeTask == null) {
            logger.debug("checkMaintenanceModeResult() - task is null");
            return bl;
        }
        if (this.hostState.isVCSAVMShutdown()) {
            logger.debug("checkMaintenanceModeResult() - not checking Maintenance Mode task result as vCSA VM has been shut down, returning: {}", (Object)bl);
            return bl;
        }
        try {
            if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.running) {
                this.services.getVirtualLoggingUtils().logMaintenanceModeFailedEvent(this.hostState.getHostSystemName());
                this.hostInMaintenanceModeTask.cancelTask();
            } else if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.error) {
                if (!this.bMaintenanceResultLogged) {
                    String string = this.hostInMaintenanceModeTask.getTaskInfo().getError() != null ? this.hostInMaintenanceModeTask.getTaskInfo().getError().getLocalizedMessage() : null;
                    this.services.getVirtualLoggingUtils().logMaintenanceModeErrorEvent(this.hostState.getHostSystemName(), string);
                }
            } else if (this.hostInMaintenanceModeTask.getTaskInfo().getState() == TaskInfoState.success) {
                if (!this.bMaintenanceResultLogged) {
                    this.services.getVirtualLoggingUtils().logMaintenanceModeEnteredEvent(this.hostState.getHostSystemName());
                }
                bl = false;
            }
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("checkMaintenanceModeResult() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
        }
        catch (RemoteException remoteException) {
            logger.error("checkMaintenanceModeResult() - RemoteException: " + String.valueOf(remoteException));
        }
        catch (NullPointerException nullPointerException) {
            if (this.vmwareConnection.isVCenterOffline()) {
                logger.debug("checkMaintenanceModeResult() - unable to get Maintenance Mode task result as vCenter connection is not available");
            } else {
                logger.error("checkMaintenanceModeResult() - NullPointerException: " + String.valueOf(nullPointerException));
            }
        }
        catch (Exception exception) {
            logger.error("checkMaintenanceModeResult() - Exception: ", (Throwable)exception);
        }
        logger.debug("checkMaintenanceModeResult() - end, result: {}", (Object)bl);
        return bl;
    }

    private HostSystem getHostSystem() {
        this.hostState.setHostSystem(this.services.getHostSystemUtils().getValidHostSystem(this.hostState.getHostSystem(), this.hostState.getMappedHostName()));
        return this.hostState.getHostSystem();
    }

    private boolean checkSkipVirtualizationShutdown() {
        boolean bl = false;
        if (this.services.getVirtualConfigurationManager().isShutdownAllVsanVMsEnabled() && this.virtualisationStatusStore.isHostUnlockedForShutdown(this.hostState.getHostSystemName())) {
            logger.debug("checkSkipVirtualizationShutdown() - check VM State");
            try {
                VirtualMachine[] virtualMachineArray = this.hostState.getHostSystem().getVms();
                boolean bl2 = false;
                for (VirtualMachine virtualMachine : virtualMachineArray) {
                    if (virtualMachine.getRuntime().getPowerState() != VirtualMachinePowerState.poweredOn || virtualMachine.getGuest().getGuestState().equalsIgnoreCase(VirtualMachineGuestState.shuttingDown.toString()) || VsanUtils.isVmUsingDatastore(virtualMachine, this.hostState.getVsanDatastoreName())) continue;
                    bl2 = true;
                    logger.debug("checkSkipVirtualizationShutdown() - found powered on VM:{}", (Object)virtualMachine.getName());
                    break;
                }
                if (!bl2) {
                    bl = true;
                }
            }
            catch (RemoteException remoteException) {
                logger.error("checkSkipVirtualizationShutdown() - Unable to connect to host system {}", (Object)this.hostState.getHostSystemName());
            }
        }
        logger.debug("checkSkipVirtualizationShutdown() - returns {}", (Object)bl);
        return bl;
    }

    @Generated
    public void setHostType(ESXManagedHost eSXManagedHost) {
        this.hostType = eSXManagedHost;
    }
}

