/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.startup;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.model.VMPriorityVector;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ResourceConfigSpec;
import com.vmware.vim25.VirtualAppSummary;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VAppStartupRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VAppStartupRunnable.class);
    private String hostName;
    private ShutdownState theState;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public VAppStartupRunnable(String string, ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.hostName = string;
        this.theState = shutdownState;
    }

    @Override
    public void run() {
        try {
            String string;
            logger.debug("run() - start, host: {}", (Object)this.hostName);
            String string2 = this.services.getVirtualConfigurationManager().getFQDNFromIP(this.hostName);
            String string3 = this.services.getVirtualConfigurationManager().getIPFromHostName(this.hostName);
            List<String> list = this.virtualisationStatusStore.getStartupvAppList(string3);
            logger.debug("run() - startup list: {}", list);
            if (list != null && !list.isEmpty()) {
                string = string3;
            } else {
                logger.debug("run() - startup list is empty, trying FQDN");
                list = this.virtualisationStatusStore.getStartupvAppList(string2);
                string = string2;
            }
            this.performVAppStartup(list, string, this.theState, false);
            list = this.virtualisationStatusStore.getReattemptvAppStartupList(string);
            this.performVAppStartup(list, string, this.theState, true);
        }
        catch (Exception exception) {
            logger.error("run() - Exception: {}", (Throwable)exception);
        }
        logger.debug("run() - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performVAppStartup(List<String> list, String string, ShutdownState shutdownState, boolean bl) {
        logger.debug("performVAppStartup() - start, host: {}, vApps:{}", (Object)string, list);
        if (list == null || list.isEmpty()) {
            logger.debug("performVAppStartup() - startUpList is empty, no vApps to start");
            return;
        }
        if (shutdownState.checkIfCriticalEventActive(string)) {
            logger.debug("performVAppStartup() - critical event active on host: {}", (Object)string);
            return;
        }
        int n = this.getBeforeVMStartupDelay();
        logger.debug("performVAppStartup() - Before VM Startup sleep duration: {} ", (Object)n);
        new CountdownTimer(n).sleep();
        ArrayList<String> arrayList = new ArrayList<String>(list);
        try {
            for (String object2 : arrayList) {
                shutdownState.setVMWareVAppStartup(object2);
            }
            Iterator iterator = this.getVAppStartupPriorities(bl, string);
            VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
            Vector<String> vector = new Vector<String>();
            ListIterator listIterator = ((Vector)((Object)iterator)).listIterator(((Vector)((Object)iterator)).size());
            while (listIterator.hasPrevious()) {
                VMPriority vMPriority = (VMPriority)((Object)listIterator.previous());
                logger.debug("performVAppStartup() - priority: {}", (Object)vMPriority);
                int n2 = this.services.getVMPrioritizationUtils().getVMVAppStartupDuration(vMPriority, vMPrioritizationDurations, string);
                List<String> list2 = this.services.getVMPrioritizationUtils().filterVAppsByPriority(list, vMPriority);
                if (n2 <= 0) {
                    this.logPriorityDurationZero(list2, vMPriority);
                    continue;
                }
                CountdownTimer countdownTimer = new CountdownTimer(n2, TimeUnit.SECONDS);
                if (list2.size() == 0) {
                    logger.debug("performVAppStartUp() - vApp list is empty, still sleeping duration: {} for priority: {}", (Object)n2, (Object)vMPriority);
                    countdownTimer.sleep();
                    continue;
                }
                ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
                if (serviceInstance == null) {
                    logger.debug("performVAppStartup() - vCenter serviceInstance is null, unable to start vApps");
                    for (String string2 : list2) {
                        vector.add(string2);
                    }
                    countdownTimer.sleep();
                    continue;
                }
                ExecutorService executorService = Executors.newFixedThreadPool(list2.size());
                Map<String, Future<VAppStartupResult>> map = this.initializeAndExecuteVAppStartupTasks(serviceInstance, executorService, list2, bl);
                this.waitForStartupTasksToComplete(executorService, n2);
                this.updateStartupTasksResults(map, list2);
                if (!list2.isEmpty()) {
                    logger.debug("performVAppStartup() - failed to start vApps: {}", list2);
                    for (String string3 : list2) {
                        vector.add(string3);
                    }
                }
                countdownTimer.sleep();
            }
            this.updateReattemptVAppsInProperties(bl, vector);
        }
        finally {
            logger.debug("performVAppStartup() - unlock lockedList:{} startUpList:{} ", arrayList, list);
            for (String string4 : arrayList) {
                shutdownState.clearVMWareVAppStartup(string4);
            }
        }
        logger.debug("performvAppStartup() - end");
    }

    private void updateReattemptVAppsInProperties(boolean bl, List<String> list) {
        if (!bl) {
            this.virtualisationStatusStore.clearVApps(this.hostName);
            if (!list.isEmpty()) {
                logger.debug("updateReattemptVMsInProperties() - writing vApps to reattempt");
                this.virtualisationStatusStore.saveReAttemptVApps(list, this.hostName);
            }
        } else {
            this.virtualisationStatusStore.clearReattemptVApps(this.hostName);
        }
    }

    private void logPriorityDurationZero(List<String> list, VMPriority vMPriority) {
        if (!list.isEmpty()) {
            logger.error("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup of vApps: {}", (Object)vMPriority, list);
        } else {
            logger.debug("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup", (Object)vMPriority);
        }
    }

    private Map<String, Future<VAppStartupResult>> initializeAndExecuteVAppStartupTasks(ServiceInstance serviceInstance, ExecutorService executorService, List<String> list, boolean bl) {
        logger.debug("initializeAndExecuteVAppStartupTasks() - start");
        HashMap<String, Future<VAppStartupResult>> hashMap = new HashMap<String, Future<VAppStartupResult>>(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                VirtualApp virtualApp = (VirtualApp)new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder()).searchManagedEntity("VirtualApp", string);
                if (virtualApp == null) {
                    logger.debug("initializeAndExecuteVAppStartupTasks() - unable to find vApp: {} in inventory, removing from property file", (Object)string);
                    iterator.remove();
                    continue;
                }
                logger.debug("initializeAndExecuteVAppStartupTasks() - starting vApp: {}", (Object)virtualApp.getName());
                if (!this.areVAppHostsOn(virtualApp)) {
                    logger.debug("initializeAndExecuteVAppStartupTasks() - startup cannot be performed");
                    continue;
                }
                logger.debug("initializeAndExecuteVAppStartupTasks() - ready to be started");
                VirtualApp virtualApp2 = virtualApp;
                while (!(virtualApp2 instanceof Datacenter)) {
                    virtualApp2 = virtualApp2.getParent();
                }
                if (!(virtualApp.getSummary() instanceof VirtualAppSummary)) {
                    logger.debug("initializeAndExecuteVAppStartupTasks() - not instance of VirtualAppSummary");
                    continue;
                }
                if (this.services.getVirtualApplianceUtils().isVAppStopped(virtualApp)) {
                    logger.debug("initializeAndExecuteVAppStartupTasks() - starting vApp");
                    Vector<String> vector = new Vector<String>();
                    vector.add(virtualApp.getName());
                    vector.add(virtualApp2.getName());
                    if (!bl) {
                        this.services.getVirtualLoggingUtils().logVAppStartupEvent(vector);
                    } else {
                        this.services.getVirtualLoggingUtils().logReattemptVAppStartupEvent(vector);
                    }
                    hashMap.put(virtualApp.getName(), executorService.submit(new VAppStartupTask(virtualApp)));
                    continue;
                }
                if (this.services.getVirtualApplianceUtils().isVAppStarted(virtualApp) || this.services.getVirtualApplianceUtils().isVAppStarting(virtualApp)) {
                    logger.debug("initializeAndExecuteVAppStartupTasks() - vApp is started or starting");
                    iterator.remove();
                    continue;
                }
                logger.debug("initializeAndExecuteVAppStartupTasks() - vApp in unexpected state: {}", (Object)this.services.getVirtualApplianceUtils().getAppState(virtualApp));
            }
            catch (RemoteException remoteException) {
                logger.debug("initializeAndExecuteVAppStartupTasks() - RemoteException: ", (Throwable)remoteException);
            }
        }
        logger.debug("initializeAndExecuteVAppStartupTasks() - end");
        return hashMap;
    }

    private boolean areVAppHostsOn(VirtualApp virtualApp) {
        boolean bl = false;
        logger.debug("areVAppHostsOn() - start");
        try {
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
            if (serviceInstance == null || virtualApp == null) {
                logger.debug("areVAppHostsOn() - serviceInstance or vApp is null");
                return bl;
            }
            Set<VirtualMachine> set = this.getAllVAppVMs(serviceInstance, virtualApp);
            for (VirtualMachine virtualMachine : set) {
                HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, serviceInstance);
                if (hostSystem == null) continue;
                if (this.services.getHostSystemUtils().isVCenterServerInstalledOnTargetHost()) {
                    logger.debug("Vcenter Installed on Target Host");
                    String string = this.services.getHostSystemUtils().getESXIConnStr(serviceInstance, hostSystem.getName());
                    ServiceInstance serviceInstance2 = this.vmwareConnection.getESXiHostInstance(string);
                    if (serviceInstance2 != null) {
                        hostSystem = this.services.getHostSystemUtils().getHostUsingIPOrDNSName(serviceInstance2, string);
                    }
                }
                if (this.services.getHostSystemUtils().checkIfHostIsPoweredOn(hostSystem) && !hostSystem.getRuntime().isInMaintenanceMode()) {
                    bl = true;
                    continue;
                }
                logger.debug("areVAppHostsOn() - vApp requires a host which is powered on and not in Maintenance Mode");
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            logger.error("areVAppHostsOn() - Exception: ", (Throwable)exception);
        }
        logger.debug("areVAppHostsOn() - end, result: {}", (Object)bl);
        return bl;
    }

    private Set<VirtualMachine> getAllVAppVMs(ServiceInstance serviceInstance, VirtualApp virtualApp) {
        Set<VirtualMachine> set = new HashSet<VirtualMachine>();
        logger.debug("getAllVAppVMs() - start vApp: {}", (Object)virtualApp.getName());
        try {
            ResourceConfigSpec[] resourceConfigSpecArray = virtualApp.getChildConfiguration();
            if (resourceConfigSpecArray != null && resourceConfigSpecArray.length > 0) {
                set = this.getMasterVAppVMs(serviceInstance, resourceConfigSpecArray, virtualApp);
            }
            if (virtualApp.getVMs().length > 0) {
                logger.debug("getAllVAppVMs() - adding vApp VMs");
                set.addAll(Arrays.asList(virtualApp.getVMs()));
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getAllVAppVMs() - RemoteException: " + String.valueOf(remoteException));
        }
        logger.debug("getAllVAppVMs() - end");
        return set;
    }

    private Set<VirtualMachine> getMasterVAppVMs(ServiceInstance serviceInstance, ResourceConfigSpec[] resourceConfigSpecArray, VirtualApp virtualApp) {
        HashSet<VirtualMachine> hashSet = new HashSet<VirtualMachine>();
        logger.debug("getMasterVAppVMs() - start");
        for (ResourceConfigSpec resourceConfigSpec : resourceConfigSpecArray) {
            ManagedObjectReference managedObjectReference = resourceConfigSpec.getEntity();
            if (!managedObjectReference.getType().equals("VirtualApp")) continue;
            VirtualApp virtualApp2 = new VirtualApp(serviceInstance.getServerConnection(), managedObjectReference);
            logger.debug("getMasterVAppVMs() - child vApp: {}", (Object)virtualApp2.getName());
            try {
                if (virtualApp2.getVMs().length <= 0) continue;
                logger.debug("getAllVAppVMs() - adding child vApp: {} VMs", (Object)virtualApp2.getName());
                hashSet.addAll(Arrays.asList(virtualApp2.getVMs()));
            }
            catch (RemoteException remoteException) {
                logger.error("getMasterVAppVMs() - RemoteException: " + String.valueOf(remoteException));
            }
        }
        logger.debug("getMasterVAppVMs() - end");
        return hashSet;
    }

    private void waitForStartupTasksToComplete(ExecutorService executorService, int n) {
        logger.debug("waitForStartupTasksToComplete() - start");
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(n, TimeUnit.SECONDS)) {
                logger.debug("waitForStartupTasksToComplete() - one or more vApp Startup tasks had insufficient time to complete");
                executorService.shutdownNow();
                if (!executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger.error("waitForStartupTasksToComplete() - failed to interrupt one or more timed out vApp Startup tasks");
                } else {
                    logger.debug("waitForStartupTasksToComplete() - all timed out vApp Startup tasks were successfully interrupted");
                }
            }
            logger.debug("waitForStartupTasksToComplete() - vApp startup tasks completed");
        }
        catch (InterruptedException interruptedException) {
            logger.debug("waitForStartupTasksToComplete() - vApp startup tasks interrupted!");
        }
        logger.debug("waitForStartupTasksToComplete() - end");
    }

    private void updateStartupTasksResults(Map<String, Future<VAppStartupResult>> map, List<String> list) {
        logger.debug("updateStartupTasksResults() - start");
        for (Map.Entry<String, Future<VAppStartupResult>> entry : map.entrySet()) {
            Future<VAppStartupResult> future = entry.getValue();
            if (!future.isDone()) {
                logger.error("updateStartupTasksResults() - vApp: {} startup task is not done!", (Object)entry.getKey());
                continue;
            }
            VAppStartupResult vAppStartupResult = VAppStartupResult.UNKNOWN;
            try {
                vAppStartupResult = future.get();
            }
            catch (InterruptedException interruptedException) {
                logger.debug("updateStartupTasksResults() - InterruptedException: ", (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                logger.error("updateStartupTasksResults() - ExecutionException: ", (Throwable)executionException);
            }
            logger.debug("updateStartupTasksResults() - vApp: {} startup result: {}", (Object)entry.getKey(), (Object)vAppStartupResult);
            if (!VAppStartupResult.SUCCESS.equals((Object)vAppStartupResult) && !VAppStartupResult.INTERRUPTED.equals((Object)vAppStartupResult)) continue;
            logger.debug("updateStartupTasksResults() - vApp: {} removed from startup list", (Object)entry.getKey());
            list.remove(entry.getKey());
        }
        logger.debug("updateStartupTasksResults() - end");
    }

    private Vector<VMPriority> getVAppStartupPriorities(boolean bl, String string) {
        logger.debug("getVAppStartupPriorities() - start");
        Vector<VMPriority> vector = !bl ? new VMPriorityVector(this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled()).getPriorities() : new VMPriorityVector(false).getPriorities();
        return vector;
    }

    private int getBeforeVMStartupDelay() {
        UPSSetup uPSSetup = null;
        int n = 0;
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(this.hostName);
            if (uPSSetup != null) {
                n = uPSSetup.getVMSettings().getBeforeVmStartupDelay();
            }
        } else {
            n = this.services.getVirtualConfigurationManager().getDurationGlobal("delay_before_vmstartup");
        }
        logger.debug("getBeforeVMStartupDelay() - end, duration: {}", (Object)n);
        return n;
    }

    private class VAppStartupTask
    implements Callable<VAppStartupResult> {
        private VirtualApp virtualApp;

        public VAppStartupTask(VirtualApp virtualApp) {
            this.virtualApp = virtualApp;
        }

        @Override
        public VAppStartupResult call() {
            VAppStartupResult vAppStartupResult;
            block6: {
                vAppStartupResult = VAppStartupResult.UNKNOWN;
                logger.info("call() - vApp Power on: {}", (Object)this.virtualApp.getName());
                try {
                    Task task = this.virtualApp.powerOnVApp_Task();
                    try {
                        if (task.waitForTask().equals("success")) {
                            logger.debug("call() - vApp: {} powered on successfully", (Object)this.virtualApp.getName());
                            vAppStartupResult = VAppStartupResult.SUCCESS;
                            break block6;
                        }
                        logger.error("call() - vApp: {} failed to power on", (Object)this.virtualApp.getName());
                        vAppStartupResult = VAppStartupResult.FAILED;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("call() - interrupted while waiting for vApp: {} to power on", (Object)this.virtualApp.getName());
                        VAppStartupRunnable.this.services.getVirtualLoggingUtils().logVAppStartupTimeoutLogEvent(this.virtualApp.getName());
                        vAppStartupResult = VAppStartupResult.INTERRUPTED;
                    }
                }
                catch (RemoteException remoteException) {
                    logger.debug("call() - power on vApp: {}, RemoteException: ", (Object)this.virtualApp.getName(), (Object)remoteException);
                    vAppStartupResult = VAppStartupResult.FAILED;
                }
                catch (Exception exception) {
                    logger.error("call() - power on vApp: {}, Exception: ", (Object)this.virtualApp.getName(), (Object)exception);
                    vAppStartupResult = VAppStartupResult.FAILED;
                }
            }
            return vAppStartupResult;
        }
    }

    private static enum VAppStartupResult {
        SUCCESS,
        FAILED,
        INTERRUPTED,
        UNKNOWN;

    }
}

