/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.startup;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.model.VMPriorityVector;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.CreateVCenterAlarm;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.CountdownTimer;
import com.vmware.vim25.FaultToleranceConfigInfo;
import com.vmware.vim25.FaultToleranceSecondaryConfigInfo;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachineConnectionState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMStartupRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VMStartupRunnable.class);
    private String hostName;
    private ShutdownState theState;
    boolean vCSAVMStarted = false;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public VMStartupRunnable(String string, ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.hostName = string;
        this.theState = shutdownState;
    }

    @Override
    public void run() {
        try {
            logger.debug("run() - start, host: {}", (Object)this.hostName);
            String string = this.services.getVirtualConfigurationManager().getFQDNFromIP(this.hostName);
            String string2 = this.services.getVirtualConfigurationManager().getIPFromHostName(this.hostName);
            int n = this.getBetweenVMStartupDelay();
            int n2 = this.getBeforeVMStartupDelay();
            this.theState.setVMWareVMStartup(this.hostName);
            String string3 = string2;
            List<String> list = this.virtualisationStatusStore.getStartupVMList(string2);
            boolean bl = false;
            if (list != null && !list.isEmpty()) {
                this.performVMStartUp(list, string2, n2, n, false);
                bl = true;
            } else {
                logger.debug("run() - startup list is empty, trying FQDN");
                string3 = string;
                list = this.virtualisationStatusStore.getStartupVMList(string);
                if (list != null && !list.isEmpty()) {
                    this.performVMStartUp(list, string, n2, n, false);
                    bl = true;
                }
            }
            list = this.virtualisationStatusStore.getReattemptVMStartupList(string3);
            if (list != null && !list.isEmpty()) {
                if (bl) {
                    TimeUnit.MINUTES.sleep(2L);
                }
                this.performVMStartUp(list, string3, 0, n, true);
            }
            this.theState.clearVMWareVMStartup(this.hostName);
        }
        catch (Exception exception) {
            logger.error("run() - Exception: ", (Throwable)exception);
        }
        logger.debug("run() - end");
    }

    private int getBetweenVMStartupDelay() {
        UPSSetup uPSSetup = null;
        int n = 0;
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(this.hostName);
            if (uPSSetup != null) {
                n = uPSSetup.getVMSettings().getBetweenVmStartupDelay();
            }
        } else {
            n = this.services.getVirtualConfigurationManager().getDurationGlobal("vm_startup_delay_duration");
        }
        logger.debug("getBetweenVMStartupDelay() - end, duration: {}", (Object)n);
        return n;
    }

    private int getBeforeVMStartupDelay() {
        UPSSetup uPSSetup = null;
        int n = 0;
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(this.hostName);
            if (uPSSetup != null) {
                n = uPSSetup.getVMSettings().getBeforeVmStartupDelay();
            }
        } else {
            n = this.services.getVirtualConfigurationManager().getDurationGlobal("delay_before_vmstartup");
        }
        logger.debug("getBeforeVMStartupDelay() - end, duration: {}", (Object)n);
        return n;
    }

    private void logPriorityDurationZero(List<String> list, VMPriority vMPriority) {
        if (!list.isEmpty()) {
            logger.error("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup of VMs: {}", (Object)vMPriority, list);
        } else {
            logger.debug("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup", (Object)vMPriority);
        }
    }

    private boolean isVmRecoverable(VirtualMachine virtualMachine) {
        boolean bl = true;
        VirtualMachineConnectionState virtualMachineConnectionState = virtualMachine.getRuntime().getConnectionState();
        switch (virtualMachineConnectionState) {
            case invalid: 
            case orphaned: {
                logger.debug("isVmRecoverable() - VM is invalid or orphaned.");
                bl = false;
                break;
            }
            case inaccessible: 
            case connected: 
            case disconnected: {
                logger.debug("isVmRecoverable() - VM is inaccessible, connected or disconnected.");
                bl = true;
                break;
            }
            default: {
                logger.warn("isVmRecoverable() - Can't determine state of VM.  Assuming it is recoverable.");
                bl = true;
            }
        }
        return bl;
    }

    private VirtualMachine checkIfFaultTolerantVirtualMachine(VirtualMachine virtualMachine, ServiceInstance serviceInstance) {
        FaultToleranceConfigInfo faultToleranceConfigInfo = virtualMachine.getSummary().getConfig().getFtInfo();
        if (faultToleranceConfigInfo instanceof FaultToleranceSecondaryConfigInfo) {
            ManagedObjectReference managedObjectReference = ((FaultToleranceSecondaryConfigInfo)faultToleranceConfigInfo).getPrimaryVM();
            virtualMachine = new VirtualMachine(serviceInstance.getServerConnection(), managedObjectReference);
        }
        return virtualMachine;
    }

    private void performVMStartUp(List<String> list, String string, int n, int n2, boolean bl) {
        logger.debug("performVMStartUp() - start, host: {}", (Object)string);
        if (list.isEmpty()) {
            logger.debug("performVMStartUp() - startupList is empty, no VMs to start");
            return;
        }
        if (this.theState.checkIfCriticalEventActive(string)) {
            logger.debug("performVMStartUp() - critical event active on host: {}", (Object)string);
            return;
        }
        logger.debug("performVMStartUp() - Before VM Startup sleep duration: {} ", (Object)n);
        new CountdownTimer(n).sleep();
        logger.debug("performVMStartUp() - startupList: {}", list);
        String string2 = null;
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
        }
        Vector<VMPriority> vector = this.getVMStartupPriorities(bl, string);
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
        Vector<String> vector2 = new Vector<String>();
        PrioritizedVM prioritizedVM = this.services.getVMPrioritizationUtils().checkIfVCSAVMInVMPrioritizedList();
        if (prioritizedVM != null) {
            string2 = this.virtualisationStatusStore.getVcsaHost();
            logger.debug("performVMStartUp() - vCSAHostIp: {}", (Object)string2);
        }
        ListIterator<VMPriority> listIterator = vector.listIterator(vector.size());
        while (listIterator.hasPrevious()) {
            VMPriority vMPriority = listIterator.previous();
            logger.debug("performVMStartUp() - priority: {}", (Object)vMPriority);
            try {
                int n3 = this.services.getVMPrioritizationUtils().getVMVAppStartupDuration(vMPriority, vMPrioritizationDurations, string);
                List<String> list2 = this.services.getVMPrioritizationUtils().filterVMsByPriority(list, vMPriority);
                if (n3 == 0) {
                    this.logPriorityDurationZero(list2, vMPriority);
                    continue;
                }
                Iterator<String> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    try {
                        String string3 = iterator.next();
                        if (this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
                            logger.debug("performVMStartUp() - host shutting down, not starting VMs");
                            continue;
                        }
                        if (serviceInstance == null) {
                            logger.debug("performVMStartUp() - serviceInstance is null");
                            continue;
                        }
                        VirtualMachine virtualMachine = this.services.getVirtualMachineUtils().getVirtualMachineFromVMName(serviceInstance, string3);
                        if (virtualMachine == null) {
                            iterator.remove();
                            continue;
                        }
                        logger.debug("performVMStartUp() - VM: {}", (Object)string3);
                        boolean bl2 = false;
                        if (prioritizedVM != null) {
                            bl2 = this.isVCSAVM(virtualMachine, prioritizedVM, vMPriority);
                        }
                        if (this.services.getVirtualMachineUtils().isPoweredOn(virtualMachine)) {
                            if (bl2) {
                                logger.debug("performVMStartUp() - vCSA VM is already powered on, setting vCSA Off to false");
                                this.vmwareConnection.setVCenterOffline(false);
                                if (!this.virtualisationStatusStore.isHAorVCLSDisabled()) {
                                    logger.debug("performVMStartUp() - removing vcsa keys");
                                    this.virtualisationStatusStore.removeVcsaKeys();
                                } else {
                                    this.virtualisationStatusStore.removeVcsaVMKey();
                                }
                            } else {
                                logger.debug("performVMStartUp() - VM is already powered on");
                            }
                            iterator.remove();
                        } else if (this.services.getVirtualMachineUtils().isConnected(virtualMachine)) {
                            if ((virtualMachine = this.checkIfFaultTolerantVirtualMachine(virtualMachine, serviceInstance)) != null) {
                                this.powerOnVM(virtualMachine, serviceInstance, n2, iterator, list2, bl2);
                            } else {
                                logger.debug("performVMStartUp() - vM is null");
                            }
                        } else {
                            logger.error("performVMStartUp() - VM is not connected, unable to start");
                        }
                        if (this.isVmRecoverable(virtualMachine)) continue;
                        iterator.remove();
                        logger.debug("performVMStartUp() - {} is not recoverable. Removing it from the virtual status store.", (Object)string3);
                        this.virtualisationStatusStore.removeVM(string, string3);
                    }
                    catch (RemoteException remoteException) {
                        logger.error("performVMStartUp() - RemoteException: ", (Throwable)remoteException);
                    }
                    catch (Exception exception) {
                        logger.error("performVMStartUp() - Exception: ", (Throwable)exception);
                    }
                }
                logger.debug("performVMStartUp() - sleep duration: {} for priority: {}", (Object)n3, (Object)vMPriority);
                new CountdownTimer(n3).sleep();
                if (list2.isEmpty()) continue;
                vector2.addAll(list2);
            }
            catch (Exception exception) {
                logger.warn("performVMStartUp() - For priority: {} Exception:{}", (Object)vMPriority, (Object)exception);
            }
        }
        if (this.vCSAVMStarted) {
            this.performVCSAVMPostStartupTasks(string2);
        }
        this.updateReattemptVMsInProperties(bl, vector2, string);
        logger.debug("performVMStartUp() - end");
    }

    private boolean isVCSAVM(VirtualMachine virtualMachine, PrioritizedVM prioritizedVM, VMPriority vMPriority) {
        boolean bl = false;
        logger.debug("isVCSAVM() - start");
        if (vMPriority == null) {
            if (virtualMachine.getName().equals(prioritizedVM.getVMName())) {
                bl = true;
            }
        } else if (prioritizedVM.getPriority() == vMPriority && virtualMachine.getName().equals(prioritizedVM.getVMName())) {
            bl = true;
        }
        if (bl) {
            if (!this.vCSAVMStarted) {
                logger.debug("isVCSAVM() - VM: {} matches name of vCSA VM: {}", (Object)virtualMachine.getName(), (Object)prioritizedVM.getVMName());
                bl = true;
            } else {
                logger.warn("isVCSAVM() - vCSA has *started* - VM: {} matches name of vCSA VM", (Object)virtualMachine.getName());
                bl = false;
            }
        }
        logger.debug("isVCSAVM() - end, result: {}", (Object)bl);
        return bl;
    }

    private void powerOnVM(VirtualMachine virtualMachine, ServiceInstance serviceInstance, int n, Iterator<String> iterator, List<String> list, boolean bl) {
        logger.debug("powerOnVM() - start");
        HostSystem hostSystem = this.services.getHostSystemUtils().getHostOfVirtualMachine(virtualMachine, serviceInstance);
        if (hostSystem == null) {
            logger.debug("powerOnVM() - hostSystem is null");
            return;
        }
        this.performVCSAVMPreStartupTasks(bl, virtualMachine);
        logger.debug("powerOnVM() - guest VM to be started on host: {}", (Object)hostSystem.getName());
        try {
            Task task = virtualMachine.powerOnVM_Task(hostSystem);
            String string = task.waitForTask();
            if (string.equals("success")) {
                iterator.remove();
                if (bl) {
                    this.vCSAVMStarted = true;
                    logger.info("powerOnVM() - vCSA VM: {} successfully powered on", (Object)virtualMachine.getName());
                } else {
                    logger.info("powerOnVM() - VM: {} successfully powered on", (Object)virtualMachine.getName());
                }
            } else {
                logger.error("powerOnVM() - VM: {} failed to power on with taskResult: {}", (Object)virtualMachine.getName(), (Object)string);
            }
            if (n > 0 && list.size() >= 1) {
                TimeUnit.SECONDS.sleep(n);
            }
            if (bl) {
                this.vmwareConnection.setVCenterOffline(false);
                if (this.vCSAVMStarted && !this.virtualisationStatusStore.isHAorVCLSDisabled()) {
                    this.virtualisationStatusStore.removeVcsaKeys();
                } else {
                    this.virtualisationStatusStore.removeVcsaVMKey();
                }
            }
        }
        catch (Exception exception) {
            logger.error("powerOnVM() - error starting Guest VM: {} - {}", (Object)virtualMachine.getName(), (Object)exception.getLocalizedMessage(), (Object)exception);
        }
        logger.debug("powerOnVM() - end");
    }

    private void performVCSAVMPreStartupTasks(boolean bl, VirtualMachine virtualMachine) {
        if (!bl) {
            return;
        }
        logger.debug("performVCSAVMPreStartupTasks() - start");
        if (this.theState.isVcsaHostShutdown()) {
            this.theState.setVcsaHostShutdown(false);
        }
        if (this.services.getVirtualMachineUtils().isPoweredOff(virtualMachine)) {
            this.services.getVirtualLoggingUtils().logVCSAVMStartupLogEvent(virtualMachine.getName());
        }
        logger.debug("performVCSAVMPreStartupTasks() - end");
    }

    private void performVCSAVMPostStartupTasks(String string) {
        logger.debug("performVCSAVMPostStartupTasks() - start");
        if (string != null) {
            logger.debug("performVCSAVMPostStartupTasks() - ========================= NORMAL EVENT Clear critical Event ===================================");
            CreateVCenterAlarm.getInstance().createUPSCriticalEvent(string, "normal");
        } else {
            logger.warn("performVCSAVMPostStartupTasks() - VCSA_HOST not found in properties file!");
        }
        this.theState.setVCSARequiredForVAppStartup(false);
        logger.debug("performVCSAVMPostStartupTasks() - end");
    }

    private void updateReattemptVMsInProperties(boolean bl, List<String> list, String string) {
        logger.debug("updateReattemptVMsInProperties() - start");
        if (!this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
            if (!bl) {
                this.virtualisationStatusStore.clearVMs(string);
                if (!list.isEmpty()) {
                    logger.debug("updateReattemptVMsInProperties() - saving list of re-attempt VMs");
                    this.virtualisationStatusStore.saveReAttemptVMs(list, string);
                }
            } else {
                this.virtualisationStatusStore.clearReattemptVMs(string);
            }
        }
    }

    private Vector<VMPriority> getVMStartupPriorities(boolean bl, String string) {
        Vector<VMPriority> vector;
        logger.debug("getVMStartupPriorities() - start");
        if (!bl) {
            vector = new VMPriorityVector(this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled()).getPriorities();
            this.services.getVirtualLoggingUtils().logGuestVMStartupLogEvent(string);
        } else {
            vector = new VMPriorityVector(false).getPriorities();
            this.services.getVirtualLoggingUtils().logReattemptVMStartupLogEvent(string);
        }
        return vector;
    }
}

