/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.startup;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.startup.VAppStartupRunnable;
import com.apcc.m11.components.shutdowner.vmware.startup.VMStartupRunnable;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.HostSystem;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMVAppStartupRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VMVAppStartupRunnable.class);
    private String hostName;
    private ShutdownState theState;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private HostSystemUtils hostSystemUtils;

    public VMVAppStartupRunnable(String string, ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.hostName = string;
        this.theState = shutdownState;
        this.hostSystemUtils = serviceManager.getHostSystemUtils();
    }

    @Override
    public void run() {
        logger.debug("run() - start, host: {}", (Object)this.hostName);
        if (!this.isHostReadyForVMVAppStartup(this.hostName)) {
            logger.debug("run() - host not ready for VM/vApp startup");
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>();
        if (!this.theState.getVCSARequiredForVAppStartup()) {
            logger.debug("run() - adding host: {} for vApp startup", (Object)this.hostName);
            arrayList.add(Executors.callable(new VAppStartupRunnable(this.hostName, this.theState, this.services)));
        }
        logger.debug("run() - adding host: {} for VM startup", (Object)this.hostName);
        arrayList.add(Executors.callable(new VMStartupRunnable(this.hostName, this.theState, this.services)));
        try {
            executorService.invokeAll(arrayList);
            executorService.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            logger.error("run() - InterruptedException: ", (Throwable)interruptedException);
        }
        logger.debug("run() - end");
    }

    private boolean isHostReadyForVMVAppStartup(String string) {
        logger.debug("isHostReadyForVMVAppStartup() - start, host: {}", (Object)string);
        if (this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
            logger.debug("isHostReadyForVMVAppStartup() - host locked");
            return false;
        }
        if (this.theState.checkIfCriticalEventActive(string)) {
            logger.debug("isHostReadyForVMVAppStartup() - critical event active on host");
            return false;
        }
        HostSystem hostSystem = this.hostSystemUtils.getHostSystem(string);
        if (hostSystem == null) {
            LinkedHashSet<String> linkedHashSet = this.services.getVirtualConfigurationManager().getConfiguredHosts();
            if (!this.services.getVirtualConfigurationManager().isHostInCurrentSetup(linkedHashSet, string)) {
                this.virtualisationStatusStore.clearHostVMsFromPropertyFile(string);
                this.virtualisationStatusStore.clearHostVAppsFromPropertyFile(string);
            }
            return false;
        }
        this.hostSystemUtils.checkIfHostIsInInvalidState(hostSystem);
        if (!this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
            logger.debug("isHostReadyForVMVAppStartup() - host is powered off");
            return false;
        }
        if (hostSystem.getRuntime().isInMaintenanceMode()) {
            logger.debug("isHostReadyForVMVAppStartup() - host in Maintenance Mode, attempting to take it out");
            this.hostSystemUtils.getOnlineHostOutOfMaintenanceMode(string, true);
            if (hostSystem.getRuntime().isInMaintenanceMode()) {
                logger.debug("isHostReadyForVMVAppStartup() - host in Maintenance Mode, not ready for startup");
                return false;
            }
        }
        if (!this.isVMVAppStartupEnabled(string)) {
            return false;
        }
        this.hostSystemUtils.rescanAllHba(hostSystem, string);
        logger.debug("isHostReadyForVMVAppStartup() - end");
        return true;
    }

    private boolean isVMVAppStartupEnabled(String string) {
        boolean bl = false;
        logger.debug("isVMVAppStartupEnabled() - start");
        UPSSetup uPSSetup = null;
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            uPSSetup = this.services.getAdvancedSetupHelper().getHostUPSSetup(string);
            if (uPSSetup != null) {
                bl = uPSSetup.getVMSettings().isGuestVMVappStartupEnabled();
            }
        } else {
            bl = this.services.getVirtualConfigurationManager().getBooleanGlobal("enable_guest_vm_vapp_startup");
        }
        logger.debug("isVMVAppStartupEnabled() - end, result: {}", (Object)bl);
        return bl;
    }
}

