/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vappshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vappshutdown.VAppShutdownPriorityGroup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VAppShutdownHost
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VAppShutdownHost.class);
    private ServiceManager services;
    private ShutdownState theState = null;
    private VMHostState hostState = null;
    private boolean bVAppShutdownTimeout = false;

    public VAppShutdownHost(ShutdownState shutdownState, VMHostState vMHostState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theState = shutdownState;
        this.hostState = vMHostState;
        this.services = serviceManager;
    }

    @Override
    public void run() {
        logger.debug("run() - start, host: {}", (Object)this.hostState.getHostSystemName());
        this.services.getVAppShutdownUtils().waitIfVAppStartupInProgress(this.theState, this.hostState);
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN);
        for (VMPriority vMPriority : this.hostState.getPriorities()) {
            logger.debug("run() - priority: {}", (Object)vMPriority);
            int n = this.services.getVmShutdownUtils().getVMShutdownDuration(vMPrioritizationDurations, vMPriority, this.hostState.isAdvancedMode(), this.hostState.getGroupIdx());
            if (n == 0) {
                logger.warn("run() - duration is 0, no VApp shutdown for priority: {}", (Object)vMPriority);
                continue;
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            VAppShutdownPriorityGroup vAppShutdownPriorityGroup = new VAppShutdownPriorityGroup(this.theState, this.hostState, this.services);
            vAppShutdownPriorityGroup.setPriority(vMPriority);
            Future<VMResult> future = executorService.submit(vAppShutdownPriorityGroup);
            executorService.shutdown();
            try {
                if (executorService.awaitTermination(n, TimeUnit.SECONDS)) continue;
                executorService.shutdownNow();
                try {
                    VMResult vMResult = future.get();
                    if (vMResult == null || vMResult != VMResult.TIMEOUT) continue;
                    this.setTimeoutDuringVAppShutdown(vMPriority);
                }
                catch (ExecutionException executionException) {
                    logger.error("run() - ExecutionException: {}", (Object)executionException.getLocalizedMessage());
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("run() - InterruptedException: {}", (Object)interruptedException.getLocalizedMessage());
            }
        }
        if (this.bVAppShutdownTimeout) {
            this.services.getVirtualLoggingUtils().logVAppShutdownFailedTimeoutEvent();
        }
        this.theState.clearvAppShutdownThreadRunInitiated(this.hostState.getGroupIdx());
        this.theState.clearvAppShutdownSet();
        logger.debug("run() - end");
    }

    private void setTimeoutDuringVAppShutdown(VMPriority vMPriority) {
        logger.error("setTimeoutDuringVAppShutdown() - insufficient time to shutdown all VApps using VApp Shutdown Duration for priority: {}", (Object)vMPriority);
        this.bVAppShutdownTimeout = true;
    }
}

