/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vappshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vmshutdown.VMShutdownVMList;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VAppConfigFault;
import com.vmware.vim25.VirtualAppSummary;
import com.vmware.vim25.VirtualAppVAppState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VAppShutdownPriorityGroup
implements Callable<VMResult> {
    private static final Logger logger = LogManager.getLogger(VAppShutdownPriorityGroup.class);
    private ShutdownState theState = null;
    private VMHostState hostState = null;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMPriority priority;

    public VAppShutdownPriorityGroup(ShutdownState shutdownState, VMHostState vMHostState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theState = shutdownState;
        this.hostState = vMHostState;
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
    }

    @Override
    public VMResult call() {
        VMResult vMResult = VMResult.OK;
        logger.debug("call() - host: {}, priority: {}", (Object)this.hostState.getHostSystemName(), (Object)this.priority);
        boolean bl = false;
        try {
            String string = this.services.getVAppShutdownUtils().getESXiAPITypeFromServiceInstance(this.hostState);
            if (string != null && "VirtualCenter".equalsIgnoreCase(string)) {
                List<VirtualApp> list;
                logger.debug("call() - serviceInstance is not ESXi");
                if (this.theState.setvAppShutdownThreadRunInitiated(this.hostState.getGroupIdx())) {
                    logger.debug("call() - Initialise Thread: {}", (Object)this.hostState.getGroupIdx());
                    this.services.getVAppShutdownUtils().computeVirtualAppsToShutdown(this.theState, this.hostState);
                    this.checkAndlogVAppShutdownStartingEvent();
                    this.checkAndlogNoVAppToShutdownEvent();
                    this.checkAndlogVAppOnHealthyHostEvent();
                } else {
                    logger.debug("call() - Initialise Thread: {} already initialised", (Object)this.hostState.getGroupIdx());
                }
                if (!this.hostState.getVAppShutdownSet().isEmpty() && !(list = this.services.getVMPrioritizationUtils().filterVAppsByPriority(this.hostState.getVAppShutdownSet(), this.priority)).isEmpty()) {
                    ArrayList<Task> arrayList = new ArrayList<Task>(list.size());
                    Iterator<VirtualApp> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        VirtualApp virtualApp;
                        if (Thread.currentThread().isInterrupted()) {
                            logger.error("call() - vApp shutdown has been interrupted");
                            if (iterator != null) {
                                while (iterator.hasNext()) {
                                    virtualApp = iterator.next();
                                    logger.error("call() - timeout, skipped vApp: {}", (Object)virtualApp.getName());
                                }
                            }
                            return VMResult.TIMEOUT;
                        }
                        virtualApp = iterator.next();
                        if (virtualApp == null || virtualApp.getName() == null || virtualApp.getSummary() == null) {
                            logger.debug("call() - invalid vApp: {}", (Object)virtualApp);
                            continue;
                        }
                        String string2 = StringEscapeUtils.escapeHtml4((String)virtualApp.getName());
                        logger.debug("shutdownVApps() - vApp: " + string2);
                        if (this.containsVCenterOrPowerChute(virtualApp, string2)) {
                            logger.debug("shutdownVApps() - VCSA or PCNS found on vApp: {}", (Object)string2);
                            continue;
                        }
                        if (this.theState.setvAppShutdownSet(string2)) {
                            Task task = this.checkAndShutdownVApp(virtualApp, string2);
                            arrayList.add(task);
                            continue;
                        }
                        logger.debug("call() - vApp shutdown already triggered {}", (Object)string2);
                    }
                    this.waitForVAppShutdownTasksToComplete(arrayList);
                }
            } else if ("HostAgent".equalsIgnoreCase(string) || this.hostState.getServiceInstance() == null) {
                if (!this.hostState.isVAppVCenterOfflineEventLogged()) {
                    this.services.getVirtualLoggingUtils().logVAppShutdownFailedVCenterServerOfflineEvent();
                    this.hostState.setVAppVCenterOfflineEventLogged(true);
                }
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {
            vMResult = VMResult.TIMEOUT;
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            logger.error("call() - Exception: ", (Throwable)exception);
            bl = true;
        }
        if (bl) {
            vMResult = this.shutdownVAppsViaESXi(this.priority, vMResult);
        }
        try {
            logger.debug("call() - wait for thread to be interrupted");
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(500L);
            }
            logger.debug("call() - shutdown thread interrupted");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return vMResult;
    }

    private void waitForVAppShutdownTasksToComplete(ArrayList<Task> arrayList) throws RuntimeFault, RemoteException, InterruptedException {
        for (Task task : arrayList) {
            if (task == null) continue;
            String string = task.getAssociatedManagedEntity().getName();
            logger.debug("waitForVAppShutdownTasksToComplete() - waitForTask started for vApp: {}", (Object)string);
            if (task.waitForTask().equals("success")) {
                this.virtualisationStatusStore.savevAppToPropertyFile(this.hostState.getMappedHostName(), string);
                logger.debug("waitForVAppShutdownTasksToComplete() - successfully powered off vApp: {}", (Object)string);
            } else {
                logger.error("waitForVAppShutdownTasksToComplete() - failed to power off vApp: {}", (Object)string);
            }
            this.theState.removevAppShutdownSet(string);
        }
    }

    private Task checkAndShutdownVApp(VirtualApp virtualApp, String string) throws TaskInProgress, InvalidState, VAppConfigFault, RuntimeFault, RemoteException {
        logger.debug("checkAndShutdownVApp() - start, vApp: {}", (Object)string);
        Task task = null;
        String string2 = this.services.getVirtualApplianceUtils().getVappDataCenterName(virtualApp);
        if (this.services.getVirtualApplianceUtils().isVAppStarted(virtualApp)) {
            this.services.getVirtualLoggingUtils().logVAppShutdownEnabledEvent(string, string2);
            logger.debug("checkAndShutdownVApp() - powerOffVApp_Task started for vApp: {}", (Object)virtualApp.getName());
            task = virtualApp.powerOffVApp_Task(false);
        } else if (this.services.getVirtualApplianceUtils().isVAppStopped(virtualApp)) {
            this.logSkipPoweredOffVAppShutdown(virtualApp, string2);
        }
        return task;
    }

    private void logSkipPoweredOffVAppShutdown(VirtualApp virtualApp, String string) {
        try {
            logger.debug("skipPoweredOffVAppShutdown() - vApp: {}", (Object)virtualApp.getName());
            if (!this.theState.getvAppShutdownSet().stream().anyMatch(virtualApp.getName()::equalsIgnoreCase)) {
                Vector<String> vector = new Vector<String>();
                vector.add(virtualApp.getName());
                vector.add(string);
                this.services.getVirtualLoggingUtils().logVAppNotPoweredOnEvent(vector);
            }
        }
        catch (Exception exception) {
            logger.error("skipPoweredOffVAppShutdown() - Exception: ", (Throwable)exception);
        }
    }

    private boolean containsVCenterOrPowerChute(VirtualApp virtualApp, String string) {
        if (this.containsVCenter(virtualApp)) {
            this.services.getVirtualLoggingUtils().logVAppWithVCSAEvent(string);
            return true;
        }
        if (this.containsPowerChute(virtualApp)) {
            if (!this.theState.getVAppRunningPCNS(string)) {
                this.theState.addVAppRunningPCNS(string);
                this.services.getVirtualLoggingUtils().logVAppWithPCNSVMAEvent(string);
            }
            return true;
        }
        return false;
    }

    private boolean containsPowerChute(VirtualApp virtualApp) {
        boolean bl;
        block3: {
            bl = false;
            try {
                VirtualMachine[] virtualMachineArray;
                if (this.hostState.getPCNSVMName() == null) break block3;
                for (VirtualMachine virtualMachine : virtualMachineArray = virtualApp.getVMs()) {
                    if (!virtualMachine.getName().equalsIgnoreCase(this.hostState.getPCNSVMName())) continue;
                    bl = true;
                    break;
                }
            }
            catch (RemoteException remoteException) {
                logger.error("checkIfVAppHasPCNSVMRunning() - RemoteException: ", (Throwable)remoteException);
            }
        }
        return bl;
    }

    private boolean containsVCenter(VirtualApp virtualApp) {
        boolean bl = false;
        try {
            VirtualMachine[] virtualMachineArray;
            for (VirtualMachine virtualMachine : virtualMachineArray = virtualApp.getVMs()) {
                if (!this.services.getHostSystemUtils().isVCenterServerInstalledOnVM(virtualMachine, this.hostState.getServiceInstance())) continue;
                bl = true;
                break;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("checkIfVAppHasVCenterServerApplianceRunning() - RemoteException: ", (Throwable)remoteException);
        }
        return bl;
    }

    private void checkAndlogVAppOnHealthyHostEvent() {
        logger.debug("checkAndlogVAppOnHealthyHostEvent() - start");
        if (this.hostState.getVAppShutdownSetOnHealthyHost() != null && !this.hostState.getVAppShutdownSetOnHealthyHost().isEmpty()) {
            Iterator<VirtualApp> iterator = this.hostState.getVAppShutdownSetOnHealthyHost().iterator();
            while (iterator.hasNext()) {
                VirtualAppSummary virtualAppSummary;
                VirtualApp virtualApp;
                VirtualApp virtualApp2 = virtualApp = iterator.next();
                while (!(virtualApp2 instanceof Datacenter)) {
                    virtualApp2 = virtualApp2.getParent();
                }
                if (virtualApp.getSummary() instanceof VirtualAppSummary && (virtualAppSummary = virtualApp.getSummary()).getVAppState().toString().equalsIgnoreCase(VirtualAppVAppState.started.toString()) && this.containsPoweredOnVMs(virtualApp)) {
                    this.skipVAppShutdown_VMsOnHealthyHost(virtualApp, (Datacenter)virtualApp2);
                }
                iterator.remove();
            }
        }
    }

    private void skipVAppShutdown_VMsOnHealthyHost(VirtualApp virtualApp, Datacenter datacenter) {
        logger.debug("skipVAppShutdown_VMsOnHealthyHost() - start");
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(virtualApp.getName());
            vector.add(datacenter.getName());
            this.services.getVirtualLoggingUtils().logSkipVAppShutdownVMOnHealthyHostEvent(vector);
        }
        catch (Exception exception) {
            logger.error("skipVAppShutdown_VMsOnHealthyHost() - Exception: ", (Throwable)exception);
        }
    }

    private boolean containsPoweredOnVMs(VirtualApp virtualApp) {
        boolean bl = false;
        try {
            VirtualMachine[] virtualMachineArray;
            for (VirtualMachine virtualMachine : virtualMachineArray = virtualApp.getVMs()) {
                if (!virtualMachine.getRuntime().getPowerState().toString().equalsIgnoreCase(VirtualMachinePowerState.poweredOn.toString())) continue;
                bl = true;
                break;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("isVMPoweredOnWithinVApp() - RemoteException: ", (Throwable)remoteException);
        }
        return bl;
    }

    private VMResult shutdownVAppsViaESXi(VMPriority vMPriority, VMResult vMResult) {
        logger.debug("shutdownVAppsViaESXi() - start, priority: {}", (Object)vMPriority);
        VirtualMachine[] virtualMachineArray = this.services.getVmShutdownUtils().getVMsForShutdownViaESXiHost(true, this.hostState.getConnESXiHost());
        if (virtualMachineArray == null || virtualMachineArray.length <= 0) {
            logger.debug("shutdownVAppsViaESXi() - VM list is empty");
            return vMResult;
        }
        List<VirtualMachine> list = this.services.getVMPrioritizationUtils().filterVAppVMsByPriority(virtualMachineArray, this.hostState.getVAppVMMap(), vMPriority);
        if (list == null || list.size() <= 0) {
            return vMResult;
        }
        try {
            this.checkLogVAppVMShutdown();
            VMShutdownVMList vMShutdownVMList = new VMShutdownVMList(this.hostState, this.services);
            if (!vMShutdownVMList.executeGuestVMShutdown(list, true, vMPriority)) {
                vMResult = VMResult.TIMEOUT;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("shutdownVAppsViaESXi() - RemoteException: ", (Throwable)remoteException);
        }
        logger.debug("shutdownVAppsViaESXi() - end");
        return vMResult;
    }

    private void checkLogVAppVMShutdown() {
        if (!this.hostState.isVAppVMShutdownEventLogged()) {
            this.services.getVirtualLoggingUtils().logVAppVMShutdownLogEvent(this.hostState.getMappedHostName());
            this.hostState.setVAppVMShutdownEventLogged(true);
        }
    }

    private void checkAndlogNoVAppToShutdownEvent() {
        logger.debug("checkAndlogNoVAppToShutdownEvent() - start");
        if ((this.hostState.getVAppShutdownSet() == null || this.hostState.getVAppShutdownSet().isEmpty()) && (this.hostState.getVAppShutdownSetOnHealthyHost() == null || this.hostState.getVAppShutdownSetOnHealthyHost().isEmpty())) {
            this.services.getVirtualLoggingUtils().logVAppShutdownNoneEvent(this.hostState.getMappedHostName());
        }
    }

    private void checkAndlogVAppShutdownStartingEvent() {
        logger.debug("checkAndlogVAppShutdownStartingEvent() - start");
        if (this.hostState.getVAppShutdownSet() != null && !this.hostState.getVAppShutdownSet().isEmpty() || this.hostState.getVAppShutdownSetOnHealthyHost() != null && this.hostState.getVAppShutdownSetOnHealthyHost().isEmpty()) {
            this.services.getVirtualLoggingUtils().logVAppShutdownStartingEvent(this.hostState.getMappedHostName());
        }
    }

    @Generated
    public void setPriority(VMPriority vMPriority) {
        this.priority = vMPriority;
    }
}

