/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vappshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.ResourceConfigSpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VAppShutdownUtils {
    private static final Logger logger = LogManager.getLogger(VAppShutdownUtils.class);
    @NonNull
    private VirtualizationLoggingUtils virtualLoggingUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigUtils;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VMWareConnection vmwareConnection;

    public VAppShutdownUtils() {
    }

    public VAppShutdownUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils, @NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull HostSystemUtils hostSystemUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("loggingUtils is marked non-null but is null");
        }
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfig is marked non-null but is null");
        }
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.virtualLoggingUtils = virtualizationLoggingUtils;
        this.virtualConfigUtils = virtualConfigurationManager;
        this.hostSystemUtils = hostSystemUtils;
    }

    public void waitIfVAppStartupInProgress(ShutdownState shutdownState, VMHostState vMHostState) {
        logger.debug("waitIfVAppStartupInProgress() - start");
        if (this.checkIfVAppStartUpInProgress(shutdownState, vMHostState.getVAppShutdownSet())) {
            this.virtualLoggingUtils.logVirtualizationStartupInProgressEvent(vMHostState.getMappedHostName());
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.checkIfVAppStartUpInProgress(shutdownState, vMHostState.getVAppShutdownSet()));
        }
        logger.debug("waitIfVAppStartupInProgress() - end");
    }

    private boolean checkIfVAppStartUpInProgress(ShutdownState shutdownState, Set<VirtualApp> set) {
        boolean bl = false;
        if (set != null && !set.isEmpty()) {
            for (VirtualApp virtualApp : set) {
                try {
                    if (virtualApp == null || virtualApp.getName() == null || !shutdownState.isVMWareVAppStartupInProgress(virtualApp.getName())) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    logger.debug("checkIfVAppStartUpInProgress() - Exception: " + exception.getMessage());
                }
            }
        }
        return bl;
    }

    public void computeVirtualAppsToShutdown(ShutdownState shutdownState, VMHostState vMHostState) {
        try {
            logger.debug("computeVirtualAppsToShutdown() - start, host: {}", (Object)vMHostState.getHostSystemName());
            vMHostState.getVAppShutdownSet().clear();
            vMHostState.getVAppShutdownSetOnHealthyHost().clear();
            if (vMHostState.getVirtualHostsToShutdown() == null || vMHostState.getVirtualHostsToShutdown().isEmpty()) {
                return;
            }
            String string = this.getESXiAPITypeFromServiceInstance(vMHostState);
            boolean bl = this.virtualConfigUtils.isForceVAppShutdownEnabled(vMHostState.getGroupIdx());
            if (string == null || !"VirtualCenter".equalsIgnoreCase(string)) {
                return;
            }
            ManagedEntity[] managedEntityArray = new InventoryNavigator((ManagedEntity)vMHostState.getServiceInstance().getRootFolder()).searchManagedEntities("VirtualApp");
            if (managedEntityArray == null) {
                return;
            }
            logger.debug("computeVirtualAppsToShutdown() - vApp Entity is not null");
            for (ManagedEntity managedEntity : managedEntityArray) {
                if (!(managedEntity instanceof VirtualApp)) continue;
                VirtualApp virtualApp = (VirtualApp)managedEntity;
                logger.debug("computeVirtualAppsToShutdown() - vApp: {} ", (Object)virtualApp.getName());
                Set<Object> set = new HashSet();
                ResourceConfigSpec[] resourceConfigSpecArray = virtualApp.getChildConfiguration();
                if (resourceConfigSpecArray != null && resourceConfigSpecArray.length > 0) {
                    set = this.checkMasterVApp(vMHostState, resourceConfigSpecArray, virtualApp);
                }
                if (virtualApp.getVMs().length > 0) {
                    logger.debug("computeVirtualAppsToShutdown() - vApp contains VMs");
                    if (!vMHostState.isVsanNonCriticalHost() || vMHostState.isVsanNonCriticalHost() && VsanUtils.isAnyVMInArrayUsingDatastore(virtualApp.getVMs(), vMHostState.getVsanDatastoreName())) {
                        set.addAll(this.getVAppVMHosts(vMHostState, virtualApp.getVMs(), virtualApp.getName()));
                    }
                }
                if (set == null || set.isEmpty() || !set.contains(vMHostState.getHostSystemName())) {
                    logger.debug("computeVirtualAppsToShutdown() - skipping vApp: {} as hosts is null, empty or critical host not in use", (Object)virtualApp.getName());
                    continue;
                }
                this.checkShutdownVApp(shutdownState, vMHostState, set, bl, virtualApp);
            }
            this.addMasterVAppsToAppVmMap(vMHostState);
        }
        catch (InvalidProperty invalidProperty) {
            logger.error("computeVirtualAppsToShutdown() - InvalidProperty: ", (Throwable)invalidProperty);
        }
        catch (NotAuthenticated notAuthenticated) {
            logger.error("computeVirtualAppsToShutdown() - NotAuthenticated: ", (Throwable)notAuthenticated);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("computeVirtualAppsToShutdown() - RuntimeFault: ", (Throwable)runtimeFault);
        }
        catch (RemoteException remoteException) {
            logger.error("computeVirtualAppsToShutdown() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("computeVirtualAppsToShutdown() - Exception: ", (Throwable)exception);
        }
        logger.debug("computeVirtualAppsToShutdown() - end");
    }

    private void addMasterVAppsToAppVmMap(VMHostState vMHostState) {
        if (vMHostState.getMasterVAppMap().isEmpty()) {
            logger.debug("addMasterVAppsToAppVmMap() - no master vApps found");
            return;
        }
        for (Map.Entry<String, List<String>> entry : vMHostState.getMasterVAppMap().entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            logger.debug("addMasterVAppsToAppVmMap() - master vApp: {}", (Object)string);
            ArrayList arrayList = new ArrayList();
            for (String string2 : list) {
                if (!vMHostState.getVAppVMMap().containsKey(string2)) continue;
                logger.debug("addMasterVAppsToAppVmMap() - adding all child vApp: {} VMs to list", (Object)string2);
                arrayList.addAll(vMHostState.getVAppVMMap().get(string2));
            }
            if (arrayList.size() <= 0) continue;
            logger.debug("addMasterVAppsToAppVmMap() - adding master vApp: {} to map", (Object)string);
            if (vMHostState.getVAppVMMap().containsKey(string)) {
                arrayList.addAll(vMHostState.getVAppVMMap().get(string));
            }
            vMHostState.getVAppVMMap().put(string, arrayList);
        }
    }

    private Set<String> checkMasterVApp(VMHostState vMHostState, ResourceConfigSpec[] resourceConfigSpecArray, VirtualApp virtualApp) {
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (ResourceConfigSpec resourceConfigSpec : resourceConfigSpecArray) {
            VirtualMachine[] virtualMachineArray;
            ManagedObjectReference managedObjectReference = resourceConfigSpec.getEntity();
            if (!managedObjectReference.getType().equals("VirtualApp")) continue;
            VirtualApp virtualApp2 = new VirtualApp(vMHostState.getServiceInstance().getServerConnection(), managedObjectReference);
            logger.debug("checkMasterVApp() - child vApp: {}", (Object)virtualApp2.getName());
            try {
                virtualMachineArray = virtualApp2.getVMs();
            }
            catch (RemoteException remoteException) {
                logger.error("checkMasterVApp() - RemoteException: ", (Throwable)remoteException);
                continue;
            }
            if (virtualMachineArray.length > 0) {
                logger.debug("checkMasterVApp() - child vApp contains VMs");
                if (vMHostState.isVsanNonCriticalHost() && !bl && VsanUtils.isAnyVMInArrayUsingDatastore(virtualMachineArray, vMHostState.getVsanDatastoreName())) {
                    bl = true;
                    logger.debug("checkMasterVApp() - child vApp is using vSAN Datastore on a non-critical host");
                }
                hashSet.addAll(this.getVAppVMHosts(vMHostState, virtualMachineArray, virtualApp2.getName()));
                this.addChildVAppToMasterVAppMap(vMHostState, virtualApp.getName(), virtualApp2.getName());
                continue;
            }
            logger.debug("checkMasterVApp() - child vApp contains no VMs");
        }
        if (vMHostState.isVsanNonCriticalHost() && !bl && hashSet.size() > 0) {
            logger.debug("checkMasterVApp() - non-critical host vApp children not using vSAN Datastore, clearing vAppHosts");
            hashSet.clear();
            vMHostState.getMasterVAppMap().remove(virtualApp.getName());
        }
        return hashSet;
    }

    private void checkShutdownVApp(ShutdownState shutdownState, VMHostState vMHostState, Set<String> set, boolean bl, VirtualApp virtualApp) {
        if (bl || vMHostState.isVsanNonCriticalHost()) {
            if (vMHostState.isVsanNonCriticalHost()) {
                logger.debug("checkShutdownVApp() - shutting down vApp as its using the vSAN Datastore");
            }
            this.setVirtualAppsToBeShutdown(vMHostState, virtualApp);
        } else {
            boolean bl2 = true;
            for (String string : set) {
                if (shutdownState.checkIfCriticalEventActive(string)) continue;
                bl2 = false;
            }
            if (bl2) {
                this.setVirtualAppsToBeShutdown(vMHostState, virtualApp);
            } else {
                this.setvAppsWithVMsOnHealthyHost(vMHostState, virtualApp);
            }
        }
    }

    private void setVirtualAppsToBeShutdown(VMHostState vMHostState, VirtualApp virtualApp) {
        if (!vMHostState.getVAppShutdownSet().contains(virtualApp)) {
            if (virtualApp != null) {
                logger.debug("setVirtualAppsToBeShutdown() - vApp: {}", (Object)virtualApp.getName());
            }
            vMHostState.getVAppShutdownSet().add(virtualApp);
        }
    }

    private void setvAppsWithVMsOnHealthyHost(VMHostState vMHostState, VirtualApp virtualApp) {
        if (!vMHostState.getVAppShutdownSetOnHealthyHost().contains(virtualApp)) {
            if (virtualApp != null) {
                logger.debug("setvAppsWithVMsOnHealthyHost() - vApp: {}", (Object)virtualApp.getName());
            }
            vMHostState.getVAppShutdownSetOnHealthyHost().add(virtualApp);
        }
    }

    private Set<String> getVAppVMHosts(VMHostState vMHostState, VirtualMachine[] virtualMachineArray, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VirtualMachine virtualMachine : virtualMachineArray) {
            logger.debug("getVAppVMHosts() - vApp VM: {}", (Object)virtualMachine.getName());
            HostSystem hostSystem = this.hostSystemUtils.getHostOfVirtualMachine(virtualMachine, vMHostState.getServiceInstance());
            if (hostSystem == null) continue;
            logger.debug("getVAppVMHosts() - vApp VM Host: {}", (Object)hostSystem.getName());
            hashSet.add(hostSystem.getName());
            if (!vMHostState.getHostSystemName().equalsIgnoreCase(hostSystem.getName()) || this.hostSystemUtils.isVCenterServerInstalledOnVM(virtualMachine, vMHostState.getServiceInstance())) continue;
            logger.debug("getVAppVMHosts() - adding VM");
            arrayList.add(virtualMachine.getName());
        }
        if (arrayList.size() > 0) {
            logger.debug("getVAppVMHosts() - add vmList to map");
            vMHostState.getVAppVMMap().put(string, arrayList);
        } else {
            logger.debug("getVAppVMHosts() - vmList is empty");
        }
        return hashSet;
    }

    private void addChildVAppToMasterVAppMap(VMHostState vMHostState, String string, String string2) {
        List<String> list = vMHostState.getMasterVAppMap().get(string);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string2);
        vMHostState.getMasterVAppMap().put(string, list);
    }

    public String getESXiAPITypeFromServiceInstance(VMHostState vMHostState) {
        String string = null;
        if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            vMHostState.setServiceInstance(this.vmwareConnection.getVCenterConnection());
            string = vMHostState.getServiceInstance().getAboutInfo().getApiType();
        } else {
            vMHostState.setServiceInstance(null);
        }
        return string;
    }

    @Generated
    public void setVirtualLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualLoggingUtils is marked non-null but is null");
        }
        this.virtualLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setVirtualConfigUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigUtils is marked non-null but is null");
        }
        this.virtualConfigUtils = virtualConfigurationManager;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }
}

