/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmmigration;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.DrsSettings;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vmmigration.VMMigrationPriorityGroup;
import com.apcc.m11.components.shutdowner.vmware.vmmigration.VMMigrationResult;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMMigrationHost {
    private static final Logger logger = LogManager.getLogger(VMMigrationHost.class);
    private ShutdownState theShutdownState = null;
    private VMHostState hostState = null;
    private int totalVMSPoweredOn = 0;
    private int totalVMSMigrated = 0;
    private int totalVMSFailed = 0;
    private int totalMigrationTimeout = 0;
    private ServiceManager services;
    private VMWareConnection vmwareConnection;

    public VMMigrationHost(ShutdownState shutdownState, VMHostState vMHostState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.theShutdownState = shutdownState;
        this.hostState = vMHostState;
    }

    public void startVMMigration(String string) {
        logger.info("startVMMigration() - start, host: {} ", (Object)this.hostState.getHostSystemName());
        boolean bl = false;
        boolean bl2 = false;
        try {
            if ("VirtualCenter".equalsIgnoreCase(string)) {
                if (this.hostState.getServiceInstance() == null) {
                    logger.info("startVMMigration() - no vCenter available, waiting migration duration");
                    this.sleepMigrationDuration();
                    return;
                }
                ClusterComputeResource clusterComputeResource = this.services.getClusterUtils().getClusterEntity(this.hostState.getHostSystem());
                if (clusterComputeResource == null) {
                    this.services.getVirtualLoggingUtils().logHostOutOfClusterLogEvent(this.hostState.getMappedHostName());
                    logger.info("startVMMigration() - host not part of cluster, waiting for migration duration");
                    this.sleepMigrationDuration();
                    return;
                }
                DrsSettings drsSettings = new DrsSettings(this.services);
                bl = drsSettings.isDrsEnabled(clusterComputeResource);
                bl2 = drsSettings.isDrsFullyAutomated(clusterComputeResource);
                if (bl && bl2 && this.hostState.isDelayMaintenanceModeEnabled()) {
                    logger.info("startVMMigration() - DRS Fully Automated & Delay Maintenance Mode enabled");
                }
                if (!this.theShutdownState.isVMMigrationLoggingInitiated(this.hostState.getGroupIdx())) {
                    this.theShutdownState.setVMMigrationLoggingInitiated(this.hostState.getGroupIdx());
                    if (!this.hostState.isDelayMaintenanceModeEnabled() && bl && bl2) {
                        this.services.getVirtualLoggingUtils().logDRSEnabledVMMigrationLogEvent(clusterComputeResource.getName());
                    } else {
                        logger.debug("startVMMigration() - VMs are getting manually migrated to other healthy hosts");
                        this.services.getVirtualLoggingUtils().logDRSDisabledVMMigrationLogEvent(clusterComputeResource.getName());
                    }
                }
                if (!bl || !bl2 || this.hostState.isDelayMaintenanceModeEnabled()) {
                    this.startManualVMMigration(clusterComputeResource);
                } else {
                    logger.debug("startVMMigration() - waiting migration duration for DRS to complete");
                    this.sleepMigrationDuration();
                }
            } else if ("HostAgent".equalsIgnoreCase(string) || this.hostState.getServiceInstance() == null) {
                this.services.getVirtualLoggingUtils().logMigrationFailedVCenterOfflineLogEvent();
            }
        }
        catch (Exception exception) {
            logger.error("startVMMigration() - Exception: " + String.valueOf(exception));
        }
        if (!this.hostState.isDelayMaintenanceModeEnabled() && bl && bl2) {
            logger.debug("startVMMigration() - clearing VM Migration logging initiated");
            this.theShutdownState.clearVMMigrationLoggingInitiated(this.hostState.getGroupIdx());
        }
        logger.info("startVMMigration() - end");
    }

    private void startManualVMMigration(ClusterComputeResource clusterComputeResource) {
        logger.info("startManualVMMigration() - start");
        if (this.hostState.getHostSystem() == null) {
            logger.error("startManualVMMigration() - no host specified");
            return;
        }
        boolean bl = this.services.getVirtualConfigurationManager().isCustomTargetHostsEnabled(this.hostState.getGroupIdx());
        Set<HostSystem> set = this.getTargetHostSet(clusterComputeResource, bl);
        if (set == null || set.isEmpty()) {
            this.services.getVirtualLoggingUtils().logMigrationFailedNoSuitableHostEvent(this.hostState.getMappedHostName());
            this.sleepMigrationDuration();
            return;
        }
        if (this.hostState.getHostSystem().getRuntime().isInMaintenanceMode() || !this.services.getHostSystemUtils().checkIfHostIsPoweredOn(this.hostState.getHostSystem())) {
            logger.debug("startManualVMMigration() - cannot migrate VMs, host in Maintenance Mode or Powered Off");
            return;
        }
        logger.debug("startManualVMMigration() - starting manual migration from host");
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION);
        ListIterator<VMPriority> listIterator = this.hostState.getPriorities().listIterator(this.hostState.getPriorities().size());
        VirtualMachine[] virtualMachineArray = null;
        try {
            virtualMachineArray = this.services.getHostSystemUtils().getVirtualMachines(this.hostState.getHostSystem());
            logger.debug("startManualVMMigration() - {} VM(s) retrieved", (Object)virtualMachineArray.length);
        }
        catch (RemoteException remoteException) {
            logger.error("startManualVMMigration() - unable to get VMs for VM Migration. Migration will be skipped, error: {}", (Object)remoteException.getLocalizedMessage());
            this.sleepMigrationDuration();
        }
        while (listIterator.hasPrevious()) {
            VMPriority vMPriority;
            block19: {
                vMPriority = listIterator.previous();
                logger.debug("startManualVMMigration() - priority: {}", (Object)vMPriority);
                int n = this.getVMMigrationDuration(vMPrioritizationDurations, vMPriority);
                if (n == 0) {
                    logger.warn("startManualVMMigration() - VM Migration Duration is 0 for priority: {}", (Object)vMPriority);
                } else {
                    try {
                        Object object;
                        logger.debug("startManualVMMigration() - checking vCenter connection, reconnecting if needed");
                        if (!this.vmwareConnection.validateServiceInstance()) {
                            object = this.vmwareConnection.getVCenterConnection();
                            if (object == null) {
                                logger.error("startManualVMMigration() - no vCenter available");
                                throw new IllegalStateException("No vCenter available");
                            }
                            if (this.hostState == null) {
                                logger.error("startManualVMMigration() - no host specified");
                                throw new IllegalStateException("No host specified");
                            }
                            this.hostState.setServiceInstance(null);
                            this.hostState.setServiceInstance((ServiceInstance)object);
                            logger.debug("startManualVMMigration() - new service instance set");
                        }
                        if (this.hostState.getHostSystem() == null) {
                            logger.error("startManualVMMigration() - no host system available");
                            throw new IllegalStateException("No host system available");
                        }
                        logger.debug("startManualVMMigration() - vCenter connection available");
                        object = this.services.getVMPrioritizationUtils().filterVMsByPriority(virtualMachineArray, vMPriority);
                        if (this.services.getVirtualConfigurationManager().hasVCLSBeenDetectedOnCluster()) {
                            logger.debug("startManualVMMigration() - Filter out VCLS VMs");
                            object = this.services.getVirtualMachineUtils().filterOutVCLSVms((List<VirtualMachine>)object);
                        }
                        if (vMPriority == VMPriority.HIGH) {
                            object = this.checkForVcsaOrPcnsInVms((List<VirtualMachine>)object, virtualMachineArray);
                        }
                        logger.debug("startManualVMMigration() - number of VMs: {}", (Object)object.size());
                        ExecutorService executorService = Executors.newSingleThreadExecutor();
                        VMMigrationPriorityGroup vMMigrationPriorityGroup = new VMMigrationPriorityGroup(vMPriority, (List<VirtualMachine>)object, set, this.hostState.getServiceInstance(), this.theShutdownState, this.services);
                        vMMigrationPriorityGroup.setIsCustomTargetHostsEnabled(bl);
                        Future<VMMigrationResult> future = executorService.submit(vMMigrationPriorityGroup);
                        executorService.shutdown();
                        if (executorService.awaitTermination(n, TimeUnit.SECONDS)) break block19;
                        executorService.shutdownNow();
                        try {
                            VMMigrationResult vMMigrationResult = future.get();
                            if (vMMigrationResult == null) break block19;
                            if (vMMigrationResult.getResult() == VMResult.TIMEOUT) {
                                this.recordMigrationTimeout(vMPriority);
                                break block19;
                            }
                            this.recordMigrationResult(vMMigrationResult.getVmsPoweredOn(), vMMigrationResult.getVmsMigrated(), vMMigrationResult.getVmsFailed(), vMPriority);
                        }
                        catch (ExecutionException executionException) {
                            logger.error("startManualVMMigration() - ExecutionException: {}", (Object)executionException.getLocalizedMessage());
                        }
                    }
                    catch (Exception exception) {
                        logger.error("startManualVMMigration() - exception migrating VMs for priority: {} {}", (Object)vMPriority, (Object)exception);
                        this.sleepMigrationDuration(n);
                    }
                }
            }
            this.theShutdownState.clearVMMigrationLoggingInitiated(this.hostState.getGroupIdx());
            logger.debug("startManualVMMigration() - startVMMigration end, priority: {}", (Object)vMPriority);
        }
        this.logMigrationResult();
    }

    private List<VirtualMachine> checkForVcsaOrPcnsInVms(List<VirtualMachine> list, VirtualMachine[] virtualMachineArray) {
        logger.debug("checkForVcsaOrPcnsInVms() - start");
        String string = "";
        VirtualMachine virtualMachine = this.services.getHostSystemUtils().getVirtualMachineOnWhichPCNSInstalled(this.hostState.getServiceInstance());
        if (virtualMachine != null) {
            string = virtualMachine.getName();
        } else {
            logger.debug("checkForVcsaOrPcnsInVms() - PCNS VM not set");
        }
        String string2 = "";
        boolean bl = false;
        VirtualMachine virtualMachine2 = this.services.getHostSystemUtils().getVCenterServerVM(this.hostState.getServiceInstance());
        if (virtualMachine2 != null) {
            string2 = virtualMachine2.getName();
            bl = this.services.getVMPrioritizationUtils().isVMInPrioritizedVMList(string2);
        } else {
            logger.debug("checkForVcsaOrPcnsInVms() - vCenter VM not set");
        }
        if (bl) {
            logger.debug("checkForVcsaOrPcnsInVms() - vCenter VM already set in priority group, not adding {}", (Object)string2);
            string2 = null;
        }
        if (StringUtils.isEmpty((CharSequence)string) && StringUtils.isEmpty((CharSequence)string2)) {
            return list;
        }
        for (int i = 0; i < virtualMachineArray.length; ++i) {
            VirtualMachine virtualMachine3 = virtualMachineArray[i];
            if (virtualMachine3.getName().equals(string)) {
                logger.info("checkForVcsaOrPcnsInVms() - adding PCNS VM: {}", (Object)string);
                list.add(0, virtualMachine3);
                virtualMachineArray = (VirtualMachine[])ArrayUtils.remove((Object[])virtualMachineArray, (int)i);
                continue;
            }
            if (!virtualMachine3.getName().equals(string2)) continue;
            logger.info("checkForVcsaOrPcnsInVms() - adding vCenter VM: {}", (Object)string2);
            list.add(0, virtualMachine3);
            virtualMachineArray = (VirtualMachine[])ArrayUtils.remove((Object[])virtualMachineArray, (int)i);
        }
        logger.debug("checkForVcsaOrPcnsInVms() - end");
        return list;
    }

    private Set<HostSystem> getTargetHostSet(ClusterComputeResource clusterComputeResource, boolean bl) {
        Object object;
        Object object2;
        Set<HostSystem> set = null;
        if (bl) {
            logger.debug("getTargetHostSet() - custom target");
            object2 = this.hostState.isAdvancedMode() ? ConfigurationKeys.getAdvancedSetupKey(this.hostState.getGroupIdx()) : "HostConfigSettings";
            object = this.services.getWebServerUtils().readMigrationTargetHostsFromConfig((String)object2);
            if (object != null && !object.isEmpty()) {
                set = this.services.getHostSystemUtils().getCustomTargetHostSystemList((List<String>)object, this.hostState.getServiceInstance());
            }
        } else {
            logger.debug("getTargetHostSet() - automatic target");
            set = this.services.getClusterUtils().getClusterHostSystemList(clusterComputeResource, this.services.getHostSystemUtils());
        }
        logger.debug("getTargetHostSet() - target hosts: {}", set);
        object2 = null;
        if (set != null && !set.isEmpty()) {
            object2 = this.services.getHostSystemUtils().computeTargetHostList(set);
            logger.debug("getTargetHostSet() - non-critical target host size: {}", (Object)object2.size());
            object = object2.iterator();
            while (object.hasNext()) {
                HostSystem hostSystem = (HostSystem)object.next();
                logger.debug("getTargetHostSet() - non-critical target host: {}", (Object)hostSystem.getName());
            }
        } else {
            logger.debug("getTargetHostSet() - hostSystemList is empty");
        }
        return object2;
    }

    private void sleepMigrationDuration(int n) {
        try {
            logger.debug("sleepMigrationDuration() - respecting duration anyway");
            TimeUnit.SECONDS.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            logger.debug("sleepMigrationDuration() - migration timer interrupted");
        }
    }

    private void sleepMigrationDuration() {
        logger.info("sleepMigrationDuration() - start");
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION);
        for (VMPriority vMPriority : this.hostState.getPriorities()) {
            int n = this.getVMMigrationDuration(vMPrioritizationDurations, vMPriority);
            try {
                logger.info("sleepMigrationDuration() - waiting: {} seconds for priority: {} ", (Object)n, (Object)vMPriority);
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("sleepMigrationDuration() - wait was interrupted");
            }
        }
        logger.info("sleepMigrationDuration() - end");
    }

    private int getVMMigrationDuration(VMPrioritizationDurations vMPrioritizationDurations, VMPriority vMPriority) {
        int n = 0;
        if (vMPriority == null) {
            if (this.hostState.isAdvancedMode()) {
                UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(this.hostState.getGroupIdx());
                if (uPSSetup != null) {
                    n = uPSSetup.getVMSettings().getGuestVMMigrationDuration();
                }
            } else {
                n = this.services.getVirtualConfigurationManager().getDurationGlobal("guest_vm_migration_duration");
            }
        } else {
            n = vMPrioritizationDurations.getDuration(vMPriority);
        }
        return n;
    }

    private void logMigrationResult() {
        logger.debug("logMigrationResult() - start");
        if (this.totalMigrationTimeout > 0) {
            this.services.getVirtualLoggingUtils().logVMMigrationFailedWithTimeout(this.hostState.getMappedHostName());
        } else if (this.totalVMSFailed > 0) {
            if (this.totalVMSMigrated > 0) {
                this.services.getVirtualLoggingUtils().logVMMigrationFailedMigrateAll(this.hostState.getMappedHostName());
            } else {
                this.services.getVirtualLoggingUtils().logVMMigrationFailedMigrateAny(this.hostState.getMappedHostName());
            }
        } else if (this.totalVMSMigrated > 0) {
            if (this.totalVMSMigrated < this.totalVMSPoweredOn) {
                this.services.getVirtualLoggingUtils().logVMMigrationFailedMigrateAll(this.hostState.getMappedHostName());
            } else {
                this.services.getVirtualLoggingUtils().logVMMigrationSucceeded(this.hostState.getMappedHostName());
            }
        } else if (this.totalVMSPoweredOn > 0) {
            this.services.getVirtualLoggingUtils().logVMMigrationFailedMigrateAny(this.hostState.getMappedHostName());
        } else {
            this.services.getVirtualLoggingUtils().logVMMigrationNoVmToMigrate(this.hostState.getMappedHostName());
        }
        logger.debug("logMigrationResult() - end");
    }

    void recordMigrationResult(int n, int n2, int n3, VMPriority vMPriority) {
        this.totalVMSPoweredOn += n;
        this.totalVMSMigrated += n2;
        this.totalVMSFailed += n3;
    }

    void recordMigrationTimeout(VMPriority vMPriority) {
        logger.error("recordMigrationTimeout() - insufficient time to migrate all VMs using VM Migration Duration for priority: " + String.valueOf((Object)vMPriority));
        ++this.totalMigrationTimeout;
    }
}

