/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmmigration;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vmmigration.VMMigrationResult;
import com.apcc.m11.components.shutdowner.vmware.vmmigration.VMMigrationTaskDetails;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.ArrayOfCheckResult;
import com.vmware.vim25.CheckResult;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMMigrationPriorityGroup
implements Callable<VMMigrationResult> {
    private static final Logger logger = LogManager.getLogger(VMMigrationPriorityGroup.class);
    private List<VirtualMachine> virtualMachines;
    private Set<HostSystem> targetHostList;
    private ServiceInstance serviceInstance;
    private ShutdownState theState;
    private ServiceManager services;
    private Boolean isCustomTargetHostsEnabled;
    private VMPriority priority;

    VMMigrationPriorityGroup(VMPriority vMPriority, List<VirtualMachine> list, Set<HostSystem> set, ServiceInstance serviceInstance, ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.priority = vMPriority;
        this.virtualMachines = list;
        this.targetHostList = set;
        this.serviceInstance = serviceInstance;
        this.theState = shutdownState;
        this.services = serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMMigrationResult call() {
        VMMigrationResult vMMigrationResult;
        block30: {
            VirtualMachine virtualMachine;
            logger.debug("call() - start, priority: {}", (Object)this.priority);
            vMMigrationResult = new VMMigrationResult();
            Iterator<VirtualMachine> iterator = null;
            try {
                if (this.virtualMachines == null) {
                    logger.debug("call() - no VMs to migrate");
                    break block30;
                }
                Vector<VMMigrationTaskDetails> vector = new Vector<VMMigrationTaskDetails>();
                virtualMachine = null;
                iterator = this.virtualMachines.iterator();
                block10: while (iterator.hasNext()) {
                    ManagedEntity managedEntity = (ManagedEntity)iterator.next();
                    if (Thread.currentThread().isInterrupted()) {
                        logger.error("call() - VM migration timeout");
                        while (iterator.hasNext()) {
                            VirtualMachine virtualMachine2 = iterator.next();
                            logger.error("call() - timeout, skipped migration of VM: {}", (Object)virtualMachine2.getName());
                        }
                        vMMigrationResult.setResult(VMResult.TIMEOUT);
                        return vMMigrationResult;
                    }
                    if (!(managedEntity instanceof VirtualMachine)) continue;
                    VirtualMachine object = (VirtualMachine)managedEntity;
                    if (!this.services.getVirtualMachineUtils().isPoweredOn(object)) {
                        logger.debug("call() - VM: {} not powered on", (Object)object.getName());
                        continue;
                    }
                    vMMigrationResult.incrementVmsPoweredOn();
                    logger.debug("call() - attempting to migrate powered on VM: {}", (Object)object.getName());
                    for (HostSystem hostSystem : this.targetHostList) {
                        String[] stringArray;
                        ShutdownTimer shutdownTimer2;
                        logger.debug("call() - seek Lock");
                        Object object2 = this.theState.getCriticalShutdownTimersLock();
                        synchronized (object2) {
                            logger.debug("call() - got Lock");
                            for (ShutdownTimer shutdownTimer2 : this.theState.getCriticalShutdownTimersList()) {
                                if (shutdownTimer2.getHostsToShutdown().containsKey(hostSystem.getName())) continue;
                                virtualMachine = hostSystem;
                            }
                        }
                        logger.debug("call() - free Lock");
                        if (virtualMachine == null) {
                            logger.debug("call() - critical event(s) on target host: {}", (Object)hostSystem.getName());
                            continue;
                        }
                        logger.debug("call() - checking VM migration to target host: {}", (Object)virtualMachine.getName());
                        object2 = null;
                        if (this.isCustomTargetHostsEnabled.booleanValue()) {
                            stringArray = (String[])virtualMachine.getParent();
                            object2 = stringArray.getResourcePool();
                        } else {
                            object2 = object.getResourcePool();
                        }
                        if (this.serviceInstance == null) {
                            logger.debug("call() - serviceInstance is null");
                            continue;
                        }
                        stringArray = new String[]{};
                        logger.debug("call() - check if VM migration is feasible on target host");
                        shutdownTimer2 = this.serviceInstance.getVirtualMachineProvisioningChecker().checkMigrate_Task(object, (HostSystem)virtualMachine, (ResourcePool)object2, VirtualMachinePowerState.poweredOn, stringArray);
                        Object object3 = null;
                        if (shutdownTimer2 != null && shutdownTimer2.waitForTask().equals("success") && shutdownTimer2.getTaskInfo() != null) {
                            object3 = shutdownTimer2.getTaskInfo().getResult();
                        }
                        if (!(object3 instanceof ArrayOfCheckResult)) continue;
                        CheckResult checkResult = ((ArrayOfCheckResult)object3).getCheckResult(0);
                        if (checkResult != null && checkResult.getError() == null) {
                            if (checkResult.getWarning() != null) {
                                logger.warn("call() - VM migration warning message: {}", (Object)checkResult.getWarning()[0].getLocalizedMessage());
                            }
                            logger.debug("call() - critical VM: {} to be migrated", (Object)object.getName());
                            Task task = object.migrateVM_Task((ResourcePool)object2, (HostSystem)virtualMachine, VirtualMachineMovePriority.highPriority, VirtualMachinePowerState.poweredOn);
                            vector.add(new VMMigrationTaskDetails(task, object, (HostSystem)virtualMachine));
                            continue block10;
                        }
                        if (checkResult == null || checkResult.getError() == null) continue;
                        logger.error("call() - VM migration error message: {}", (Object)checkResult.getError()[0].getLocalizedMessage());
                    }
                }
                logger.debug("call() - all host migration tasks started, waiting for them to complete");
                for (VMMigrationTaskDetails vMMigrationTaskDetails : vector) {
                    if (vMMigrationTaskDetails.theTask == null) continue;
                    if (vMMigrationTaskDetails.theTask.waitForTask().equals("success")) {
                        if (vMMigrationTaskDetails.theVM == null) continue;
                        vMMigrationResult.incrementVmsMigrated();
                        try {
                            logger.debug("call() - VM: {} successfully migrated to host: {}", (Object)vMMigrationTaskDetails.theVM.getName(), (Object)vMMigrationTaskDetails.theDestination.getName());
                        }
                        catch (Exception exception) {
                            logger.debug("call() - VM successfully migrated to destination host but exception thrown on getName() call");
                        }
                        continue;
                    }
                    vMMigrationResult.incrementVmsFailed();
                    TaskInfo taskInfo = vMMigrationTaskDetails.theTask.getTaskInfo();
                    logger.error("call() - VM: {} failed to migrate to host: {}, because: {}", (Object)vMMigrationTaskDetails.theVM.getName(), (Object)vMMigrationTaskDetails.theDestination.getName(), (Object)taskInfo.getError().getFault());
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("call() - VM migration timeout");
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        virtualMachine = (VirtualMachine)iterator.next();
                        logger.error("call() - timeout skipped migration of VM: {}", (Object)virtualMachine.getName());
                    }
                }
                vMMigrationResult.setResult(VMResult.TIMEOUT);
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                logger.error("call() - VM migration Exception: " + String.valueOf(exception));
                if (iterator == null) break block30;
                while (iterator.hasNext()) {
                    virtualMachine = iterator.next();
                    logger.error("call() - error skipped migration of VM: {}", (Object)virtualMachine.getName());
                }
            }
        }
        try {
            logger.debug("call() - waiting to be interrupted");
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("call() - end");
        return vMMigrationResult;
    }

    @Generated
    public void setIsCustomTargetHostsEnabled(Boolean bl) {
        this.isCustomTargetHostsEnabled = bl;
    }
}

