/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vmshutdown.VMShutdownPriorityGroup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMShutdownHost
implements Runnable {
    private static final Logger logger = LogManager.getLogger(VMShutdownHost.class);
    private ShutdownState theState = null;
    private VMHostState hostState = null;
    private boolean bVMShutdownTimeout = false;
    private ServiceManager services;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public VMShutdownHost(ShutdownState shutdownState, VMHostState vMHostState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theState = shutdownState;
        this.hostState = vMHostState;
        this.services = serviceManager;
        this.virtualisationStatusStore = serviceManager.getVirtualisationStatusStore();
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    @Override
    public void run() {
        this.services.getVmShutdownUtils().waitIfVMStartupInProgress(this.theState, this.hostState);
        this.services.getVirtualLoggingUtils().logVMShutdownEvent(this.hostState.getMappedHostName());
        VMPrioritizationDurations vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN);
        for (VMPriority vMPriority : this.hostState.getPriorities()) {
            logger.debug("run() - priority: {}", (Object)vMPriority);
            this.checkVMShutdownServerConnection();
            if (this.hostState.getHostSystem() == null) {
                logger.error("run() - host is null, no VM shutdown for priority: {}", (Object)vMPriority);
                continue;
            }
            int n = this.services.getVmShutdownUtils().getVMShutdownDuration(vMPrioritizationDurations, vMPriority, this.hostState.isAdvancedMode(), this.hostState.getGroupIdx());
            if (n == 0) {
                logger.debug("run() - duration is 0, no VM shutdown for priority: {}", (Object)vMPriority);
                continue;
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            VMShutdownPriorityGroup vMShutdownPriorityGroup = new VMShutdownPriorityGroup(this.hostState, vMPriority, this.theState, this.services);
            Future<VMResult> future = executorService.submit(vMShutdownPriorityGroup);
            executorService.shutdown();
            try {
                if (executorService.awaitTermination(n, TimeUnit.SECONDS)) continue;
                executorService.shutdownNow();
                try {
                    VMResult vMResult = future.get();
                    if (vMResult == null || vMResult != VMResult.TIMEOUT) continue;
                    this.setTimeoutDuringVMShutdown(vMPriority);
                }
                catch (ExecutionException executionException) {
                    logger.error("run() - ExecutionException: {}", (Object)executionException.getLocalizedMessage());
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("run() - InterruptedException: {}", (Object)interruptedException.getLocalizedMessage());
            }
        }
        if (this.bVMShutdownTimeout) {
            this.services.getVirtualLoggingUtils().logHostVMShutdownFailedInsufficientTimeEvent(this.hostState.getMappedHostName());
        }
        if (this.hostState.isVCSAVMShutdown()) {
            this.vcsaVmShutdownTasks();
        }
        logger.debug("run() - end");
    }

    private void vcsaVmShutdownTasks() {
        if (this.vmwareConnection.validateServiceInstance()) {
            this.services.getVirtualLoggingUtils().logVCSAVMUngracefulShutdownEvent(this.hostState.getVCSAName());
        }
        this.virtualisationStatusStore.setProperty("VCSA_VM", this.hostState.getVCSAName());
        if (this.theState.getIPForESXiHost(this.hostState.getCriticalHostName()) != null) {
            this.virtualisationStatusStore.setVcsaHost(this.theState.getIPForESXiHost(this.hostState.getCriticalHostName()), this.hostState.getCriticalHostName());
        } else {
            this.hostState.setHostSystem(this.services.getHostSystemUtils().getValidHostSystem(this.hostState.getHostSystem(), this.hostState.getMappedHostName()));
            if (this.hostState.getHostSystem() != null) {
                this.virtualisationStatusStore.setVcsaHost(this.services.getHostSystemUtils().getESXiHostIPAddress(this.hostState.getHostSystem()), this.hostState.getCriticalHostName());
            } else {
                logger.warn("vcsaVmShutdownTasks() - unable to save property, vCSA Host is null");
            }
        }
    }

    private void checkVMShutdownServerConnection() {
        if (!this.vmwareConnection.validateServiceInstance()) {
            logger.debug("checkVMShutdownServerConnection() - using ESXi Host connection");
            this.hostState.setServiceInstance(null);
            this.hostState.setServiceInstance(this.vmwareConnection.getESXiHostInstance(this.hostState.getConnESXiHost()));
            this.hostState.setHostSystem(this.services.getHostSystemUtils().getHostUsingIPOrDNSName(this.hostState.getServiceInstance(), this.hostState.getConnESXiHost()));
        } else {
            this.hostState.setHostSystem(this.services.getHostSystemUtils().getValidHostSystem(this.hostState.getHostSystem(), this.hostState.getMappedHostName()));
        }
    }

    private void setTimeoutDuringVMShutdown(VMPriority vMPriority) {
        logger.error("setTimeoutDuringVMShutdown() - insufficient time to shutdown all VMs using VM Shutdown Duration for priority: {}", (Object)vMPriority);
        this.bVMShutdownTimeout = true;
    }
}

