/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.shutdowner.vmware.VMResult;
import com.apcc.m11.components.shutdowner.vmware.vmshutdown.VMShutdownVMList;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.pcns.ServiceManager;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMShutdownPriorityGroup
implements Callable<VMResult> {
    private static final Logger logger = LogManager.getLogger(VMShutdownPriorityGroup.class);
    private VMHostState hostState;
    private ServiceManager services;
    private ShutdownState theState;
    private VMPriority priority;

    public VMShutdownPriorityGroup(VMHostState vMHostState, VMPriority vMPriority, ShutdownState shutdownState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.hostState = vMHostState;
        this.priority = vMPriority;
        this.services = serviceManager;
        this.theState = shutdownState;
    }

    @Override
    public VMResult call() {
        VMResult vMResult;
        block15: {
            logger.debug("call() - priority: {}", (Object)this.priority);
            vMResult = VMResult.OK;
            try {
                VirtualMachine[] virtualMachineArray;
                if (this.services.getHostSystemUtils().checkIfHostIsInMaintenanceMode(this.hostState.getHostSystem())) {
                    logger.debug("call() - no shutdown required, host: {} in Maintenance Mode; waiting duration anyway", (Object)this.hostState.getHostSystem().getName());
                    break block15;
                }
                if (!this.services.getHostSystemUtils().checkIfHostIsPoweredOn(this.hostState.getHostSystem())) {
                    logger.warn("call() - no shutdown required, host: {} powered off; waiting duration anyway", (Object)this.hostState.getHostSystem().getName());
                    break block15;
                }
                VMShutdownVMList vMShutdownVMList = new VMShutdownVMList(this.hostState, this.services);
                try {
                    virtualMachineArray = this.services.getHostSystemUtils().getVirtualMachines(this.hostState.getHostSystem());
                    if (virtualMachineArray != null) {
                        logger.debug("call() - Found {} VMs on host {} ", (Object)virtualMachineArray.length, (Object)this.hostState.getMappedHostName());
                    } else {
                        logger.debug("call() - Found no VMs on host {} ", (Object)this.hostState.getMappedHostName());
                    }
                    List<VirtualMachine> list = this.filterVMs(virtualMachineArray);
                    if (!vMShutdownVMList.executeGuestVMShutdown(list, false, this.priority)) {
                        vMResult = VMResult.TIMEOUT;
                    }
                }
                catch (Exception exception) {
                    logger.debug("call() - Exception shutting down VM via VCenter.  Will try via Host. ", (Throwable)exception);
                    if (Thread.currentThread().isInterrupted()) break block15;
                    logger.debug("call() - try shutdown via ESXi host instead");
                    virtualMachineArray = this.services.getVmShutdownUtils().getVMsForShutdownViaESXiHost(false, this.hostState.getConnESXiHost());
                    logger.debug("call() - filtering for priority {}", (Object)this.priority);
                    List<VirtualMachine> list = this.filterVMs(virtualMachineArray);
                    try {
                        if (!vMShutdownVMList.executeGuestVMShutdown(list, false, this.priority)) {
                            vMResult = VMResult.TIMEOUT;
                        }
                    }
                    catch (RemoteException remoteException) {
                        logger.error("call() - RemoteException shutting down via ESXi host", (Throwable)remoteException);
                    }
                }
            }
            catch (Exception exception) {
                logger.error("call() - Exception: ", (Throwable)exception);
            }
        }
        try {
            logger.debug("run() - wait for thread to be interrupted");
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(500L);
            }
            logger.debug("run() - shutdown thread interrupted");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return vMResult;
    }

    private List<VirtualMachine> filterVMs(VirtualMachine[] virtualMachineArray) {
        List<VirtualMachine> list = this.services.getVMPrioritizationUtils().filterVMsByPriority(virtualMachineArray, this.priority);
        if (this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            logger.debug("filterVMs() - Filter out AFS VMs and CVMs");
            list = this.services.getNutanixUtils().filterOutNutanixSpecialVms(list);
        }
        if (this.services.getVirtualConfigurationManager().isSimplivity()) {
            list = this.services.getSimplivityUtils().filterOutSimplivitySpecialVMs(list);
        }
        if (this.services.getVirtualConfigurationManager().isHyperflex()) {
            logger.debug("filterVMs() - Filter out Hyperflex Controller VMs");
            list = this.services.getHyperflexUtils().filterOutHyperflexSpecialVms(list);
        }
        if (this.services.getVirtualConfigurationManager().isVxRail()) {
            logger.debug("filterVMs() - Filter out VxRail system VMs");
            list = this.services.getVxRailUtils().filterOutVxRailSpecialVms(list);
        }
        if (this.services.getVirtualConfigurationManager().hasVCLSBeenDetectedOnCluster()) {
            if (!this.theState.isShutdownVclsVmsSet()) {
                logger.debug("filterVMs() - Filter out VCLS VMs");
                list = this.services.getVirtualMachineUtils().filterOutVCLSVms(list);
            } else {
                logger.debug("filterVMs() - vCLS VMs need to be shut down, not filtering out VCLS VMs");
            }
        }
        return list;
    }
}

