/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.shutdowner.vmware.vmshutdown;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.VMHostState;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMShutdownUtils {
    private static final Logger logger = LogManager.getLogger(VMShutdownUtils.class);
    @NonNull
    private VirtualizationLoggingUtils virtualLoggingUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigUtils;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private VMWareConnection vmwareConnection;

    public void waitIfVMStartupInProgress(ShutdownState shutdownState, VMHostState vMHostState) {
        logger.debug("waitIfVMStartupInProgress() - start");
        if (shutdownState.isVMWareVMStartupInProgress(vMHostState.getCriticalHostName())) {
            this.virtualLoggingUtils.logVirtualizationStartupInProgressEvent(vMHostState.getMappedHostName());
            do {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (shutdownState.isVMWareVMStartupInProgress(vMHostState.getCriticalHostName()));
        }
        logger.debug("waitIfVMStartupInProgress() - end");
    }

    public int getVMShutdownDuration(VMPrioritizationDurations vMPrioritizationDurations, VMPriority vMPriority, boolean bl, int n) {
        int n2 = 0;
        if (vMPriority == null) {
            if (bl) {
                UPSSetup uPSSetup = this.advancedSetupHelper.readUPSSetupFromConfig(n);
                if (uPSSetup != null) {
                    n2 = uPSSetup.getVMSettings().getGuestVMVappShutdownDuration();
                }
            } else {
                n2 = this.virtualConfigUtils.getDurationGlobal("guest_vm_vapp_shutdown_duration");
            }
        } else {
            n2 = vMPrioritizationDurations.getDuration(vMPriority);
        }
        return n2;
    }

    public VirtualMachine[] getVMsForShutdownViaESXiHost(boolean bl, String string) {
        VirtualMachine[] virtualMachineArray = null;
        try {
            logger.debug("getVMsForShutdownViaESXiHost() - host: {}", (Object)string);
            if (bl || !this.vmwareConnection.validateServiceInstance()) {
                logger.debug("getVMsForShutdownViaESXiHost() - connect directly to host to get list of VMs");
                ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
                if (serviceInstance != null) {
                    HostSystem hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
                    if (hostSystem != null && !hostSystem.getRuntime().isInMaintenanceMode() && this.hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) {
                        virtualMachineArray = this.hostSystemUtils.getVirtualMachines(hostSystem);
                    }
                } else {
                    logger.debug("getVMsForShutdownViaESXiHost() - serviceInstance is null, unable to get list of VMs");
                }
            }
        }
        catch (Exception exception) {
            logger.error("getVMsForShutdownViaESXiHost() - Exception: ", (Throwable)exception);
        }
        return virtualMachineArray;
    }

    @Generated
    public void setVirtualLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualLoggingUtils is marked non-null but is null");
        }
        this.virtualLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setVirtualConfigUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigUtils is marked non-null but is null");
        }
        this.virtualConfigUtils = virtualConfigurationManager;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }
}

